(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   3440448,      64695]
NotebookOptionsPosition[   3217592,      60191]
NotebookOutlinePosition[   3380356,      63573]
CellTagsIndexPosition[   3380313,      63570]
WindowTitle->31. Complex Analysis in a Nutshell | Essentials of Complex \
Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Complex Analysis in a Nutshell"
}], "Section",
 CounterAssignments->{{"Section", 30}},
 CellID->168748717,ExpressionUUID->"e5e2312a-7e77-49d8-8b7a-17fda54cd664"],

Cell["\<\
This book has presented an introduction to complex analysis. The reader \
should now be equipped with the tools to appreciate the main properties of \
analytic functions, to recognize the types of singularities occurring in \
complex analysis, to calculate contour integrals. The book also introduced \
the most important classical theorems: Cauchy\[CloseCurlyQuote]s theorem, \
Cauchy\[CloseCurlyQuote]s integral formula and the residue theorem. An \
introduction to applications of complex analysis was also presented.\
\>", "Text",
 CellID->136822398,ExpressionUUID->"de902cca-f48a-419f-8dae-3ff9125c694d"],

Cell["\<\
This chapter will shortly summarize the main points of the whole book.\
\>", "Text",
 CellID->455076095,ExpressionUUID->"d0f0f3c3-094b-408f-acd4-602d1c81185b"],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsection",
 CellID->27151775,ExpressionUUID->"e2fe9ad9-6109-496e-8450-ad3e898ae27a"],

Cell[CellGroupData[{

Cell["Historical Overview", "Subsubsection",
 CellID->134633408,ExpressionUUID->"49ccfea5-4f8a-4ee8-b3a1-099521b16552"],

Cell["\<\
The first uses of complex numbers date to the sixteenth century. The main \
results of modern complex analysis are due to Augustin-Louis Cauchy (1789\
\[Dash]1857) and Bernhard Riemann (1826\[Dash]1866).\
\>", "Text",
 CellID->444998928,ExpressionUUID->"344347d8-afae-4738-a42f-89a63e48c904"],

Cell["\<\
Today, complex analysis has wide applications in physics and engineering, as \
well as many areas of pure and applied mathematics.\
\>", "Text",
 CellID->56104104,ExpressionUUID->"c3fad102-8e40-4aa5-bfa4-634fea155cd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsubsection",
 CellID->310649732,ExpressionUUID->"496f660f-2767-4068-b892-f7fbaa9ed29f"],

Cell["A complex number has the form", "Text",
 CellID->274766732,ExpressionUUID->"adb55e35-689d-4c8b-b48d-08d70972df9d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    RowBox[{"a", "+", 
     RowBox[{"\[ImaginaryI]", " ", "b", " ", "for", " ", "a"}]}]}], ",", 
   RowBox[{"b", "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalR]", "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->390909247,ExpressionUUID->"6fb84a28-5a5b-4a96-b103-e3651f67293b"],

Cell[TextData[{
 "The real number ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "112f1812-ba4c-44f3-93ae-b2090176acc2"],
 " is the ",
 StyleBox["real part",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "69c4b452-6473-4e08-91df-03919ad6e5e4"],
 ", and the real number ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath",ExpressionUUID->
  "37804102-c160-478a-ae03-368fddf89050"],
 " is the ",
 StyleBox["imaginary part",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "494f0473-079e-42c6-a3f8-5058126b1212"],
 "."
}], "Text",
 CellID->209611468,ExpressionUUID->"a39771c8-43a6-4166-a2b3-e351f7f828f1"],

Cell[TextData[{
 "The imaginary unit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ImaginaryI]", "=", 
    SqrtBox[
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineFormula",ExpressionUUID->
  "a2234552-91f7-43de-8410-74380c53b21a"],
 " has the property"
}], "Text",
 CellID->83879064,ExpressionUUID->"5ecea6fe-0a97-44c8-9ae9-1a8a03bc6265"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ImaginaryI]", "2"], "=", 
   RowBox[{"-", "1."}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->101427874,ExpressionUUID->"f3a23b6b-b920-44e6-879b-ae1136cb2d30"],

Cell[TextData[{
 "Given ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9b458ba8-d3ec-48e5-9275-214582b93ccb"],
 ", its ",
 StyleBox["complex conjugate",
  FontSlant->"Italic"],
 " is the complex number"
}], "Text",
 CellID->215538370,ExpressionUUID->"ccfc64cf-8b1b-451d-a479-fc82e7c69af6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["z", "_"], "=", 
   RowBox[{
    RowBox[{"x", "-", 
     RowBox[{"\[ImaginaryI]", "y"}]}], "=", 
    RowBox[{
     OverscriptBox[
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", "y"}]}], "_"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->985618216,ExpressionUUID->"93e6f676-d962-40e2-a849-ca8bc3175d97"],

Cell[TextData[{
 "Its ",
 StyleBox["absolute value",
  FontSlant->"Italic"],
 " or ",
 StyleBox["modulus",
  FontSlant->"Italic"],
 " is the real number"
}], "Text",
 CellID->55158655,ExpressionUUID->"43ff195a-bf0d-4b69-a054-224a10fcd252"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{"z", 
       OverscriptBox["z", "_"]}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->257296754,ExpressionUUID->"d757e035-457f-4816-82b3-01c2bbdb5c77"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Complex Plane", "Subsubsection",
 CellID->132359519,ExpressionUUID->"2ee9e99f-d7b4-4809-aa9e-94b99d0be05c"],

Cell[TextData[{
 "Complex numbers are represented in the ",
 StyleBox["complex plane",
  FontSlant->"Italic"],
 " as points or vectors, in Cartesian coordinates (Fig. 1, 2)."
}], "Text",
 CellID->197904126,ExpressionUUID->"e48f9b91-42e7-4085-b598-bbb29daea71e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"ComplexListPlot", "[", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["9", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["5120", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[{
         Labeled[0, 0, LabelStyle -> Directive[12]], 
         Labeled[1, 1, Above, LabelStyle -> Directive[12]], 
         Labeled[2, 2, Above, LabelStyle -> Directive[12]], 
         Labeled[Pi, Pi, Above, LabelStyle -> Directive[12]], 
         Labeled[I, I, LabelStyle -> Directive[12]], 
         Labeled[2 + I, 2 + I, Above, LabelStyle -> Directive[12]], 
         Labeled[-2 - I, -2 - I, Above, LabelStyle -> Directive[12]]}, 
        PlotStyle -> PointSize[Medium], PlotRange -> {{-4, 4}, {-3, 3}}, 
        AxesLabel -> {
          Style[
           ToString[
            Re[$CellContext`z], TraditionalForm], 12], 
          Style[
           ToString[
            Im[$CellContext`z], TraditionalForm], 12]}, AspectRatio -> 
        Automatic, Ticks -> {
          Range[-4, 4], 
          Range[-3, 3]}, TicksStyle -> 
        Directive[FontOpacity -> 0, FontSize -> 0], Epilog -> {{
           Text[
            Style[
             ToString[$CellContext`z, TraditionalForm], 12], {7/2, 5/2}]}, {
           Thickness[0.003], 
           Line[{{3.3, 2.25}, {3.7, 2.25}}]}, {
           Thickness[0.003], 
           Line[{{3.3, 2.25}, {3.3, 2.7}}]}}, ImageSizeRaw -> 300],
       SelectWithContents->True,
       Selectable->False], "]"}], "//", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = True}, 
       TemplateBox[{"Expression", 
         RowBox[{"Function", "[", 
           DynamicBox[
            FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
           "]"}], 
         GridBox[{{
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["224", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Labeled[#, "Fig. 1. The complex plane."]& ,
      SelectWithContents->True,
      Selectable->False]}], ",", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], 
           ",", 
           RowBox[{"Arrowheads", "[", "0.05`", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}], "]"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], 
           ",", 
           RowBox[{"Arrowheads", "[", "0.05`", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                FractionBox["1", "2"], ",", 
                FractionBox["3", "2"]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], 
           ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox["1", "2"]}], ",", 
                FractionBox["7", "2"]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], 
           ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                FractionBox["1", "2"], ",", 
                FractionBox["3", "2"]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox["1", "2"]}], ",", 
                FractionBox["7", "2"]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], 
           ",", 
           RowBox[{"Arrowheads", "[", "0.05`", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox["1", "2"]}], ",", 
                FractionBox["7", "2"]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], ",", 
             "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", "2"], ",", 
             FractionBox["3", "2"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], ",", 
             "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["3", "2"], ",", 
             RowBox[{"-", 
              FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{
                SubscriptBox["z", "1"], "+", 
                SubscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], ",",
              "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["1", "2"]}], ",", 
             FractionBox["7", "2"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", "2"], ",", 
             RowBox[{"-", 
              FractionBox["3", "2"]}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}],
              ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["3", "2"]}], ",", "0"}], "}"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}],
              ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["1", "2"]}], ",", 
             RowBox[{"-", 
              FractionBox["3", "2"]}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "12"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8`", ",", "3.75`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3.3`", ",", "3.75`"}], "}"}]}], "}"}], "]"}]}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8`", ",", "3.75`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2.8`", ",", "4.25`"}], "}"}]}], "}"}], "]"}]}], 
          "}"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "230"}]}], "]"}], "//", 
     RowBox[{
      RowBox[{"Labeled", "[", 
       RowBox[{"#1", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Fig. 2. The sum of \>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}]}], 
              ")"}], "<>", "\"\< and \>\""}], ")"}], "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{
             SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}]}], ")"}],
          "<>", "\"\<.\>\""}]}], "]"}], "&"}]}]}], "}"}], "]"}]], "Input",
 CellID->352200432,ExpressionUUID->"ba0f23da-97c0-4be2-97c4-2a9564e8b34b"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[{{{{}, {}}, {}, {{}, {{
           TagBox[{
             Directive[
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2], 
              PointSize[Medium]], 
             
             PointBox[{{0., 0.}, {1., 0.}, {2., 0.}, {3.141592653589793, 
              0.}, {0., 1.}, {2., 1.}, {-2., -1.}}]}, 
            Annotation[#, "Charting`Private`Tag#1"]& ]}, {
           TagBox[{
             Opacity[0.], 
             PointBox[{{0., 0.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {1}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{1., 0.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {2}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{2., 0.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {3}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{3.141592653589793, 0.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {4}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{0., 1.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {5}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{2., 1.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {6}}]& ], 
           TagBox[{
             Opacity[0.], 
             PointBox[{{-2., -1.}}]}, 
            Annotation[#, {{Labeled}, Charting`Private`Tag, {
              7}}]& ]}}, {{{{}, {{
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{9.999999999999998, 20.}, {0.046892344436581565`, 
                    1.0351692583274361`}], 
                   
                   Offset[{10.000000000000002`, 1.7763568394002505`*^-15}, {
                    0.046892344436581565`, 1.0351692583274361`}], 
                   
                   Offset[{
                    1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
                    0.046892344436581565`, 1.0351692583274361`}], 
                   
                   Offset[{-1.7763568394002505`*^-15, 20.}, {
                    0.046892344436581565`, 1.0351692583274361`}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox["\[ImaginaryI]", BoxRotation -> 0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 
                 Offset[{5., 10.}, {0.046892344436581565`, 
                  1.0351692583274361`}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}], 
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{12.999999999999998`, 20.}, {0.046892344436581565`, 
                    0.03516925832743618}], 
                   
                   Offset[{13.000000000000002`, 1.7763568394002505`*^-15}, {
                    0.046892344436581565`, 0.03516925832743618}], 
                   
                   Offset[{
                    1.7763568394002505`*^-15, -1.7763568394002505`*^-15}, {
                    0.046892344436581565`, 0.03516925832743618}], 
                   
                   Offset[{-1.7763568394002505`*^-15, 20.}, {
                    0.046892344436581565`, 0.03516925832743618}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox["0", BoxRotation -> 0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 
                 Offset[{6.5, 10.}, {0.046892344436581565`, 
                  0.03516925832743618}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}]}}}, {{}, {{
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{6.499999999999998, 20.}, {1., 
                    0.049736842105263156`}], 
                   
                   Offset[{6.500000000000002, 1.7763568394002505`*^-15}, {1., 
                    0.049736842105263156`}], 
                   
                   Offset[{-6.499999999999998, -1.7763568394002505`*^-15}, {
                    1., 0.049736842105263156`}], 
                   
                   Offset[{-6.500000000000002, 20.}, {1., 
                    0.049736842105263156`}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox["1", BoxRotation -> 0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 Offset[{0., 10.}, {1., 0.049736842105263156`}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}], 
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{6.499999999999998, 20.}, {2., 
                    0.049736842105263156`}], 
                   
                   Offset[{6.500000000000002, 1.7763568394002505`*^-15}, {2., 
                    0.049736842105263156`}], 
                   
                   Offset[{-6.499999999999998, -1.7763568394002505`*^-15}, {
                    2., 0.049736842105263156`}], 
                   
                   Offset[{-6.500000000000002, 20.}, {2., 
                    0.049736842105263156`}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox["2", BoxRotation -> 0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 Offset[{0., 10.}, {2., 0.049736842105263156`}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}], 
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{7.499999999999998, 20.}, {3.141592653589793, 
                    0.049736842105263156`}], 
                   
                   Offset[{7.500000000000002, 1.7763568394002505`*^-15}, {
                    3.141592653589793, 0.049736842105263156`}], 
                   Offset[{-7.499999999999998, -1.7763568394002505`*^-15}, {
                    3.141592653589793, 0.049736842105263156`}], 
                   
                   Offset[{-7.500000000000002, 20.}, {3.141592653589793, 
                    0.049736842105263156`}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox["\[Pi]", BoxRotation -> 0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 
                 Offset[{0., 10.}, {3.141592653589793, 
                  0.049736842105263156`}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}], 
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{13.999999999999998`, 20.000000000000004`}, {2., 
                    1.049736842105263}], 
                   
                   Offset[{14.000000000000002`, 3.552713678800501*^-15}, {2., 
                    1.049736842105263}], 
                   
                   Offset[{-13.999999999999998`, -3.552713678800501*^-15}, {
                    2., 1.049736842105263}], 
                   
                   Offset[{-14.000000000000002`, 19.999999999999996`}, {2., 
                    1.049736842105263}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox[
                    RowBox[{"2", "+", "\[ImaginaryI]"}], BoxRotation -> 0.], {
                   
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 Offset[{0., 10.}, {2., 1.049736842105263}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 0.5}]]]}], 
              GraphicsGroupBox[{{
                 FaceForm[
                  Directive[
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                 EdgeForm[], 
                 PolygonBox[{
                   
                   Offset[{17.999999999999996`, 
                    20.000000000000004`}, {-2., -0.9502631578947368}], 
                   
                   Offset[{18.000000000000004`, 
                    3.552713678800501*^-15}, {-2., -0.9502631578947368}], 
                   
                   Offset[{-17.999999999999996`, -3.552713678800501*^-15}, \
{-2., -0.9502631578947368}], 
                   
                   Offset[{-18.000000000000004`, 
                    19.999999999999996`}, {-2., -0.9502631578947368}]}]}, {
                 EdgeForm[], 
                 Directive[
                  RGBColor[
                  0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
                  AbsoluteThickness[1.25]]}, {}, 
                InsetBox[
                 FormBox[
                  StyleBox[
                   RotationBox[
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"2"}]}], "-", "\[ImaginaryI]"}], BoxRotation -> 
                    0.], {
                    Directive[12], 
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                 Offset[{0., 10.}, {-2., -0.9502631578947368}], 
                 NCache[
                  ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                  ImageScaled[{0.5, 
                   0.5}]]]}]}}}}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}}}, {
      DisplayFunction -> Identity, AxesOrigin -> {0, 0}, Ticks -> {{{-4, 
           FormBox[
            RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
           FormBox[
            RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
           FormBox[
            RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}, {4, 
           FormBox["4", TraditionalForm]}}, {{-3, 
           FormBox[
            RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
           FormBox[
            RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {0, 
           FormBox["0", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}, {3, 
           FormBox["3", TraditionalForm]}}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, PlotRangePadding -> {{0, 
          Scaled[0.05]}, {0, 
          Scaled[0.05]}}, ImagePadding -> {{All, All}, {All, All}}, 
       PlotRangeClipping -> False, AspectRatio -> Automatic, 
       PlotRange -> {{-4., 4.}, {-3., 3.}}, Axes -> True, AxesLabel -> {
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
         
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm]},
        DisplayFunction -> Identity, Epilog -> {{
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[7, 2], 
             Rational[5, 2]}, {3.5, 2.5}]]}, {
          Thickness[0.003], 
          LineBox[{{3.3, 2.25}, {3.7, 2.25}}]}, {
          Thickness[0.003], 
          LineBox[{{3.3, 2.25}, {3.3, 2.7}}]}}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSizeRaw -> 300, 
       Method -> {
        "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
           Directive[
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.528488, 0.470624, 0.701351], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.772079, 0.431554, 0.102387], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.363898, 0.618501, 0.782349], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[1, 0.75, 0], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.647624, 0.37816, 0.614037], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.571589, 0.586483, 0.], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.915, 0.3325, 0.2125], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[
            0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
            AbsoluteThickness[2]], 
           Directive[
            RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
            AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
         "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
         Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
         "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& )}}, TicksStyle -> 
       Directive[FontOpacity -> 0, FontSize -> 0]}], 
     "\"Fig. 1. The complex plane.\""}, "Labeled", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"]}, {
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Labeled", "[", 
       RowBox[{#, ",", #2, ",", 
         RowBox[{"{", "}"}]}], "]"}]& )], 
   TemplateBox[{
     GraphicsBox[{{
        RGBColor[0.368417, 0.506779, 0.709798], 
        Arrowheads[0.05], 
        ArrowBox[{{0, 0}, {-1, 2}}]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Arrowheads[0.05], 
        ArrowBox[
         NCache[{{0, 0}, {
            Rational[1, 2], 
            Rational[3, 2]}}, {{0, 0}, {0.5, 1.5}}]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Dashing[{Small, Small}], 
        LineBox[
         NCache[{{-1, 2}, {
            Rational[-1, 2], 
            Rational[7, 2]}}, {{-1, 2}, {-0.5, 3.5}}]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Dashing[{Small, Small}], 
        LineBox[
         NCache[{{
            Rational[1, 2], 
            Rational[3, 2]}, {
            Rational[-1, 2], 
            Rational[7, 2]}}, {{0.5, 1.5}, {-0.5, 3.5}}]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Arrowheads[0.05], 
        ArrowBox[
         NCache[{{0, 0}, {
            Rational[-1, 2], 
            Rational[7, 2]}}, {{0, 0}, {-0.5, 3.5}}]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
        NCache[{
          Rational[1, 2], 
          Rational[3, 2]}, {0.5, 1.5}], 
        NCache[
         ImageScaled[{
           Rational[-1, 2], 0}], 
         ImageScaled[{-0.5, 0}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], {-1, 2}, 
        NCache[
         ImageScaled[{
           Rational[5, 4], 
           Rational[1, 4]}], 
         ImageScaled[{1.25, 0.25}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[RowBox[{SubscriptBox[\\\"z\\\", \\\"1\\\"], \
\\\"+\\\", SubscriptBox[\\\"z\\\", \\\"2\\\"]}], TraditionalForm]\\)\"", 12, 
          StripOnInput -> False], TraditionalForm], 
        NCache[{
          Rational[-1, 2], 
          Rational[7, 2]}, {-0.5, 3.5}], 
        NCache[
         ImageScaled[{
           Rational[3, 4], 
           Rational[-1, 4]}], 
         ImageScaled[{0.75, -0.25}]]], {
        Thickness[0.003], 
        LineBox[{{0, -1}, {0, 4}}]}, {
        Thickness[0.003], 
        LineBox[{{-3, 0}, {3, 0}}]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {3, 0}, 
        NCache[
         ImageScaled[{
           Rational[-1, 4], 
           Rational[1, 2]}], 
         ImageScaled[{-0.25, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {0, 4}, 
        NCache[
         ImageScaled[{
           Rational[1, 4], 
           Rational[-1, 4]}], 
         ImageScaled[{0.25, -0.25}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
          StripOnInput -> False], TraditionalForm], {3, 4}], {
        Thickness[0.003], 
        LineBox[{{2.8, 3.75}, {3.3, 3.75}}]}, {
        Thickness[0.003], 
        LineBox[{{2.8, 3.75}, {2.8, 4.25}}]}}, ImageSize -> 230], 
     "\"Fig. 2. The sum of \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \
\\\"1\\\"], TraditionalForm]\\) and \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \
\\\"2\\\"], TraditionalForm]\\).\""}, "Labeled", DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"]}, {
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Labeled", "[", 
       RowBox[{#, ",", #2, ",", 
         RowBox[{"{", "}"}]}], "]"}]& )]},
  "RowDefault"]], "Output",
 CellID->979014697,ExpressionUUID->"9f59bcb3-a742-49dc-bbb2-4021dd43387d"]
}, {2}]],

Cell["Or in polar coordinates (Fig. 3).", "Text",
 CellID->43983047,ExpressionUUID->"ed39b878-0d9d-ca44-bd34-ddc0d68b1784"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "z", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2c", "[", "p_", "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"p", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"c2p", "[", "p_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "p", "]"}], ",", 
     RowBox[{"Im", "[", "p", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"brace", "[", 
   RowBox[{"pa_", ",", "pb_", ",", 
    RowBox[{"a_", ":", 
     RowBox[{"1", "/", "10"}]}], ",", 
    RowBox[{"t_", ":", 
     RowBox[{"1", "/", "3"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "\[Rho]"}], "}"}], ",", 
    RowBox[{
     RowBox[{"\[Theta]", "=", 
      RowBox[{"Arg", "[", 
       RowBox[{"p2c", "[", 
        RowBox[{"pb", "-", "pa"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]", "=", 
      RowBox[{"Norm", "[", 
       RowBox[{"p2c", "[", 
        RowBox[{"pb", "-", "pa"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"pa", "+", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "+", "\[Theta]", "+", 
            RowBox[{"t", " ", 
             RowBox[{"\[Pi]", "/", "2"}]}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "\[Pi]"}], ")"}], "/", "2"}], "+", "\[Theta]"}]}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"pa", "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "-", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "-", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
          RowBox[{"2", "a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], "+", "\[Theta]"}]}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "+", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
          RowBox[{"2", "a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], "+", "\[Theta]"}], ",", 
           RowBox[{"\[Pi]", "+", "\[Theta]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
          RowBox[{"pb", "-", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"pb", "-", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "\[Pi]"}], ")"}], "/", "2"}], "+", "\[Theta]"}], ",", 
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "+", "\[Theta]", "-", 
            RowBox[{"t", " ", 
             RowBox[{"\[Pi]", "/", "2"}]}]}]}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<1\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<-1\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<-\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", "1"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2.8"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{"\"\<z\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8", ",", "2.75"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3.3", ",", "2.75"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8", ",", "2.75"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2.8", ",", "3.25"}], "}"}]}], "}"}], "]"}]}], "}"}], 
         ","}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", "/", "2"}], ",", 
            RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"17", "/", "2"}], "]"}]}], 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"5", "/", "2"}], ",", 
             RowBox[{"3", "/", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"5", "/", "2"}], ",", 
              RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.45", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"ArcTan", "[", 
               RowBox[{"3", "/", "5"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[Theta]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6", ",", "0.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "0.4"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"StringJoin", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"HoldForm", "[", 
                RowBox[{"z", "==", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", "*", "y"}]}], "==", "r"}], "]"}], ",",
                "TraditionalForm"}], "]"}], 
             ",", "\"\<(cos\[Theta]+\[ImaginaryI] sin\[Theta])\>\""}], "]"}], 
           ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", "/", "2"}], ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.0025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"BezierCurve", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2", ",", 
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"3", "/", "2"}], ",", 
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"11", "/", "8"}], ",", 
               RowBox[{"3", "/", "4"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"17", "/", "2"}], "]"}]}], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"5", "/", "2"}], ",", 
                RowBox[{"3", "/", "2"}]}], "}"}]}]}], "}"}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<cos\[Theta]+\[ImaginaryI] sin\[Theta]\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0.5"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.0025", "]"}], ",", 
         RowBox[{"brace", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"5", "/", "2"}], ",", 
             RowBox[{"3", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"1", "/", "20"}], ",", 
           RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"r", ",", "11"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", "/", "4"}], ",", 
           RowBox[{"3", "/", "4"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{"-", "2.5"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "->", "320"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<Fig. 3. The representation of the complex number \>\"", ",", 
     
     RowBox[{"ToString", "[", 
      RowBox[{"z", ",", "TraditionalForm"}], "]"}], 
     ",", "\"\< in polar coordinates.\>\""}], "]"}]}], "]"}]}], "Input",
 CellID->83803175,ExpressionUUID->"907e19d7-2580-4abb-bc56-fa53e5112bb6"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      CircleBox[{0, 0}]}, 
     InsetBox[
      FormBox[
       StyleBox["\"1\"", 12, StripOnInput -> False], TraditionalForm], {1, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"-1\"", 12, StripOnInput -> False], TraditionalForm], {-1, 
      0}, 
      NCache[
       ImageScaled[{
         Rational[5, 4], 0}], 
       ImageScaled[{1.25, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 1}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"-\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, -1}, 
      NCache[
       ImageScaled[{
         Rational[5, 4], 1}], 
       ImageScaled[{1.25, 1}]]], {
      Thickness[0.003], 
      LineBox[{{0, -2}, {0, 2.8}}]}, {
      Thickness[0.003], 
      LineBox[{{-3, 0}, {3, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
        RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], {3, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
        RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], {0, 2.8}, 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 4]}], 
       ImageScaled[{0, -0.25}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{
         Rational[5, 2], 
         Rational[3, 2]}, {2.5, 1.5}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{5 34^Rational[-1, 2], 3 34^Rational[-1, 2]}, {
        0.8574929257125441, 0.5144957554275265}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      LineBox[
       NCache[{{0, 0}, {
          Rational[5, 2], 
          Rational[3, 2]}}, {{0, 0}, {2.5, 1.5}}]]}, {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.45, 
        NCache[{0, 
          ArcTan[
           Rational[3, 5]]}, {0, 0.5404195002705842}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0.6, 0.1}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 0.3}], 
       ImageScaled[{0.5, 0.3}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"z\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"x\\\", \\\"+\\\", RowBox[{\\\"\[ImaginaryI]\\\", \\\" \\\", \\\"y\
\\\"}]}], \\\"\[LongEqual]\\\", \\\"r\\\"}], HoldForm], \
TraditionalForm]\\)(cos\[Theta]+\[ImaginaryI] sin\[Theta])\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[5, 2], 
        Rational[3, 2]}, {2.5, 1.5}], 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 4]}], 
       ImageScaled[{0, -0.25}]]], {
      Thickness[0.0025], 
      ArrowBox[
       BezierCurveBox[
        NCache[{{2, 
           Rational[-1, 2]}, {
           Rational[3, 2], 
           Rational[-1, 2]}, {
           Rational[11, 8], 
           Rational[3, 4]}, {5 34^Rational[-1, 2], 3 34^Rational[-1, 2]}}, {{
          2, -0.5}, {1.5, -0.5}, {1.375, 0.75}, {0.8574929257125441, 
          0.5144957554275265}}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"cos\[Theta]+\[ImaginaryI] sin\[Theta]\"", 12, StripOnInput -> 
        False], TraditionalForm], 
      NCache[{2, 
        Rational[-1, 2]}, {2, -0.5}], 
      ImageScaled[{0, 0.75}]], {
      Thickness[0.0025], {
       CircleBox[
        NCache[{
          Rational[19, 8], 
          Rational[57, 40]}, {2.375, 1.425}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[1, 6] Pi + ArcTan[
            Rational[3, 5]], Rational[1, 2] Pi + ArcTan[
            Rational[3, 5]]}, {1.064018275868883, 2.1112158270654806`}]], 
       LineBox[
        NCache[{{
           Rational[23, 10], 
           Rational[31, 20]}, {
           Rational[13, 10], 
           Rational[19, 20]}}, {{2.3, 1.55}, {1.3, 0.95}}]], 
       CircleBox[
        NCache[{
          Rational[49, 40], 
          Rational[43, 40]}, {1.225, 1.075}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{-Pi + ArcTan[
            Rational[3, 5]], Rational[-1, 2] Pi + ArcTan[
            Rational[3, 5]]}, {-2.601173153319209, -1.0303768265243125`}]], 
       CircleBox[
        NCache[{
          Rational[39, 40], 
          Rational[37, 40]}, {0.975, 0.925}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[-1, 2] Pi + ArcTan[
            Rational[3, 5]], 
          ArcTan[
           Rational[3, 5]]}, {-1.0303768265243125`, 0.5404195002705842}]], 
       LineBox[
        NCache[{{
           Rational[21, 20], 
           Rational[4, 5]}, {
           Rational[1, 20], 
           Rational[1, 5]}}, {{1.05, 0.8}, {0.05, 0.2}}]], 
       CircleBox[
        NCache[{
          Rational[1, 8], 
          Rational[3, 40]}, {0.125, 0.075}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[1, 2] Pi + ArcTan[
            Rational[3, 5]], Rational[5, 6] Pi + ArcTan[
            Rational[3, 5]]}, {2.1112158270654806`, 3.1584133782620785`}]]}}, 
     
     InsetBox[
      FormBox[
       StyleBox["r", 11, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[5, 4], 
        Rational[3, 4]}, {1.25, 0.75}], 
      NCache[
       ImageScaled[{
         Rational[5, 2], -0.75}], 
       ImageScaled[{2.5, -0.75}]]]}, ImageSize -> 320], 
   "\"Fig. 3. The representation of the complex number \\!\\(\\*FormBox[\\\"z\
\\\", TraditionalForm]\\) in polar coordinates.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->213110671,ExpressionUUID->"f3de9161-f481-49c4-82a6-39bb76fa65ad"]
}, {2}]],

Cell[TextData[{
 "Where the complex number ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e66a1e2b-ce7f-4f9c-aa39-6b1a04c6bfcc"],
 " is written"
}], "Text",
 CellID->988905240,ExpressionUUID->"45f49141-f458-4161-8c24-f9a0a540c2b5"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"cos", " ", "\[Theta]"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "sin", " ", "\[Theta]"}]}], ")"}]}]}], 
   ","}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->655590036,ExpressionUUID->"17fe4828-8c77-40e5-9ae5-5d69eef9a907"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0b3fe131-95aa-4838-9af3-8852353be5c3"],
 " is the ",
 StyleBox["argument",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c13b9f97-2213-4f0d-9cf4-c6c9cdb79ff8"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c4b7d7c3-4af2-4913-b5a2-75894be0d34c"],
 " is its modulus or absolute value."
}], "Text",
 CellID->54662656,ExpressionUUID->"cde95db1-2603-4e25-87bd-cbb9ae156af4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Addition and Multiplication", "Subsubsection",
 CellID->702094346,ExpressionUUID->"94e2545f-fa7a-4b0e-9801-1abab57999a3"],

Cell[TextData[{
 "Addition of complex numbers works like with real numbers, but using the \
rule ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ImaginaryI]", "2"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a5bb0c07-816d-45d0-88fd-e01f08989a61"],
 ":"
}], "Text",
 CellID->319708638,ExpressionUUID->"4e59f97d-d9cf-4e41-b381-f48d93d7724e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "c"}], ")"}], "+", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{"b", "+", "d"}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->228605019,ExpressionUUID->"541fd2fb-fec0-4fe2-8096-6c9af9a2078b"],

Cell["\<\
In the complex plane, it can be visualized as vector addition.\
\>", "Text",
 CellID->241301666,ExpressionUUID->"d1bd81f4-d6ce-49fb-8200-12118ab78115"],

Cell["Multiplication works by", "Text",
 CellID->523567933,ExpressionUUID->"f6f8d1db-4d02-4dce-a6da-91f110b1d6ef"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{"b", " ", "d"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{"a", " ", "d"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->533759894,ExpressionUUID->"7ffe809f-6f33-464a-b131-96135fb5c06f"],

Cell[TextData[{
 "It corresponds to multiplying the absolute values and adding the angles of \
the two numbers in polar coordinates: with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{
     SubscriptBox["r", "1"], "(", 
     RowBox[{
      RowBox[{"cos", " ", 
       SubscriptBox["\[Theta]", "1"]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["sin\[Theta]", "1"]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8fd753de-3e61-4aee-828c-f921ff7d1499"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     SubscriptBox["r", "2"], "(", 
     RowBox[{
      RowBox[{"cos", " ", 
       SubscriptBox["\[Theta]", "2"]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["sin\[Theta]", "2"]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3464048b-bd75-468b-acfa-967fb38a8cf3"],
 ","
}], "Text",
 CellID->458118477,ExpressionUUID->"9f419d80-529f-43c1-8b31-85999d84518d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["z", "1"], 
    SubscriptBox["z", "2"]}], "=", 
   RowBox[{
    SubscriptBox["r", "1"], 
    RowBox[{
     RowBox[{
      SubscriptBox["r", "2"], "[", 
      RowBox[{
       RowBox[{"cos", "(", 
        RowBox[{
         SubscriptBox["\[Theta]", "1"], "+", 
         SubscriptBox["\[Theta]", "2"]}], ")"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"sin", "(", 
         RowBox[{
          SubscriptBox["\[Theta]", "1"], "+", 
          SubscriptBox["\[Theta]", "2"]}], ")"}]}]}], "]"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->17545120,ExpressionUUID->"27be7e03-38ae-4123-b011-b19981b10002"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", "Dashed", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"StringJoin", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Abs", "[", "z", "]"}], ",", "TraditionalForm"}], 
              "]"}], ",", "\"\<=1\>\""}], "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              FractionBox["2", "3"], ",", 
              RowBox[{"-", 
               FractionBox["1", "3"]}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["2", "3"], ",", 
           RowBox[{"-", 
            FractionBox["1", "3"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{"3", "/", "5"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], "/", "3"}], ",", "2"}], "}"}]}], "}"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], "/", "3"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "/", "9"}], ",", 
              RowBox[{"14", "/", "9"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{
              SubscriptBox["z", "1"], "*", 
              SubscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "/", "9"}], ",", 
           RowBox[{"14", "/", "9"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "Pi"}], ",", 
              RowBox[{
               RowBox[{"2", "Pi"}], "-", 
               RowBox[{"ArcTan", "[", 
                FractionBox["1", "2"], "]"}]}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(1\)]\)\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "5"}], ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "10"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "3"}], ",", 
           RowBox[{"2", "/", "9"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.35", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"\[Pi]", "-", 
               RowBox[{"ArcTan", "[", "3", "]"}]}]}], "}"}]}], "]"}], "]"}]}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(2\)]\)\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "5"}], ",", 
           RowBox[{"2", "/", "5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.45", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"ArcTan", "[", "7", "]"}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \
\(1\)]\)+\!\(\*SubscriptBox[\(\[Theta]\), \(2\)]\)\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "/", "3"}], ",", 
           RowBox[{"2", "/", "5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
            "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
            "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.3"}], ",", 
           RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1.5", ",", "2.3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.8", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "->", "240"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", 
   ",", "\"\<Fig. 4. The multiplication of two complex numbers.\>\""}], 
  "]"}]], "Input",
 CellID->12708307,ExpressionUUID->"9442589b-f92e-4cc8-9097-ca24acfa2f94"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      Dashing[{Small, Small}], 
      CircleBox[{0, 0}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)=1\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-1, 2], 
        Rational[-1, 2]}, {-0.5, -0.5}], 
      NCache[
       ImageScaled[{
         Rational[3, 2], 1}], 
       ImageScaled[{1.5, 1}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[2, 3], 
          Rational[-1, 3]}}, {{0, 0}, {
         0.6666666666666666, -0.3333333333333333}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 3], 
        Rational[-1, 3]}, {0.6666666666666666, -0.3333333333333333}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[4, 5]}], 
       ImageScaled[{0.25, 0.8}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[-2, 3], 2}}, {{0, 0}, {-0.6666666666666666, 2}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-2, 3], 2}, {-0.6666666666666666, 2}], 
      NCache[
       ImageScaled[{1, 
         Rational[1, 2]}], 
       ImageScaled[{1, 0.5}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[2, 9], 
          Rational[14, 9]}}, {{0, 0}, {0.2222222222222222, 
         1.5555555555555556`}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{SubscriptBox[\\\"z\\\", \\\"1\\\"], \\\" \
\\\", SubscriptBox[\\\"z\\\", \\\"2\\\"]}], TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 9], 
        Rational[14, 9]}, {0.2222222222222222, 1.5555555555555556`}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 0}], 
       ImageScaled[{0.25, 0}]]], {
      Arrowheads[{0, -0.02}], 
      ArrowBox[
       CircleBox[{0, 0}, 0.3, 
        NCache[{2 Pi, 2 Pi - ArcTan[
           Rational[1, 2]]}, {6.283185307179586, 5.81953769817878}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(1\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[3, 5], 
        Rational[-1, 10]}, {0.6, -0.1}], 
      NCache[
       ImageScaled[{
         Rational[2, 3], 
         Rational[11, 18]}], 
       ImageScaled[{0.6666666666666666, 0.6111111111111112}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.35, 
        NCache[{0, Pi - ArcTan[3]}, {0, 1.8925468811915387`}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(2\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-1, 5], 
        Rational[2, 5]}, {-0.2, 0.4}], 
      NCache[
       ImageScaled[{
         Rational[3, 4], 
         Rational[1, 2]}], 
       ImageScaled[{0.75, 0.5}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.45, 
        NCache[{0, 
          ArcTan[7]}, {0, 1.4288992721907328`}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(1\\)]\\)+\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(2\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 3], 
        Rational[2, 5]}, {0.6666666666666666, 0.4}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], {
      Thickness[0.003], 
      LineBox[{{0, -2}, {0, 2}}]}, {
      Thickness[0.003], 
      LineBox[{{-2, 0}, {2, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {2, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{-0.5, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 2}, 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 2]}], 
       ImageScaled[{0, -0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[3, 2], 2}, {1.5, 2}], 
      ImageScaled[{-0.6499999999999999, -0.25}]], 
     LineBox[{{1.5, 2.3}, {1.5, 2}, {1.8, 2}}]}, ImageSize -> 240], 
   "\"Fig. 4. The multiplication of two complex numbers.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->807623629,ExpressionUUID->"8d485305-ef08-4ce7-a068-feaa574bd9c2"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Riemann Sphere", "Subsubsection",
 CellID->404130285,ExpressionUUID->"32de264a-d9e3-47e1-86cf-46b6d782f893"],

Cell[TextData[{
 "Complex numbers ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "075cd59c-af7f-4689-b843-20a150b3e1da"],
 " can also be represented as points ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["z", "^"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cbe4ad7d-2d6d-44c8-ba62-81a7057e4955"],
 " on the ",
 StyleBox["Riemann sphere",
  FontSlant->"Italic"],
 ", which is a sphere of radius 1 centered at the origin. The representation \
(called ",
 StyleBox["stereographic projection",
  FontSlant->"Italic"],
 ") is constructed as the intersection with the sphere of a line joining ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d2c2cc62-d2bd-4c5d-a062-ab3782865c4c"],
 " and the sphere\[CloseCurlyQuote]s north pole, as in the figure here."
}], "Text",
 CellID->41251982,ExpressionUUID->"99f68ff6-6535-44f9-99d3-7af2967debf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "=", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"y", "=", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ParametricPlot3D", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Directive", "[", 
               RowBox[{"LightBlue", ",", 
                RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}]}], 
           "]"}], ",", 
          RowBox[{"ParametricPlot3D", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", "t", "]"}], " ", 
               RowBox[{"Cos", "[", "p", "]"}]}], ",", 
              RowBox[{
               RowBox[{"Sin", "[", "t", "]"}], " ", 
               RowBox[{"Sin", "[", "p", "]"}]}], ",", 
              RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"p", ",", "0", ",", 
              RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                FractionBox[
                 RowBox[{"2", " ", "x"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{"2", " ", "y"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"], "-", "1"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]]}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", "x"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{"2", " ", "y"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"], "-", "1"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<N\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{
                 OverscriptBox["z", "^"], ",", "TraditionalForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 FractionBox[
                  RowBox[{"2", " ", "x"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]], ",", 
                 FractionBox[
                  RowBox[{"2", " ", "y"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]], ",", 
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"], "-", "1"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"1", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\[ImaginaryI]", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"zp", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\"\<Fig. 5. Stereographic projection.\>\""}], 
  "]"}]], "Input",
 CellID->92703975,ExpressionUUID->"b33cc200-21a9-4548-8326-6d128a7a9586"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`zp$$ = {-2, -2}, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`zp$$], {-2, -2}, 
           Text[
            Style[
            "\!\(\*FormBox[\"z\", TraditionalForm]\)", 12]]}, {-3, -3}, {3, 
          3}, ControlType -> Slider2D}}, 
       Typeset`size$$ = {240., {83.50477583293457, 90.73719770793457}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`zp$$ = {-2, -2}}, 
        "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Module[{$CellContext`x = Part[$CellContext`zp$$, 1], $CellContext`y = 
           Part[$CellContext`zp$$, 2]}, 
          Show[{
            
            ParametricPlot3D[{$CellContext`x, $CellContext`y, 
              0}, {$CellContext`x, -3, 3}, {$CellContext`y, -3, 3}, MeshStyle -> 
             None, PlotStyle -> {
               Directive[LightBlue, 
                Opacity[0.4]]}], 
            
            ParametricPlot3D[{
             Sin[$CellContext`t] Cos[$CellContext`p], Sin[$CellContext`t] 
              Sin[$CellContext`p], 
              Cos[$CellContext`t]}, {$CellContext`t, 0, Pi}, {$CellContext`p, 
              0, 2 Pi}, MeshStyle -> None, PlotStyle -> {
               Opacity[0.4]}], 
            Graphics3D[{
              Point[{$CellContext`x, $CellContext`y, 0}], 
              Point[{0, 0, 1}], 
              
              Point[{2 ($CellContext`x/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), 
                2 ($CellContext`y/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/(1 + $CellContext`x^2 + $CellContext`y^2)}], 
              Line[{{$CellContext`x, $CellContext`y, 0}, {0, 0, 1}}], 
              
              Line[{{$CellContext`x, $CellContext`y, 0}, {
                2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
                 2 ($CellContext`y/(
                  1 + $CellContext`x^2 + $CellContext`y^2)), \
($CellContext`x^2 + $CellContext`y^2 - 1)/(
                 1 + $CellContext`x^2 + $CellContext`y^2)}}], 
              Line[{{-3, 0, 0}, {3, 0, 0}}], 
              Line[{{0, -3, 0}, {0, 3, 0}}], 
              Text[
               
               ToString[$CellContext`z, 
                TraditionalForm], {$CellContext`x, $CellContext`y, 0}, {1, 
               1}], 
              Text["N", {0, 0, 1}, {0, -1}], 
              Text[
               ToString[
                OverHat[$CellContext`z], TraditionalForm], {
               2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
                2 ($CellContext`y/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/(1 + $CellContext`x^2 + $CellContext`y^2)}, {1, 1}], 
              Point[{1, 0, 0}], 
              Text[1, {1, 0, 0}, {1, 1}], 
              Point[{0, 1, 0}], 
              Text[I, {0, 1, 0}, {1, 1}]}]}]], 
        "Specifications" :> {{{$CellContext`zp$$, {-2, -2}, 
            Text[
             Style[
             "\!\(\*FormBox[\"z\", TraditionalForm]\)", 12]]}, {-3, -3}, {3, 
           3}}}, "Options" :> {}, "DefaultOptions" :> {}], 
       ImageSizeCache -> {290.5, {158.50477583293457`, 165.73719770793457`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 5. Stereographic projection.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->418074643,ExpressionUUID->"22c46ed9-77aa-4421-b0bb-90ae464552a5"]
}, {2}]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Functions", "Subsection",
 CellID->643385582,ExpressionUUID->"14e32912-a83e-44c5-9bd3-435e7a775a61"],

Cell[CellGroupData[{

Cell["Visualization of Complex Functions", "Subsubsection",
 CellID->825712246,ExpressionUUID->"bac3ed51-5187-4eb2-bc85-ddab44f5434e"],

Cell[TextData[{
 "A complex function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     RowBox[{
      RowBox[{"f", "(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
      RowBox[{
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"v", "(", 
         RowBox[{"x", ",", "y"}], ")"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b9d177ad-fe38-4600-847a-0d2198267386"],
 " can be visualized in several different ways."
}], "Text",
 CellID->56675858,ExpressionUUID->"48631a2c-fbec-4662-9ac8-be3f287afa53"],

Cell[TextData[{
 "Taking ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"31070d97-35b1-4268-85ac-7fee5e9d270b"],
 ", one can plot its real and imaginary parts."
}], "Text",
 CellID->475691221,ExpressionUUID->"1efbeb3f-d7b0-4b1c-b20d-86572cf03fcb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
      RowBox[{"Im", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["6", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1792", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-10, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], Mesh -> None, AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> {
        ToString[
         Re[$CellContext`z^2], TraditionalForm], 
        ToString[
         Im[$CellContext`z^2], TraditionalForm]}],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["664", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 6. Real and imaginary parts of " <> ToString[
       HoldForm[$CellContext`w == $CellContext`f[$CellContext`z] == \
$CellContext`z^2], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->362855523,ExpressionUUID->"1596f31f-76e6-4d9b-af2d-c4bdf43a1558"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJytmg+Q1dV1xx/LKmRbbNZiTLaIu7ql1USJf0oQXny3lWkhTaJhDYxWiKIo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          "], {{{
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
                 RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                "Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmgnYlsMax5+xb0XRQkWIbCch0YJQ9kQKkTbbR7RvorTKkkKyJpQtFVmP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                 "]]}, Annotation[#, "Charting`Private`Tag$12975#1"]& ]]}, {
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
                 RGBColor[
                 0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
                "Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmGuUllUVx5nnAbk4YHEdrsplAEUE5DpcZ7jNDNeZ4U6ShYiIBAqWmSKS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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwlkMFKAlAQRZ/v2dZFbVyJ/oAf4ycIqaioRAgFLhRBEUMEFREXRkqQSBgS
ISJ9TiuXugvPZRYHDm/mMXcmla1mKt45F4coNIJzMx4+4BPPw1/EuQuM8Dnc
UbuFKv4G/9ROUMB/YEltDC/4K6TwJCzwgf5469njfejgXfjC6/CM92CNN4Nl
2UMLf4cEHoMK/ghpb28PeC1YNs3UbGVW9jPc40PYahYc8UMwVyZla8Ovtx71
roLN0o5F/ClYNt1og5ch6u0mus0OJt520m5TuPHWU8JzwbLoTTXdSLfSn2/8
CvorNVw=
                 "]]}, Annotation[#, "Charting`Private`Tag$12975#2"]& ]]}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNULsOgkAQvOM+QP7AWEphw59YQgIJVBZqLGws7P0DbI1RNMZoo/JVPrDH
2eyYUMzt3dzu7Oz2sulw4hljAsABKY4YCIE1Pg5AKRHvrtwRC3J7YOk054w4
AGrc31bjF7Ce1nUAH9gg54n/EeLjrw00VvmXVa7vVF+8BE7fxlNdyzrxIR53
TvVn7G/oQXKkx91TXcM+IfWEvyJWiBfOUbHGsEZ0Iqez1PST09PWqd6Y+4pb
Pv3WzIaeV/Rb8K+hpwV3feIOI86RU/OGe0b+Y5VLyQuX0Z/0Ljmv8AnzE9aK
9typjyO9BtzzD27qQmg=
                "]], 
               
               Polygon3DBox[{{944, 697, 681, 894}, {881, 527, 543, 937}, {940,
                 665, 649, 885}, {942, 681, 665, 890}, {873, 495, 511, 932}, {
                877, 511, 527, 934}}]}]}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJw1kb1OAkEUhWd3nsBHoN6180nsTCABQi2FhSaaSGJiCJTGEEKIlbzAaigo
/FkfRaBGsfc7mUPx7bl7Z+b+Nrr90/M8hFBChGs+zziW6G8Wwg57j474j9gz
tIIJ9hU6hiPsJ7QFZ/CTJz2O6X3H/m/irOEvSzEP93RHOV/hBd7xfaBv6Ak0
oYBhTG8n9vWgdOyW48vuOHfP977ypG3b6ku95FBBDZ/OrzoWsIrpbBCTX/lV
m2reOcbSs7pxfbXrjz7fe36q5dC3dJOlWpru7x62+B7QqXscOl7lmHeeiWZz
69pWfl+4RuVaO2/h2dTuvfS9C+9Le3t0XuW/9E6127l3rZ3/A/bCT7o=
                "]], 
               
               Polygon3DBox[{{949, 678, 677, 891}, {896, 691, 706, 957}, {892,
                 677, 692, 953}, {919, 501, 486, 901}, {927, 529, 514, 905}, {
                923, 515, 500, 903}, {903, 500, 501, 921}, {905, 514, 515, 
                925}, {953, 692, 691, 895}, {901, 486, 487, 917}, {888, 663, 
                678, 949}, {957, 706, 705, 899}}]}]}, {}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwt0LtKgmEAx+EvzdJOdgVFVC6SW06FbhVFJ7fa2myw1a7ArsAIWhNcQkIh
3MKuIDPtYNmd+AgOD7//y/cu37tycXVamAiCIEeI0V5kmRTbHJD04VwfNc2l
/aRZru1dvdFbKjR4pc07HT7o0uPQ/U991iPu+HJu6jH3fDuf6I/2+eWPAf+8
0aLOA2X23C/pi+5QtGuaIW9v6pnus8UGS8RZYJ45Zpkh4X5Mq7pOdPR/usa0
vapTGmGS8PgdhxjmJV8=
              "]]}, {
             GrayLevel[0], 
             
             Line3DBox[{865, 484, 861, 754, 499, 514, 529, 883, 907, 927, 905,
               925, 906, 923, 903, 921, 904, 919, 901, 917, 902, 915, 487, 
              486, 485, 813, 865}], 
             
             Line3DBox[{489, 488, 871, 916, 869, 918, 870, 920, 875, 922, 876,
               924, 879, 926, 880, 929, 928, 544, 559, 574, 589, 604, 619, 
              634, 886, 939, 889, 941, 893, 943, 897, 898, 698, 699, 700, 701,
               702, 703, 704, 900, 913, 958, 914, 956, 911, 954, 912, 952, 
              909, 950, 910, 948, 908, 946, 648, 633, 618, 603, 588, 573, 558,
               884, 882, 935, 878, 933, 874, 931, 872, 494, 493, 492, 491, 
              490, 489}], 
             
             Line3DBox[{496, 495, 930, 873, 932, 877, 934, 881, 937, 936, 543,
               528, 513, 756, 866, 498, 862, 814, 497, 496}], 
             
             Line3DBox[{938, 649, 664, 679, 810, 867, 694, 863, 819, 695, 696,
               697, 945, 944, 894, 942, 890, 940, 885, 938}], 
             
             Line3DBox[{678, 663, 887, 947, 888, 949, 891, 951, 892, 953, 895,
               955, 896, 957, 899, 960, 959, 705, 706, 707, 812, 868, 708, 
              864, 820, 693, 678}]}}}, VertexNormals -> CompressedData["
1:eJzVewlYjlv3dxEyR2VIRBlLUUqk0zaEFKF0iBxHSIocCSHzPEQ54phC1IkK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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, 
         FaceGridsStyle -> Automatic, 
         Method -> {"DefaultBoundaryStyle" -> Directive[
             GrayLevel[0.3]], 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-10., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"], \\\")\\\"}], TraditionalForm]\\)\"", 
           "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", SuperscriptBox[\
\\\"z\\\", \\\"2\\\"], \\\")\\\"}], TraditionalForm]\\)\""}, "SwatchLegend", 
          DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 Graphics3DBox[
                  SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                  PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
                  0]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 6. Real and imaginary parts of \
\\!\\(\\*FormBox[TagBox[RowBox[{\\\"w\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->1080812295,ExpressionUUID->"19e21a6a-1f74-4572-97eb-5c4058b70923"]
}, {2}]],

Cell["Or its modulus and argument.", "Text",
 CellID->168372174,ExpressionUUID->"156b923c-f8e5-4a30-80e9-0b8f03f0d851"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Abs", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
      RowBox[{"Arg", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["7", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1664", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-4, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], Mesh -> None, AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, Exclusions -> All, 
      PlotLegends -> {
       "Abs(\!\(\*SuperscriptBox[\(z\), \(2\)]\))", 
        "Arg(\!\(\*SuperscriptBox[\(z\), \(2\)]\))"}],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["664", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 7. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`w == $CellContext`f[$CellContext`z] == \
$CellContext`z^2], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->72528126,ExpressionUUID->"46d7777c-5d68-42b8-bab7-c93621a99c18"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJyVnXm8zdX+/898dso8JBeZIlLpplAnn1VKVOYhhFRXCqekOVGkkCYypHQq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          "], {{{
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
                 RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                "Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmgnY11MWx38Xb9mXtGpmkKUwg4nSYgaV0lCK7A0t1CsjLUqpCMW0K/HM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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwtkU0rxFEUhw/j3DRpkrc0NsZ2FmavfACxmaWlD8DX8AXIDkNGKBpKFspL
MikvTURDsrCwEFnITp5fx+Lp/5x7Tuf8z72FqZnydKuZDUIbvLlZie8wbOLb
MIpPwCfehEv8CvqT2Q/xCF6EDfwQ9vFzyJDf8uilHu+4p8jV4YT4FYbwAlTx
HvLX+BHcEz96zNJZX4oz5Y6hi7hGPImPwQ6+BN0WPdW7g5pdfBVuibMpfA4a
xHdQs6jJkdsjnsUXdOZRo9p5aCe/7vGvpf+7+vbYfQDW8AOoWtxBC/WdKf5V
MzRLO2v3BzjFK0CJ9cKzx0zNVo9f/MKjdx6+PHbUrrrzG4830duMwwf+oju0
uINF/AyeLN5Mb6cZmqWaZY+e6p2FFfwPvWZJJw==
                 "]]}, Annotation[#, "Charting`Private`Tag$16086#1"]& ]]}, {
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
                 RGBColor[
                 0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
                "Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNm3f811P7x+t9ziclRYq0uLMz2kqDSigNGiqjklQaGrRLWspeiZQyb7L3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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwtlmeMVVUUhZ/cs2M0GhSlqAgMdukoVelI701A2oyKNIeOgCCggICA9CZg
b9ixN8RCLBRRo1IUNMRYAAEBiVGj38p6P745a99595629zqnoGhkt+ISuVxu
AyR4lT9lIpf7PcvlfuAfS4gT8T7i72Ec+iq4lOcd4Rb0FVAZfQOMQF8Jl6Db
Qj/05VCAbgYd9C5URNeHKeir4TJ0V+ghDZXQ18MaWACr6LsvvI9+CXYytkLi
eejNyfokz8rx7nBow7M74ADcTNyS9lb4CVYSF9EOhu2wmvhO2mn5vj6A2zL3
+Ri6uuZMOxU+hMdhXwn/piL/mw/9eHY2XIQeCx3QE+FvmEvcm/Z2KEDX1JzR
5eFfeB1O8q3dmgP6BTiB/gJO47dvEv+J3gsNiTcQnws1oB3x87TnQT0YRvwa
bbnkNWhO/CxtKbgGgvht2lOZ93RmeA4aey9YgX5H80heo8rE9aE6+uLkvusS
V8uPoaX2Giqgr9Wehd/Rb2vqWXjOmmvV5LE0Jq6VH1Nt9FO050AV6Ev8BG1J
aAIHoU743SFQQXsFXdCT4Ag0Cvc1FL7WPodz8SblTXKOKDc2a03R/cO52BeO
K2/DYx8Ge6Cacpp2AKxDP6o85d0ZtA/Dt8pB4o2qEfT9/Ka/akF5Ad2Jr1Pe
5ffyu+S+tafKnfc0tsw59CT6TH7/G/EB4me0FsSHiP+A57S3xIfRx+Fp5Rnx
QfQxKKm+wrkwLl8b70LvzDWisW9Krh3N4T70R6oN9GIoxbstwrkxHrZCz3Dt
9czn5gXERzLn6FrNV/mF3gKrk7+pb6nPT5PnpLksIP4ZPYP3u6umknPvG3gw
cw6eQncMe8Fw2AufJL+7CSbzv7eIL0ze8wdgIZyfeQ3/Qs8K5+4IOEtzCefS
WPhPdRf2omLI0OPD3jUSTkdPDXvPqORaK098NHPNfay9CudiUzgDvRQGoUfD
Nlgfzo2ZmleyZ8or9Y0x/O8NrWGyJ3QjflHjT86RBeEcUu7IQwrDniWvagGV
iBfBQHQZWB72MHlXIdwbXgPN/UboHF5TrWUD7U3Yg+Q9ffR7OATbGds2WJ5/
Jq2c6hrOYeVuQ6gR9kh5ozxwSdgT5YVag/naE55N15jZ82nhNdVadlOehddc
a90JWodrTrVWB1YRLwvPZYz2JLxn2qt2sDbch74tj24SrnnVujykXtgj5A3y
pEXwT7KX7oJ1+WfSOtPmok8ke+tOWK/chT2Zc/xl9I/Jub2fPh9CL4X9mXNW
v82FvVjv7CKuojMuP8YtyR4hb1CN7U7+jf4nz1iZPAb1rZqegz4Kn6N3wIrk
Z9LyANXal7Auc819lXxG62zWs3vCNaba6qHvJM9BY1+buVZ2JGvVzJpwzipX
tWdViR+hnZLsedOJZ9NOTq7ZgWHPlFc2V45F3iOgkfoNe668tlXyt2aHc1Hf
1NnUKrzXOqN0NxgCrZPvCKqN4vBeq0bk/fPCuaozQGfD3eG56YzQ2XRXOLd0
Rs0J14hqQ2fsQvRG2tLJnqyzqSnUTj6jtFfyeHm79kx3j4nQOfkOortHl3Du
6w6iu84oaJ9855EXTQjnsjxJtdwpXGuqad1t2kDd5DuOxtIrvFYa09DwHUV3
E63BpPCZprNMY2iLLg0Tkr/RIOzx8nadwbXCHidv0x1idPjOobuGxrg47FHy
JnlGs7DHy9u1BkXoV2jLJt+JlsEs+CzzGfRr8hmjs2Vr5rtbb2icfIfT3WJw
eK91x9Ddb1DYq3QH7BP2THml3lFfA8K5Uzbf1y/J31afh5PPPJ118qRjyWee
zjrVhNaiffhuozX5H/r6TI0=
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$16086#2"]& ]]}, {}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJw1k8tqk1EUhU9+Pb9IrW11IErihXaitdIH0Cdw5qiTRHBaLw/Rh2iddFQF
BxkIaREVFW2LgmjTRsVBrWkQG0QQEcFLwW+xl5CVtc9/9tlnX9Y5deXGpetF
SqkB9oCNnNIsvAu/Buewv8Dn4bNgAvzMYTfhl+AQdg8+Vqa0iX20DL8aOA5e
sXcS/gz/AFXsO/A+/N5hl2XEq/qMfIfBiHnbtvYPgEGwCt6CN6BNrAvwV3gR
XgHLjiXfg+AbewPwAny5klIfeydF7oVrf8Eev7TJ3yr4gH2E3JZ8n+IeZr0G
P2H/KnHmQJf1afgM+Ig9DTfBWCXumvd9smfAEHarEue79p8FGym+KY7iNcA1
UElh3wTjoO6z8pmqxPlR7zfs3/MZ9W7eeejeOZ+t+85px5i0j3rS9HflM+Pv
k46l+9WvP9R/Ef4Nr7v+doo8VLf6/8s+8l1w/7/n8FWf2s5x3LEf5ehzQY+f
pojb9pz61tKu9fkX7ltX0lcX7MV+Dm95jprnXWtDGqk5luIs59CqNPs4x0w1
20/Ws3RdWp/vva+ct8Ai61vw/jI0Mep6pzyHToq5qbaedSOddjzflmf8IEed
Q2VA9sMcvR9zLJ2VpqXB22at7+ewE+cGQAvzXo6clNuS653wux32uzrhHtT8
LurW0bo1s23fwm9jxN8K2+rBmucy6DhV17fid/I/745nqLqepdDQju/9B67G
jp0=
                "]], 
               Polygon3DBox[CompressedData["
1:eJwtkcFKQmEQRgd17sZaGEgggbYPn0CfwF2P4APU4/gECi1qJRYqKiUWRFQI
iYuUiAiJNiFCO8/HuDje893/Z2ace1w/Pz1LmVkBMpBLzF55vsDQzQ7JC/wd
xuQ8eWnxbkLuQBNvQ5aze3J6V+sDf4IiXoIVfgkneAWuPJDX4B/PUONNtWFA
TiXhHeiS+3BrMaNm/SQfWPRUb0vibguuyTces93BPmdz8syih3rpju42YIpf
wJHFjBv8EXIWPb7wB4//plZLfv4gi+9B06OHemnGnsc7nanmGv/22IVqqvYv
VPEyPOM/Hq6daXcjj2+hnWv3Wyq3Oj8=
                "]]}]}, {}, {}, {}}, {{
             GrayLevel[0], 
             
             Line3DBox[{409, 1, 365, 227, 16, 31, 46, 61, 1457, 1489, 1517, 
              1487, 1515, 1485, 1513, 1486, 1511, 1483, 1509, 1484, 1507, 
              1479, 1505, 1480, 1503, 1481, 1501, 5, 4, 3, 2, 299, 409}], 
             Line3DBox[CompressedData["
1:eJwt0UsrRHEYwOH/pGFIkiRbe5eVNVuyMVaGlR2FLZ+AT2DrVghlMjYW1BBp
VtPkMrckSZJIEis8pyyefu+ped9zajomZpMzsRDCNJ2GWl2Lh3DLKncsc88K
D2zyyBZP7PDMLi/s8cYrQ+71ujum59rPlDmng8ybk7qoB36f4YdfDon5oCOt
0azG9URPKdoZtVvSvKZIU/ZciN5Jhornca3qmb0y7e5UtE2r2qo32qJFbdYr
bdJrbdRLbdCCJnTJvRF3F7Skw8yZL3SASXNf9F26bydNnm++2OaTDT7I8c56
9B47PXbrNavdJMzH2kXd///1Bzb/QTI=
              "]], 
             
             Line3DBox[{12, 11, 1520, 1444, 1522, 1445, 1524, 1449, 1526, 
              1453, 1454, 1529, 1531, 1530, 75, 60, 45, 30, 233, 414, 15, 387,
               304, 14, 13, 12}], 
             
             Line3DBox[{1532, 151, 166, 181, 196, 292, 429, 211, 407, 344, 
              212, 213, 214, 215, 1543, 1542, 1497, 1540, 1470, 1538, 1466, 
              1536, 1463, 1491, 1533, 1532}], 
             
             Line3DBox[{180, 165, 1461, 1545, 1462, 1547, 1464, 1549, 1467, 
              1551, 1468, 1553, 1471, 1555, 1472, 1557, 1478, 1559, 1476, 
              1562, 1561, 221, 222, 223, 224, 298, 436, 225, 408, 349, 210, 
              195, 180}]}, {
             GrayLevel[0], 
             
             Line3DBox[{968, 508, 938, 738, 522, 536, 550, 564, 578, 592, 606,
               621, 635, 649, 663, 677, 691, 803, 988, 705, 966, 834, 706, 
              707, 708, 709, 710, 711, 806, 991, 1171}], 
             Line3DBox[{510, 509, 812, 968}], 
             Line3DBox[{510, 511, 512, 513, 514, 813, 958, 1243}], 
             Line3DBox[{743, 515, 996, 741, 911, 1146, 1158}], 
             Line3DBox[{517, 516, 743}], 
             
             Line3DBox[{517, 518, 519, 520, 815, 959, 521, 969, 745, 535, 549,
               563, 577, 591, 605, 620, 634, 648, 662, 676, 690, 704, 836, 
              967, 718, 993, 811, 717, 716, 715, 714, 713, 809, 712, 992, 808,
               1001, 1138, 1432}]}, {}, {}, {}, {}, {}, {}}}, 
          VertexNormals -> CompressedData["
1:eJzMu3lcjt3XNxyKJIQyJgqVKWVIiBXJEJkSEZJMaUIilAYKiRJFSioVTaSS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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, 
         FaceGridsStyle -> Automatic, 
         Method -> {"DefaultBoundaryStyle" -> Directive[
             GrayLevel[0.3]], 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-4., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
          "\"\\!\\(\\*FormBox[SuperscriptBox[TemplateBox[List[\\\"z\\\"], \
\\\"Abs\\\"], \\\"2\\\"], TraditionalForm]\\)\"", 
           "\"\\!\\(\\*FormBox[RowBox[{\\\"arg\\\", \\\"(\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"], \\\")\\\"}], TraditionalForm]\\)\""}, 
          "SwatchLegend", DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 Graphics3DBox[
                  SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                  PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
                  0]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 6. Real and imaginary parts of \
\\!\\(\\*FormBox[TagBox[RowBox[{\\\"w\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->176418308,ExpressionUUID->"dea537f0-5f50-449e-b8ea-a2dd68cbf1e1"]
}, {2}]],

Cell["\<\
One can color-code the argument and only use one colored surface.\
\>", "Text",
 CellID->524194449,ExpressionUUID->"a0531ff3-1bfc-440b-9bdc-5772a601108c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["5", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1320", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-4, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["656", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 8. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`f[$CellContext`z] == $CellContext`z^2], 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->419226696,ExpressionUUID->"72c4cd80-525d-444b-a875-8b28e19ce853"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJydnHuwVtV5hw8gHnBQjIgYsXKNSawXiFghYt5VMkqoZmgxeEVjNFaIGqNM
TYOkUZOj2Bo1adREiFZHrZGkeIk10dHz2YoySvBC1EgwCkStthEBo4gX2oH9
vGfOb/Ebc8o/33wP++y99nqfb+91fUeccva003q3tbW9tF1bW5//+1y02yG/
37y5vcVn25Z/o8vHX9yh4/Bjt6/49T9Z8bHv3r5dxYfMvu3h5f36VPyKiXNO
3+NLvSo+cMAPdv6Pczd3Km+7/sBpU0e9V/F1Y5f/88rlGyu++qFzn571nT9W
fPkxuwx5e9z6is97+tQ7+j32h+SfffDp6U/cN6p85d0bx43a95Xk5zwwctmc
AaPKkSNW33Pod19MftTcGbdumjeynHD5pPNuX7k8+WubLvr91LEjy9/P7LPh
qvPvTX7Qp6++aE7fkWXuVh7KZ2w9T+h5muuGXrcpZ2g5m/sKva+mHsLUW8Wb
eq54E5eKN3GseBP3YjypeONVxRsPK958d7yFv+qzcnxWjs/K8Vk5PivHZ+X4
rByf4aO+NXDMX4/POCZ/tfEEn+GnHLxm0+ijR6TP8CvHjZn9+C3D02f47PWz
Pj911PD0Gb7r6uGDplwzLH2GLzx58tTrYlj6rByf9Tz4rNfFZy0nPut94bPW
Az5rveGziUvF8dnEvRhPKo7PxsOK47PhLTxVn5XzXTk+K8dn5fisHJ/hl7W9
umHTFVnPySUuyd+5u//Bcz4Ynj7D55666ZkNrw9Ln+Fnr7y3z3Xj90qf4Y89
84U31z+3Z/oM/960Jbeuf2po+gzvnDp4xI9HDU2f4UcvO+TE9Y/tkT4rx2c9
Dz7rdfFZy4nPel/4rPWAz1pv+Kz1jM8aF3w2cS/Gk4rjs/Gw4vhseAsf1Wfl
/L1yvivHZ+X4DP9q897EZ/jgjY/P2HThiPQZfm7zvMJneN8TVsWGF/8sfYZf
2fiAz/CLHpv39II990if4S8sHvnwuvt3T5/hN/3l1XPW/fuQ9Bn+1GfWrJ/f
PiR9hs+6v/8B6xbtlj4rx2c9Dz7rdfFZy4nPel/4rPWAz1pv+Kz1jM8aF3zW
OOKz8aTi+Gw8rDg+G97CO/VZOT4r57zK+c7nL98/6MybXxyZPsN/et5bP5y6
z4j0GX5r817GZ/jJ088f87mL9kyf4Rd2j2PyAf959mcW7JRxT942ccwZhx+7
W/oMn/EXj54w/51d02f4iDsP3Xn++kHpM3zqon+cd9hnB6XP8Jf3u+Oha/97
l/RZOT7refBZr4vPWk581vvCZ60HfNZ6w2etZ3zWuOCzxhGfNe74bLyqOD4r
x2fDW/ilPivHZ+X4DJffaXLul+98xgtn/dOGV/ZKn+GXN88TfIZPnvzepQsG
fzR9hs9snnv4DN/w8zeueeOGjHtyvMJn+KRPHHH32ss+kj7D2296YNbajp3T
Z/gZk4Y8dODPBqbP8B/Flyf+7v2d0mfl+Aw/szkPPut18VnLic96X/is9YDP
Wm/4rPWMzxoXfNY44rPGHZ/VE3w2HlYcnw1v4ZH6rDzbKw2nHZXP/YbzPsrf
T8Pld90Jp37yes3n75r3KT7Dr7736H+d37Zb+gy/Z8yXj3zj2kHpM1zinhwP
8Rk+6uAjbn5+7YD0Gf5v+39qp+dX7ZA+w3f45NIPxn67f/oMH7/3R7++cnm/
9Bk+oeH4rOfBZ70uPms58VnvC5+1HvBZ6w2ftZ7xWeOCzxpHfNa447N6gs/q
FT6rh/hseCt9EZ+V4zOc/gI+w2l34TOc9xc+w+U5kJz65DufvJfxGf61j/1w
v2uf3zl9hr814YN9D7x+x/QZvvLPv3XxJZ9KT5L/YPhdp4/9u/b0GT5s92uf
GHN63/QZPneXcQ929NsufYbfNvDCCWOO65M+K8dnPQ8+63XxWcuJz3pf+Kz1
gM9ab/is9YzPGhd81jjis8Ydn9UTfFav8Fk9xGfDW/mcE5/hjOfgM5x+MT7D
6V/gM5x2Gj7Ded/hM1yeG8mpf77zObp5XuEznOchPsPFk+TPDlh2x4qf9E6f
4adsd/ceK+a3pc/wb77/491OmvNB4DP8ubcPbr9r6PuBz/DfNByf9Tz4rNfF
Zy0nPut94bPWAz5rveGz1jM+a1zwWeOIzxp3fFZP8Fm9wmf1EJ/VW3zO97P4
DOf3gs9wxn/wGX5l9/dOcvoj+AynXYfPcN6P+AyX50xy4sV3Pj8/+JXP/fae
7dJn+Lj2mTcecESv9BmOb/gMf/3lvs/dsXlj4DP8lt9OuPeESW+lz/Dezyy/
7fY1b6bP8F4Nx2f4zc158Fmvi89aTnzW+8JnrQd81nrDZ61nfNa44LPGEZ81
7visnuCzeoXP6iE+q7f4TJyZV8JnOOPz+AxnnBOf4YwX4XO2W5t+Nz7D6b/g
M5x2ID7DeZ/iM1yeS8mJL9/5PGj9k2+33/8uniS/pbtXye97tP2y4/denz7D
X/qHr6/o99Tr6TP8utkL77tz1/9Jn5Xjc9ZDcx581uvis5YTn/W+8FnrAZ+1
3vBZ6xmfNS74rHHEZ407Pqsn+Kxe4bN6iM/qLT4TT+ZP8RnOPBQ+wxnPx2c4
46L4DGd8CZ/h/N7xGT6q+3swOe1GfIbz/sVnuDzHkuMD33McevENcxc98kb6
DD965gsLZhzzavoMX/I3k794+8o16TP8gsPPL8cPW5U+K8dnPQ8+63XxWcuJ
z3pf+Kz1gM9ab/is9YzPGhd81jjis8Ydn9UTfFav8Fk9xGf1Fp+JG+sE8Bk+
u3u7PTnzVvgMZ/wfn+GMo+IznPEofIbTr8dnOM8TfIbTzsRnOO9rfIbLcy85
/vCdTzzEZ/iqLz7cd8aUZ9Nn+LQp+y9ZtOzJ9Fk5Pmc7vTkPPut18VnLic96
X/is9YDPWm/4rPWMzxoXfNY44rPGHZ/VE3xWr/BZPcRn9Rafic9r3fuVyVlX
gM9w5mfxGc48Fz7D6S/jM5z3Fz7DGb/CZzjjAPgMpz+Fz3B5LyennYDPcHlO
JsdbvvPZcdq+g9tvXZI+w3/1tY0HnnjafemzcnyGX9ycB5/1uvis5cRnvS98
1nrAZ603fNZ6xmeNCz5rHPFZ447P6gk+q1f4rB7is3qLz8SBdV/4DGf9DD7D
WYeAz/BZ3fu5yWlf4TOc+QV8ho/v3k9JzngXPsMZT8BnOP0yfIbTjsVnOM9D
fIbzXKUe4fjJdz4POf7kt25/7ar0GR4Nx2f4E8158Fmvi89aTnzW+8JnrQd8
1nrDZ61nfNa44LPGEZ817visnuCzeoXP6iE+q7f4TH2rz3D1Ga4+w9VnuPoM
V5/h0u9Orj7DfyM+w3uJz3D1Ga4+w9VnuPoMD/GZz0niM1x91uvis5YTn/W+
8FnrAZ+13vBZ6xmfNS74rHHEZ407Pqsn+Kxe4bN6iM/qLT5Tr9regGt7A67t
Dbi2N+Da3oCfKe0NuLY3Mv7S3oBrewN+s7Q34C9LewOu7Y0cJ5b2BvxiaW/A
n5D2hnK+5ziHtDf0uvis5cRnvS981nrAZ603fNZ6xmeNCz5rHPFZ447P6gk+
q1f4rB7is3or/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw
/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw/cEw
/cEw/cEw/cHQ/iD1ZMbrwozXhRmvCzNeF2a8Lsx4XZjxujDjdWHG68KM14UZ
rwszXhdmvC7MeF2Y8bow43X6Xgi9rozXhRmvCzNeF2a8Lsx4XZjxujDjdWHG
68KM14UZrwszXhdmvC50vI76MPMpYeZTwsynhJlPCTOfEmY+Jcx8Spj5lDDz
KWHmU8LMp4SZTwkznxJmPiXMfEqY+ZQw8yn6Hgktp8ynhJlPCTOfEmY+Jcx8
Spj5lDDzKWHmU8LMp4SZTwkznxI6n5LrsLY93x1mvjvMfHeY+e4w891h5rvD
zHeHme8OM98dZr47zHx3mPnuMPPdYea7w8x3h5nvDjPfHWa+W987ofcl891h
5ru13x1azzLfHWa+O8x8d5j57jDz3WHmu8PMd4dZj1T5DDfrkcKsRwqzHinM
eqQw65HCrEcKsx4pzHqkMOuRwqxHCrMeKcx6pDDrkcKsRwqzHinMeqQw65HC
rEfS91RoPch6pDDrkcKsRwqzHinMeqQw65HCrEcKsx4pzHqkyudc97rt9aLJ
Zb1omPWiYdaLhlkvGma9aJj1omHWi4ZZLxpmvWiY9aJh1ouGWS8aZr1omPWi
YdaLhlkvqr+70HLKetEw60X1vRZab7JeNMx60TDrRcOsFw2zXjTMetEw60XV
W8dZb1/5rFzW84dZzx9mPX+Y9fxh1vOHWc8fZj1/mPX8Ydbzh1nPH2Y9f5j1
/GHW84dZzx9mPX+Y9fxh1vOHWc8fZj1/mPX8+h4MrWdZzx9mPX+Y9fxh1vOH
Wc8fZj1/5bPhrSzXtvdbVT4rl/1WYfZbhdlvFWa/VZj9VmH2W4XZbxVmv1WY
/VZh9luF2W8VZr9VmP1WYfZbhdlvFWa/lf5OQ+9L9luF2W8VZr+VvjdD4yL7
rcLstwqz3yrMfiv1sOKy36ryOX9P4rNy2Q9b1Gflsh+2mP2wxeyHLWY/bDH7
YYvZD1vMfthi9sMWsx+2mP2wxeyHLWY/bDH7YYvZD1vMfthi9sMWsx+2mP2w
xeyHLWY/bDH7YYvZD1vMflj1quKyHza57IdV3sr3gPisXPIVVD4rl3wFySVf
QTH5CorJV1BMvoJi8hUUk6+gmHwFxeQrKCZfQTH5CorJV1BMvoJi8hUUk6+g
mHwFxeQrKCZfQTH5CorJV1BMvoJi8hWoJxWXfAWVz8olX0Hlc7ZfxGflkk+m
8lm55JOpfFYu+WSKySdTTD6ZYvLJFJNPpph8MsXkkykmn0wx+WSKySdTTD6Z
YvLJFJNPpph8MsXkkykmn0wx+WSKySdTTD4ZjXsxnlRc8slUPiuXfDKVz9nu
Fp+VS76vymflku+r8lm55PtKLvm+kku+r2LyfRWT76uYfF/F5PsqJt9XMfm+
isn3VUy+r2LyfRWT76uYfF/F5PvS50BovUm+L41LxSXfV+Wz8aTiku+r8lm5
5PuqfM7+ovisXPIxVj4rl3yMlc/KJR9j5bNyyceYXPIxJpd8jMXkYywmH2Mx
+RiLycdYTD7GYvIx5nkkH2Mx+RiLycdYTD5GrbeKSz7GymcTx4pLPsbKZ+NV
xSUfY+Wz8jO21E97i0/1XPk3tsTl0U747C3jlsOb810wEb77lnUFw8v5W48P
Pb75Xsx1K85152z5XNG5bMv6tMeC68K3rs9cHBzP56Fb+N1Bedx5uh9/cx4P
j+Y8lA/OfXFeOOfHf/jW9UgPZjm4PuXnd8HxS7ecZ2GWg+MpJ78X/v9XzfEc
1/1z+ITmuqHl5H45vjTn53gtJ3HUeugevwsm4kOOczZ86z6IX2Q9cH3Kk+Of
zfFb15N3ZLk5nrjkuGhz/KTmeL5zPPeV46XN/89rysNx3Y+/O+tBy0k96P1S
DxxP/VAP8KMaH7hf+OMSd67Pdblfjn9S4s7xxIv75fgvNNeV30V1X1p+ysnx
a7aso3sky6NcnjP6XKq4PGeKec4U85wp5jmjzz37PNS8tZQH/o3eUy95bfDI
LA982I3HPrN584gsD3xOc7xcN88v9dlJvXFdfOG5IfWcx1Oe7vuMunyG41ve
D8/Lppycl3JpeeBLxbfu+z460jf+Tn3jeDzHG70ucdJydq/HCyZS/5SfetLy
d1/n31X+7uv5O7Kc8CelnHr+7j51lYdy5u+sKT/loZ6oH/6++7rrrjjq8VxX
zy8+V7+vrNdt+1yMz2VO9/qvfl879j/7so9c3d7iU3gxnOP1PEU59enOr78v
jnPtInPd6jkgxyu35Xft8DFn7njpx1dvn+fp88e5L/1h4dtV3mna53cuvWJY
65qu6+5zy4D9jlmxtsqj3vAq7zftWz0P7VtTHpefuXOH8ZcMfa5P3+Tjftr/
hXWD3q/yEtMfOWfNTRt+1G975aE85y+3ff4qXy79o58tPnzQ5qVd+T+nL+g7
dslNbS7fbJjjqzyi9MvW3HnM1H85sXdyvpu8oMUcX+V15HqUF075TP7GYo6v
8uxRX8QHnvW77Tx7xRxf5T0jfpo/quFVXil8wnc4/pl8U8UcX+X5wW/Nl9Jw
m0eF35PwolzOX82v8fsz5wlTnuRSD8qrdURSn8klLtW8oTm+Wtchniiv5s3F
t+Tisx5fzPHVPKb8Xgpcfo9Fji/m+GpeSX7vyeV5oscXc3w1zi/Pq+Ty/NTj
wxxfjffK8zm5PIeTy3tHjw9zvB3H0+vK+y65vNeSy3tNjw9zvB230etO2ue8
jjLxrc5nvz/g+bE/374FP7X/36799JsbOtf+Ytw5/3Vw1/tx6JTjOqfPX9d5
1BUnjT/gri7+yIpZk5+5YUMcNH3gkVdO6eJXnXTYia2O9zq/cumpCxev6npP
HX3Wdwb8+pubOqdNPnD1vI6u99qTj/faYcqZGzuHHDCyNXd0V3nOuXf3+/Y5
d1O8MnTmOcMu7Tr+uL+6/uQvjW5rzbpn816/nt31npr1wLHv3vHVDzqX9j50
aMf+Xdf95dszTzjxhV4tPuH3X/7OJ85q79U6bPEn5+29qOs9xXm5Dpzj+Ds4
98l9wykH5YJz/9QHvLlP7js5cSJucOqL+oMTP+IJb+JE3JITV+IsnPiHnKdF
/OW6eBRSTuKcvLkvfExOvIm/1BseJW/qmfgnb+KCj8mbOBL/InHHr+Qcx9+J
V/kpHgblEm/zOnDiTfzh1Bf1B+f+qQ8498l9w4k38YcTV+IMJ37EE06ciBvc
tcPdc8O1593zx/UX3HPM9SPcc8a1z93zyrX/3XPP9Qvc88q1591zz7Xz3fPN
tefdc9K1893z0LXn3XPVtfPd89O1591z2LXz3XPYtefd89a1591z27Xz3XPb
teddu909z3vaL3bv9572l10/173f/5/93572Z3vaP+1pf/NP7j+69/6H9B//
5P6ge+9/SP/uw/qJ2o+r+oOuneD6dz3tx7l2guuv9bRf1tN+Vk/7TT3tB7l+
jWs/9LS/4/oprv3Q0/6LGwdw7Uw3PuDamW58wLUz3TiAa6+68QHXLnXjA65d
6sYBXPvWjQ+4dqwbB3DtYTc+4Nq9bhzAtZ/d+IBrJ7txANfeduMDrp3s+u+u
ve3GB1y73Y0buHa167+79nlPxwdc+/9/Aer3Oro=
          "], {{{
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> "Neutral", 
              Opacity[0.8], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJy1vWdUlee6773H+46xEpNY05OJNTGmiCJVxYqCvQFib7HX2HvBEkuw994r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                  "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                  RGBColor], 
                 BoxForm`ImageTag[
                 "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                 Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                ImageSizeRaw -> {144., 144.}, 
                PlotRange -> {{0, 144.}, {0, 144.}}]]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNm3n81VP+x+/n3msZy9jXIcrYB6ONZCtbJEuLLSqlsofsY18i7ZihpPKN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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwlk0tIVlEUhe9/75Yekj0HNQmKNCsq0hIhAkud1EBSQYkKEwoiSER+yOAP
GoSDMKKCoqJBMweCSQ8JIUQiItSiJCJCopmaUAoVFfUt1uC7rHP2vufsc/Y6
G9o7Gs+mSZLUQEA1n/NZkhyFk+h78Jr5B5ChJ6GU2CLloO+GY9fgH3PdjC+g
C/CHcY7xbfQQXES/gcXMT7PpEfQZKCe2GaaZL2M8T2wV+iF6NexVrubQ7bCf
2AH4iC7AncR76ABaU2vPwAR6OWzLJckyaECfgmP8exw+o6fCugZOoIfhMLoR
9oTvQHehf76gd0JF5pyn6CJ4wtaTcCm8htZSjZ+0FrRQSys8Q98P1zJH/hL0
KFwnlocmdF5rEGuDn6xxg3ETejd8YzyT+a7qoYPYvnCsEq6ir8AO1t8Oveiv
5BcT2wKnGbfCGHuNwyv1Jty7LvhN7ki4FtWs2m+FY83wg3iz8lPX/By9Fs6h
b8I69Sacq5pV+6/MZ5En5I1OqEPXwvfMZ9BZNLfA+G9m76in6q3OpLOtgTli
LxgPpK5BtWyEd6k9M4heCQdz7rl6/yHslU3qeRhpefh9uAfqhTx+CN0j/6k2
WIreGvbiLngs74Z7rRzlyiPySidUoYvD/65g/8voofC/8oy8ox6oF/L8LHNj
Ya+qJ+rNeniU+kwD4TvV3WquP/wG9BZ0533ol+Fe6k5awm9Sb1Nv7C26JFyL
PCFvzGe+e3lMXtOb1NuUhwP9H+sce2A=
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$17275#1"]& ]]}, {}, {
             EdgeForm[], 
             GrayLevel[0.82], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNl1mI1mUUxj+//5ummQtkmmbOuI45aguZS+UyLrmNIuRuLo2m5kbouGSm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                "]], 
               Polygon3DBox[CompressedData["
1:eJwtk01IlFEUhr/5PGQz9IMLJ9CkhnQyLMhCpQmMxkEiImOgoI2muJJwRMSi
mSJCIsRN+FNDBC3ctRCtdNEuXIiLJEdaRItwrTi2cNEiel5Pi2fmud/ce79z
33sm0ZfLDoZBEKTAYJmPBR7MQw2+Ctv4FpzEU3CQeVG4j/fDUEUQ5OAzHocH
zL0LWTyESeYuwFv8HHQwtxd+4Ht8t/LbbXhlvof2ugXn8ePwkb1m4A5eEMzt
hgw+Amm8Htrxv6wbCfydbxg/hSKeh078IfTgVyGNl5kfx1u0hvEZSPIsA9/x
Bojip2Edn4ff1FKCE3gdrIWekbKaM/9NNav2WvMsNWcFX4IunQ2a8IR5tjHG
X/H35mdVhsryk/ncKtWAfzB31XAKPwZTod+Z7q4aRkN/9sV8T+2tM9Tj47DL
WUtwAz9gfjffoNI8k/1sYNQ8M2WnzJ+YZ67sleEj84yUle70LP5SNQSeafl/
ZspOmTbiP+Ee3gPN5j2gXtCzi/gveIwX4BK+ae55aNNa895QhsryOWzwrkW4
jl82780YDODT5nerHlOvHWZ8JEKtMIuPma99DdfwPxXei+qhIuMJOBrxzG7i
V9QTeBKG8EFz139C/w1lqCx34J15T6o3tWbY/B16l3rymfkd6C50hhf4IfO1
qlG1XjDPSpkom39v7mmt
                "]]}]}, {}, {}}, {{
             GrayLevel[0], 
             
             Line3DBox[{998, 1, 994, 902, 31, 61, 91, 121, 151, 181, 211, 241,
               271, 1040, 1104, 1164, 1102, 1162, 1100, 1160, 1101, 1158, 
              1098, 1156, 1096, 1154, 1097, 1152, 1094, 1150, 1095, 1148, 
              1092, 1146, 1093, 1144, 1090, 1142, 1091, 1140, 1086, 1138, 
              1087, 1136, 1088, 1134, 1082, 1132, 1083, 1130, 1084, 1128, 10, 
              9, 8, 7, 6, 5, 4, 3, 2, 955, 998}], 
             Line3DBox[CompressedData["
1:eJwt0ktIFlEYgOHjDVJTU1sYlKALF0K1sYiiRVtdhF3Q7qRkSdiPZaWFSISJ
RBEiESIKlYuCIioi4rcokYgSCQ0tjZJ23UALLMrsGXDx8DID38zh4xRUxbYc
SQgh3GMx6XxLCqE2OYSvelg/a51+0Zj+1Hqd0WP6Q4/rLz2pv7VJ/+ppndNm
DbSQwBmSOUsKrSyijTTaSec8mVzkAisdtoxa2hj07T4d0gEd1SmdZ0ViCBvI
NZfDDW6SxzJucZt87lDIXYq4TzEPWMVDVvOIEuKsYS31/nk02gUNvIv2wQQn
mIz2QmO0F06xztwBPlHDFAf5wH7eU8UE1bxlL2Ps4w27GWEPr9nJMLsYopKX
7OAFFTxnG4NsZ4CtPKWcJ9Gcna1nOf/scdx5P+qIPtNXel3PcYhSss1lsZlr
XCWVMnrpIYlu5s136R+9orN6WTfRybTnDt3IJb57Xur65JJDNo+9W6L9mqVx
zdSMhXv8H64QXuE=
              "]], 
             
             Line3DBox[{22, 21, 1167, 1007, 1169, 1008, 1171, 1013, 1173, 
              1014, 1175, 1018, 1177, 1022, 1179, 1026, 1181, 1030, 1031, 
              1184, 1185, 1036, 1037, 1188, 1190, 1189, 300, 270, 240, 210, 
              180, 150, 120, 90, 60, 907, 999, 30, 995, 959, 29, 28, 27, 26, 
              25, 24, 23, 22}], 
             
             Line3DBox[{1191, 601, 631, 661, 691, 721, 751, 781, 811, 841, 
              949, 1000, 871, 996, 985, 872, 873, 874, 875, 876, 877, 878, 
              879, 880, 1214, 1213, 1124, 1211, 1072, 1209, 1120, 1207, 1067, 
              1205, 1063, 1203, 1059, 1201, 1055, 1199, 1052, 1110, 1196, 
              1195, 1046, 1106, 1192, 1191}], 
             
             Line3DBox[{660, 630, 1044, 1216, 1045, 1218, 1047, 1220, 1050, 
              1222, 1051, 1224, 1053, 1226, 1056, 1228, 1057, 1230, 1060, 
              1232, 1061, 1234, 1064, 1236, 1065, 1238, 1068, 1240, 1069, 
              1242, 1075, 1244, 1073, 1246, 1074, 1248, 1081, 1250, 1079, 
              1253, 1252, 891, 892, 893, 894, 895, 896, 897, 898, 899, 954, 
              1001, 900, 997, 989, 870, 840, 810, 780, 750, 720, 690, 
              660}]}}}, VertexNormals -> CompressedData["
1:eJztfHlYz1v3dsY0CBkyJiRCpkIybDJlniWVIRIyz0OmDA0ic2ZCJFOZSTYa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           "], VertexTextureCoordinates -> CompressedData["
1:eJyF233MnmV5gPFO+SiGLPYPM0TM5NMwmTCHDnVwQxgFtyUMxgQhDnBDO0AQ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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, Lighting -> 
         "Neutral", Method -> {"RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-4., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 8. Absolute value and argument of \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], \
HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->1659718151,ExpressionUUID->"4861b854-e394-49ea-b72a-338541c12be9"]
}, {2}]],

Cell["The plot can be compressed in two dimensions.", "Text",
 CellID->203126643,ExpressionUUID->"bbdfa234-6d52-4e5a-893c-587db2cccfd3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"3", "I"}]}]}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["2", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["576", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[FrameLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["656", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 9. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`f[$CellContext`z] == $CellContext`z^2], 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->733672611,ExpressionUUID->"deecfb75-3773-4d5f-97ef-7e1379a893cd"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{
         GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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          "], {{{
             EdgeForm[], 
             Directive[
              Opacity[1.], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJxE2seSI2mW6PcxcsMlX4FvwS2X3F4aH+DO7Z7W3dWldVVWZaVWkRkZWmuB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                  "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                  RGBColor], 
                 BoxForm`ImageTag[
                 "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                 Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                ImageSizeRaw -> {144., 144.}, 
                PlotRange -> {{0, 144.}, {0, 144.}}]]], 
             GraphicsGroupBox[
              TagBox[{
                PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, {{
             Directive[], 
             LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
              "]]}}}, VertexTextureCoordinates -> CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, PlotRangeClipping -> True, ImagePadding -> All, 
         DisplayFunction -> Identity, Axes -> {False, False}, 
         AxesLabel -> {None, None}, AxesOrigin -> {Automatic, Automatic}, 
         DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
         FrameLabel -> {{
            FormBox[
             TagBox[
              StyleBox[
              "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
             TraditionalForm], None}, {
            FormBox[
             TagBox[
              StyleBox[
              "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
             TraditionalForm], None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         Method -> {
          "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
           "TransparentPolygonMesh" -> True, "AxesInFront" -> True}, 
         PlotRange -> {All, All}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{{}, 
                 RasterBox[CompressedData["
1:eJzt1j1IVXEcxvEbZUM2FIQ5OFSLLUbUUhC6NFRDN6IisqGCmoRehmrIpUCa
pDAiQ7LIgkzK3qTQyGsvammZld1eNEsrtRcbahGhznmeXJIv/7HFH+dy4H7Q
c8/5/X/P/8zdtnPt9smJRKI1+kyKPlOiz8nyuF4V/HtOqH6M+37sPL+4M7e4
cxh9zUhVcqSKfZ+KvfLnyuhgb96dEx3sw99V6LOLUllFKfaCwbL8wTL2HSr2
0r4l0cFetyUzOth7uuP6hj61sDajsJY9L30wOtjXq9jV3lz2c8m4wV/R29vi
Yv8Vt7eSPUcNZl+uYld7s9iP5ccN/oLeUB8Xe3/c3lL2TDWYfbGKXe3NYD+k
Bg+hX6yOi13tLWbX+CbZ56nYV2mAB9H3qMHsPrOrvUXsGt989pkq9qUa4AH0
rWow+2EVu9pbyK7xzWN3PrM7nz+jO5/Z9yuf2Z3P7M5ndufzJ3S1N8Wu7pax
O5/Znc/szmd25/NHdOcz+wI1mH2D8pnd+czufO5HVzy3sau9lezOZ3bnM7vz
md353IfufGZ3PrNPV4PZnc/szmd2jW/6A7riuZrd+czufGZ3PrM7n9+jO5/Z
dSpnb9IAsw8pn9mdz+zO5150jW8du/OZ3fnM7nxmdz6zr1YD36Gf0gCy+/W2
J5CP7M4/dudbdyC/2A9oAbM7f94G8oXd+cHufHiDPk3zz75JC4Dd8/s6MJ/s
KzR/478fO5+A78fOA5ofdsdfOrD+2bscYOh+v3iJ7vcH9ha9H7Bnq8Fd6N7f
2b1/s3t/foHu/Zdd7R15ju79k937I7v3v2fo3t/YF2n/Ynd7O9G9/7B7f2Hf
pQF+it6o/YF9hvKf3fnegX5J+c0++juuJ+gVaiD7MuXrY/RexWd7IB/ZnX9t
gXx7hL5Z+cU+qgX8MJA/rYF8aUH3/sjufGhGn6X5f4B+XQuAfZ3m935gPu8F
5u8u+kLNF3uH5qcpMB+pwPpnr9H6buT+6QbvcH+0Pm+jZ2v9NaBv1PqqRz+i
863A+rjJ11f/6/j66u8Nvn/171qgP1cDz/8K+mk938voc/T8agLP5wJfX/d/
nv9e93c28PvPoCf0+yrYdf3j7Pr/RwN/XxLwvex/a8In/H/6H5X32l8=
                  "], {{-11.25, 
                    Rational[-225, 2]}, {-3.75, 
                    Rational[225, 2]}}], 
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{-3.75, 
                    Rational[-225, 2]}, {11.25, 
                    Rational[225, 2]}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{11.25, 
                    Rational[-225, 2]}, {-11.25, 
                    Rational[-225, 2]}, {-11.25, 
                    Rational[225, 2]}, {11.25, 
                    Rational[225, 2]}, {11.25, 
                    Rational[-225, 2]}}, {{
                    11.25, -112.5}, {-11.25, -112.5}, {-11.25, 112.5}, {11.25,
                     112.5}, {11.25, -112.5}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{11.25, -112.5}, 
                    Offset[{4., 0}, {11.25, -112.5}]}, {{11.25, -56.25}, 
                    Offset[{4., 0}, {11.25, -56.25}]}, {{11.25, 0.}, 
                    Offset[{4., 0}, {11.25, 0.}]}, {{11.25, 56.25}, 
                    Offset[{4., 0}, {11.25, 56.25}]}, {{11.25, 112.5}, 
                    Offset[{4., 0}, {11.25, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{11.25, -101.25}, 
                    Offset[{2.5, 0.}, {11.25, -101.25}]}, {{11.25, -90.}, 
                    Offset[{2.5, 0.}, {11.25, -90.}]}, {{11.25, -78.75}, 
                    Offset[{2.5, 0.}, {11.25, -78.75}]}, {{11.25, -67.5}, 
                    Offset[{2.5, 0.}, {11.25, -67.5}]}, {{11.25, -67.5}, 
                    Offset[{2.5, 0.}, {11.25, -67.5}]}, {{11.25, -45.}, 
                    Offset[{2.5, 0.}, {11.25, -45.}]}, {{11.25, -33.75}, 
                    Offset[{2.5, 0.}, {11.25, -33.75}]}, {{11.25, -22.5}, 
                    Offset[{2.5, 0.}, {11.25, -22.5}]}, {{11.25, -22.5}, 
                    Offset[{2.5, 0.}, {11.25, -22.5}]}, {{11.25, -11.25}, 
                    Offset[{2.5, 0.}, {11.25, -11.25}]}, {{11.25, 11.25}, 
                    Offset[{2.5, 0.}, {11.25, 11.25}]}, {{11.25, 22.5}, 
                    Offset[{2.5, 0.}, {11.25, 22.5}]}, {{11.25, 22.5}, 
                    Offset[{2.5, 0.}, {11.25, 22.5}]}, {{11.25, 33.75}, 
                    Offset[{2.5, 0.}, {11.25, 33.75}]}, {{11.25, 45.}, 
                    Offset[{2.5, 0.}, {11.25, 45.}]}, {{11.25, 67.5}, 
                    Offset[{2.5, 0.}, {11.25, 67.5}]}, {{11.25, 67.5}, 
                    Offset[{2.5, 0.}, {11.25, 67.5}]}, {{11.25, 78.75}, 
                    Offset[{2.5, 0.}, {11.25, 78.75}]}, {{11.25, 90.}, 
                    Offset[{2.5, 0.}, {11.25, 90.}]}, {{11.25, 101.25}, 
                    Offset[{2.5, 0.}, {11.25, 101.25}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, -56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False], 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{-11.25, -112.5}, 
                    Offset[{-4., 0}, {-11.25, -112.5}]}, {{-11.25, 90.}, 
                    Offset[{-4., 0}, {-11.25, 90.}]}, {{-11.25, 112.5}, 
                    Offset[{-4., 0}, {-11.25, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, -112.5}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["14.`", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, 90.}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Infinity]\"", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, 112.5}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", 
                 RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "-", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0.9`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "&"}], ")"}]}],
                ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "\"0\""}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.9`", ",", "14"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "\"\[Infinity]\""}], "}"}]}], "}"}]}], 
               ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 9. Absolute value and argument of \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], \
HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->933078346,ExpressionUUID->"93dab77e-0e89-4fee-b482-31d1bea34a5e"]
}, {2}]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"41d88c90-875a-4be8-91d5-b289116caab4"],
 " can be plotted as a vector field in which the arrow at ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9a5734cd-0964-4684-bc19-f25c5e71e087"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "(", "w", ")"}], ",", 
     RowBox[{"Im", "(", "w", ")"}]}], "}"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"33e80bf3-8698-42df-a67f-9fce5ed67743"],
 "."
}], "Text",
 CellID->22270563,ExpressionUUID->"da56f6b4-5141-4fa8-bb01-73e0cdad108b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexVectorPlot", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"3", "I"}]}]}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["4", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["720", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[VectorScaling -> Automatic, FrameLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic, ImageSize -> 200],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["600", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 10. Vector plot of " <> 
     ToString[$CellContext`f[$CellContext`z] == $CellContext`z^2, 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->8870751,ExpressionUUID->"dec5fa98-3926-47a4-ad3f-302d68076fe6"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{{{{}}, {{
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02812500000000001, 1.}}], {
               LABColor[
               0.8167969189733053, 0.14500114740169545`, 0.8282532063436999], 
               
               
               ArrowBox[{{-2.8060096153846152`, -3.0914608764901237`}, \
{-2.8189903846153848`, -2.7542105990548373`}}]}}, {
              Arrowheads[{{0.02696747544570384, 1.}}], {
               LABColor[
               0.7549310523583713, 0.28607479613572645`, 0.793740823035273], 
               
               ArrowBox[{{-2.40843796335463, -3.0820092543352247`}, \
{-2.46656203664537, -2.7636622212097364`}}]}}, {
              Arrowheads[{{0.025910945694153684`, 1.}}], {
               LABColor[
               0.7019031666884278, 0.4069950664791816, 0.7641587801994786], 
               
               ArrowBox[{{-2.0103933729447236`, -3.069309200421781}, \
{-2.1146066270552764`, -2.77636227512318}}]}}, {
              Arrowheads[{{0.024975943018834577`, 1.}}], {
               LABColor[
               0.6577132619634748, 0.5077619584320612, 0.7395070778363165], 
               
               ArrowBox[{{-1.6125721709434964`, -3.0526145445991806`}, \
{-1.7624278290565036`, -2.7930569309457804`}}]}}, {
              Arrowheads[{{0.02418550173148977, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{-1.216089301316938, -3.031292009899011}, \
{-1.408910698683062, -2.81437946564595}}]}}, {
              Arrowheads[{{0.02356380246478242, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{-0.8224945760300917, -3.0050723036971103`}, \
{-1.0525054239699083`, -2.8405991718478507`}}]}}, {
              Arrowheads[{{0.02313373848197518, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-0.43361202845756686`, -2.974352779740785}, \
{-0.6913879715424331, -2.871318695804176}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-0.051145390825357406`, -2.9404023328008284`}, \
{-0.3238546091746426, -2.9052691427441326`}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{0.3238546091746426, -2.9052691427441326`}, {
                0.051145390825357406`, -2.9404023328008284`}}]}}, {
              Arrowheads[{{0.02313373848197518, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{0.6913879715424331, -2.871318695804176}, {
                0.43361202845756686`, -2.974352779740785}}]}}, {
              Arrowheads[{{0.023563802464782405`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{1.052505423969908, -2.8405991718478507`}, {
                0.8224945760300919, -3.0050723036971103`}}]}}, {
              Arrowheads[{{0.02418550173148977, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{1.408910698683062, -2.81437946564595}, {
                1.216089301316938, -3.031292009899011}}]}}, {
              Arrowheads[{{0.024975943018834577`, 1.}}], {
               LABColor[
               0.6577132619634748, 0.5077619584320612, 0.7395070778363165], 
               
               ArrowBox[{{1.7624278290565036`, -2.7930569309457804`}, {
                1.6125721709434964`, -3.0526145445991806`}}]}}, {
              Arrowheads[{{0.025910945694153684`, 1.}}], {
               LABColor[
               0.7019031666884278, 0.4069950664791816, 0.7641587801994786], 
               
               ArrowBox[{{2.1146066270552764`, -2.77636227512318}, {
                2.0103933729447236`, -3.069309200421781}}]}}, {
              Arrowheads[{{0.02696747544570384, 1.}}], {
               LABColor[
               0.7549310523583713, 0.28607479613572645`, 0.793740823035273], 
               
               ArrowBox[{{2.46656203664537, -2.7636622212097364`}, {
                2.40843796335463, -3.0820092543352247`}}]}}, {
              Arrowheads[{{0.02812500000000001, 1.}}], {
               LABColor[
               0.8167969189733053, 0.14500114740169545`, 0.8282532063436999], 
               
               
               ArrowBox[{{2.8189903846153848`, -2.7542105990548373`}, {
                2.8060096153846152`, -3.0914608764901237`}}]}}, {
              Arrowheads[{{0.02644738548515838, 1.}}], {
               LABColor[
               0.7284171095233996, 0.3465349313074541, 0.7789498016173758], 
               
               ArrowBox[{{-2.626635920751659, -2.756752091459004}, \
{-2.623364079248341, -2.439400331247628}}]}}, {
              Arrowheads[{{0.025262222732556048`, 1.}}], {
               LABColor[
               0.6709702333809607, 0.4775318908461973, 0.7469025885452651], 
               
               ArrowBox[{{-2.2283466662292377`, -2.7480949083301454`}, \
{-2.2716533337707623`, -2.4480575143764867`}}]}}, {
              Arrowheads[{{0.024185501731489797`, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{-1.8292794624801973`, -2.73579846167272}, \
{-1.9207205375198027`, -2.460353961033912}}]}}, {
              Arrowheads[{{0.02324250490563072, 1.}}], {
               LABColor[
               0.5575388139325278, 0.5323283309099432, 0.3448920416431297], 
               
               ArrowBox[{{-1.430272485283108, -2.71884780952848}, \
{-1.569727514716892, -2.477304613178152}}]}}, {
              Arrowheads[{{0.022462170758477135`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-1.0327868779388834`, -2.696364095989873}, \
{-1.2172131220611166`, -2.499788326716759}}]}}, {
              Arrowheads[{{0.02187500000000003, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-0.6389423076923076, -2.668024417043598}, \
{-0.8610576923076924, -2.528128005663034}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-0.25121312580684935`, -2.6345707058916434`}, \
{-0.49878687419315065`, -2.5615817168149886`}}]}}, {
              Arrowheads[{{0.02138461153538154, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{
                0.12830766921228923`, -2.598076211353316}, \
{-0.12830766921228923`, -2.598076211353316}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{0.49878687419315065`, -2.5615817168149886`}, {
                0.25121312580684935`, -2.6345707058916434`}}]}}, {
              Arrowheads[{{0.02187500000000003, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{0.8610576923076924, -2.528128005663034}, {
                0.6389423076923076, -2.668024417043598}}]}}, {
              Arrowheads[{{0.022462170758477135`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{1.2172131220611166`, -2.499788326716759}, {
                1.0327868779388834`, -2.696364095989873}}]}}, {
              Arrowheads[{{0.02324250490563072, 1.}}], {
               LABColor[
               0.5575388139325278, 0.5323283309099432, 0.3448920416431297], 
               
               ArrowBox[{{1.569727514716892, -2.477304613178152}, {
                1.430272485283108, -2.71884780952848}}]}}, {
              Arrowheads[{{0.024185501731489797`, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{1.9207205375198027`, -2.460353961033912}, {
                1.8292794624801973`, -2.73579846167272}}]}}, {
              Arrowheads[{{0.025262222732556048`, 1.}}], {
               LABColor[
               0.6709702333809607, 0.4775318908461973, 0.7469025885452651], 
               
               ArrowBox[{{2.2716533337707623`, -2.4480575143764867`}, {
                2.2283466662292377`, -2.7480949083301454`}}]}}, {
              Arrowheads[{{0.02644738548515838, 1.}}], {
               LABColor[
               0.7284171095233996, 0.3465349313074541, 0.7789498016173758], 
               
               ArrowBox[{{2.623364079248341, -2.439400331247628}, {
                2.626635920751659, -2.756752091459004}}]}}, {
              Arrowheads[{{0.026091671779532397`, 1.}}], {
               LABColor[
               0.7107411476334183, 0.3868416880886058, 0.769089120672111], 
               
               ArrowBox[{{-2.845325006432315, -2.4263867050483103`}, \
{-2.779674993567685, -2.1202466648199927`}}]}}, {
              Arrowheads[{{0.02478213496054044, 1.}}], {
               LABColor[
               0.6488752810184844, 0.5279153368226368, 0.7345767373636841], 
               
               ArrowBox[{{-2.4478520310594662`, -2.4216487014654176`}, \
{-2.4271479689405338`, -2.1249846684028855`}}]}}, {
              Arrowheads[{{0.023563802464782447`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{-2.048783756774231, -2.414032586627407}, \
{-2.076216243225769, -2.132600783240896}}]}}, {
              Arrowheads[{{0.022462170758477132`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-1.648486756051066, -2.4023195335196323`}, \
{-1.726513243948934, -2.1443138363486707`}}]}}, {
              Arrowheads[{{0.021509066792426892`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-1.2479727996227195`, -2.3850810744577795`}, \
{-1.3770272003772805`, -2.1615522954105235`}}]}}, {
              Arrowheads[{{0.02074191386301625, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-0.8492262735597216, -2.3610430828174294`}, \
{-1.0257737264402784`, -2.1855902870508737`}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{-0.45528292994122466`, -2.3298357236064686`}, \
{-0.6697170700587753, -2.2167976462618344`}}]}}, {
              Arrowheads[{{0.01991909240358717, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-0.06960050712471377, -2.2928982655221817`}, \
{-0.3053994928752862, -2.2537351043461213`}}]}}, {
              Arrowheads[{{0.01991909240358717, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{0.3053994928752862, -2.2537351043461213`}, {
                0.06960050712471377, -2.2928982655221817`}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{0.6697170700587752, -2.2167976462618344`}, {
                0.4552829299412247, -2.3298357236064686`}}]}}, {
              Arrowheads[{{0.02074191386301625, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{1.0257737264402784`, -2.1855902870508737`}, {
                0.8492262735597216, -2.3610430828174294`}}]}}, {
              Arrowheads[{{0.021509066792426892`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{1.3770272003772805`, -2.1615522954105235`}, {
                1.2479727996227195`, -2.3850810744577795`}}]}}, {
              Arrowheads[{{0.022462170758477132`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{1.726513243948934, -2.1443138363486707`}, {
                1.648486756051066, -2.4023195335196323`}}]}}, {
              Arrowheads[{{0.023563802464782447`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{2.076216243225769, -2.132600783240896}, {
                2.048783756774231, -2.414032586627407}}]}}, {
              Arrowheads[{{0.02478213496054044, 1.}}], {
               LABColor[
               0.6488752810184844, 0.5279153368226368, 0.7345767373636841], 
               
               ArrowBox[{{2.4271479689405338`, -2.1249846684028855`}, {
                2.4478520310594662`, -2.4216487014654176`}}]}}, {
              Arrowheads[{{0.026091671779532397`, 1.}}], {
               LABColor[
               0.7107411476334183, 0.3868416880886058, 0.769089120672111], 
               
               ArrowBox[{{2.779674993567685, -2.1202466648199927`}, {
                2.845325006432315, -2.4263867050483103`}}]}}, {
              Arrowheads[{{0.02448676312067471, 1.}}], {
               LABColor[
               0.6320395081726374, 0.5371829267167847, 0.6767944920581912], 
               
               ArrowBox[{{-2.667529641209593, -2.089187475556486}, \
{-2.582470358790407, -1.807926841473488}}]}}, {
              Arrowheads[{{0.023133738481975155`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-2.2698289186988356`, -2.085935937097132}, \
{-2.2301710813011644`, -1.811178379932842}}]}}, {
              Arrowheads[{{0.02187500000000002, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-1.869951923076923, -2.079710044184265}, \
{-1.880048076923077, -1.817404272845709}}]}}, {
              Arrowheads[{{0.02074191386301624, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-1.4681635740707193`, -2.068867647040625}, \
{-1.5318364259292807`, -1.828246669989349}}]}}, {
              Arrowheads[{{0.019775628679223053`, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{-1.065673113962331, -2.0513143393870785`}, \
{-1.184326886037669, -1.8457999776428955`}}]}}, {
              Arrowheads[{{0.019026374951867667`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-0.6653019437626536, -2.0250969863612878`}, \
{-0.8346980562373464, -1.8720173306686863`}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-0.2716639713526636, -1.9898609858695053`}, \
{-0.4783360286473364, -1.9072533311604687`}}]}}, {
              Arrowheads[{{0.018382208651536155`, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{
                0.11029325190921693`, -1.948557158514987}, \
{-0.11029325190921693`, -1.948557158514987}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{0.4783360286473364, -1.9072533311604687`}, {
                0.2716639713526636, -1.9898609858695053`}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{0.8346980562373464, -1.8720173306686863`}, {
                0.6653019437626536, -2.0250969863612878`}}]}}, {
              Arrowheads[{{0.019775628679223032`, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{1.1843268860376692`, -1.8457999776428955`}, {
                1.0656731139623308`, -2.0513143393870785`}}]}}, {
              Arrowheads[{{0.02074191386301624, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{1.5318364259292807`, -1.828246669989349}, {
                1.4681635740707193`, -2.068867647040625}}]}}, {
              Arrowheads[{{0.02187500000000002, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{1.880048076923077, -1.817404272845709}, {
                1.869951923076923, -2.079710044184265}}]}}, {
              Arrowheads[{{0.023133738481975155`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{2.2301710813011644`, -1.811178379932842}, {
                2.2698289186988356`, -2.085935937097132}}]}}, {
              Arrowheads[{{0.02448676312067471, 1.}}], {
               LABColor[
               0.6320395081726374, 0.5371829267167847, 0.6767944920581912], 
               
               ArrowBox[{{2.582470358790407, -1.807926841473488}, {
                2.667529641209593, -2.089187475556486}}]}}, {
              Arrowheads[{{0.024387014419226933`, 1.}}], {
               LABColor[
               0.6258311169859616, 0.5367783770662146, 0.6491359545236027], 
               
               ArrowBox[{{-2.885661043257681, -1.75051627615287}, \
{-2.739338956742319, -1.497078988038775}}]}}, {
              Arrowheads[{{0.022913584461854545`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-2.4904641870347786`, -1.7506674850783357`}, \
{-2.3845358129652214`, -1.4969277791133093`}}]}}, {
              Arrowheads[{{0.02150906679242688, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-2.0927882777281113`, -1.749247457071323}, \
{-2.0322117222718887`, -1.498347807120322}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{-1.6921616117416858`, -1.7449098578222164`}, \
{-1.6828383882583142`, -1.5026854063694286`}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-1.2885635928024892`, -1.7354182143716779`}, \
{-1.3364364071975108`, -1.5121770498199671`}}]}}, {
              Arrowheads[{{0.018042190566019217`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               
               ArrowBox[{{-0.8833734283019423, -1.717547604316378}, \
{-0.9916265716980577, -1.530047659875267}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-0.48085511784468926`, -1.688076306673537}, \
{-0.6441448821553107, -1.559518957518108}}]}}, {
              Arrowheads[{{0.016930881560337365`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-0.08858800772645013, -1.64694906400064}, \
{-0.28641199227354985`, -1.6006462001910051`}}]}}, {
              Arrowheads[{{0.016930881560337365`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{0.28641199227354985`, -1.6006462001910051`}, {
                0.08858800772645013, -1.64694906400064}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{0.6441448821553107, -1.559518957518108}, {
                0.48085511784468926`, -1.688076306673537}}]}}, {
              Arrowheads[{{0.018042190566019214`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               ArrowBox[{{0.9916265716980577, -1.530047659875267}, {
                0.8833734283019423, -1.717547604316378}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{1.3364364071975108`, -1.5121770498199671`}, {
                1.2885635928024892`, -1.7354182143716779`}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{1.6828383882583142`, -1.5026854063694286`}, {
                1.6921616117416858`, -1.7449098578222164`}}]}}, {
              Arrowheads[{{0.02150906679242688, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{2.0322117222718887`, -1.498347807120322}, {
                2.0927882777281113`, -1.749247457071323}}]}}, {
              Arrowheads[{{0.022913584461854545`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{2.3845358129652214`, -1.4969277791133093`}, {
                2.4904641870347786`, -1.7506674850783357`}}]}}, {
              Arrowheads[{{0.024387014419226933`, 1.}}], {
               LABColor[
               0.6258311169859616, 0.5367783770662146, 0.6491359545236027], 
               
               ArrowBox[{{2.739338956742319, -1.497078988038775}, {
                2.885661043257681, -1.75051627615287}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-2.708390422139864, -1.4083413636308233`}, \
{-2.541609577860136, -1.1897348477224927`}}]}}, {
              Arrowheads[{{0.02138461153538153, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{-2.3141538346061443`, -1.410155806714871}, \
{-2.1858461653938557`, -1.187920404638445}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-1.9169916002021568`, -1.4109328518939734`}, \
{-1.8330083997978432`, -1.1871433594593426`}}]}}, {
              Arrowheads[{{0.018547492321316795`, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-1.5158978505611287`, -1.4091816452887072`}, \
{-1.4841021494388713`, -1.1888945660646089`}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-1.1101554759717618`, -1.401883985001001}, \
{-1.1398445240282382`, -1.196192226352315}}]}}, {
              Arrowheads[{{0.01630875245281537, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{-0.7010737426415539, -1.3837808692456774`}, \
{-0.7989262573584461, -1.2142953421076386`}}]}}, {
              Arrowheads[{{0.015624999999999998`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-0.2956730769230769, -1.3490011097411447`}, \
{-0.4543269230769231, -1.2490751016121713`}}]}}, {
              Arrowheads[{{0.01537980576769077, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{
                0.09227883460614462, -1.299038105676658}, \
{-0.09227883460614462, -1.299038105676658}}]}}, {
              Arrowheads[{{0.015624999999999998`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{0.4543269230769231, -1.2490751016121713`}, {
                0.2956730769230769, -1.3490011097411447`}}]}}, {
              Arrowheads[{{0.01630875245281537, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{0.7989262573584461, -1.2142953421076386`}, {
                0.7010737426415539, -1.3837808692456774`}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{1.1398445240282382`, -1.196192226352315}, {
                1.1101554759717618`, -1.401883985001001}}]}}, {
              Arrowheads[{{0.018547492321316795`, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{1.4841021494388713`, -1.1888945660646089`}, {
                1.5158978505611287`, -1.4091816452887072`}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{1.8330083997978432`, -1.1871433594593426`}, {
                1.9169916002021568`, -1.4109328518939734`}}]}}, {
              Arrowheads[{{0.02138461153538153, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{2.1858461653938557`, -1.187920404638445}, {
                2.3141538346061443`, -1.410155806714871}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{2.541609577860136, -1.1897348477224927`}, {
                2.708390422139864, -1.4083413636308233`}}]}}, {
              Arrowheads[{{0.023133738481975186`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-2.9215590528435973`, -1.0601403158713343`}, \
{-2.7034409471564027`, -0.8884168426436527}}]}}, {
              Arrowheads[{{0.0215090667924269, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-2.5309985964650394`, -1.0632339096946666`}, \
{-2.3440014035349606`, -0.8853232488203204}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-2.1384078926731296`, -1.0665917448867788`}, \
{-1.9865921073268704`, -0.8819654136282082}}]}}, {
              Arrowheads[{{0.018382208651536155`, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{-1.7426466259546085`, -1.0697953372768718`}, \
{-1.6323533740453915`, -0.8787618212381152}}]}}, {
              Arrowheads[{{0.01693088156033738, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-1.3419062679732177`, -1.0715145932577266`}, \
{-1.2830937320267823`, -0.8770425652572604}}]}}, {
              Arrowheads[{{0.015624999999999995`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-0.9338942307692308, -1.0679592118784063`}, \
{-0.9411057692307692, -0.8805979466365808}}]}}, {
              Arrowheads[{{0.014575314339611525`, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{-0.5187740569811654, -1.0500141341749767`}, \
{-0.6062259430188346, -0.8985430243400103}}]}}, {
              Arrowheads[{{0.013961246160658398`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-0.10971591424776038`, -1.005369191998226}, \
{-0.2652840857522396, -0.9431879665167611}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               ArrowBox[{{0.2652840857522396, -0.9431879665167613}, {
                0.10971591424776038`, -1.0053691919982257`}}]}}, {
              Arrowheads[{{0.014575314339611532`, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{0.6062259430188346, -0.8985430243400103}, {
                0.5187740569811654, -1.0500141341749767`}}]}}, {
              Arrowheads[{{0.015625000000000014`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{0.9411057692307692, -0.8805979466365805}, {
                0.9338942307692308, -1.0679592118784065`}}]}}, {
              Arrowheads[{{0.01693088156033735, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{1.2830937320267823`, -0.8770425652572607}, {
                1.3419062679732177`, -1.0715145932577264`}}]}}, {
              Arrowheads[{{0.01838220865153617, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{1.6323533740453915`, -0.878761821238115}, {
                1.7426466259546085`, -1.069795337276872}}]}}, {
              Arrowheads[{{0.019919092403587187`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{1.9865921073268704`, -0.8819654136282082}, {
                2.1384078926731296`, -1.0665917448867788`}}]}}, {
              Arrowheads[{{0.0215090667924269, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{2.3440014035349606`, -0.8853232488203204}, {
                2.5309985964650394`, -1.0632339096946666`}}]}}, {
              Arrowheads[{{0.023133738481975172`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{2.7034409471564027`, -0.888416842643653}, {
                2.9215590528435973`, -1.060140315871334}}]}}, {
              Arrowheads[{{0.021875000000000002`, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-2.741105769230769, -0.7107237328173255}, \
{-2.508894230769231, -0.5883143728593325}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{-2.3525554583170893`, -0.7141122398924058}, \
{-2.1474445416829107`, -0.5849258657842522}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-1.9624381780862077`, -0.7183587650958596}, \
{-1.7875618219137923`, -0.5806793405807984}}]}}, {
              Arrowheads[{{0.016930881560337372`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-1.5695057243003323`, -0.7236036349337447}, \
{-1.4304942756996677`, -0.5754344707429133}}]}}, {
              Arrowheads[{{0.015379805767690777`, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{-1.1711394173030725`, -0.7294348678388729}, \
{-1.0788605826969275`, -0.5696032378377851}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-0.7619667824234214, -0.7324273534802819}, \
{-0.7380332175765786, -0.5666107521963761}}]}}, {
              Arrowheads[{{0.012841876226407674`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               
               ArrowBox[{{-0.33647437132077695`, -0.7162473991042759}, \
{-0.41352562867922305`, -0.5827907065723821}}]}}, {
              Arrowheads[{{0.012377402883845387`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{
                0.07426441730307232, -0.649519052838329}, \
{-0.07426441730307232, -0.649519052838329}}]}}, {
              Arrowheads[{{0.012841876226407674`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               
               ArrowBox[{{0.41352562867922305`, -0.5827907065723821}, {
                0.33647437132077695`, -0.7162473991042759}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{0.7380332175765786, -0.5666107521963761}, {
                0.7619667824234214, -0.7324273534802819}}]}}, {
              Arrowheads[{{0.015379805767690777`, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{1.0788605826969275`, -0.5696032378377851}, {
                1.1711394173030725`, -0.7294348678388729}}]}}, {
              Arrowheads[{{0.016930881560337372`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{1.4304942756996677`, -0.5754344707429133}, {
                1.5695057243003323`, -0.7236036349337447}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{1.7875618219137923`, -0.5806793405807984}, {
                1.9624381780862077`, -0.7183587650958596}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{2.1474445416829107`, -0.5849258657842522}, {
                2.3525554583170893`, -0.7141122398924058}}]}}, {
              Arrowheads[{{0.021875000000000002`, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{2.508894230769231, -0.5883143728593325}, {
                2.741105769230769, -0.7107237328173255}}]}}, {
              Arrowheads[{{0.02246217075847712, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-2.9437263660100506`, -0.3554744903680884}, \
{-2.6812736339899494`, -0.2940445624702406}}]}}, {
              Arrowheads[{{0.020741913863016236`, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-2.557610152369559, -0.35734361706152484`}, \
{-2.317389847630441, -0.29217543577680416`}}]}}, {
              Arrowheads[{{0.019026374951867677`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-2.1711344634348575`, -0.35984028084871905`}, \
{-1.9538655365651425`, -0.28967877198960995`}}]}}, {
              Arrowheads[{{0.017318611366278037`, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-1.783989406183549, -0.36332673116579317`}, \
{-1.591010593816451, -0.28619232167253583`}}]}}, {
              Arrowheads[{{0.015625, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-1.3954326923076923`, -0.3684771549755905}, \
{-1.2295673076923077`, -0.2810418978627385}}]}}, {
              Arrowheads[{{0.013961246160658384`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-1.003317303328818, -0.37657721432038505`}, \
{-0.8716826966711819, -0.27294183851794396`}}]}}, {
              Arrowheads[{{0.012377402883845394`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{-0.5996322086515362, -0.38907439840087377`}, \
{-0.5253677913484638, -0.26044465443745524`}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{-0.15417468566038847`, -0.38248066403357533`}, \
{-0.22082531433961153`, -0.26703838880475367`}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{0.22082531433961153`, -0.26703838880475367`}, {
                0.15417468566038847`, -0.38248066403357533`}}]}}, {
              Arrowheads[{{0.012377402883845394`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{0.5253677913484638, -0.26044465443745524`}, {
                0.5996322086515362, -0.38907439840087377`}}]}}, {
              Arrowheads[{{0.013961246160658407`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{0.8716826966711817, -0.27294183851794396`}, {
                1.0033173033288183`, -0.37657721432038505`}}]}}, {
              Arrowheads[{{0.015625, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{1.2295673076923077`, -0.2810418978627385}, {
                1.3954326923076923`, -0.3684771549755905}}]}}, {
              Arrowheads[{{0.017318611366278037`, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{1.591010593816451, -0.28619232167253583`}, {
                1.783989406183549, -0.36332673116579317`}}]}}, {
              Arrowheads[{{0.019026374951867642`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{1.953865536565143, -0.28967877198960995`}, {
                2.171134463434857, -0.35984028084871905`}}]}}, {
              Arrowheads[{{0.020741913863016236`, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{2.317389847630441, -0.29217543577680416`}, {
                2.557610152369559, -0.35734361706152484`}}]}}, {
              Arrowheads[{{0.02246217075847712, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{2.6812736339899494`, -0.2940445624702406}, {
                2.9437263660100506`, -0.3554744903680884}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-2.754054400754561, 0.}, {-2.495945599245439, 
                0.}}]}}, {
              Arrowheads[{{0.01977562867922304, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{-2.368653772075338, 0.}, {-2.131346227924662, 
                0.}}]}}, {
              Arrowheads[{{0.018042190566019207`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               
               ArrowBox[{{-1.9832531433961154`, 0.}, {-1.7667468566038846`, 
                0.}}]}}, {
              Arrowheads[{{0.01630875245281536, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{-1.5978525147168923`, 0.}, {-1.4021474852831077`, 
                0.}}]}}, {
              Arrowheads[{{0.01457531433961153, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{-1.2124518860376692`, 0.}, {-1.0375481139623308`, 
                0.}}]}}, {
              Arrowheads[{{0.012841876226407681`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               ArrowBox[{{-0.8270512573584461, 0.}, {-0.6729487426415539, 
                0.}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{-0.44165062867922306`, 0.}, {-0.30834937132077694`, 
                0.}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{0.30834937132077694`, 0.}, {0.44165062867922306`, 
                0.}}]}}, {
              Arrowheads[{{0.012841876226407681`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               
               ArrowBox[{{0.6729487426415539, 0.}, {0.8270512573584461, 
                0.}}]}}, {
              Arrowheads[{{0.01457531433961153, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{1.0375481139623308`, 0.}, {1.2124518860376692`, 
                0.}}]}}, {
              Arrowheads[{{0.01630875245281536, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{1.4021474852831077`, 0.}, {1.5978525147168923`, 
                0.}}]}}, {
              Arrowheads[{{0.018042190566019228`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               
               ArrowBox[{{1.7667468566038846`, 0.}, {1.9832531433961154`, 
                0.}}]}}, {
              Arrowheads[{{0.01977562867922304, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{2.131346227924662, 0.}, {2.368653772075338, 
                0.}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{2.495945599245439, 0.}, {2.754054400754561, 
                0.}}]}}, {
              Arrowheads[{{0.02246217075847712, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-2.9437263660100506`, 
                0.3554744903680884}, {-2.6812736339899494`, 
                0.2940445624702406}}]}}, {
              Arrowheads[{{0.020741913863016236`, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-2.557610152369559, 
                0.35734361706152484`}, {-2.317389847630441, 
                0.29217543577680416`}}]}}, {
              Arrowheads[{{0.019026374951867677`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-2.1711344634348575`, 
                0.35984028084871905`}, {-1.9538655365651425`, 
                0.28967877198960995`}}]}}, {
              Arrowheads[{{0.017318611366278037`, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-1.783989406183549, 
                0.36332673116579317`}, {-1.591010593816451, 
                0.28619232167253583`}}]}}, {
              Arrowheads[{{0.015625, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-1.3954326923076923`, 
                0.3684771549755905}, {-1.2295673076923077`, 
                0.2810418978627385}}]}}, {
              Arrowheads[{{0.013961246160658384`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-1.003317303328818, 
                0.37657721432038505`}, {-0.8716826966711819, 
                0.27294183851794396`}}]}}, {
              Arrowheads[{{0.012377402883845394`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{-0.5996322086515362, 
                0.38907439840087377`}, {-0.5253677913484638, 
                0.26044465443745524`}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{-0.15417468566038847`, 
                0.38248066403357533`}, {-0.22082531433961153`, 
                0.26703838880475367`}}]}}, {
              Arrowheads[{{0.011108438113203842`, 1.}}], {
               LABColor[
               0.19414602255820335`, 0.5225863189271683, -0.8441174448560856], 
               
               ArrowBox[{{0.22082531433961153`, 0.26703838880475367`}, {
                0.15417468566038847`, 0.38248066403357533`}}]}}, {
              Arrowheads[{{0.012377402883845394`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{0.5253677913484638, 0.26044465443745524`}, {
                0.5996322086515362, 0.38907439840087377`}}]}}, {
              Arrowheads[{{0.013961246160658407`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{0.8716826966711817, 0.27294183851794396`}, {
                1.0033173033288183`, 0.37657721432038505`}}]}}, {
              Arrowheads[{{0.015625, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{1.2295673076923077`, 0.2810418978627385}, {
                1.3954326923076923`, 0.3684771549755905}}]}}, {
              Arrowheads[{{0.017318611366278037`, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{1.591010593816451, 0.28619232167253583`}, {
                1.783989406183549, 0.36332673116579317`}}]}}, {
              Arrowheads[{{0.019026374951867642`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{1.953865536565143, 0.28967877198960995`}, {
                2.171134463434857, 0.35984028084871905`}}]}}, {
              Arrowheads[{{0.020741913863016236`, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{2.317389847630441, 0.29217543577680416`}, {
                2.557610152369559, 0.35734361706152484`}}]}}, {
              Arrowheads[{{0.02246217075847712, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{2.6812736339899494`, 0.2940445624702406}, {
                2.9437263660100506`, 0.3554744903680884}}]}}, {
              Arrowheads[{{0.021875000000000002`, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-2.741105769230769, 
                0.7107237328173255}, {-2.508894230769231, 
                0.5883143728593325}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{-2.3525554583170893`, 
                0.7141122398924058}, {-2.1474445416829107`, 
                0.5849258657842522}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-1.9624381780862077`, 
                0.7183587650958596}, {-1.7875618219137923`, 
                0.5806793405807984}}]}}, {
              Arrowheads[{{0.016930881560337372`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-1.5695057243003323`, 
                0.7236036349337447}, {-1.4304942756996677`, 
                0.5754344707429133}}]}}, {
              Arrowheads[{{0.015379805767690777`, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{-1.1711394173030725`, 
                0.7294348678388729}, {-1.0788605826969275`, 
                0.5696032378377851}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-0.7619667824234214, 
                0.7324273534802819}, {-0.7380332175765786, 
                0.5666107521963761}}]}}, {
              Arrowheads[{{0.012841876226407674`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               
               ArrowBox[{{-0.33647437132077695`, 
                0.7162473991042759}, {-0.41352562867922305`, 
                0.5827907065723821}}]}}, {
              Arrowheads[{{0.012377402883845387`, 1.}}], {
               LABColor[
               0.20510302317438386`, 0.5225667542281431, -0.8179308107437433], 
               
               ArrowBox[{{0.07426441730307232, 
                0.649519052838329}, {-0.07426441730307232, 
                0.649519052838329}}]}}, {
              Arrowheads[{{0.012841876226407674`, 1.}}], {
               LABColor[
               0.2105815234824741, 0.5225569718786306, -0.8048374936875722], 
               
               ArrowBox[{{0.41352562867922305`, 0.5827907065723821}, {
                0.33647437132077695`, 0.7162473991042759}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{0.7380332175765786, 0.5666107521963761}, {
                0.7619667824234214, 0.7324273534802819}}]}}, {
              Arrowheads[{{0.015379805767690777`, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{1.0788605826969275`, 0.5696032378377851}, {
                1.1711394173030725`, 0.7294348678388729}}]}}, {
              Arrowheads[{{0.016930881560337372`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{1.4304942756996677`, 0.5754344707429133}, {
                1.5695057243003323`, 0.7236036349337447}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{1.7875618219137923`, 0.5806793405807984}, {
                1.9624381780862077`, 0.7183587650958596}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{2.1474445416829107`, 0.5849258657842522}, {
                2.3525554583170893`, 0.7141122398924058}}]}}, {
              Arrowheads[{{0.021875000000000002`, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{2.508894230769231, 0.5883143728593325}, {
                2.741105769230769, 0.7107237328173255}}]}}, {
              Arrowheads[{{0.023133738481975186`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-2.9215590528435973`, 
                1.0601403158713343`}, {-2.7034409471564027`, 
                0.8884168426436527}}]}}, {
              Arrowheads[{{0.0215090667924269, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-2.5309985964650394`, 
                1.0632339096946666`}, {-2.3440014035349606`, 
                0.8853232488203204}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-2.1384078926731296`, 
                1.0665917448867788`}, {-1.9865921073268704`, 
                0.8819654136282082}}]}}, {
              Arrowheads[{{0.018382208651536155`, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{-1.7426466259546085`, 
                1.0697953372768718`}, {-1.6323533740453915`, 
                0.8787618212381152}}]}}, {
              Arrowheads[{{0.01693088156033738, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-1.3419062679732177`, 
                1.0715145932577266`}, {-1.2830937320267823`, 
                0.8770425652572604}}]}}, {
              Arrowheads[{{0.015624999999999995`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-0.9338942307692308, 
                1.0679592118784063`}, {-0.9411057692307692, 
                0.8805979466365808}}]}}, {
              Arrowheads[{{0.014575314339611525`, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{-0.5187740569811654, 
                1.0500141341749767`}, {-0.6062259430188346, 
                0.8985430243400103}}]}}, {
              Arrowheads[{{0.013961246160658398`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{-0.10971591424776038`, 
                1.005369191998226}, {-0.2652840857522396, 
                0.9431879665167611}}]}}, {
              Arrowheads[{{0.013961246160658391`, 1.}}], {
               LABColor[
               0.22701702440674484`, 0.5225276248300929, -0.7655575425190587], 
               
               ArrowBox[{{0.2652840857522396, 0.9431879665167613}, {
                0.10971591424776038`, 1.0053691919982257`}}]}}, {
              Arrowheads[{{0.014575314339611532`, 1.}}], {
               LABColor[
               0.23797402502292536`, 0.5225080601310677, -0.7393709084067165], 
               
               ArrowBox[{{0.6062259430188346, 0.8985430243400103}, {
                0.5187740569811654, 1.0500141341749767`}}]}}, {
              Arrowheads[{{0.015625000000000014`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{0.9411057692307692, 0.8805979466365805}, {
                0.9338942307692308, 1.0679592118784065`}}]}}, {
              Arrowheads[{{0.01693088156033735, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{1.2830937320267823`, 0.8770425652572607}, {
                1.3419062679732177`, 1.0715145932577264`}}]}}, {
              Arrowheads[{{0.01838220865153617, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{1.6323533740453915`, 0.878761821238115}, {
                1.7426466259546085`, 1.069795337276872}}]}}, {
              Arrowheads[{{0.019919092403587187`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{1.9865921073268704`, 0.8819654136282082}, {
                2.1384078926731296`, 1.0665917448867788`}}]}}, {
              Arrowheads[{{0.0215090667924269, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{2.3440014035349606`, 0.8853232488203204}, {
                2.5309985964650394`, 1.0632339096946666`}}]}}, {
              Arrowheads[{{0.023133738481975172`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{2.7034409471564027`, 0.888416842643653}, {
                2.9215590528435973`, 1.060140315871334}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-2.708390422139864, 
                1.4083413636308233`}, {-2.541609577860136, 
                1.1897348477224927`}}]}}, {
              Arrowheads[{{0.02138461153538153, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{-2.3141538346061443`, 
                1.410155806714871}, {-2.1858461653938557`, 
                1.187920404638445}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-1.9169916002021568`, 
                1.4109328518939734`}, {-1.8330083997978432`, 
                1.1871433594593426`}}]}}, {
              Arrowheads[{{0.018547492321316795`, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-1.5158978505611287`, 
                1.4091816452887072`}, {-1.4841021494388713`, 
                1.1888945660646089`}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-1.1101554759717618`, 
                1.401883985001001}, {-1.1398445240282382`, 
                1.196192226352315}}]}}, {
              Arrowheads[{{0.01630875245281537, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{-0.7010737426415539, 
                1.3837808692456774`}, {-0.7989262573584461, 
                1.2142953421076386`}}]}}, {
              Arrowheads[{{0.015624999999999998`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{-0.2956730769230769, 
                1.3490011097411447`}, {-0.4543269230769231, 
                1.2490751016121713`}}]}}, {
              Arrowheads[{{0.01537980576769077, 1.}}], {
               LABColor[
               0.2544095259471961, 0.5224787130825299, -0.700090957238203], 
               
               ArrowBox[{{0.09227883460614462, 
                1.299038105676658}, {-0.09227883460614462, 
                1.299038105676658}}]}}, {
              Arrowheads[{{0.015624999999999998`, 1.}}], {
               LABColor[
               0.25988802625528634`, 0.5224689307330174, -0.6869976401820319], 
               
               ArrowBox[{{0.4543269230769231, 1.2490751016121713`}, {
                0.2956730769230769, 1.3490011097411447`}}]}}, {
              Arrowheads[{{0.01630875245281537, 1.}}], {
               LABColor[
               0.2763235271795571, 0.5224395836844796, -0.6477176890135184], 
               
               ArrowBox[{{0.7989262573584461, 1.2142953421076386`}, {
                0.7010737426415539, 1.3837808692456774`}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{1.1398445240282382`, 1.196192226352315}, {
                1.1101554759717618`, 1.401883985001001}}]}}, {
              Arrowheads[{{0.018547492321316795`, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{1.4841021494388713`, 1.1888945660646089`}, {
                1.5158978505611287`, 1.4091816452887072`}}]}}, {
              Arrowheads[{{0.019919092403587177`, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{1.8330083997978432`, 1.1871433594593426`}, {
                1.9169916002021568`, 1.4109328518939734`}}]}}, {
              Arrowheads[{{0.02138461153538153, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{2.1858461653938557`, 1.187920404638445}, {
                2.3141538346061443`, 1.410155806714871}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{2.541609577860136, 1.1897348477224927`}, {
                2.708390422139864, 1.4083413636308233`}}]}}, {
              Arrowheads[{{0.024387014419226933`, 1.}}], {
               LABColor[
               0.6258311169859616, 0.5367783770662146, 0.6491359545236027], 
               
               ArrowBox[{{-2.885661043257681, 
                1.75051627615287}, {-2.739338956742319, 
                1.497078988038775}}]}}, {
              Arrowheads[{{0.022913584461854545`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-2.4904641870347786`, 
                1.7506674850783357`}, {-2.3845358129652214`, 
                1.4969277791133093`}}]}}, {
              Arrowheads[{{0.02150906679242688, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-2.0927882777281113`, 
                1.749247457071323}, {-2.0322117222718887`, 
                1.498347807120322}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               ArrowBox[{{-1.6921616117416858`, 
                1.7449098578222164`}, {-1.6828383882583142`, 
                1.5026854063694286`}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-1.2885635928024892`, 
                1.7354182143716779`}, {-1.3364364071975108`, 
                1.5121770498199671`}}]}}, {
              Arrowheads[{{0.018042190566019217`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               
               ArrowBox[{{-0.8833734283019423, 
                1.717547604316378}, {-0.9916265716980577, 
                1.530047659875267}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{-0.48085511784468926`, 
                1.688076306673537}, {-0.6441448821553107, 
                1.559518957518108}}]}}, {
              Arrowheads[{{0.016930881560337365`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{-0.08858800772645013, 
                1.64694906400064}, {-0.28641199227354985`, 
                1.6006462001910051`}}]}}, {
              Arrowheads[{{0.016930881560337365`, 1.}}], {
               LABColor[
               0.29275902810382787`, 0.5224102366359419, -0.608437737845005], 
               
               
               ArrowBox[{{0.28641199227354985`, 1.6006462001910051`}, {
                0.08858800772645013, 1.64694906400064}}]}}, {
              Arrowheads[{{0.01731861136627803, 1.}}], {
               LABColor[
               0.30371602872000836`, 0.5223906719369168, -0.5822511037326628], 
               
               ArrowBox[{{0.6441448821553107, 1.559518957518108}, {
                0.48085511784468926`, 1.688076306673537}}]}}, {
              Arrowheads[{{0.018042190566019214`, 1.}}], {
               LABColor[
               0.32563002995236934`, 0.5223515425388664, -0.5298778355079781], 
               
               ArrowBox[{{0.9916265716980577, 1.530047659875267}, {
                0.8833734283019423, 1.717547604316378}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{1.3364364071975108`, 1.5121770498199671`}, {
                1.2885635928024892`, 1.7354182143716779`}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{1.6828383882583142`, 1.5026854063694286`}, {
                1.6921616117416858`, 1.7449098578222164`}}]}}, {
              Arrowheads[{{0.02150906679242688, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{2.0322117222718887`, 1.498347807120322}, {
                2.0927882777281113`, 1.749247457071323}}]}}, {
              Arrowheads[{{0.022913584461854545`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{2.3845358129652214`, 1.4969277791133093`}, {
                2.4904641870347786`, 1.7506674850783357`}}]}}, {
              Arrowheads[{{0.024387014419226933`, 1.}}], {
               LABColor[
               0.6258311169859616, 0.5367783770662146, 0.6491359545236027], 
               
               ArrowBox[{{2.739338956742319, 1.497078988038775}, {
                2.885661043257681, 1.75051627615287}}]}}, {
              Arrowheads[{{0.02448676312067471, 1.}}], {
               LABColor[
               0.6320395081726374, 0.5371829267167847, 0.6767944920581912], 
               
               ArrowBox[{{-2.667529641209593, 
                2.089187475556486}, {-2.582470358790407, 
                1.807926841473488}}]}}, {
              Arrowheads[{{0.023133738481975155`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-2.2698289186988356`, 
                2.085935937097132}, {-2.2301710813011644`, 
                1.811178379932842}}]}}, {
              Arrowheads[{{0.02187500000000002, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-1.869951923076923, 
                2.079710044184265}, {-1.880048076923077, 
                1.817404272845709}}]}}, {
              Arrowheads[{{0.02074191386301624, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-1.4681635740707193`, 
                2.068867647040625}, {-1.5318364259292807`, 
                1.828246669989349}}]}}, {
              Arrowheads[{{0.019775628679223053`, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{-1.065673113962331, 
                2.0513143393870785`}, {-1.184326886037669, 
                1.8457999776428955`}}]}}, {
              Arrowheads[{{0.019026374951867667`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{-0.6653019437626536, 
                2.0250969863612878`}, {-0.8346980562373464, 
                1.8720173306686863`}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{-0.2716639713526636, 
                1.9898609858695053`}, {-0.4783360286473364, 
                1.9072533311604687`}}]}}, {
              Arrowheads[{{0.018382208651536155`, 1.}}], {
               LABColor[
               0.3365870305685499, 0.5223319778398413, -0.5036912013956358], 
               
               ArrowBox[{{0.11029325190921693`, 
                1.948557158514987}, {-0.11029325190921693`, 
                1.948557158514987}}]}}, {
              Arrowheads[{{0.01854749232131678, 1.}}], {
               LABColor[
               0.3420655308766401, 0.5223221954903287, -0.49059788433946466`], 
               
               ArrowBox[{{0.4783360286473364, 1.9072533311604687`}, {
                0.2716639713526636, 1.9898609858695053`}}]}}, {
              Arrowheads[{{0.019026374951867653`, 1.}}], {
               LABColor[
               0.35850103180091086`, 
                0.5222928484417909, -0.45131793317095126`], 
               
               ArrowBox[{{0.8346980562373464, 1.8720173306686863`}, {
                0.6653019437626536, 2.0250969863612878`}}]}}, {
              Arrowheads[{{0.019775628679223032`, 1.}}], {
               LABColor[
               0.3858935333413621, 0.5222439366942281, -0.3858513478900955], 
               
               ArrowBox[{{1.1843268860376692`, 1.8457999776428955`}, {
                1.0656731139623308`, 2.0513143393870785`}}]}}, {
              Arrowheads[{{0.02074191386301624, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{1.5318364259292807`, 1.828246669989349}, {
                1.4681635740707193`, 2.068867647040625}}]}}, {
              Arrowheads[{{0.02187500000000002, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{1.880048076923077, 1.817404272845709}, {
                1.869951923076923, 2.079710044184265}}]}}, {
              Arrowheads[{{0.023133738481975155`, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{2.2301710813011644`, 1.811178379932842}, {
                2.2698289186988356`, 2.085935937097132}}]}}, {
              Arrowheads[{{0.02448676312067471, 1.}}], {
               LABColor[
               0.6320395081726374, 0.5371829267167847, 0.6767944920581912], 
               
               ArrowBox[{{2.582470358790407, 1.807926841473488}, {
                2.667529641209593, 2.089187475556486}}]}}, {
              Arrowheads[{{0.026091671779532397`, 1.}}], {
               LABColor[
               0.7107411476334183, 0.3868416880886058, 0.769089120672111], 
               
               ArrowBox[{{-2.845325006432315, 
                2.4263867050483103`}, {-2.779674993567685, 
                2.1202466648199927`}}]}}, {
              Arrowheads[{{0.02478213496054044, 1.}}], {
               LABColor[
               0.6488752810184844, 0.5279153368226368, 0.7345767373636841], 
               
               ArrowBox[{{-2.4478520310594662`, 
                2.4216487014654176`}, {-2.4271479689405338`, 
                2.1249846684028855`}}]}}, {
              Arrowheads[{{0.023563802464782447`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{-2.048783756774231, 
                2.414032586627407}, {-2.076216243225769, 
                2.132600783240896}}]}}, {
              Arrowheads[{{0.022462170758477132`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-1.648486756051066, 
                2.4023195335196323`}, {-1.726513243948934, 
                2.1443138363486707`}}]}}, {
              Arrowheads[{{0.021509066792426892`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-1.2479727996227195`, 
                2.3850810744577795`}, {-1.3770272003772805`, 
                2.1615522954105235`}}]}}, {
              Arrowheads[{{0.02074191386301625, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{-0.8492262735597216, 
                2.3610430828174294`}, {-1.0257737264402784`, 
                2.1855902870508737`}}]}}, {
              Arrowheads[{{0.02020031754730549, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{-0.45528292994122466`, 
                2.3298357236064686`}, {-0.6697170700587753, 
                2.2167976462618344`}}]}}, {
              Arrowheads[{{0.01991909240358717, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{-0.06960050712471377, 
                2.2928982655221817`}, {-0.3053994928752862, 
                2.2537351043461213`}}]}}, {
              Arrowheads[{{0.01991909240358717, 1.}}], {
               LABColor[
               0.3913720336494524, 0.5222341543447155, -0.37275803083392434`], 
               
               ArrowBox[{{0.3053994928752862, 2.2537351043461213`}, {
                0.06960050712471377, 2.2928982655221817`}}]}}, {
              Arrowheads[{{0.020200317547305485`, 1.}}], {
               LABColor[
               0.4023290342656329, 0.5222145896456903, -0.3465713967215819], 
               
               ArrowBox[{{0.6697170700587752, 2.2167976462618344`}, {
                0.4552829299412247, 2.3298357236064686`}}]}}, {
              Arrowheads[{{0.02074191386301625, 1.}}], {
               LABColor[
               0.42716259901233605`, 
                0.5238327882479709, -0.23593724658322807`], 
               
               ArrowBox[{{1.0257737264402784`, 2.1855902870508737`}, {
                0.8492262735597216, 2.3610430828174294`}}]}}, {
              Arrowheads[{{0.021509066792426892`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{1.3770272003772805`, 2.1615522954105235`}, {
                1.2479727996227195`, 2.3850810744577795`}}]}}, {
              Arrowheads[{{0.022462170758477132`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{1.726513243948934, 2.1443138363486707`}, {
                1.648486756051066, 2.4023195335196323`}}]}}, {
              Arrowheads[{{0.023563802464782447`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{2.076216243225769, 2.132600783240896}, {
                2.048783756774231, 2.414032586627407}}]}}, {
              Arrowheads[{{0.02478213496054044, 1.}}], {
               LABColor[
               0.6488752810184844, 0.5279153368226368, 0.7345767373636841], 
               
               ArrowBox[{{2.4271479689405338`, 2.1249846684028855`}, {
                2.4478520310594662`, 2.4216487014654176`}}]}}, {
              Arrowheads[{{0.026091671779532397`, 1.}}], {
               LABColor[
               0.7107411476334183, 0.3868416880886058, 0.769089120672111], 
               
               ArrowBox[{{2.779674993567685, 2.1202466648199927`}, {
                2.845325006432315, 2.4263867050483103`}}]}}, {
              Arrowheads[{{0.02644738548515838, 1.}}], {
               LABColor[
               0.7284171095233996, 0.3465349313074541, 0.7789498016173758], 
               ArrowBox[{{-2.626635920751659, 
                2.756752091459004}, {-2.623364079248341, 
                2.439400331247628}}]}}, {
              Arrowheads[{{0.025262222732556048`, 1.}}], {
               LABColor[
               0.6709702333809607, 0.4775318908461973, 0.7469025885452651], 
               
               ArrowBox[{{-2.2283466662292377`, 
                2.7480949083301454`}, {-2.2716533337707623`, 
                2.4480575143764867`}}]}}, {
              Arrowheads[{{0.024185501731489797`, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{-1.8292794624801973`, 
                2.73579846167272}, {-1.9207205375198027`, 
                2.460353961033912}}]}}, {
              Arrowheads[{{0.02324250490563072, 1.}}], {
               LABColor[
               0.5575388139325278, 0.5323283309099432, 0.3448920416431297], 
               
               ArrowBox[{{-1.430272485283108, 
                2.71884780952848}, {-1.569727514716892, 
                2.477304613178152}}]}}, {
              Arrowheads[{{0.022462170758477135`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{-1.0327868779388834`, 
                2.696364095989873}, {-1.2172131220611166`, 
                2.499788326716759}}]}}, {
              Arrowheads[{{0.02187500000000003, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{-0.6389423076923076, 
                2.668024417043598}, {-0.8610576923076924, 
                2.528128005663034}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{-0.25121312580684935`, 
                2.6345707058916434`}, {-0.49878687419315065`, 
                2.5615817168149886`}}]}}, {
              Arrowheads[{{0.02138461153538154, 1.}}], {
               LABColor[
               0.45820455494571505`, 0.5258555365008214, -0.0976445589102857], 
               
               ArrowBox[{{0.12830766921228923`, 
                2.598076211353316}, {-0.12830766921228923`, 
                2.598076211353316}}]}}, {
              Arrowheads[{{0.021509066792426885`, 1.}}], {
               LABColor[
               0.4644129461323908, 0.5262600861513915, -0.06998602137569734], 
               
               
               ArrowBox[{{0.49878687419315065`, 2.5615817168149886`}, {
                0.25121312580684935`, 2.6345707058916434`}}]}}, {
              Arrowheads[{{0.02187500000000003, 1.}}], {
               LABColor[
               0.4830381196924182, 0.5274737351031019, 0.012989591228068104`], 
               
               ArrowBox[{{0.8610576923076924, 2.528128005663034}, {
                0.6389423076923076, 2.668024417043598}}]}}, {
              Arrowheads[{{0.022462170758477135`, 1.}}], {
               LABColor[
               0.5140800756257973, 0.5294964833559525, 0.15128227890101045`], 
               
               
               ArrowBox[{{1.2172131220611166`, 2.499788326716759}, {
                1.0327868779388834`, 2.696364095989873}}]}}, {
              Arrowheads[{{0.02324250490563072, 1.}}], {
               LABColor[
               0.5575388139325278, 0.5323283309099432, 0.3448920416431297], 
               
               ArrowBox[{{1.569727514716892, 2.477304613178152}, {
                1.430272485283108, 2.71884780952848}}]}}, {
              Arrowheads[{{0.024185501731489797`, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{1.9207205375198027`, 2.460353961033912}, {
                1.8292794624801973`, 2.73579846167272}}]}}, {
              Arrowheads[{{0.025262222732556048`, 1.}}], {
               LABColor[
               0.6709702333809607, 0.4775318908461973, 0.7469025885452651], 
               
               ArrowBox[{{2.2716533337707623`, 2.4480575143764867`}, {
                2.2283466662292377`, 2.7480949083301454`}}]}}, {
              Arrowheads[{{0.02644738548515838, 1.}}], {
               LABColor[
               0.7284171095233996, 0.3465349313074541, 0.7789498016173758], 
               
               ArrowBox[{{2.623364079248341, 2.439400331247628}, {
                2.626635920751659, 2.756752091459004}}]}}, {
              Arrowheads[{{0.02812500000000001, 1.}}], {
               LABColor[
               0.8167969189733053, 0.14500114740169545`, 0.8282532063436999], 
               
               
               ArrowBox[{{-2.8060096153846152`, 
                3.0914608764901237`}, {-2.8189903846153848`, 
                2.7542105990548373`}}]}}, {
              Arrowheads[{{0.02696747544570384, 1.}}], {
               LABColor[
               0.7549310523583713, 0.28607479613572645`, 0.793740823035273], 
               
               ArrowBox[{{-2.40843796335463, 
                3.0820092543352247`}, {-2.46656203664537, 
                2.7636622212097364`}}]}}, {
              Arrowheads[{{0.025910945694153684`, 1.}}], {
               LABColor[
               0.7019031666884278, 0.4069950664791816, 0.7641587801994786], 
               
               ArrowBox[{{-2.0103933729447236`, 
                3.069309200421781}, {-2.1146066270552764`, 
                2.77636227512318}}]}}, {
              Arrowheads[{{0.024975943018834577`, 1.}}], {
               LABColor[
               0.6577132619634748, 0.5077619584320612, 0.7395070778363165], 
               
               ArrowBox[{{-1.6125721709434964`, 
                3.0526145445991806`}, {-1.7624278290565036`, 
                2.7930569309457804`}}]}}, {
              Arrowheads[{{0.02418550173148977, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{-1.216089301316938, 
                3.031292009899011}, {-1.408910698683062, 
                2.81437946564595}}]}}, {
              Arrowheads[{{0.02356380246478242, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{-0.8224945760300917, 
                3.0050723036971103`}, {-1.0525054239699083`, 
                2.8405991718478507`}}]}}, {
              Arrowheads[{{0.02313373848197518, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{-0.43361202845756686`, 
                2.974352779740785}, {-0.6913879715424331, 
                2.871318695804176}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{-0.051145390825357406`, 
                2.9404023328008284`}, {-0.3238546091746426, 
                2.9052691427441326`}}]}}, {
              Arrowheads[{{0.022913584461854538`, 1.}}], {
               LABColor[
               0.5389136403725004, 0.531114681958233, 0.26191642903936424`], 
               
               ArrowBox[{{0.3238546091746426, 2.9052691427441326`}, {
                0.051145390825357406`, 2.9404023328008284`}}]}}, {
              Arrowheads[{{0.02313373848197518, 1.}}], {
               LABColor[
               0.551330422745852, 0.5319237812593732, 0.317233504108541], 
               
               ArrowBox[{{0.6913879715424331, 2.871318695804176}, {
                0.43361202845756686`, 2.974352779740785}}]}}, {
              Arrowheads[{{0.023563802464782405`, 1.}}], {
               LABColor[
               0.5761639874925553, 0.5335419798616536, 0.42786765424689516`], 
               
               
               ArrowBox[{{1.052505423969908, 2.8405991718478507`}, {
                0.8224945760300919, 3.0050723036971103`}}]}}, {
              Arrowheads[{{0.02418550173148977, 1.}}], {
               LABColor[
               0.61341433461261, 0.5359692777650744, 0.5938188794544257], 
               
               ArrowBox[{{1.408910698683062, 2.81437946564595}, {
                1.216089301316938, 3.031292009899011}}]}}, {
              Arrowheads[{{0.024975943018834577`, 1.}}], {
               LABColor[
               0.6577132619634748, 0.5077619584320612, 0.7395070778363165], 
               
               ArrowBox[{{1.7624278290565036`, 2.7930569309457804`}, {
                1.6125721709434964`, 3.0526145445991806`}}]}}, {
              Arrowheads[{{0.025910945694153684`, 1.}}], {
               LABColor[
               0.7019031666884278, 0.4069950664791816, 0.7641587801994786], 
               
               ArrowBox[{{2.1146066270552764`, 2.77636227512318}, {
                2.0103933729447236`, 3.069309200421781}}]}}, {
              Arrowheads[{{0.02696747544570384, 1.}}], {
               LABColor[
               0.7549310523583713, 0.28607479613572645`, 0.793740823035273], 
               
               ArrowBox[{{2.46656203664537, 2.7636622212097364`}, {
                2.40843796335463, 3.0820092543352247`}}]}}, {
              Arrowheads[{{0.02812500000000001, 1.}}], {
               LABColor[
               0.8167969189733053, 0.14500114740169545`, 0.8282532063436999], 
               
               
               ArrowBox[{{2.8189903846153848`, 2.7542105990548373`}, {
                2.8060096153846152`, 3.0914608764901237`}}]}}}}}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         PlotRange -> {{-3., 3.}, {-3., 3.}}, DisplayFunction -> Identity, 
         AspectRatio -> 1, Frame -> True, FrameLabel -> {
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm], 
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 200, 
         Method -> {
          "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
           Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
         Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
         AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic, 
         BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
         Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
         FormatType :> TraditionalForm, FrameStyle -> {}, 
         FrameTicksStyle -> {}, GridLines -> None, ImageMargins -> 0., 
         ImagePadding -> All, ImageSizeRaw -> Automatic, LabelStyle -> {}, 
         PlotLabel -> None, PlotRegion -> Automatic, PreserveImageOptions -> 
         Automatic, Prolog -> {}, RotateLabel -> True, TicksStyle -> {}, 
         DisplayFunction -> Identity, AspectRatio -> 1, DisplayFunction :> 
         Identity, Frame -> True, FrameLabel -> {
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm], 
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 200, 
         Method -> {
          "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
           Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "TransparentPolygonMesh" -> True}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp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                  "], {{
                    Rational[-15, 2], -100}, {
                    Rational[15, 2], 100}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -100}, {
                    Rational[-15, 2], -100}, {
                    Rational[-15, 2], 100}, {
                    Rational[15, 2], 100}, {
                    Rational[15, 2], -100}}, {{
                    7.5, -100}, {-7.5, -100}, {-7.5, 100}, {7.5, 100}, {
                    7.5, -100}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -100.}, 
                    Offset[{4., 0}, {7.5, -100.}]}, {{7.5, -39.3939393939394}, 
                    Offset[{4., 0}, {7.5, -39.3939393939394}]}, {{7.5, 
                    21.21212121212121}, 
                    Offset[{4., 0}, {7.5, 21.21212121212121}]}, {{7.5, 
                    81.81818181818183}, 
                    Offset[{4., 0}, {7.5, 81.81818181818183}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -87.87878787878788}, 
                    Offset[{2.5, 0.}, {7.5, -87.87878787878788}]}, {{
                    7.5, -75.75757575757576}, 
                    Offset[{2.5, 0.}, {7.5, -75.75757575757576}]}, {{
                    7.5, -63.63636363636364}, 
                    Offset[{2.5, 0.}, {7.5, -63.63636363636364}]}, {{
                    7.5, -51.515151515151516`}, 
                    Offset[{2.5, 0.}, {7.5, -51.515151515151516`}]}, {{
                    7.5, -27.272727272727273`}, 
                    Offset[{2.5, 0.}, {7.5, -27.272727272727273`}]}, {{
                    7.5, -15.151515151515152`}, 
                    Offset[{2.5, 0.}, {7.5, -15.151515151515152`}]}, {{
                    7.5, -3.0303030303030303`}, 
                    Offset[{2.5, 0.}, {7.5, -3.0303030303030303`}]}, {{7.5, 
                    9.090909090909092}, 
                    Offset[{2.5, 0.}, {7.5, 9.090909090909092}]}, {{7.5, 
                    33.333333333333336`}, 
                    Offset[{2.5, 0.}, {7.5, 33.333333333333336`}]}, {{7.5, 
                    45.45454545454545}, 
                    Offset[{2.5, 0.}, {7.5, 45.45454545454545}]}, {{7.5, 
                    57.57575757575758}, 
                    Offset[{2.5, 0.}, {7.5, 57.57575757575758}]}, {{7.5, 
                    69.6969696969697}, 
                    Offset[{2.5, 0.}, {7.5, 69.6969696969697}]}, {{7.5, 
                    93.93939393939394}, 
                    Offset[{2.5, 0.}, {7.5, 93.93939393939394}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -100.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["5", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -39.3939393939394}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["10", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 21.21212121212121}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["15", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 81.81818181818183}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 200}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0.`", ",", "16.453125`"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "200"}], ",", 
               RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 10. Vector plot of \\!\\(\\*FormBox[RowBox[{RowBox[{\\\"f\\\", \
\\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\
\\\", \\\"2\\\"]}], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->1344865958,ExpressionUUID->"75183ef4-0321-41c7-ac42-72e642c8b531"]
}, {2}]],

Cell["By joining the arrows together, one gets the stream plot.", "Text",
 CellID->108638230,ExpressionUUID->"c3856ac3-9b60-4eaa-a645-e07ea756fdd7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexStreamPlot", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"3", "I"}]}]}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["3", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["656", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[FrameLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic, ImageSize -> 200],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["600", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 11. Stream plot of " <> 
     ToString[$CellContext`f[$CellContext`z] == $CellContext`z^2, 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->584475159,ExpressionUUID->"a778f65c-7347-4ffd-8e8b-628949a8fa09"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{{{{}}, {{
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.18866755933886142`, 0.5225961012104556, -0.8572106732721703], 
               ArrowBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAcDd/YMd7UT9VpRETHEievil6Nub7
7Go/qtWrRw7S0b51+DL9xQt2P9/LtL+D0ue+b9kijRJufz8V7s+3FC34viXK
YXJ3M4U/3i35WOTkBb9LLJt0AI+NP5pN1YcaSRW/SHAuSZNckT8OlE4QwEYd
v2mJWmCOE5U/f84JZG6dJb+/WwVGtzKYP9gnXecdcyy/uv0L9bBnnD/nz/l6
Qoozv1oqVKGxOKE/rmMJEEvIPL96BvL0oNGjP8ovZ0cMBkO/o1FST6BWpz9S
Xj0gREdKv9g+ZVzXb6w/lyzwZluNU7/3mRsGRjiwPxjHwAtqbVm/61hqmxbj
sj+b9LpNB0NhvyJC0y9Ko7Y/sFkSxxX1aL+CTKN26VG5P5+LB8t/OG+/Lm7y
QZG5vD/+I+qwAx90vyOXXNprl8A/1dF6B9Dqer8F/6sG4p3DPwIlcLw8xIK/
bnvjOAPzxT9krofAVYKHv6LPdUPo6Mg/6qX3mvZZjr/ofJsPYMjMP4uxGd+n
VJS/gNzsB68E0T9fEaUWa2qcv98jh2t25tI/2nNaIbOQob/ZLHuW3D3VP29x
fAKFRqa/b3qSlCE62D+ojWrU9SOtv/NKQgstJtw/LgZ1UAzIs783XhXA8xPe
P+heCdEOvba/c8DsiQ==
                "]]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.1965298213864852, 0.522582062442365, -0.8384202956178659], 
               
               ArrowBox[{{0.48117295160718193`, -0.09311696386683237}, {
                0.4845670933593238, -0.09441785610286067}, {
                0.5388772331548292, -0.11787898798560949`}, {
                0.6059098380624259, -0.15102992968749954`}, {
                0.6902334151601288, -0.1996353110212832}, {
                0.7500703508284245, -0.23972553380195397`}, {
                0.8193514634162397, -0.2926218682589385}, {
                0.8835884468311446, -0.3496541961744711}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.21892862967204965`, 0.5225420673782065, -0.7848883649670265], 
               
               ArrowBox[{{0.8925620193909718, -0.35762131582422635`}, {
                0.8996957506647171, -0.36395494607329454`}, {
                0.9445168661518925, -0.40890807277902563`}, {
                0.9923382861674538, -0.4622228761105389}, {
                1.0339711652555954`, -0.514577478206376}, {
                1.0771380308903769`, -0.5754493798304068}, {
                1.1212194799253654`, -0.6465133271123512}, {
                1.1433363634055829`, -0.6866779977259482}, {
                1.1652458313390517`, -0.7301949039742465}, {
                1.1717243596097469`, -0.7444389222492224}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2526334944731327, 0.5224818843446725, -0.7043355756344658], 
               
               ArrowBox[{{1.1766925208203174`, -0.7553621714995957}, {
                1.1926864921374867`, -0.7905273217022589}, {
                1.218884310210642, -0.8573936392264887}, {
                1.2431457416731095`, -0.9315176829856104}, {
                1.2644079985893708`, -1.0135991058820044`}, {
                1.2821134675268064`, -1.1083597487513672`}, {
                1.2933646574886744`, -1.2132188727336428`}, {
                1.293474141326985, -1.2181252094259893`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.29293908682338426`, 0.5224099151250852, -0.6080074073218145], 
               
               ArrowBox[{{1.2937418520773147`, -1.230122222844093}, {
                1.2959466855037054`, -1.3289281772875505`}, {
                1.2869272961085172`, -1.4553712134621937`}, {
                1.2769612664348782`, -1.5225855523446619`}, {
                1.26276791827203, -1.5924445298571583`}, {
                1.243849401778878, -1.6644946415945827`}, {
                1.23120058445427, -1.703155301603229}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3343345664551319, 0.5223359998148314, -0.5090744678255157], 
               
               ArrowBox[{{1.22746911826806, -1.7145603952065789`}, {
                1.2197078671143295`, -1.7382823831518344`}, {
                1.1896356600357227`, -1.8137046616321943`}, {
                1.1530929698216492`, -1.8903780549322389`}, {
                1.1098337119128987`, -1.9674285648368082`}, {
                1.059611801750259, -2.0439821931307405`}, {
                1.0016555924795107`, -2.1193229904973556`}, {
                0.9923278457219398, -2.129673863608399}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3699788701543481, 0.522272353740667, -0.4238865252619093], 
               ArrowBox[{{0.9842945793903446, -2.1385882694801137`}, {
                0.9356138870824411, -2.192608568501189}, {
                0.8618712757538477, -2.262775270248905}, {
                0.7808123486885271, -2.328759438847171}, {
                0.6922372221177493, -2.389183884515145}, {
                0.6104695713632816, -2.435039581713597}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3952969207932599, 0.5222271461096732, -0.36337776453957477`], 
               
               ArrowBox[{{0.6000030924565545, -2.4409092341134446`}, {
                0.5964135914436067, -2.4429222437819935`}, {
                0.49442741561712894`, -2.489287099219386}, {
                0.3873646535893462, -2.5275910333989966`}, {
                0.2761150782450707, -2.556444217200703}, {
                0.16172541132208967`, -2.575018750857819}, {
                0.1424491886386456, -2.576420631727077}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4070953315592042, 0.5225251699307674, -0.32533742343746047`], 
               
               ArrowBox[{{0.13048079765672854`, -2.5772910438731125`}, {
                0.04551703505089462, -2.5834701109721667`}, \
{-0.07118866833802287, -2.5819537741455685`}, {-0.1866822324696004, \
-2.5700233451445302`}, {-0.2995646582844316, -2.5477139262038118`}, \
{-0.34462135980081204`, -2.5346144732390434`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.40255463280279796`, 0.5222705857448965, -0.3442925289349709], 
               
               ArrowBox[{{-0.35614424859647653`, -2.5312643935679384`}, \
{-0.4089802645255089, -2.5159032401276122`}, {-0.514073369935825, \
-2.475469009720133}, {-0.6133954124806922, -2.427158675104409}, \
{-0.7059721347475668, -2.3718239025484094`}, {-0.7824705719093115, \
-2.31707501076718}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3837036485613624, 0.522247846928253, -0.3910850531248433], 
               
               ArrowBox[{{-0.7921949274172275, -2.31004738971025}, \
{-0.8703127211521677, -2.2442172917019656`}, {-0.9412728200235491, \
-2.1741744154431726`}, {-1.004292321379255, -2.101436354916637}, \
{-1.0598453808380048`, -2.026844166557808}, {-1.1078835826288833`, \
-1.9520525088736516`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3525623110587927, 0.5223034525558168, -0.46551115197387555`], 
               
               ArrowBox[{{-1.113757844951722, -1.9415907372559094`}, \
{-1.1508888845709497`, -1.8746499198310596`}, {-1.1866880454471203`, \
-1.798564208852757}, {-1.216292312140335, -1.7235123840049913`}, \
{-1.2401903601439004`, -1.6500250554255271`}, {-1.2588892951824073`, \
-1.5784305460754058`}, {-1.2728962229804464`, -1.5090571789156677`}, \
{-1.2756980384947645`, -1.492655411941793}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.31383793505352203`, 0.5223725983729997, -0.5580602994277234], 
               
               ArrowBox[{{-1.2777186568697985`, -1.480826756000289}, \
{-1.2845571471582515`, -1.4407943828511216`}, {-1.2921100910032328`, \
-1.3750251082147016`}, {-1.296940662095753, -1.2969406998787654`}, \
{-1.2938632935140577`, -1.2328646768480853`}, {-1.2881506604952497`, \
-1.172207115118798}, {-1.2723778483712334`, -1.057483112073575}, \
{-1.2604481863519674`, -1.0047420133274618`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.2727453543703105, 0.5224459728302436, -0.6562693269506473], 
               
               ArrowBox[{{-1.25780075240798, -0.9930376938892278}, \
{-1.2492989804114818`, -0.9554513150245032}, {-1.2213423372838432`, \
-0.8650330686236065}, {-1.1852699130689008`, -0.7748548478747839}, \
{-1.147188205180625, -0.6964798010034927}, {-1.1088482997336326`, \
-0.6281725185298038}, {-1.070723183205054, -0.5685964215814213}, \
{-1.0626314862493629`, -0.5577929207366822}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23496046388229594`, 0.5225134411124854, -0.7465731552376875], 
               
               ArrowBox[{{-1.055437705966515, -0.5481882590954733}, \
{-0.9973763137460315, -0.4706685122073334}, {-0.9294362387696469, \
-0.39462877732220103`}, {-0.8778966180983079, -0.34441233894321194`}, \
{-0.8305416474273236, -0.3029043537435084}, {-0.7476146578271099, \
-0.23883518263817224`}, {-0.7130679030527374, -0.21592416026246655`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.20631335778702806`, 0.5225645930680551, -0.8150381770052717], 
               
               ArrowBox[{{-0.7030672760607981, -0.2092918560046618}, \
{-0.6779535279555365, -0.19263669842082085`}, {-0.6190900142232882, \
-0.15839796830546155`}, {-0.5419438368976502, -0.1196727501928506}, \
{-0.48112330794298175`, -0.09332868148432312}, {-0.4321296453033581, \
-0.07472705890502751}, {-0.3919326407164577, -0.061151199614546334`}, \
{-0.3354585233497363, -0.044628082527870074`}, {-0.2929134655968375, \
-0.033863192767079095`}, {-0.26205131485479677`, -0.02704568444203389}}]}}, {
              Arrowheads[{{0.008331068994519046, 1.}}], {
               LABColor[
               0.19074290730136093`, 0.5225923954921043, -0.852250704786861], 
               
               
               ArrowBox[{{-0.25028552823744277`, -0.024689196510451726`}, \
{-0.23338175066970676`, -0.021385399944781718`}, {-0.1974657703233251, \
-0.01532745379349459}, {-0.17097367051955376`, -0.01145608272057948}, \
{-0.15071498857993781`, -0.00888372187594222}, {-0.1347462186599327, \
-0.007098100461834754}, {-0.11325092251747344`, -0.004982957315774835}, \
{-0.09775253495792861, -0.003706018648239211}, {-0.08601346953850024, \
-0.0028696794047128223`}, {-0.07050113863713642, -0.0019224314952702266`}, \
{-0.05981853498404579, -0.0013894462801048633`}, {-0.05194616535289616, \
-0.0010498495057477285`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19087437629606727`, 0.5225921607425225, -0.8519365010570183], 
               
               ArrowBox[{{0.25851795363160596`, 0.02501223515284179}, {
                0.28732703117000497`, 0.03095948315964815}, {
                0.32325197848504955`, 0.039324944269662584`}, {
                0.3691975256433065, 0.05155612483490622}, {0.4297946337856676,
                 0.07018685682303075}, {0.47394245826427095`, 
                0.08583992952487535}, {0.5277215885041373, 
                0.10730855860292232`}, {0.5944146432413255, 
                0.13773697992467002`}, {0.6788705904891413, 
                0.18251512543405676`}, {0.7036811417702303, 
                0.19774048435151845`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.20673363430879646`, 0.5225638426269495, -0.8140337390311327], 
               
               ArrowBox[{{0.7139088854262599, 0.2040168893501262}, {
                0.7382046160575882, 0.21892632102026793`}, {
                0.8073138080296118, 0.26697080626247033`}, {0.888182437021806,
                 0.33178771785120226`}, {0.9827557224101321, 
                0.4211891317223727}, {1.0262231344575279`, 
                0.46918979598046295`}, {1.069744635630197, 
                0.5224606628180579}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23587571464530202`, 0.5225118068508533, -0.7443857558122929], 
               
               ArrowBox[{{1.0769531485796262`, 0.5320492090260003}, {
                1.119622764486906, 0.5908266722858739}, {1.1440187396732926`, 
                0.6280749396706558}, {1.1685934984317723`, 
                0.6685582650124225}, {1.2222509025757895`, 
                0.7691415446018699}, {1.2483839039657525`, 
                0.8269033727420139}, {1.2734472279705638`, 
                0.8903342744156573}, {1.2955302227608563`, 
                0.9566340511104952}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2745278314026151, 0.5224427900589838, -0.6520093040215909], 
               
               ArrowBox[{{1.29932233921849, 0.9680191225978307}, {
                1.3002298668449073`, 0.970743792849635}, {1.3236686569785925`,
                 1.060179536171388}, {1.3423227598916092`, 
                1.1596569451880676`}, {1.3541142184125459`, 
                1.2698294565162178`}, {1.3568213181673947`, 
                1.3292446485688145`}, {1.3570745913939164`, 
                1.3917155438253432`}, {1.354886405585119, 
                1.4423791103066834`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3178311058387459, 0.5223654682114431, -0.5485168389531173], 
               
               ArrowBox[{{1.3543686020743926`, 1.4543679334150739`}, {
                1.3542546655910113`, 1.4570059308727075`}, {
                1.3477421682575805`, 1.5248795982978118`}, {
                1.3345833717661961`, 1.6076312128889148`}, {1.315204362510256,
                 1.69378213689768}, {1.288772366472599, 1.782851903015172}, {
                1.2544546096360645`, 1.8743600439324555`}, {
                1.2349707897426385`, 1.9165138091117842`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.35972643677092997`, 0.5222906603722396, -0.4483892820999684], 
               
               ArrowBox[{{1.2299360773739005`, 1.9274065439090735`}, {
                1.211416633820955, 1.967473855096142}, {1.1588239808475738`, 
                2.061360631952845}, {1.1152558147428786`, 
                2.128237096636109}, {1.0660943824641707`, 
                2.1944818267175332`}, {1.0113768703038808`, 
                2.2594502297026997`}, {0.9554248843488518, 
                2.31801335048487}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3951439541002091, 0.5222274192453072, -0.3637433465964365], 
               
               ArrowBox[{{0.9468640370700402, 2.326412821947375}, {
                0.885093956343101, 2.382963901233296}, {0.8132088529292603, 
                2.440201044981947}, {0.7359164148035617, 
                2.4935834916566613`}, {0.6536479024566503, 
                2.5424855885709596`}, {0.5665533340517376, 
                2.586022297389244}, {0.5504943885405561, 
                2.592599463996502}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4210309513558054, 0.5234332393403259, -0.2632538897775222], 
               
               ArrowBox[{{0.5393896671995567, 2.5971475585358395`}, {
                0.47500772161398197`, 2.623516088295212}, {
                0.37977981642694586`, 2.654652571381326}, {0.2816383697741903,
                 2.6791173567400484`}, {0.1813007670880517, 
                2.696207102842517}, {0.07952548648184701, 2.70552962945693}, {
                0.07441643363538507, 2.70561484436281}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4317274127290447, 0.5241302395100588, -0.21560088765775393`], 
               
               ArrowBox[{{0.062418102461146534`, 
                2.705814966908506}, {-0.02285708173939128, 
                2.70723728862134}, {-0.12501654727062966`, 
                2.7014824323737994`}, {-0.24596512611243845`, 
                2.6844193499378584`}, {-0.36354180891026816`, 
                2.6565755377125244`}, {-0.4104415249579659, 
                2.6410056117139256`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.42467391221422635`, 
                0.5236706210545254, -0.24702440832089037`], 
               
               ArrowBox[{{-0.421830328450082, 
                2.637224718298612}, {-0.47691536009893637`, 
                2.618937403605046}, {-0.5852545441132604, 
                2.5724913555226747`}, {-0.6870962512576685, 
                2.518142856994058}, {-0.7814828711408995, 
                2.4568621270507247`}, {-0.8417053739719682, 
                2.410318615981481}}]}}, {
              Arrowheads[{{0.01999999999999999, 1.}}], {
               LABColor[
               0.4013556900912169, 0.5222718392142038, -0.3471853081228726], 
               
               ArrowBox[{{-0.8512001882270516, 
                2.402980462108642}, {-0.8683414171542397, 
                2.3897327068542484`}, {-0.9475989026889747, 
                2.3178381375662003`}, {-1.0186685942198248`, 
                2.242471666762782}, {-1.0813747557547622`, 
                2.1647587768884913`}, {-1.1362608969849517`, 
                2.085531361407345}, {-1.1626201324496273`, 
                2.0412888891588974`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3683119843790288, 0.5222753301134578, -0.4278702913886444], 
               
               ArrowBox[{{-1.1687621415861493`, 
                2.0309798773843926`}, {-1.183870527601558, 
                2.0056213137833603`}, {-1.2252134891463016`, 
                1.9249486285301902`}, {-1.2596943802927432`, 
                1.8451299906418057`}, {-1.287848650349113, 
                1.7666777097130704`}, {-1.3102117486236415`, 
                1.6901040953388484`}, {-1.3273220799529712`, 
                1.6157138165549216`}, {-1.3330013363445778`, 
                1.5827715396898212`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3277222662041313, 0.5223478066649728, -0.5248775049320575], 
               ArrowBox[{{-1.3350400636803643`, 
                1.5709459914636155`}, {-1.3397180491737455`, 
                1.5438115423970729`}, {-1.3497568373402415`, 
                1.4731532705522628`}, {-1.3556931381982307`, 
                1.4052266093953687`}, {-1.3548582533478732`, 
                1.3378342185663947`}, {-1.3511040613934913`, 
                1.2738401843273077`}, {-1.3387203306802304`, 
                1.1524631754057129`}, {-1.3276078774558102`, 
                1.094108700721288}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28452128304593416`, 0.5224249458623397, -0.6281254994230466], 
               
               ArrowBox[{{-1.3253630555323612`, 
                1.0823205382464998`}, {-1.3180472849837945`, 
                1.0439034633979645`}, {-1.2916607791285788`, 
                0.9472209187296963}, {-1.2564641007916402`, 
                0.8501885755733084}, {-1.218551725837946, 
                0.7655029390454872}, {-1.1798661480602979`, 
                0.6914674177219775}, {-1.1484070236814161`, 
                0.6390452461469227}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2442118750335612, 0.5224969218951309, -0.7244627869601438], 
               
               ArrowBox[{{-1.142232234468037, 
                0.6287558351739693}, {-1.140997730619281, 
                0.6266987094958943}, {-1.1027376419419412`, 
                0.5698680590058981}, {-1.0654017904056792`, 
                0.5198579022948792}, {-0.9946613986696152, 
                0.4365689645544168}, {-0.9406824804127489, 
                0.3814509176075575}, {-0.8908545805057281, 
                0.3357887816515885}, {-0.8186858815629712, 
                0.2776525306497631}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21248871788070858`, 0.5225535664134224, -0.8002794030533595], 
               
               ArrowBox[{{-0.8093408570879026, 
                0.27012454834635874`}, {-0.8031712244217867, 
                0.2651545361593457}, {-0.7291573286615717, 
                0.2140909090964715}, {-0.6664019314075621, 
                0.17617273360328997`}, {-0.5848420139873794, 
                0.1336519237881184}, {-0.5202043729883138, 
                0.10456991208850475`}, {-0.4679268821956469, 
                0.08394083777300029}, {-0.42490090445170847`, 
                0.06882841259736791}, {-0.3826434937459309, 
                0.05595107807288997}}]}}, {
              Arrowheads[{{0.004978831264758327, 1.}}], {
               LABColor[
               0.19327984263523929`, 0.5225878655684516, -0.8461875676490535], 
               
               ArrowBox[{{-0.3711646475516592, 
                0.052453065773275576`}, {-0.3647246912733507, 
                0.0504905822719509}, {-0.3191580790979106, 
                0.03847175650572326}, {-0.2835660618423385, 
                0.030262458836436947`}, {-0.25504758306155195`, 
                0.024433424167505508`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.18888925275453508`, 0.5225957053571464, -0.8566808380951249], 
               
               ArrowBox[{{0.08227250306093288, -0.005316150236418595}, {
                0.0934746826775211, -0.006867851709273652}, {
                0.10823244037422364`, -0.009236736723871349}, {
                0.1286163345626579, -0.013156835199431957`}, {
                0.1441546504487501, -0.016567997825113392`}, {
                0.1638878331768033, -0.02152770654922278}, {
                0.1896889017570678, -0.029060642909695757`}, {
                0.22468009568514696`, -0.04099714991306836}, {
                0.2493845115403785, -0.05090715420363528}, {
                0.2797984402881338, -0.06483660718537886}, {
                0.3179378327278156, -0.0851454467078164}, {
                0.36683398569475245`, -0.11604902056107308`}, {
                0.40000281760426865`, -0.14097737377022637`}, {
                0.4382995343597185, -0.1743727226645347}, {
                0.48235162211094706`, -0.2201817621741514}, {
                0.492097584831885, -0.23274625219539052`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19879184853364334`, 0.5225780233917279, -0.83301417405871], 
               
               ArrowBox[{{0.4994524436768313, -0.24222813235551255`}, {
                0.5321758952554445, -0.28441518894425566`}, {
                0.5555654396199475, -0.3223786672138853}, {
                0.5788275388737879, -0.3673862351934824}, {
                0.6008861581584191, -0.42086943568994856`}, {
                0.610962139344946, -0.4514572192869417}, {
                0.6200215537302081, -0.48480201455948224`}, {
                0.6358765484635156, -0.575183336864319}, {
                0.6376899618791011, -0.6843367455579087}, {
                0.6367909390206731, -0.6900804089020639}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2180221926925191, 0.5225436859020445, -0.7870546999304299], 
               
               ArrowBox[{{0.6349352420743282, -0.7019360568743734}, {
                0.6207246976922866, -0.7927241632083316}, {
                0.5783247585135298, -0.9122902429630021}, {
                0.5448204111229322, -0.9741415603292655}, {
                0.5019201899284167, -1.0354795507793784`}, {
                0.4486363558030333, -1.0946593154398723`}, {
                0.42104108351283076`, -1.1184234978737604`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23574672439928535`, 0.522512037174409, -0.7446940354679052], 
               
               
               ArrowBox[{{0.41194811643662055`, -1.1262540757420252`}, {
                0.3851304689374212, -1.1493485921112274`}, {
                0.2909945215690581, -1.2080126013830907`}, {
                0.18361967745390032`, -1.2509495098199863`}, {
                0.06719069060364116, -1.2742594943758858`}, {
                0.0337215462844477, -1.2778038991097194`}, \
{-5.031959999524015*^-6, -1.2795902545010076`}, {-0.031805635291137835`, \
-1.2773616962190522`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2420197654966373, 0.5225008361016572, -0.7297018092426497], 
               
               ArrowBox[{{-0.04377627688520255, -1.276522804195936}, \
{-0.044453843693940606`, -1.2764753209105573`}, {-0.08831374734916266, \
-1.2703323946627414`}, {-0.20408815189821788`, -1.2430729152686277`}, \
{-0.3097984362411443, -1.19660257342727}, {-0.4015077505962569, \
-1.1350974443339943`}, {-0.46231553638703504`, -1.0791703322026693`}, \
{-0.4672098690635816, -1.0733840482082457`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23312203382629307`, 0.5225167237928452, -0.7509669028429025], 
               
               ArrowBox[{{-0.4749595575565716, -1.0642220436098175`}, \
{-0.5129308075265036, -1.0193308499641287`}, {-0.5533335185335757, \
-0.9578552391033044}, {-0.5845717411812091, -0.8962654007908357}, \
{-0.6233039367696271, -0.7780281415897067}, {-0.6377346251098269, \
-0.6714715456949067}, {-0.6373978887915229, -0.6248409149501865}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21425702152156229`, 0.5225504089500134, -0.7960532537571573], 
               
               ArrowBox[{{-0.6373112347961005, -0.6128412278257204}, \
{-0.6372191323408988, -0.6000870479355714}, {-0.6299653136517239, \
-0.536643706987987}, {-0.6034587788592485, -0.43201046745936666`}, \
{-0.5695555917450469, -0.3516802959981095}, {-0.5339716518470992, \
-0.28982355123771025`}, {-0.48040684144510387`, -0.21937521303924237`}, \
{-0.446743728236528, -0.18460253090288273`}}]}}, {
              Arrowheads[{{0.00030504716357268087`, 1.}}], {
               LABColor[
               0.1959690301393466, 0.522583063785009, -0.8397605561249735], 
               
               ArrowBox[{{-0.4383971180987658, -0.17598080838309557`}, \
{-0.4333048986028232, -0.17072074438355203`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2453866435996026, 0.522494824241382, -0.7216551541340418], 
               
               ArrowBox[{{1.0739065314687701`, 0.7623167395489321}, {
                1.100298854725323, 0.8463770422807922}, {1.1259142056056661`, 
                0.9741766298383042}, {1.1336726319949164`, 
                1.046142836493743}, {1.1368740997582074`, 
                1.123795612298373}, {1.1342971921026854`, 
                1.2071072648323942`}, {1.13128908512367, 
                1.2350448186821683`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.2813214529100223, 0.5224306594436138, -0.6357729189976181], 
               
               ArrowBox[{{1.130004440043584, 1.2469758574893388`}, {
                1.1247204922354974`, 1.296050101676007}, {1.1152439236829135`,
                 1.3625471506385063`}, {1.1012522324919995`, 
                1.4318622765266973`}, {1.0824238728585311`, 
                1.4898302454130534`}, {1.059489725226165, 
                1.5488179009154635`}, {1.0343240055181298`, 
                1.6081149043245504`}, {1.0046951416587557`, 
                1.6680306035469914`}, {0.9862027610667554, 
                1.7003826459056042`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3158395745670506, 0.522369024267639, -0.5532764901169732], 
               
               ArrowBox[{{0.9802477588751186, 1.7108008006797282`}, {
                0.9703285407864235, 1.7281542702437604`}, {0.9309496100395127,
                 1.7880751760758307`}, {0.8863712099575558, 
                1.847254571649292}, {0.8364062010800849, 
                1.9051537075702343`}, {0.78015598512297, 
                1.9623618302091719`}, {0.7184659402938358, 
                2.016974305440455}, {0.658713540301574, 
                2.062501974447012}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3425234871876353, 0.5223213777686085, -0.4895033937233229], 
               
               ArrowBox[{{0.6490515256941259, 2.069608082114734}, {
                0.5784181892456384, 2.1152056986708634`}, {0.5004722476700351,
                 2.157343757145085}, {0.41824477909812885`, 
                2.1939944194359535`}, {0.3321508987196477, 
                2.2244609872023364`}, {0.2426057217243194, 
                2.2480467621031006`}, {0.2097516819572639, 
                2.2538911882684696`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3563197043474681, 0.5222967433959482, -0.4565311868617615], 
               
               ArrowBox[{{0.1979371617235667, 2.255992880835797}, {
                0.15048841043383968`, 2.2644335695766027`}, {
                0.05694329695959964, 
                2.273519534363765}, {-0.03721674882412931, 
                2.274932407077304}, {-0.1311788570430752, 
                2.268299938329934}, {-0.22402997930376817`, 
                2.25390819178518}, {-0.27803193466211384`, 
                2.241123811024071}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.3553165111346665, 0.5222985346866456, -0.4589287639476682], 
               
               ArrowBox[{{-0.28970916749010456`, 
                2.2383593520388634`}, {-0.3147998223446249, 
                2.2324194099927426`}, {-0.4025896489892032, 
                2.2040256118946018`}, {-0.4865007220610614, 
                2.168918816432737}, {-0.5458091082228598, 
                2.1389191284724656`}, {-0.602524125511144, 
                2.1060222714970678`}, {-0.6564120853395574, 
                2.0705084639081717`}, {-0.7072392991217425, 
                2.0326579241074056`}, {-0.7155275801103093, 
                2.025350236296491}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3390415169529357, 0.5223275951361201, -0.49782511275211394`], 
               
               ArrowBox[{{-0.7245285976867317, 
                2.0174141363356197`}, {-0.7995926757139338, 
                1.951230949641826}, {-0.8793466296207303, 
                1.8643099516434543`}, {-0.9465321763861688, 
                1.774134324273024}, {-1.00185694352128, 
                1.6826959663914058`}, {-1.0204859501750718`, 
                1.6443464977831053`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3104426116014994, 0.5223786610249752, -0.5661749373697778], 
               
               ArrowBox[{{-1.0257292809515923`, 
                1.6335526346022051`}, {-1.0460647393346538`, 
                1.5916902831956212`}, {-1.0802738589159362`, 
                1.5023924385689158`}, {-1.100425854980166, 
                1.4355197678830625`}, {-1.1158096095378809`, 
                1.3704086440381122`}, {-1.1269043952413735`, 
                1.3074670944626579`}, {-1.134189484742937, 
                1.2471031465852922`}, {-1.1374415080401288`, 
                1.1707995442160162`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2750073338348859, 0.5224419338647479, -0.6508633193502646], 
               
               ArrowBox[{{-1.1379524784825321`, 
                1.1588104279346971`}, {-1.1390060956558754`, 
                1.1340889611747107`}, {-1.1336104833078946`, 
                1.031327898306134}, {-1.1207598315285718`, 
                0.9388039578558691}, {-1.1024966818990765`, 
                0.855697726844518}, {-1.0805898609289928`, 
                0.7813437780886779}, {-1.0561771589321156`, 
                0.7148289637730894}, {-1.045693728493786, 
                0.6916003426919237}}]}}, {
              Arrowheads[{{0.00856436013426729, 1.}}], {
               LABColor[
               0.2392921419647314, 0.5225057065160457, -0.7362206807776898], 
               
               ArrowBox[{{-1.0407573922844138`, 
                0.6806626745296488}, {-1.018768668668407, 
                0.6319412438930486}, {-0.9801592744811157, 
                0.5612499703265835}, {-0.9419008154916719, 
                0.5007955303921374}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21162741853482056`, 0.5225551043400013, -0.8023378615331976], 
               
               ArrowBox[{{0.7547226489188319, -0.365228114433408}, {
                0.821054082979872, -0.4596585883714165}, {
                0.8552956424585887, -0.5195691132972001}, {
                0.8887748251007932, -0.5902809415937593}, {
                0.9274001712484827, -0.6995881036174416}, {
                0.9435025663953418, -0.7635722641152646}, {
                0.9496792676292225, -0.7984782457832188}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23978216005992223`, 0.5225048315451586, -0.735049564245284], 
               
               
               ArrowBox[{{0.9517702140710611, -0.8102946726110446}, {
                0.9560559329585576, -0.834514271270015}, {
                0.963709040241644, -0.9130594265484687}, {
                0.9646455933281795, -0.999417442553445}, {
                0.9569574880885614, -1.0939744776093319`}, {
                0.9379901103796766, -1.1958926208694665`}, {
                0.9125230084050382, -1.2816671070791923`}, {
                0.9117305693058202, -1.2836242143774867`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.27044640116632773`, 0.5224500778156392, -0.6617636997724569], 
               
               ArrowBox[{{0.9072269054327541, -1.294747029296312}, {
                0.876587445362975, -1.3704180947164037`}, {
                0.8287441961608729, -1.4606912844400222`}, {
                0.8016725855116406, -1.5059953482621182`}, {
                0.7712614249173662, -1.5511790552244749`}, {
                0.7353851282461528, -1.593258515376176}, {
                0.6961309191067423, -1.6341121847388134`}, {
                0.6394731522808729, -1.6862541401387592`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2956435032700862, 0.5224050861490112, -0.6015439994551942], 
               
               ArrowBox[{{0.6306432855899033, -1.6943802372474397`}, {
                0.6109214275252953, -1.712530197989262}, {
                0.5126108552691699, -1.782905674825808}, {
                0.4022226929518466, -1.842317627097894}, {
                0.2817617814131745, -1.888491228938789}, {
                0.21852314830169278`, -1.9057846275524637`}, {
                0.2063950748471396, -1.9081961312222369`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.30928907466557903`, 0.5223807207677604, -0.568931827757409], 
               
               
               ArrowBox[{{0.19462548065779203`, -1.9105363561298208`}, {
                0.1537079650389962, -1.9186722516982702`}, {
                0.08776888087068668, -1.9270603940032798`}, {
                0.021233386864046275`, -1.9310347312800409`}, \
{-0.04546457819074324, -1.9304567101092562`}, {-0.11189107550350001`, \
-1.925187777071627}, {-0.17759605536275674`, -1.9153625895506996`}, \
{-0.24212026181631147`, -1.9012719253887878`}, {-0.2799011159480361, \
-1.8903030043994615`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.30790908922034566`, 0.5223831848544973, -0.5722299177366429], 
               
               ArrowBox[{{-0.29142524731725156`, -1.886957201628068}, \
{-0.30501594671288046`, -1.8830114118547456`}, {-0.36583536190118, \
-1.860676676217427}, {-0.4801558965313428, -1.8052392875782295`}, \
{-0.5829028924635439, -1.7378692573617323`}, {-0.6586208382660337, \
-1.6744521590500019`}, {-0.6952025369645966, -1.6369730414170731`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.29165768069239095`, 0.5224122031896897, -0.6110698981144206], 
               
               ArrowBox[{{-0.7035843841032443, -1.6283855715601048`}, \
{-0.7249690142538778, -1.6064763355905962`}, {-0.7818923074401587, \
-1.5355477835163558`}, {-0.8297874480699976, -1.463137104282117}, \
{-0.8691054097087807, -1.3905162207340225`}, {-0.9005773308581799, \
-1.3186906795705176`}, {-0.9249054585773179, -1.2485181097002946`}, \
{-0.9342138026070008, -1.2133783430471081`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2646660638595192, 0.522460399121956, -0.6755783907998343], 
               
               ArrowBox[{{-0.9372865620083749, -1.2017784228033621`}, \
{-0.9429032309509101, -1.1805750341684438`}, {-0.9615483500680299, \
-1.0659343680790045`}, {-0.966407027139277, -0.9611351362778875}, \
{-0.9609960789729848, -0.8669808786709792}, {-0.9482210990423732, \
-0.7828114743617489}, {-0.9349139963373009, -0.7268071563899797}}]}}, {
              Arrowheads[{{0.011280275548214464`, 1.}}], {
               LABColor[
               0.23382073478907242`, 0.5225154762001394, -0.7492970456340577], 
               
               ArrowBox[{{-0.9321399279446648, -0.7151322026618925}, \
{-0.9304790378067629, -0.7081421747451632}, {-0.9093525910440188, \
-0.6419317731064766}, {-0.8619091882304717, -0.5314345038751105}, \
{-0.8260562974077889, -0.4669391124507056}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.1917726280360592, 0.5225905568341577, -0.8497897283698645], 
               
               ArrowBox[{{0.22640636565737426`, -0.20906668204547066`}, {
                0.2252850054866784, -0.2574308873713994}, {
                0.20982422691561192`, -0.31520911262896056`}, {
                0.19320936201592095`, -0.3471279162404951}, {
                0.16949728542361894`, -0.3785654884295938}, {
                0.13816295614640065`, -0.4074264419553009}, {
                0.11964570104312505`, -0.4201977697083082}, {
                0.09937036899393847, -0.43135993481200097`}, {
                0.0409154220554502, -0.4503558664558748}, \
{-0.021994150429239447`, -0.4530202700673895}, {-0.08361717625363763, \
-0.43830600283748705`}, {-0.08942788542553813, -0.4360053287959121}, \
{-0.09514389927904368, -0.43355767849558713`}, {-0.10199177229269775`, \
-0.42950445768273576`}}]}}, {
              Arrowheads[{{0.018310460620696353`, 1.}}], {
               LABColor[
               0.19494028510074524`, 0.5225849007007635, -0.842219200681492], 
               
               
               ArrowBox[{{-0.11231842940306228`, -0.42339216245713046`}, \
{-0.11521630960787682`, -0.4216769220699497}, {-0.1333879765109445, \
-0.4083652176947566}, {-0.16581596372348126`, -0.37967875664944367`}, \
{-0.19045491122854977`, -0.3481124913890025}, {-0.20776366239873245`, \
-0.31588679813937237`}, {-0.22374405225323077`, -0.2589124348774606}, \
{-0.22547616841157084`, -0.2109167692827367}, {-0.21933640851772193`, \
-0.17234146410400092`}, {-0.20952614493615557`, -0.1419189328324876}, \
{-0.1903911908060499, -0.10505488813406155`}, {-0.17199690326492448`, \
-0.08010482607717098}, {-0.1556169999454998, -0.06266523684473571}, \
{-0.14140018096644966`, -0.050128327963457425`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.20562151324339742`, 0.5225658284180147, -0.8166916477461533], 
               
               ArrowBox[{{0.6493015977751606, 0.31143107447263}, {
                0.6943700159896065, 0.37301967657706236`}, {
                0.7410102358423382, 0.45236345704927394`}, {
                0.7787890631116461, 0.536871116544898}, {0.8114116040952429, 
                0.6422561047166048}, {0.8237777439217977, 
                0.7043168733579882}, {0.8290570319687623, 
                0.7494882623761753}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23021936823212655`, 0.5225219067604027, -0.7579041153636972], 
               
               ArrowBox[{{0.8304500193611044, 0.761407137580018}, {
                0.8318421250740188, 0.7733184688339835}, {0.8343535812198419, 
                0.8500510080008051}, {0.8289585324645086, 
                0.9341782777123793}, {0.8030836592313302, 
                1.0603373574882506`}, {0.780680742601831, 
                1.1272963395962192`}, {0.7507716723263314, 
                1.1960447732017108`}, {0.7350686580067526, 
                1.2245778439614603`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.256002224174133, 0.5224758691782043, -0.6962844953075006], 
               
               ArrowBox[{{0.7292828537972147, 1.2350909058203525`}, {
                0.7125547028835445, 1.2654866950609194`}, {0.6652280887521839,
                 1.3345261419300387`}, {0.6335264323290016, 
                1.3765890725389152`}, {0.5981498619602212, 
                1.4179115416429227`}, {0.5606187576505959, 
                1.4519646173705607`}, {0.5201890567614953, 
                1.4842630869841453`}, {0.4337979247360514, 
                1.5445848449674626`}, {0.3923567457469394, 
                1.5662054102119642`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2743151173086047, 0.5224431698789156, -0.6525176791094012], 
               
               ArrowBox[{{0.3817176307905515, 1.5717560167504214`}, {
                0.33699942633621416`, 1.5950862617049864`}, {
                0.23148844983316094`, 1.6333734335440828`}, {
                0.12093661510517531`, 1.6577184417152862`}, {
                0.007019013183380671, 
                1.666950107860703}, {-0.08265733657088263, 
                1.6617478797181588`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.27922654790870793`, 0.5224344000827971, -0.6407796277394725], 
               
               ArrowBox[{{-0.0946371956309027, 
                1.6610529143218584`}, {-0.10716382690892096`, 
                1.660326230040614}, {-0.21845743379233468`, 
                1.6385095018902107`}, {-0.3240435839624277, 
                1.6024583836703898`}, {-0.42141333061168285`, 
                1.5541295500552081`}, {-0.5087331147888842, 
                1.4955971006822975`}, {-0.530385395252028, 
                1.4768465587962114`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.2688511420944785, 0.5224529262925811, -0.665576281982886], 
               
               ArrowBox[{{-0.5394567256825407, 
                1.468990926153295}, {-0.5849994037475744, 
                1.4295516673594455`}, {-0.6407053518841901, 
                1.3697130197564207`}, {-0.6882345498063757, 
                1.3076431880923063`}, {-0.7280020655075278, 
                1.2444864271195084`}, {-0.7604229669810431, 
                1.181386991590433}, {-0.7861265764242804, 
                1.1191104970748729`}, {-0.8005430467207604, 
                1.0745080333298367`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24680551810817894`, 0.522492290714764, -0.7182641214135955], 
               
               
               ArrowBox[{{-0.804233706147336, 
                1.063089669480448}, {-0.805742216034599, 
                1.0584225591426213`}, {-0.8247498148057375, 
                0.9700899617056936}, {-0.8337049068184229, 
                0.8877238821645993}, {-0.8349208249805926, 
                0.8123541040378928}, {-0.8300177623544618, 
                0.743549810418064}, {-0.8078484581119372, 
                0.6248119915744416}, {-0.7964175028095747, 
                0.5898943013227972}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.22023363241132296`, 0.5225397371797594, -0.7817694795670851], 
               
               ArrowBox[{{-0.7926840465233082, 
                0.5784898590234764}, {-0.7761977956348729, 
                0.5281299558739729}, {-0.7477685412858721, 
                0.4646362266645253}, {-0.718358386985568, 
                0.41081932704206814`}, {-0.660865631331019, 
                0.3260225830789534}, {-0.6077310207509456, 
                0.26355972624763735`}, {-0.5600704764214941, 
                0.21665586159203234`}, {-0.5253604850187327, 
                0.18834844450293348`}}]}}, {
              Arrowheads[{{0.0011503656390832822`, 1.}}], {
               LABColor[
               0.198492146519322, 0.5225785585363274, -0.833730445533604], 
               
               ArrowBox[{{-0.5160609725440289, 
                0.18076431187402792`}, {-0.494665293321778, 
                0.1633152607169412}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6960491019067997, 0.420344176802164, 0.7608930419384528], 
               
               ArrowBox[{{-2.5290377591312, -2.935083973348704}, \
{-2.539774955456813, -2.8549790011008693`}, {-2.547832725743023, \
-2.7769156948363487`}, {-2.5533764840438242`, -2.7008678073045487`}, \
{-2.556571644413213, -2.6268090912548776`}, {-2.5575836209051865`, \
-2.554713299436743}, {-2.556577827573739, -2.484554184599551}, \
{-2.5554039964565125`, -2.456524705569297}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6236062589892427, 0.5366334014198552, 0.6392241566743557], 
               
               ArrowBox[{{-2.554901895165468, -2.444535214575367}, \
{-2.5537196784728673`, -2.41630549949271}, {-2.549174587656567, \
-2.3499409968656257`}, {-2.536989393412382, -2.2313448951035695`}, \
{-2.5203061935497915`, -2.1193536620851914`}, {-2.499829937988806, \
-2.0137247491047803`}, {-2.4894183237698972`, -1.9697578968241567`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5315476709821573, 0.5306347024831366, 0.2291008517447702], 
               
               ArrowBox[{{-2.4866531264257263`, -1.9580808388193427`}, \
{-2.4762655766494355`, -1.9142156074566237`}, {-2.4501432194774853`, \
-1.8205359787570676`}, {-2.4219929764187604`, -1.7323956046224582`}, \
{-2.392828790416648, -1.6470248577703217`}, {-2.3621604860861365`, \
-1.566839835464169}, {-2.33328793884474, -1.5040863370237987`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.44371959114657294`, 
                0.5249116708732753, -0.16217543379870275`], 
               
               ArrowBox[{{-2.328272220176264, -1.4931848432619923`}, \
{-2.3270238085833563`, -1.4904714631679714`}, {-2.2914027010837956`, \
-1.4188830020869918`}, {-2.2556671052629715`, -1.3494975211065325`}, \
{-2.2197025327996207`, -1.2845180003271144`}, {-2.1836916142759857`, \
-1.2236441343332227`}, {-2.1478169802743086`, -1.1665756177093425`}, \
{-2.087699150144111, -1.0785436787297473`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.36765508956011284`, 
                0.5222765030575758, -0.42944023419286786`], 
               
               ArrowBox[{{-2.080931728828195, -1.0686339860638325`}, \
{-2.076954211373613, -1.0628096146070825`}, {-2.0329265614668897`, \
-1.0038450903952725`}, {-1.989652082158153, -0.9494997497330966}, \
{-1.947342869638993, -0.8992109580162727}, {-1.9062110201009987`, \
-0.8524160806405179}, {-1.827398221968969, -0.7684067151301249}, \
{-1.7654425485860663`, -0.7077919904995282}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3055656238224484, 0.5223873693203737, -0.5778306722751657], 
               
               ArrowBox[{{-1.756864949559315, -0.6994000422789852}, \
{-1.7530513117629845`, -0.6956689456377338}, {-1.6831907912966222`, \
-0.6322790443331449}, {-1.6175552538131661`, -0.5768668554376611}, \
{-1.5559675988205102`, -0.5281386886761441}, {-1.4981940778060114`, \
-0.48515410530276515`}, {-1.4146694329193852`, -0.4274337669912366}, \
{-1.3789367461146338`, -0.4046816469523757}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2551866765458551, 0.5224773254110228, -0.6982336096765704], 
               
               ArrowBox[{{-1.368814494256356, -0.39823649239118847`}, \
{-1.3390206875418749`, -0.3792658431789844}, {-1.2703768985764756`, \
-0.3384913689360254}, {-1.2078969556097223`, -0.30386842485521515`}, \
{-1.0986316884508962`, -0.24855302443879576`}, {-1.0065500349906635`, \
-0.2068946636545321}, {-0.9416281343502171, -0.1810658827989631}}]}}, {
              Arrowheads[{{0.006169018560056813, 1.}}], {
               LABColor[
               0.21813510400509606`, 0.5225434842888546, -0.7867848480491375], 
               
               ArrowBox[{{-0.9304781434322684, -0.17662992714886216`}, \
{-0.8865799127760919, -0.1591652847342003}, {-0.7913819778188989, \
-0.12599380785920444`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2144856575582816, 0.5225500007000369, -0.7955068260943147], 
               
               ArrowBox[{{0.8739488757900894, 0.16015874124671012`}, {
                0.947044538974228, 0.18919291219494694`}, {1.032758348035802, 
                0.2267958663215459}, {1.1343828158825295`, 
                0.27648668484502525`}, {1.1923746104474493`, 
                0.30718012997394123`}, {1.2560923479505743`, 
                0.3432528807428835}, {1.3034463522882866`, 
                0.3727573907922209}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2498853801888506, 0.5224867913471216, -0.7109034189505579], 
               
               ArrowBox[{{1.3136311903102682`, 0.3791031826629016}, {
                1.349286753886417, 0.4013188315517426}, {1.4554145083455237`, 
                0.47491679208294013`}, {1.5139576788164246`, 
                0.5192990419170009}, {1.5764937665999406`, 
                0.5698977738759685}, {1.6219700265826942`, 
                0.6077452229966447}, {1.669567722825208, 
                0.6492718297836969}, {1.6930951877000984`, 
                0.6718387013850872}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2985083423043224, 0.5223999707241406, -0.5946971903503817], 
               
               ArrowBox[{{1.7017554196607751`, 0.6801453482649823}, {
                1.7093665611924673`, 0.6874457376014048}, {
                1.7505265964000873`, 0.7288955002756434}, {
                1.8355255364752268`, 0.8192043162775485}, {
                1.8799857598475567`, 0.8703336323341413}, {1.925688620229508, 
                0.9260034738485867}, {1.972509083086933, 
                0.9867409340608699}, {2.0137617899965687`, 
                1.0439718104699711`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3585235894113747, 0.5222928081631714, -0.45126402171175206`], 
               
               ArrowBox[{{2.0207571832829267`, 1.05372140761213}, {
                2.0701462153080388`, 1.1273165142006085`}, {
                2.1203346267550356`, 1.2088382535504898`}, {2.170571034498786,
                 1.2984824404480664`}, {2.220539124811398, 
                1.3970931910807833`}, {2.2542193123509233`, 
                1.4722161207469193`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.43097108203840345`, 
                0.524080955676709, -0.21897035974265683`], 
               
               ArrowBox[{{2.2591285161882255`, 1.4831659936997814`}, {
                2.269236786102063, 1.505712271059205}, {2.315270022286872, 
                1.6254943885213917`}, {2.3370049370684756`, 
                1.6898883144272376`}, {2.357734692898289, 
                1.7574530734460332`}, {2.37734627221787, 1.828315356825115}, {
                2.3957266574687783`, 1.9026018558118196`}, {
                2.4037394262823897`, 1.9400331261078954`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5161943279681888, 0.5296342517440281, 0.1607013258024251], 
               
               ArrowBox[{{2.406251312267662, 1.951767282609195}, {
                2.4123835668110445`, 1.9804138194901515`}, {2.426708021702693,
                 2.061844668586167}, {2.4384119595322713`, 
                2.1470093518102815`}, {2.4472073176883242`, 
                2.2360228178729082`}, {2.4528060335593986`, 
                2.3290000154844614`}, {2.4549200445340396`, 
                2.4260558933553544`}, {2.4548809485691416`, 
                2.428442287673044}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.6042638353539175, 0.5353730151961836, 0.5530531771014648], 
               
               ArrowBox[{{2.454684380622148, 2.4404406776084566`}, {
                2.453261288000795, 2.5273054001960036`}, {2.44754170134821, 
                2.63286348471682}, {2.4402562508863253`, 
                2.7136805681043663`}, {2.429865192852101, 
                2.7964660084253428`}, {2.4161309812316465`, 
                2.881165423963859}, {2.408868495721009, 
                2.9174713305296596`}}]}}, {
              Arrowheads[{{0.0016353610037268922`, 1.}}], {
               LABColor[
               0.678923123677638, 0.45939679772421876`, 0.7513391739088416], 
               
               ArrowBox[{{2.4065146956627532`, 2.9292382173433307`}, {
                2.398816070011071, 2.967724433004024}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.4911287830670999, 0.5280009369083187, 0.049033698292167444`], 
               
               ArrowBox[{{-2.986084185654346, 
                0.12248840061291634`}, {-2.861178377416774, 
                0.11241126833867117`}, {-2.746265621089617, 
                0.10352110812946312`}, {-2.640283253163973, 
                0.09565534330694864}, {-2.5421686101309438`, 
                0.0886513971927843}, {-2.5074589959722386`, 
                0.08622895422332796}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.39255997668976694`, 0.5222320331667712, -0.3699189117325634], 
               
               ArrowBox[{{-2.495488114927197, 
                0.08539348608780893}, {-2.4479878295442212`, 
                0.08207836043279498}, {-2.3606446214521113`, 
                0.07621756183113279}, {-2.273740484009048, 
                0.07079641471048914}, {-2.1929043191076616`, 
                0.06592811832995137}, {-2.114761017974468, 
                0.06129610608865454}, {-2.04200344437766, 
                0.057136662125839614`}, {-2.016410339253665, 
                0.055724623394320334`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3201875935687161, 0.5223612604930348, -0.5428849617508994], 
               
               ArrowBox[{{-2.004428561771686, 
                0.055063557306597434`}, {-1.9741198072991712`, 
                0.053391343833009405`}, {-1.9105983157209363`, 
                0.05000170860166672}, {-1.7951030044287821`, 
                0.04412651972709998}, {-1.6837166217775712`, 
                0.03885397638994478}, {-1.5854469969447071`, 
                0.03448959374525292}, {-1.5249899205674669`, 
                0.03193462664369953}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2635970904222678, 0.5224623078690938, -0.6781331790359304], 
               
               ArrowBox[{{-1.5130006221089014`, 
                0.03142794876630434}, {-1.4975871737821949`, 
                0.030776563423908682`}, {-1.418949515790094, 
                0.027631196593290018`}, {-1.348072362833887, 
                0.02493460669005839}, {-1.2839796909685055`, 
                0.022619269188405566`}, {-1.1724917050721144`, 
                0.018864107428067645`}, {-1.0841892098471158`, 
                0.016145539311742344`}, {-1.033296105783868, 
                0.014693875605144006`}}]}}, {
              Arrowheads[{{0.01721493190386387, 1.}}], {
               LABColor[
               0.2228495576657862, 0.5225350662125788, -0.7755175608254995], 
               
               ArrowBox[{{-1.0213009844432615`, 
                0.014351729402295742`}, {-1.0083273205756043`, 
                0.013981671467631768`}, {-0.8841174049014456, 
                0.010745732194883359`}, {-0.7870976075810431, 
                0.008513612785896085}, {-0.7092865121741697, 
                0.006914849670379832}, {-0.6082484888346491, 
                0.005096968117128946}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.007499518486010732, 1.}}], {
               LABColor[
               0.18935873567600972`, 0.5225948670536381, -0.8555587995083518], 
               
               ArrowBox[{{0.10962804696688558`, -0.09461921961407702}, {
                0.1093443485828981, -0.12414756298651619`}, {
                0.10450830181379198`, -0.1446285677299325}, {
                0.09415846251701576, -0.16659217127100945`}, {
                0.07689837354652944, -0.18808886256802065`}, {
                0.06543459799357795, -0.19786819467008115`}, {
                0.05211153544487122, -0.2063244294379315}, {
                0.03224319378901741, -0.21459389668613357`}, {
                0.010507636259740142`, -0.2189102865646259}, {
                0.0074825603444913505`, -0.21918026140285882`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3029702731716024, 0.5223920035497698, -0.5840334188358047], 
               
               ArrowBox[{{1.2343463757932864`, 1.4041469787527792`}, {
                1.2150893741596003`, 1.5146164306565761`}, {
                1.1882936614264512`, 1.61536172399905}, {1.1505788493683085`, 
                1.7198168717231568`}, {1.1003082787967213`, 
                1.826819046803449}, {1.0827438665228846`, 
                1.8563257295064717`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.34068594450107137`, 
                0.5223246588644913, -0.49389502056395673`], 
               
               ArrowBox[{{1.0766058252238515`, 1.8666371042456307`}, {
                1.036188070126562, 1.9345354122921026`}, {0.998517629553541, 
                1.9879504585516081`}, {0.9568847131147045, 
                2.040690902947656}, {0.9113138371603229, 2.092358471510693}, {
                0.8618295180406654, 2.1425548902711653`}, {0.808186035635461, 
                2.190959691051237}, {0.7638243906877643, 
                2.226421951245099}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.37049070635926634`, 0.5222714398116046, -0.4226632646367478], 
               
               ArrowBox[{{0.7544511770189487, 2.2339148055422764`}, {
                0.750353859000871, 2.237190161039697}, {0.6886817882518155, 
                2.280754659316933}, {0.6235186235032137, 2.321161544963331}, {
                0.5449153739831665, 2.3628678935987377`}, {
                0.46214788799539286`, 2.3993952358264394`}, {
                0.37576350890142235`, 2.430227271087521}, {
                0.32620678338459097`, 2.4438667813386403`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.38777535979188377`, 
                0.5222405765257466, -0.38135388526789155`], 
               
               ArrowBox[{{0.31463700003152223`, 2.44705113577291}, {
                0.28630958006278423`, 2.4548476988230683`}, {
                0.19449213096003207`, 2.4729053882465073`}, {
                0.10101719107371934`, 2.484049208571264}, {
                0.057144575296238696`, 2.487625354987554}, {
                0.0130957464028748, 
                2.4896521305964945`}, {-0.03216205595756948, 
                2.4884798925995795`}, {-0.07728137843099962, 
                2.485669412376642}, {-0.16117913537428546`, 
                2.477314232250512}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.39012404673140044`, 0.5222363827363433, -0.3757406515295694], 
               
               ArrowBox[{{-0.17308925192099442`, 
                2.475901045199758}, {-0.26152144813683265`, 
                2.460343240250137}, {-0.3508002570086462, 
                2.437740108412025}, {-0.43724951540861595`, 
                2.408929045818697}, {-0.5203128970875622, 
                2.374391938793356}, {-0.5994340757963055, 
                2.3346106736592067`}, {-0.6239564277143681, 
                2.3201397446912724`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.37697469847899157`, 0.5222598620670422, -0.4071668769687746], 
               
               ArrowBox[{{-0.6342911531443396, 
                2.314041101375985}, {-0.6661328601366094, 
                2.295250934688771}, {-0.7293854256112294, 
                2.2525698993401377`}, {-0.7888155150807109, 
                2.2070531992856766`}, {-0.8440468714055981, 
                2.1591864661977547`}, {-0.89509418662362, 
                2.109364376980953}, {-0.9421955523023237, 
                2.0579296343868294`}, {-0.9853098105969835, 
                2.005289908858221}, {-0.9910132080084583, 
                1.997492418237787}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.35054078556321955`, 0.5223070621693667, -0.4703424876975562], 
               
               ArrowBox[{{-0.9980976422471352, 
                1.9878068211205275`}, {-1.0243958036628726`, 
                1.9518528708379623`}, {-1.0911306986586657`, 
                1.8437823965235811`}, {-1.1436956463903563`, 
                1.7361092898458559`}, {-1.1833644634248441`, 
                1.6307618408807594`}, {-1.2038266613925368`, 
                1.557513937201724}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3145444331052964, 0.5223713368578982, -0.5563718076012669], 
               
               ArrowBox[{{-1.2070553116488831`, 
                1.5459564367140668`}, {-1.2117955417598931`, 
                1.5289879800929391`}, {-1.2320088401362554`, 
                1.421296648958232}, {-1.2422275576994817`, 
                1.3199715613285117`}, {-1.2442726596607896`, 
                1.2255308932609008`}, {-1.2397454036886864`, 
                1.1379249792954012`}, {-1.23156137649213, 
                1.0696282894938338`}}]}}, {
              Arrowheads[{{0.0031784541641414446`, 1.}}], {
               LABColor[
               0.2747413956259851, 0.5224424087210703, -0.6514988971709589], 
               
               ArrowBox[{{-1.2301336246259182`, 
                1.0577135287069557`}, {-1.2300595501549534`, 
                1.0570953683509106`}, {-1.2163315083632908`, 
                0.9826909029666622}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.20242697141405072`, 0.5225715325565471, -0.8243264285563452], 
               
               ArrowBox[{{0.647905874954424, -0.029739690054583556`}, {
                0.6820610455065257, -0.03298504772701796}, {
                0.7208142477146376, -0.03684811565513316}, {
                0.7642485968796815, -0.04144139615051655}, {
                0.8550545733317428, -0.05192211207114967}, {
                0.9701532241745332, -0.06691494272058116}, {
                1.0398763511048525`, -0.0768544287719819}, {
                1.1204085626732843`, -0.08922267642404491}, {
                1.1240428142573926`, -0.08983126622442572}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2311857098788091, 0.522520181271454, -0.7555946115117192], 
               
               ArrowBox[{{1.1358780162803799`, -0.09181318274009356}, {
                1.2200926289346004`, -0.10591571612784562`}, {
                1.3390851197761586`, -0.12778595268162468`}, {
                1.407595139125354, -0.14131494201359637`}, {
                1.4834150913328736`, -0.1571028422452815}, {
                1.5674547612702072`, -0.17549106801686273`}, {
                1.606727087884891, -0.18462248427430183`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.27554436301747876`, 0.5224409749513834, -0.6495798488819465], 
               
               ArrowBox[{{1.61841529470687, -0.18734017102715705`}, {
                1.661520405497037, -0.19736276819360235`}, {
                1.7546094178062626`, -0.220496410624523}, {
                1.8585601736039792`, -0.2479309246922022}, {
                1.975366247877381, -0.280813688254589}, {
                2.037260937127942, -0.29878255568826634`}, {
                2.081818076160434, -0.3121459913395705}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3352504483235262, 0.5223343644263043, -0.5068855600926502], 
               
               ArrowBox[{{2.093312254677984, -0.31559328886178956`}, {
                2.1030089526627664`, -0.31850149173036424`}, {
                2.167592296085512, -0.33921601958656084`}, {
                2.23620716445703, -0.3620219355504789}, {
                2.307065722000644, -0.3860506916215256}, {
                2.3824116578884498`, -0.4125251279068295}, {
                2.4626902707825384`, -0.44181224130824803`}, {
                2.546482279659515, -0.473572289020966}}]}}, {
              Arrowheads[{{0.016880532256026117`, 1.}}], {
               LABColor[
               0.41110600893086996`, 
                0.5227865126974311, -0.30746975574580204`], 
               
               ArrowBox[{{2.557653712931589, -0.47795353527820605`}, {
                2.639949058654471, -0.5104451592332393}, {
                2.7380645037895803`, -0.550830301893289}, {
                2.831380438884716, -0.5907771782469422}, {
                2.930945544715785, -0.6352521199468335}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.22023979779707026`, 0.5225397261709148, -0.7817547446312773], 
               
               ArrowBox[{{0.9555056077093635, -0.22880764858574645`}, {
                1.0128264056343177`, -0.25886736459858983`}, {
                1.0768396723613984`, -0.29518154845807426`}, {
                1.1736598823798041`, -0.35609995800628225`}, {
                1.228008540944867, -0.3935915916498503}, {
                1.2868100667660334`, -0.4371283307801386}, {
                1.3504995426043798`, -0.48786520744199685`}, {
                1.355540502442855, -0.4922327301978385}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.25777961780312014`, 0.5224726954838131, -0.692036621435233], 
               
               
               ArrowBox[{{1.3646099370171911`, -0.500090551556322}, {
                1.419408754812351, -0.5475686294189632}, {
                1.4940406279125742`, -0.6180900978253027}, {
                1.5743492172700473`, -0.7023336785912023}, {
                1.6272938050411079`, -0.7635034099037751}, {
                1.6822143843984543`, -0.8323562426248954}, {
                1.6936819427604728`, -0.8480671940236876}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3073644470273567, 0.5223841573615688, -0.5735315828847569], 
               
               ArrowBox[{{1.700756702785419, -0.8577598598380765}, {
                1.7388927535117178`, -0.9100075677274204}, {
                1.7968010427007841`, -0.9978897153365629}, {
                1.8554341808913368`, -1.0976108180563917`}, {
                1.9136221640979727`, -1.2110612818379733`}, {
                1.9414888039174316`, -1.2718653016933867`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3663787640450174, 0.5222787820502889, -0.43249058259046635`], 
               
               ArrowBox[{{1.9462120101057228`, -1.2828959266321933`}, {
                1.9704399293091068`, -1.340203687156306}, {
                1.9975909610327878`, -1.4113777237017233`}, {
                2.023142665743343, -1.4874208121325174`}, {
                2.0430480347166027`, -1.5554698760907466`}, {
                2.0614179392265264`, -1.6273151439900826`}, {
                2.0779114458703907`, -1.7031240016576068`}, {
                2.08472276948433, -1.7412641939494249`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.4355503531183369, 0.5243793490059226, -0.19856959290354081`], 
               
               ArrowBox[{{2.0868324297333305`, -1.7530772940350836`}, {
                2.09218762124547, -1.7830638349204009`}, {
                2.103807326492692, -1.8672676833802584`}, {
                2.1123314227529835`, -1.9558685866389727`}, {
                2.119307714519809, -2.0466680172971152`}, {
                2.1226135742011456`, -2.1419932875999517`}, {
                2.117679573798496, -2.2309341530997493`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.512763763143281, 0.5294107101276182, 0.14541807397090561`], 
               
               ArrowBox[{{2.1167930431334887`, -2.2428980109298515`}, {
                2.1068151763369163`, -2.3385043612149716`}, {
                2.09343568620549, -2.44046467029928}, {
                2.0742043271719286`, -2.5460169448496783`}, {
                2.048456726252896, -2.6548676984559605`}, {
                2.0309774822618767`, -2.7142439456578384`}}]}}, {
              Arrowheads[{{0.012103382298918539`, 1.}}], {
               LABColor[
               0.5880439461613949, 0.5343160987893689, 0.4807931663274883], 
               
               ArrowBox[{{2.027588695353155, -2.725755510420601}, {
                2.015528510465056, -2.7667234447079205`}, {
                1.9747272902971764`, -2.8810705302074173`}, {
                1.925360676238022, -2.9973953015563093`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6424597689717021, 0.5378619291730343, 0.7232170137333191], 
               
               ArrowBox[{{-2.0027610436485705`, 3.}, {-2.0474696717549694`, 
                2.884161211297447}, {-2.0852043049624434`, 
                2.7663630295513544`}, {-2.115005771888364, 
                2.651507442304621}, {-2.137576416074475, 
                2.540295204462501}}]}}, {
              Arrowheads[{{0.01999999999999999, 1.}}], {
               LABColor[
               0.566800512048879, 0.5329318393912866, 0.3861531376795554], 
               
               ArrowBox[{{-2.139364175138092, 
                2.5284294172068864`}, {-2.153749014687793, 
                2.432327498136638}, {-2.1640900150841644`, 
                2.3285177911696464`}, {-2.1715374105229928`, 
                2.2266777267378424`}, {-2.173971376855994, 
                2.1289597219294336`}, {-2.168938520899735, 
                2.050477284096002}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4883746827841932, 0.5278214749070395, 0.0367641128620036], 
               
               ArrowBox[{{-2.1681705723578295`, 
                2.0385018820135254`}, {-2.1678054524197305`, 
                2.032808195746199}, {-2.158130808965589, 
                1.9413875549293795`}, {-2.1469881882721533`, 
                1.8522509959840574`}, {-2.13290961310013, 
                1.7676826007817306`}, {-2.1163304708215676`, 
                1.6875237808741943`}, {-2.097686148808515, 
                1.6116159478132432`}, {-2.084921924318917, 
                1.5666094183715022`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.41044604900784515`, 
                0.522743508552199, -0.31040989365809746`], 
               
               ArrowBox[{{-2.0816477552412542`, 
                1.5550647305519518`}, {-2.0773107830445623`, 
                1.5397726094350368`}, {-2.0555385095133, 
                1.4718072735757335`}, {-2.0278906090185456`, 
                1.395832021250985}, {-1.998811890705378, 
                1.3248297448267419`}, {-1.9688607502714657`, 
                1.2584170500713026`}, {-1.9385955834144752`, 
                1.196210542752963}, {-1.8942655547889626`, 
                1.1143086500856672`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3452250365932791, 0.5223165539118914, -0.48304683792852454`], 
               
               ArrowBox[{{-1.8885534943316191`, 
                1.1037553394519535`}, {-1.8775429628718638`, 
                1.083412844899451}, {-1.8164936139587502`, 
                0.9844301602099377}, {-1.756540874117726, 
                0.897311770674186}, {-1.6981249381777372`, 
                0.82042789702733}, {-1.6417189812425568`, 
                0.752320855471289}, {-1.608450774653497, 
                0.7152243204147667}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28877373997150574`, 0.5224173527223207, -0.6179623592089271], 
               
               ArrowBox[{{-1.6004390003693714`, 
                0.7062905937108528}, {-1.5875025873839612`, 
                0.6918655270474537}, {-1.5059626362851493`, 
                0.6091016374275036}, {-1.430377402418825, 
                0.5398142895448763}, {-1.36070035575045, 
                0.48113853623594993`}, {-1.2963894112161887`, 
                0.43126336044159663`}, {-1.240091962564383, 
                0.39063480322022}}]}}, {
              Arrowheads[{{0.0175153894943256, 1.}}], {
               LABColor[
               0.24299280858571634`, 0.5224990986466872, -0.7273762893086974], 
               
               ArrowBox[{{-1.2302067465794255`, 
                0.38383409723048517`}, {-1.182285535819916, 
                0.3515772614673455}, {-1.084765120383516, 
                0.29163008979830674`}, {-1.0201116097267418`, 
                0.2557573674060337}, {-0.962258539773619, 
                0.2260666922654908}, {-0.8633003276189586, 
                0.17997667421912167`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.18910378323007282`, 0.5225953222939037, -0.8561681219544907], 
               
               ArrowBox[{{0.11454219304138324`, 0.014595871273826364`}, {
                0.1284089879018576, 0.018417172980246747`}, {
                0.1459757281831577, 0.023981207418505585`}, {
                0.16884930958117814`, 0.03244069459690424}, {
                0.19971129952954897`, 0.04588871188320695}, {
                0.221430493754326, 0.05714000521184958}, {
                0.24787010606499552`, 0.07295013923841501}, {
                0.28044065325914125`, 0.09596139457751282}, {
                0.3210026586612192, 0.13093123901374906`}, {
                0.3474285660881693, 0.15899549612574337`}, {
                0.37642804634340304`, 0.1961472583771514}, {
                0.40710561960508057`, 0.24627153479258032`}, {
                0.4369696746833782, 0.3148002606486365}, {
                0.44269298599936563`, 0.3352526011687295}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19911720881431152`, 0.5225774424320119, -0.8322365807261001], 
               
               ArrowBox[{{0.4459267929761868, 0.3468086598582942}, {
                0.44848271590167854`, 0.3559422895228636}, {
                0.4568077418113503, 0.40356454316264384`}, {
                0.46009214930654757`, 0.4582644433789299}, {
                0.4590091949887318, 0.4885228841408544}, {0.4556418976815564, 
                0.5206028236944055}, {0.44242186394400995`, 
                0.5846448172521683}, {0.4169701893974817, 
                0.6534603714208113}, {0.35764410062287494`, 
                0.7484803362733147}, {0.31808257987148036`, 
                0.7853160871000507}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21251362329819676`, 0.5225535219425846, -0.8002198804633712], 
               
               ArrowBox[{{0.3093001412389056, 0.7934934198965717}, {
                0.26473587878896127`, 0.8349872259031458}, {
                0.18738774396737987`, 0.878696069498144}, {
                0.09945996723165644, 0.90758988086596}, {0.005471831437604277,
                 0.9184014179398271}, {-0.01768214687326856, 
                0.9186802959956997}, {-0.040842803524839356`, 
                0.9177913624726718}, {-0.08612221499892991, 
                0.9090858635241422}, {-0.12958727217617683`, 
                0.8962017738715862}, {-0.1345120333814799, 
                0.8941698266907118}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21527710338813358`, 0.522548587503123, -0.7936153137094866], 
               
               
               ArrowBox[{{-0.14560491289128583`, 
                0.8895929255358989}, {-0.21904558027917426`, 
                0.8592914447453861}, {-0.2951275778323241, 
                0.8076445806162508}, {-0.35552033810508743`, 
                0.746640934940652}, {-0.41580635735533567`, 
                0.6500091182711694}, {-0.44708297534875896`, 
                0.5571557141397764}, {-0.44843872031442406`, 
                0.5463585611703473}}]}}, {
              Arrowheads[{{0.012218624430220803`, 1.}}], {
               LABColor[
               0.20468684078613208`, 0.5225674973588091, -0.8189254639619842], 
               
               ArrowBox[{{-0.44993376107122696`, 
                0.5344520565138372}, {-0.4575010961087384, 
                0.4741857999241646}, {-0.45442741227609956`, 
                0.40324850262355216`}, {-0.43444065402934834`, 
                0.3149102108321242}, {-0.4069487656042102, 
                0.2495219823682427}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.22167402054049512`, 0.5225371652386586, -0.7783270304663072], 
               
               ArrowBox[{{0.8112360589241068, -0.5926169143415073}, {
                0.8301592636050504, -0.6595870744003408}, {
                0.8469142896563792, -0.7618651527536177}, {
                0.8504598452135032, -0.8814635034194929}, {
                0.8450545334540391, -0.9478404365935503}, {
                0.8334646454485406, -1.0184384682915095`}, {
                0.824355190576052, -1.0635500056616811`}, {
                0.8236182079998523, -1.0664101972450122`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24869653026158614`, 0.5224889141443931, -0.7137447054622867], 
               
               ArrowBox[{{0.8206239815657284, -1.0780306364820287`}, {
                0.8123496019683463, -1.11014307936196}, {
                0.7947789766197458, -1.1559777142705217`}, {
                0.773650107608367, -1.2023860845098857`}, {
                0.7237235720069509, -1.2955551073696914`}, {
                0.6576737679997109, -1.3878332988686688`}, {
                0.5743416617608204, -1.4756098213010118`}, {
                0.5692217327133745, -1.4796842738291067`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2713106572630981, 0.5224485346095186, -0.6596981748192078], 
               
               ArrowBox[{{0.5598321121687179, -1.487156557685289}, {
                0.47654726362705957`, -1.5534348514952097`}, {
                0.42179583162480666`, -1.5879094724491645`}, {
                0.3631873081528762, -1.618573290454793}, {
                0.3011952573229807, -1.6449847930922223`}, {
                0.2365442525304242, -1.6668154066386107`}, {
                0.16964510556602122`, -1.6835953839998286`}, {
                0.13202422759879556`, -1.6897579898137334`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28264713153172155`, 0.5224282923265399, -0.632604619365899], 
               
               
               ArrowBox[{{0.12018205694727856`, -1.6916978336889845`}, {
                0.10090862822058656`, -1.6948549780817461`}, {
                0.031024229780149352`, -1.7004822246625162`}, \
{-0.03915948190056752, -1.7005696068758793`}, {-0.10899289717770842`, \
-1.6949540486610908`}, {-0.17782640640741798`, -1.6834724739574054`}, \
{-0.24504516524202355`, -1.666452044524713}, {-0.3100541952173859, \
-1.6445000580204114`}, {-0.3490093278974089, -1.6278187446975676`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.27908273705917813`, 0.5224346568698582, -0.6411233278294828], 
               
               ArrowBox[{{-0.36004047688106194`, -1.6230950012561378`}, \
{-0.37223368551494945`, -1.6178736422300142`}, {-0.4309638253161584, \
-1.5868299249390347`}, {-0.514559053433082, -1.531247484347555}, \
{-0.5883083121165268, -1.4687801309655004`}, {-0.6517215996517225, \
-1.4014611472503664`}, {-0.7050017179225871, -1.3313122551003824`}, \
{-0.7168247166459003, -1.3119370872612317`}}]}}, {
              Arrowheads[{{0.01562084562342639, 1.}}], {
               LABColor[
               0.2612517567888775, 0.5224664956708708, -0.683738398555428], 
               
               ArrowBox[{{-0.7230754246413102, -1.3016936186320944`}, \
{-0.7484883968125505, -1.2600476189468754`}, {-0.7830046960038988, \
-1.1890680654746366`}, {-0.8093424185388396, -1.1195455596768689`}, \
{-0.8285037757189319, -1.0522665359819203`}, {-0.8463974470164706, \
-0.9509471721324603}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.193349895793275, 0.522587740482308, -0.8460201444205481], 
               
               ArrowBox[{{0.3519744458625394, -0.13906159960188216`}, {
                0.39364141664961166`, -0.18201497205158967`}, {
                0.41506748461000587`, -0.2091181098429019}, {
                0.43743087735808767`, -0.24208170575605417`}, {
                0.4600707567203867, -0.282426870389726}, {
                0.47116979523422686`, -0.30608097146131835`}, {
                0.48181293501699235`, -0.3323398889023514}, {
                0.5007300752400723, -0.3926597495671702}, {
                0.5134057308431617, -0.46655224536143275`}, {
                0.5134753637185643, -0.5712536215983771}, {
                0.5130539634304423, -0.5733708992595868}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2084416159999257, 0.5225607928737463, -0.8099517559061037], 
               
               ArrowBox[{{0.5107115557751942, -0.5851400592286176}, {
                0.4967622119825521, -0.6552269453394908}, {
                0.4609528555780444, -0.7460222950890271}, {
                0.40083344378682484`, -0.8382226027303978}, {
                0.3849697589626534, -0.8578942683623838}, {
                0.3677647266964061, -0.8772310549541952}, {
                0.3402633648309493, -0.9014345614382556}, {
                0.3103635609413184, -0.9240630500283101}, {
                0.24680689754457966`, -0.964965682634561}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2212790969828408, 0.522537870409792, -0.7792708762384218], 
               
               ArrowBox[{{0.235913718966567, -0.9699776608695307}, {
                0.1736220942248036, -0.9978275493391395}, {
                0.0949297297867375, -1.0191110658336737`}, {
                0.018191054673057216`, -1.0279585090401135`}, \
{-0.05918840178517775, -1.0252765633675966`}, {-0.13464506314636024`, \
-1.0110044974196153`}, {-0.2058608836066472, -0.9863396614521318}, \
{-0.22664004505425758`, -0.9755515012501322}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.22132576119859831`, 0.5225377870866849, -0.779159351306829], 
               
               
               ArrowBox[{{-0.23729021172886489`, -0.9700221296942423}, \
{-0.27090745526416987`, -0.9525686723098871}, {-0.32836877343791604`, \
-0.9116964542526351}, {-0.37738467731704994`, -0.86560611879638}, \
{-0.41790705157134067`, -0.8164181184208821}, {-0.4751676031200061, \
-0.7143909884380741}, {-0.5049548700149705, -0.617200977267328}, \
{-0.5074329569383866, -0.5953955912045354}}]}}, {
              Arrowheads[{{0.013011280084468163`, 1.}}], {
               LABColor[
               0.20833132008337202`, 0.5225609898169141, -0.8102153571334881], 
               
               ArrowBox[{{-0.508787982318427, -0.5834723405479634}, \
{-0.5148325519716374, -0.5302844666173773}, {-0.5114873795084535, \
-0.45530382355066273`}, {-0.48892543575505987`, -0.3546757473857522}, \
{-0.45769347117791503`, -0.28041744154840864`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5716437943838439, 0.5332474361565851, 0.4077300812426043], 
               
               ArrowBox[{{-1.4491587213190011`, -3.}, {-1.4644312356282627`, \
-2.9814814325054417`}, {-1.5282038792567845`, -2.8940514757174527`}, \
{-1.5851023470309984`, -2.805777237504145}, {-1.6353654656837866`, \
-2.717292558627843}, {-1.679324082135592, -2.6290913129920543`}, \
{-1.6962379338170823`, -2.5901633930082872`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.514076533474995, 0.5294962525431982, 0.15126649853086813`], 
               
               ArrowBox[{{-1.7010199527539123`, -2.5791573812470814`}, \
{-1.7173090433068572`, -2.5416673745002853`}, {-1.7523071768378522`, \
-2.454632089580526}, {-1.7817577887056255`, -2.368865443556195}, \
{-1.802821327962407, -2.2800274441018913`}, {-1.8190795593914448`, \
-2.1937771632835124`}, {-1.8314759954246909`, -2.1192375225178126`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.44935654832186656`, 
                0.5252789848821666, -0.13706264903276638`], 
               
               ArrowBox[{{-1.8333758773746485`, -2.1073902777820153`}, \
{-1.8430253821055094`, -2.02677058979931}, {-1.8489887362900026`, \
-1.9474785162052055`}, {-1.8515036162734282`, -1.871114880754541}, \
{-1.8509333086548065`, -1.7976916685819484`}, {-1.8476411000331574`, \
-1.7272208648220606`}, {-1.8402636209780767`, -1.6466311925574681`}, \
{-1.8378089717795063`, -1.6288153909551264`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.38446982394476786`, 0.5222464788539687, -0.3892539357293133], 
               
               ArrowBox[{{-1.8361710927859356`, -1.6169276934319547`}, \
{-1.8297169802595457`, -1.5700838558863208`}, {-1.8166620674797136`, \
-1.4975285419440607`}, {-1.8017597722407293`, -1.4289149378661299`}, \
{-1.7852872976108747`, -1.3640688990003662`}, {-1.7673025972105065`, \
-1.302745519673119}, {-1.748137686469888, -1.2447883454875979`}, \
{-1.7281245808192816`, -1.1900409220470123`}, {-1.7132398307633498`, \
-1.1543896457123637`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3269203879881829, 0.5223492384898397, -0.5267939501508968], 
               
               ArrowBox[{{-1.708616493858703, -1.1433160394404156`}, \
{-1.6861326336082534`, -1.0894637199962627`}, {-1.642484453217719, \
-0.9995906987120979}, {-1.5982491730121682`, -0.9191969845627618}, \
{-1.5540327556298326`, -0.847213150184901}, {-1.4829989874632075`, \
-0.7453618314713061}, {-1.4697158861823152`, -0.7286902188085576}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.27557271993645693`, 0.5224409243175827, -0.6495120773915682], 
               
               ArrowBox[{{-1.4622381613721034`, -0.7193049307648829}, \
{-1.4147667246947455`, -0.6597235583057593}, {-1.3503569768177957`, \
-0.5871353944751381}, {-1.2897289905798062`, -0.5253487218192907}, \
{-1.2330236217233885`, -0.47231153907212653`}, {-1.1800324536133675`, \
-0.4266256208881015}, {-1.1226981509325704`, -0.3820862639844705}}]}}, {
              Arrowheads[{{0.007445314797738275, 1.}}], {
               LABColor[
               0.2338799151114188, 0.5225153705284109, -0.7491556078900782], 
               
               ArrowBox[{{-1.1132216013830978`, -0.37472453805664696`}, \
{-1.0845447058204545`, -0.3524472899410871}, {-1.0223005327253945`, \
-0.3093113601330734}, {-0.9660878749534251, -0.27351175911641845`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.20989097523062927`, 0.5225582049139459, -0.8064878663617576], 
               
               ArrowBox[{{0.8047065024472015, 0.03520363858640116}, {
                0.8894290113634352, 0.04301677248917894}, {0.9940457759242238,
                 0.05377047031391028}, {1.0560683409993414`, 
                0.060708703016681825`}, {1.1263619673384664`, 
                0.06909556989255984}, {1.2063698591349277`, 
                0.07922726842786185}, {1.2815763787461585`, 
                0.0894751651197156}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.24367260842223518`, 0.5224978848036234, -0.7257516047611524], 
               
               ArrowBox[{{1.2934665002461836`, 0.09109535360092343}, {
                1.2986407208717237`, 0.09180041053887902}, {1.413477450618977,
                 0.10883935618205329`}, {1.4788069154749177`, 
                0.11919545708611937`}, {1.5504547568142062`, 
                0.13111916800002374`}, {1.6292736707075792`, 
                0.144880550794879}, {1.7164671164101237`, 
                0.16092077880374545`}, {1.7667747702734473`, 
                0.17063941893675433`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.2931625468850522, 0.5224095161172724, -0.6074733499571576], 
               
               ArrowBox[{{1.7785569284281142`, 0.1729155448599885}, {
                1.8130751338431526`, 0.17958391419753394`}, {
                1.9211661279642263`, 0.20175046439534944`}, {
                2.0277063701253315`, 0.22506799231182073`}, {2.14659740666194,
                 0.25266215193774555`}, {2.211365889565711, 
                0.26840418549946066`}, {2.2469961524913264`, 
                0.2773481911882057}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.3581312864213892, 0.5222935086550482, -0.4522016044700078], 
               
               ArrowBox[{{2.2586350563032167`, 0.2802698205379982}, {
                2.2801040961413834`, 0.28565903741931437`}, {
                2.3508271645530057`, 0.30367029851823735`}, {
                2.425931344897242, 0.32341225945523616`}, {
                2.4997353578020927`, 0.34411835790485173`}, {
                2.5781363616237276`, 0.3668857500972041}, {
                2.6590981451220594`, 0.390856232576282}, {2.720767701654841, 
                0.40975230537477736`}}]}}, {
              Arrowheads[{{0.011740641244170421`, 1.}}], {
               LABColor[
               0.4432108015623675, 0.5248785172522621, -0.16444210408232723`], 
               
               ArrowBox[{{2.732241182301417, 0.41326787671563164`}, {
                2.745181487973787, 0.4172328956288113}, {2.836900745738761, 
                0.4463723932376678}, {2.934770273976833, 
                0.4786313793857276}, {3., 0.5009906251182611}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24656823516412824`, 0.5224927144045626, -0.7188312147135429], 
               
               ArrowBox[{{1.2404347676451617`, 0.4815135264824503}, {
                1.297144773784792, 0.5355377337385784}, {1.3576920944231483`, 
                0.5984525822658294}, {1.4218926860499173`, 
                0.6723283284990288}, {1.4897415903003517`, 
                0.7594416762256659}, {1.549384294643009, 
                0.8471507193500454}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.2918860336145827, 0.5224117954452393, -0.610524147079864], 
               
               ArrowBox[{{1.5561320578379958`, 0.8570738081768362}, {
                1.5601352972950457`, 0.8629608702416004}, {
                1.6038799542660023`, 0.9362204064918385}, {
                1.6474794618850328`, 1.017995028135866}, {1.690291460296516, 
                1.1093557038330109`}, {1.7311960596032083`, 
                1.2115139380518538`}, {1.7505520654211892`, 
                1.2670830857294062`}, {1.7580570630954337`, 
                1.2910369452756438`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.34566448882514655`, 0.5223157692308501, -0.4819965710526815], 
               
               ArrowBox[{{1.7616448182972317`, 1.3024880593093076`}, {
                1.7689739984576902`, 1.3258807583843761`}, {
                1.7861203717485605`, 1.3880538408086875`}, {
                1.8016496983296486`, 1.4537492177942637`}, {
                1.8154920257433451`, 1.5232145542325923`}, {
                1.8273601739268073`, 1.5966168909355098`}, {
                1.8365868145080353`, 1.673982176575464}, {1.8425046191150285`,
                 1.7553363598249025`}, {1.843027234850644, 
                1.7741457819394781`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.40455216510015424`, 
                0.5224297053524936, -0.33450025872870676`], 
               
               ArrowBox[{{1.84336052363814, 1.7861411526542217`}, {
                1.8444597080380123`, 1.8257018125233677`}, {
                1.8436405196920882`, 1.898910085314642}, {1.8396919239688647`,
                 1.9749360159264437`}, {1.8322587907599506`, 
                2.0537544420864933`}, {1.8209362057443574`, 
                2.1352615118066085`}, {1.8053192546010968`, 
                2.219353373098607}, {1.7963376015062482`, 
                2.2625241670081224`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.47113603803803905`, 0.526698174602876, -0.04003447930471121], 
               
               ArrowBox[{{1.7938933487790174`, 2.2742725979078395`}, {
                1.7875551203940028`, 2.3047376301765476`}, {
                1.7649958966401527`, 2.392532431542398}, {1.7342094449051082`,
                 2.47709577180494}, {1.6979474847165559`, 
                2.5627551241108093`}, {1.6587498957195146`, 
                2.6487171435134265`}, {1.621461993039992, 
                2.720339013133486}}]}}, {
              Arrowheads[{{0.013528692537122208`, 1.}}], {
               LABColor[
               0.5333971347885513, 0.5307552167861375, 0.23734025911616732`], 
               
               
               ArrowBox[{{1.6159205516555524`, 2.7309829046860536`}, {
                1.6136810491054958`, 2.7352844971095402`}, {
                1.5624376429418072`, 2.8219685544289974`}, {
                1.5047163752957555`, 2.908280685001645}, {1.4403073303864586`,
                 2.993602486771348}, {1.4348579328863227`, 3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.23938172655631829`, 0.5225055465547905, -0.7360065784878236], 
               
               ArrowBox[{{1.223338871481186, -0.23196514462038345`}, {
                1.288965119074753, -0.2585420851533988}, {
                1.3616780733508465`, -0.2899294478899951}, {
                1.4425425096655564`, -0.3270962417500578}, {
                1.5329738902203391`, -0.3718342681944816}, {
                1.5924457018557352`, -0.40321002249034604`}, {
                1.6561614449944577`, -0.4385662225891414}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.2859832681143966, 0.522422335357983, -0.6246314348148], 
               
               ArrowBox[{{1.6665217419660916`, -0.4446212336572986}, {
                1.7250147394536506`, -0.47883368328867104`}, {
                1.799025292467159, -0.5246711839145197}, {
                1.8788982245040093`, -0.5771121083774042}, {
                1.9652025028363314`, -0.6375515645029024}, {
                2.0585492176439435`, -0.7072270375008286}, {
                2.0646110351095768`, -0.7121122633937934}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.34633706075598175`, 0.5223145682938547, -0.4803891608056651], 
               
               ArrowBox[{{2.073954504137438, -0.7196421761771791}, {
                2.1595068541017097`, -0.7885889165927257}, {
                2.2467464216521127`, -0.8648463523254901}, {
                2.339477976951959, -0.9520723629203817}, {
                2.387939362722111, -1.000429411533027}, {
                2.4284578629471394`, -1.0426022795768053`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4212287399950992, 0.5234461275947073, -0.2623727364578728], 
               
               ArrowBox[{{2.4367717195440926`, -1.051255590416322}, {
                2.437802168872928, -1.0523281129265194`}, {
                2.488365685214078, -1.1059976407104348`}, {
                2.5403211777837047`, -1.163574631599949}, {
                2.589882168014357, -1.2238647171471053`}, {
                2.6404120274153624`, -1.2885812587805887`}, {
                2.6913562068488215`, -1.3557460625379205`}, {
                2.7396510992285843`, -1.4229665483925773`}}]}}, {
              Arrowheads[{{0.016672644944777024`, 1.}}], {
               LABColor[
               0.5158560798531114, 0.529612210904035, 0.15919442201599016`], 
               
               ArrowBox[{{2.7465163798883396`, -1.4328073103455239`}, {
                2.7955664701148315`, -1.505207936516401}, {
                2.8485045223561194`, -1.588390394179002}, {
                2.901674888711052, -1.6778782828318901`}, {
                2.954809274819629, -1.774195121776202}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24700512657159931`, 0.5224919342961011, -0.7177870680683947], 
               
               ArrowBox[{{1.2245005299711142`, -0.533377681640952}, {
                1.2769257037123338`, -0.5923586317340724}, {
                1.3320630971839609`, -0.6607559271060182}, {
                1.3893525386576833`, -0.7405919922584479}, {
                1.4483576424453646`, -0.8341598138672676}, {
                1.4976241968292017`, -0.9261480375701029}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2912725791962785, 0.5224128908226588, -0.6119902696949351], 
               
               ArrowBox[{{1.5032897054487524`, -0.9367264123073579}, {
                1.5073608767012918`, -0.944327914312012}, {
                1.5437765617125747`, -1.0244643468342103`}, {
                1.5784825829668647`, -1.1135176664332653`}, {
                1.6105229916617432`, -1.2124909533277872`}, {
                1.6383696138010104`, -1.3223574649353682`}, {
                1.6501790961064666`, -1.38173760131534}, {
                1.6517534434091217`, -1.3914745070424699`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.342526999661426, 0.5223213714967743, -0.4894949991024582], 
               
               ArrowBox[{{1.6536688317268078`, -1.4033206577925013`}, {
                1.6602907412060313`, -1.444275349444117}, {
                1.6683037400717031`, -1.510008121059446}, {
                1.6738172836754786`, -1.578973327899073}, {
                1.6766500700714824`, -1.6514157984275182`}, {
                1.6764451916481367`, -1.727414427727882}, {
                1.6725384308788882`, -1.8067577274657838`}, {
                1.6650358364223745`, -1.8815550221686492`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.39644894798501507`, 0.5222295824784289, -0.3604858769955249], 
               
               ArrowBox[{{1.6636342005448532`, -1.8934696882044513`}, {
                1.6543442874132155`, -1.9557901187030822`}, {
                1.6412696396992976`, -2.0242043430221313`}, {
                1.6247561933682781`, -2.0943470937414217`}, {
                1.6045185146930063`, -2.1660885823383857`}, {
                1.580262119430718, -2.2392218406085567`}, {
                1.5516925233386496`, -2.313539900347468}, {
                1.5349700579338426`, -2.3543092674065798`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.45434388867878367`, 
                0.5256039687206522, -0.11484392339002551`], 
               
               ArrowBox[{{1.530416180881751, -2.3654116186798206`}, {
                1.5209663268316904`, -2.388450360820749}, {
                1.4855814878895914`, -2.4642544130716244`}, {
                1.4429064008724333`, -2.5360600852520183`}, {
                1.39530153192565, -2.6074512816621827`}, {
                1.3451529306383196`, -2.6783828378237375`}, {
                1.289916864669895, -2.748395113488075}, {
                1.2726989399407063`, -2.7679548132215817`}}]}}, {
              Arrowheads[{{0.013552361811464686`, 1.}}], {
               LABColor[
               0.505344906890873, 0.5289272844519001, 0.11236688438714952`], 
               
               ArrowBox[{{1.2647700067163423`, -2.7769621445646364`}, {
                1.2295076542093009`, -2.817020458082847}, {
                1.1638396194454612`, -2.883791221035706}, {
                1.0929368577963665`, -2.9481823839902472`}, {
                1.0287925071951538`, -3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28053137097106123`, 0.5224320702051791, -0.6376611717575743], 
               
               ArrowBox[{{1.5863878869501922`, -0.5418312299409332}, {
                1.6633301547965234`, -0.6035180254690555}, {
                1.7464275924810035`, -0.6758786537588253}, {
                1.7904601930466688`, -0.7167381194981948}, {
                1.8362424177128143`, -0.7610778005986163}, {
                1.8836894856078903`, -0.8094654843618001}, {
                1.9327166158603468`, -0.8624689580894565}, {
                1.9375732810419666`, -0.868081028576852}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3376304956951444, 0.5223301146400606, -0.5011973766313322], 
               
               ArrowBox[{{1.9454258627351333`, -0.8771550001853674}, {
                1.997103791474116, -0.9368709097406258}, {
                2.0638730601396715`, -1.0205260899255637`}, {
                2.1327642645415397`, -1.1147672088307843`}, {
                2.2031531294176503`, -1.2212991707004432`}, {
                2.2289154867585506`, -1.2636504871571101`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.4055683368743709, 0.5224681160003274, -0.33083086668427913`], 
               
               ArrowBox[{{2.2351518992686166`, -1.2739026654136707`}, {
                2.2387215078854092`, -1.2797708249984387`}, {
                2.2744390894939626`, -1.3420311187393452`}, {
                2.310036889616743, -1.4084026723722596`}, {
                2.3452459236271843`, -1.4792081063462792`}, {
                2.380125844730352, -1.554689552887463}, {
                2.414473395866004, -1.6351535348002995`}, {
                2.44196297721569, -1.7063536076970494`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.49131213224106757`, 0.5280128842618329, 0.04985052343376026], 
               
               ArrowBox[{{2.446285095572805, -1.7175482176905725`}, {
                2.4476252270096133`, -1.721019258401532}, {
                2.4789179881366517`, -1.8127059300079027`}, {
                2.5030870963099074`, -1.8936097744069516`}, {
                2.5255178093052466`, -1.9789301337017757`}, {
                2.5458290214967874`, -2.068861322843446}, {
                2.5636396272586466`, -2.163597656783033}, {
                2.5663084398210056`, -2.181551095645107}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.582996235901538, 0.5339871811422034, 0.4583054912619087], 
               
               ArrowBox[{{2.568072874292407, -2.1934206689734173`}, {
                2.5784603325650233`, -2.2632984114795978`}, {
                2.5898018433901173`, -2.3681228628922004`}, {
                2.5994037569745694`, -2.475509162662822}, {
                2.60488677936111, -2.588177863439983}, {
                2.601699117086679, -2.6714182950773906`}}]}}, {
              Arrowheads[{{0.013271438254265732`, 1.}}], {
               LABColor[
               0.6682942782184963, 0.4836339108981787, 0.7454097849148245], 
               
               ArrowBox[{{2.60123991799909, -2.6834095058668797`}, {
                2.6005121182280444`, -2.702414771127693}, {
                2.590376833249247, -2.8212120262006346`}, {
                2.576940472839989, -2.9421802962678107`}, {
                2.567694458870177, -3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23571256978123709`, 0.5225120981605168, -0.7447756631429786], 
               
               ArrowBox[{{1.185780466855346, 0.1785172064441494}, {
                1.2514901744994047`, 0.19934687318406297`}, {
                1.3247029923538804`, 0.22404442081214135`}, {
                1.4066020803815011`, 0.2533939602437231}, {
                1.4989136405223151`, 0.2889141651558537}, {
                1.5575729119340607`, 0.3129094605079375}, {1.620782004404334, 
                0.33999355575560986`}, {1.6351452367485022`, 
                0.3464512815622054}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2813620308150651, 0.5224305869881556, -0.6356759400168166], 
               
               ArrowBox[{{1.6460899277812653`, 0.3513720272574587}, {
                1.6890322422282469`, 0.3706789412970275}, {
                1.7629273707843445`, 0.40567033378067446`}, {
                1.8431158451747272`, 0.4456838039312885}, {
                1.9303815432212488`, 0.49179716682175484`}, {
                2.0254870519238586`, 0.5449397641624841}, {2.071756524087167, 
                0.572571923448253}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.34150202803725666`, 0.5223232016747618, -0.4919446254042054], 
               
               ArrowBox[{{2.082059141108981, 0.5787246531271705}, {
                2.1295083853658188`, 0.6070613730851304}, {
                2.2229980461462064`, 0.6669576987182612}, {2.323967014732998, 
                0.7358624318797136}, {2.377473677997265, 
                0.7742540867009461}, {2.433113509441847, 0.815613912455229}, {
                2.4780170768901417`, 0.8495403110665772}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.41676607785913844`, 
                0.5231553327086521, -0.28225400754410207`], 
               
               ArrowBox[{{2.487591560795346, 0.8567742075234661}, {
                2.4898199249765858`, 0.8584578236760368}, {2.548764177627502, 
                0.9046040049990475}, {2.60585332532812, 0.9527811590147446}, {
                2.664980699818573, 1.0047376895836955`}, {2.7251486375279232`,
                 1.0588135483053405`}, {2.7873977016750686`, 
                1.1171280633323744`}, {2.8465213986760394`, 
                1.1750118602188646`}}]}}, {
              Arrowheads[{{0.008801814385469333, 1.}}], {
               LABColor[
               0.5141992581944108, 0.529504249501003, 0.151813240215842], 
               
               ArrowBox[{{2.8550199643429304`, 1.1834827706768414`}, {
                2.918212619194043, 1.2482566617468895`}, {2.9867665487314703`,
                 1.3220770303442764`}, {3., 1.3370834801715707`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19003525136577168`, 0.5225936590747103, -0.8539419638925088], 
               
               ArrowBox[{{0.18732268713967404`, 0.08277727881978413}, {
                0.21185977093669514`, 0.11380924652226919`}, {
                0.22664304570365765`, 0.1390877426938435}, {
                0.2408004745948342, 0.17221087937866492`}, {
                0.2517484372886563, 0.21590957839616923`}, {
                0.25454805450686707`, 0.27300127449295625`}, {
                0.24984707757530117`, 0.30630643713324895`}, {
                0.23941505187286075`, 0.342457187574156}, {
                0.22168157415508036`, 0.38037502162718634`}, {
                0.2096457191917366, 0.3995328117059847}, {
                0.19524889891655212`, 0.4183930359146553}, {
                0.16060413394912895`, 0.4522248405216065}, {
                0.11719564491977257`, 0.4804720524787673}, {
                0.10477767170952985`, 0.48505732537352986`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19680111308467446`, 0.5225815780269115, -0.8377719232496369], 
               
               ArrowBox[{{0.09352056559585492, 0.48921395404896656`}, {
                0.059202116078062375`, 
                0.5018858654551223}, {-0.004024593511006519, 
                0.5087794365962076}, {-0.012081738932979622`, 
                0.5086522153669365}, {-0.0201308358958576, 
                0.5082698826605249}, {-0.04647658286901825, 
                0.5033297169253703}, {-0.07171743635990821, 
                0.49584121934786335`}, {-0.11927921158308553`, 
                0.47643623922575407`}, {-0.1601048866589783, 
                0.44943487738858184`}, {-0.19299430238905, 
                0.41745380778791896`}, {-0.23130828876088583`, 
                0.3586334460369478}, {-0.25014275415839105`, 
                0.30160632657612113`}, {-0.2534426046239303, 
                0.2676454787749912}}]}}, {
              Arrowheads[{{0.004160460934977082, 1.}}], {
               LABColor[
               0.19294132707113318`, 0.522588470018096, -0.8469966013918724], 
               
               
               ArrowBox[{{-0.2546031348320837, 
                0.25570172854166984`}, {-0.2550322952080253, 
                0.2512849677333138}, {-0.24816710607466236`, 
                0.1982363880834755}, {-0.2353937093468849, 
                0.15830720215356267`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.507213480602228, 0.5290490439898002, 0.12069142686162795`], 
               
               ArrowBox[{{-0.6016723935097523, -3.}, {-0.6306060957541437, \
-2.9882157030348866`}, {-0.7098232310752961, -2.9505966982027383`}, \
{-0.7858133944473522, -2.909179821660162}, {-0.8583228729475174, \
-2.8643111950530153`}, {-0.9271925523095803, -2.8163610548482207`}, \
{-0.9922633182673296, -2.7656996375127014`}, {-1.0099141743082767`, \
-2.7511654197451776`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.47774992171903213`, 
                0.5271291468550433, -0.010569462597525042`], 
               
               ArrowBox[{{-1.0191777958872494`, -2.743537489800455}, \
{-1.055434627522922, -2.713682581611819}, {-1.1146779044014299`, \
-2.6593931083837283`}, {-1.1666553919113762`, -2.6010145768984665`}, \
{-1.2145979151087718`, -2.5416255966325547`}, {-1.2605772317054988`, \
-2.4819111967174328`}, {-1.3026301351008893`, -2.421545957503891}, \
{-1.3288731856186937`, -2.379866668896407}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4344080973464165, 0.5243049176179031, -0.20365837084806943`], 
               
               ArrowBox[{{-1.3352670382794414`, -2.369711933638772}, \
{-1.3408710261163914`, -2.3608116639749768`}, {-1.375414305573453, \
-2.2999901011137367`}, {-1.4064094879477624`, -2.23931100221459}, \
{-1.4340060877150085`, -2.1790041005719556`}, {-1.465763216910453, \
-2.099044402440104}, {-1.492102660304091, -2.020253729172968}, \
{-1.5134809106388234`, -1.943165894169655}, {-1.5169925567628437`, \
-1.9275882079350544`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.38428569563180526`, 0.5222468076314463, -0.3896939923588761], 
               
               ArrowBox[{{-1.51963147135691, -1.9158819647389975`}, \
{-1.5303544606575514`, -1.868314710829272}, {-1.5431079983598641`, \
-1.7958185034534435`}, {-1.5520851804634592`, -1.7255581740023758`}, \
{-1.5576809527883981`, -1.6577114023630473`}, {-1.5602902611547445`, \
-1.592455868422438}, {-1.5577416354018263`, -1.4695768619622047`}, \
{-1.5548060667116683`, -1.4392105669505155`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3343140782137116, 0.5223360363984084, -0.5091234336055199], 
               
               ArrowBox[{{-1.5536513863801054`, -1.4272662497522868`}, \
{-1.546823601985043, -1.356637851271336}, {-1.5295754500257694`, \
-1.2533833547855997`}, {-1.507497642041378, -1.1591595271153312`}, \
{-1.4885846591139074`, -1.094145253450627}, {-1.4679933978326767`, \
-1.0335491687253597`}, {-1.4462325726566645`, -0.9771126894725489}, \
{-1.440192852428072, -0.9629612280251567}}]}}, {
              Arrowheads[{{0.013113433571871141`, 1.}}], {
               LABColor[
               0.2856754639828501, 0.5224228849696335, -0.6253670699081461], 
               
               ArrowBox[{{-1.4354824247860163`, -0.951924386473836}, \
{-1.4238108980448485`, -0.9245772322252139}, {-1.3776221284613892`, \
-0.830127088758287}, {-1.3307013449774645`, -0.7480341483472084}, \
{-1.2842913614511335`, -0.6764720116820551}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.6442334100315367, 0.5379775027329822, 0.731118628878255], 
               
               ArrowBox[{{-2.0144024022668714`, -3.}, {-2.030914672196191, \
-2.960501825059885}, {-2.0677510639166496`, -2.8579778581194053`}, \
{-2.101252053263081, -2.7562276019113305`}, {-2.1286317035738738`, \
-2.656511834556982}, {-2.1465272214766244`, -2.5541789356192344`}, \
{-2.1482958885217838`, -2.5404596407909112`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.5684041897251569, 0.5330363378392835, 0.3932975617129356], 
               
               ArrowBox[{{-2.1498302095454447`, -2.528558134205762}, \
{-2.1592843755775726`, -2.455223533719107}, {-2.169770313754597, \
-2.358012258882158}, {-2.1757138200837765`, -2.264289238171567}, \
{-2.1775890098183517`, -2.174103541773657}, {-2.1758699982115637`, \
-2.0875042398747503`}, {-2.1736532235377513`, -2.0500192498452914`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.48918574522070096`, 0.527874325156873, 
                0.040377416239404794`], 
               
               ArrowBox[{{-2.1729448092670327`, -2.0380401785448505`}, \
{-2.1709591119167166`, -2.004462636245468}, {-2.163258677587113, \
-1.9249500346564312`}, {-2.150550133211727, -1.834457838175011}, \
{-2.134642212610242, -1.7487197720170475`}, {-2.1162541421527705`, \
-1.6676079571450484`}, {-2.096105148209426, -1.5909945145215199`}, \
{-2.0887986618193026`, -1.5665543835598663`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.4110428307692764, 0.5227823958976955, -0.3077512160309647], 
               
               ArrowBox[{{-2.085361516936414, -1.5550571649808345`}, \
{-2.0744817674205085`, -1.518664501147484}, {-2.0514232851521355`, \
-1.4503532231888256`}, {-2.0272780508631505`, -1.3858581753553492`}, \
{-2.002394414012398, -1.3249768523568595`}, {-1.9509878971534862`, \
-1.2132360960850508`}, {-1.8985870750509586`, -1.1139309342025336`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3456100041704717, 0.5223158665180464, -0.48212678640692735`], 
               
               ArrowBox[{{-1.8924959228934584`, -1.1035924513172113`}, \
{-1.8455762858875282`, -1.024322513135066}, {-1.7932462630969612`, \
-0.9445140079826535}, {-1.7513131489765972`, -0.8856926298810229}, \
{-1.710081750995177, -0.8319105562188591}, {-1.669803006551608, \
-0.7825955341956518}, {-1.6307278530447982`, -0.7371753110108901}, \
{-1.6110982245733472`, -0.7160268772080087}}]}}, {
              Arrowheads[{{0.0028674395536220885`, 1.}}], {
               LABColor[
               0.28909310978922664`, 0.522416782459109, -0.6171990827561692], 
               
               
               ArrowBox[{{-1.6029346434513367`, -0.7072316544556075}, \
{-1.5561174926344263`, -0.6567921152493034}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2697395968939221, 0.5224513398775249, -0.6634529234495273], 
               
               ArrowBox[{{1.3697425656702633`, 0.7780004984545223}, {
                1.4173164643780913`, 0.8630164601089195}, {
                1.4639612696690543`, 0.9607286692175983}, {
                1.4865123853829663`, 1.0150326134370617`}, {1.508323775462368,
                 1.073334715763818}, {1.5288698276154487`, 
                1.1358884916669014`}, {1.5476249295503972`, 
                1.2029474566153473`}, {1.5514970577194451`, 
                1.2203016628799936`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.31733781125211735`, 0.5223663490327971, -0.5496957861214296], 
               
               ArrowBox[{{1.5541102793061137`, 1.232013668384559}, {
                1.5693085487116525`, 1.30012967348938}, {1.5858840954654863`, 
                1.4065025931439348`}, {1.5957979973868222`, 
                1.5227024707976762`}, {1.5969598609344489`, 
                1.6489434539447847`}, {1.5938758194448477`, 
                1.7085477930514992`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.36847584732844857`, 0.522275037521589, -0.4274786678731096], 
               
               
               ArrowBox[{{1.5930593939723598`, 1.7205174169064041`}, {
                1.586926663092184, 1.7854558388154371`}, {1.576856375636703, 
                1.8574166462387822`}, {1.5628869975615163`, 
                1.9315934087188498`}, {1.5446645625984168`, 
                2.0080968423580714`}, {1.5218002985356787`, 
                2.086796817415759}, {1.49384452276042, 2.1671417239257664`}, {
                1.485870412696882, 2.186528474174207}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4205692147073267, 0.5234031517710699, -0.26531093805928185`], 
               
               ArrowBox[{{1.48130565870826, 2.19762635780233}, {
                1.460347552659758, 2.2485799519219443`}, {1.4314475607351231`,
                 2.3097794850226703`}, {1.3990987636222914`, 
                2.3712942924955533`}, {1.363156382824726, 2.43289007838666}, {
                1.3234756398458896`, 2.494332546742054}, {1.2799481995605733`,
                 2.5553365700001134`}, {1.2376703290375723`, 
                2.6090096190151937`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.470324215559104, 0.5266452748273459, -0.04365116869007684], 
               
               ArrowBox[{{1.2301810310826473`, 2.618384831939464}, {
                1.1830057379107193`, 2.67553568486884}, {1.1294899839089725`, 
                2.7343681315920323`}, {1.0685614752079917`, 
                2.7890790771080587`}, {1.0036927344125075`, 
                2.8414319277865823`}, {0.9369229243110053, 
                2.8923866338321247`}, {0.8732180580431864, 
                2.935858941973513}}]}}, {
              Arrowheads[{{0.004741990854083658, 1.}}], {
               LABColor[
               0.5086848509778116, 0.5291449210622017, 0.1272464185715088], 
               
               ArrowBox[{{0.863198761896682, 2.942456300526841}, {
                0.7921433691355978, 2.9855385995951553`}, {0.7650494886543224,
                 3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.2937816945435651, 0.5224084105740663, -0.605993620808375], 
               
               ArrowBox[{{1.7161466436983075`, 0.5187865111486397}, {
                1.7820241170548037`, 0.5637906536404158}, {1.852390853000718, 
                0.6147133795739046}, {1.9275752762439475`, 
                0.6725195334595196}, {2.0078882526594772`, 
                0.7385331710244332}, {2.093723508892136, 
                0.8141437043636623}, {2.0938469708854752`, 
                0.8142612786799031}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3554034462813498, 0.5222983794562098, -0.45872099368667774`], 
               
               ArrowBox[{{2.102536926050348, 0.8225368257453545}, {
                2.1852739323812402`, 0.9013282552700514}, {
                2.2332990157094494`, 0.9498322736286701}, {
                2.2828809114867568`, 1.0019155799603652`}, {2.333887623195076,
                 1.0581748064291856`}, {2.3861871543163184`, 
                1.1192065851991801`}, {2.4278745180229473`, 
                1.1705452595345902`}, {2.4297967335362287`, 
                1.173020947830398}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4321757489065504, 0.5241594538811404, -0.2136035388083015], 
               
               ArrowBox[{{2.4371560988643544`, 1.1824993307076181`}, {
                2.470306776253664, 1.2251952425050967`}, {2.513406650688194, 
                1.283426452944684}, {2.5570968630062634`, 
                1.3455088096873373`}, {2.601249689941938, 
                1.4117593296584097`}, {2.6457374082292837`, 
                1.4824950297832549`}, {2.690392572192465, 
                1.5554733199849864`}, {2.7047820586731706`, 
                1.5804784158576812`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5263890186650051, 0.5302985556570804, 0.206118927047747], 
               
               ArrowBox[{{2.7107673242656003`, 1.5908792137015044`}, {
                2.735199566332066, 1.6333359445984728`}, {2.7761220234629524`,
                 1.7150766136229665`}, {2.8163468116597343`, 
                1.8022157804067458`}, {2.8560146361604395`, 
                1.892272073543369}, {2.8945685332689908`, 
                1.9881626193856805`}, {2.9088367381460185`, 
                2.027527772022083}}]}}, {
              Arrowheads[{{0.012211837022636606`, 1.}}], {
               LABColor[
               0.6288162754525582, 0.5369728952236964, 0.6624349099232325], 
               
               ArrowBox[{{2.912925908788691, 2.038809557494919}, {
                2.931578232028513, 2.090270239317709}, {2.966613461482131, 
                2.198977754723483}, {2.999080561674469, 
                2.3146728403350574`}, {3., 2.318534105575915}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.21094212738922363`, 0.5225563279882859, -0.8039756700100608], 
               
               ArrowBox[{{0.6337838872813367, 0.5287639052292502}, {
                0.6440052857752079, 0.6226239088786599}, {0.6396076897752636, 
                0.7236914327141912}, {0.6147486989068904, 
                0.8386144126332455}, {0.5918657853674653, 
                0.9001144561783333}, {0.5605396823062719, 
                0.9629963490604846}, {0.5436671286928833, 
                0.9889655083363063}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.23079212248628925`, 0.5225208840567458, -0.7565352639220082], 
               
               ArrowBox[{{0.537129284328002, 0.9990281417421594}, {
                0.5194941944707104, 1.0261709482100567`}, {0.4682320202131063,
                 1.0875400182032904`}, {0.3836056612817641, 
                1.1620748189073125`}, {0.2812349469541678, 
                1.2237250081158275`}, {0.1642338331246741, 
                1.2668488984013433`}, {0.15388540092502728`, 
                1.2695797032770253`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24230191833286932`, 0.5225003322926758, -0.7290274793466327], 
               
               ArrowBox[{{0.14228258793943693`, 1.27264152149851}, {
                0.1299948232189156, 1.2758840887939868`}, {0.0950379688206719,
                 1.2830882107612136`}, {0.04571032629660251, 
                1.2865756937791364`}, {-0.003651751489446502, 
                1.2862731945089103`}, {-0.12235939808134667`, 
                1.2745635615695357`}, {-0.2349664129477985, 
                1.242009311579735}, {-0.3212323080399066, 
                1.199244078487789}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2388877562338374, 0.5225064285827309, -0.7371871406279826], 
               
               ArrowBox[{{-0.3319837031456803, 
                1.1939142095138324`}, {-0.33656614789743994`, 
                1.1916425201314789`}, {-0.40827688302029796`, 
                1.1407798374083047`}, {-0.46972027349495465`, 
                1.0836233762243739`}, {-0.5202805115311426, 
                1.022662418201206}, {-0.5607327383584224, 
                0.9599267001557018}, {-0.5916917786194511, 
                0.8972506560971272}, {-0.6143076148798973, 
                0.8360436448248041}, {-0.6172575481824952, 
                0.8223096347532296}}]}}, {
              Arrowheads[{{0.013574246168865814`, 1.}}], {
               LABColor[
               0.22281079023122297`, 0.522535135435281, -0.7756102128805593], 
               
               
               ArrowBox[{{-0.6197775580072881, 
                0.8105772202326398}, {-0.6388478524407469, 
                0.7217916142711921}, {-0.6413097028854167, 
                0.5927461314334208}, {-0.6240426071445069, 
                0.48826091742855576`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.2677435247858316, 0.5224549040417881, -0.6682234269648076], 
               
               ArrowBox[{{1.3246375732589408`, -0.8144837037745807}, {
                1.367736607601243, -0.9069100043935227}, {
                1.4084696319710068`, -1.013411054801692}, {
                1.4441527973896786`, -1.1359395851921694`}, {
                1.4629332423068333`, -1.2247255670493677`}, {
                1.4695217567479133`, -1.2698722441573633`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3132477733906846, 0.5223736521591328, -0.5594707536271174], 
               
               ArrowBox[{{1.4712546303155463`, -1.2817464662034006`}, {
                1.477067137601966, -1.3215756859758687`}, {
                1.4852277610648152`, -1.4270033456803615`}, {
                1.4856295725026933`, -1.541170832440812}, {
                1.4822662558517818`, -1.6015855939077428`}, {
                1.4761776347620437`, -1.6642496116675285`}, {
                1.4670271315785055`, -1.7290041706149244`}, {
                1.461299324409461, -1.7594422838129207`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3609632060659096, 0.5222884520106754, -0.4454334709118972], 
               
               ArrowBox[{{1.4590801294049305`, -1.7712352975724253`}, {
                1.4544781686461947`, -1.7956905556446872`}, {
                1.4382408789340053`, -1.864501403820532}, {
                1.4179880269117378`, -1.9353482704710074`}, {
                1.3933269821757779`, -2.007650817888116}, {
                1.3638651143225098`, -2.0808287083638586`}, {
                1.3120769192758477`, -2.1867703893425228`}, {
                1.29290285520515, -2.2190317170059357`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4059598763758995, 0.5224905794788629, -0.3291806273151589], 
               
               ArrowBox[{{1.2867719224323158`, -2.2293473199129394`}, {
                1.248838401327459, -2.29317237803721}, {
                1.2127555012967801`, -2.346140185159857}, {
                1.1734704806039948`, -2.3984114639750977`}, {
                1.1309833392491035`, -2.4499862144829327`}, {
                1.0852940772321062`, -2.5008644366833614`}, {
                1.0363803096767532`, -2.550526095232103}, {
                0.9842196517067946, -2.5984511547848754`}, {
                0.983811542349017, -2.598791360109315}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4471997849794018, 0.5251384464028213, -0.14667108349946195`], 
               
               ArrowBox[{{0.9745941555363593, -2.606475094900798}, {
                0.9288121033222304, -2.6446396153416796`}, {
                0.8701576645230605, -2.6890914769025143`}, {
                0.8058312577113015, -2.735602299068392}, {
                0.7379263132322214, -2.7794218748035484`}, {
                0.6593066970604357, -2.818319895297337}, {
                0.5775819496161083, -2.8528096545622783`}, {
                0.568108985417677, -2.856551102817316}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4750966210518647, 0.5269562531333875, -0.02238998322626697], 
               
               
               ArrowBox[{{0.55694797612944, -2.860959262486372}, {
                0.5154389226650767, -2.8773537059149903`}, {
                0.451919420500093, -2.899115136442336}, {
                0.38702344312115705`, -2.9180939461443183`}, {
                0.3207509905282687, -2.934290135020933}, {
                0.25349541849946716`, -2.9475239506200146`}, {
                0.1856500828127914, -2.9576156404893954`}, {
                0.11721498346824148`, -2.964565204629075}, {
                0.09078938474030092, -2.966022850978911}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.48657401527429167`, 0.5277041402562387, 0.02874209420815121], 
               
               ArrowBox[{{0.07880759919760578, -2.966683770950513}, {
                0.04819012046581729, -2.9683726430390527`}, \
{-0.020983939070842412`, -2.969012197675885}, {-0.08986662801809892, \
-2.966458110496127}, {-0.1584579463759522, -2.96071038149978}, \
{-0.22675789414440228`, -2.9517690106868426`}, {-0.32615392776117375`, \
-2.9330973853765587`}, {-0.3962722393216253, -2.915145372426948}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4807083467013994, 0.5273219230118394, 0.002610394463299143], 
               
               
               ArrowBox[{{-0.4078972835824113, -2.912169075073731}, \
{-0.4236498198077128, -2.9081360382248325`}, {-0.5183569098036591, \
-2.8770553318886902`}, {-0.6093865372686522, -2.8400256290251544`}, \
{-0.6963852392199386, -2.797567224460777}, {-0.7793053798162538, \
-2.7504003742618366`}, {-0.8408464562502213, -2.7100553730085424`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.45791697511392965`, 
                0.5258367972949689, -0.09892573423130892], 
               
               ArrowBox[{{-0.850882121649178, -2.7034762074079377`}, \
{-0.8577170392894714, -2.698995382944952}, {-0.9311902978714653, \
-2.6438225550267385`}, {-0.9996264615574042, -2.585441549286171}, \
{-1.0631161082071963`, -2.5244630840807103`}, {-1.1215132258498255`, \
-2.461434053294708}, {-1.1746718025142746`, -2.396901350812511}, \
{-1.1938804533802618`, -2.370774280972841}}]}}, {
              Arrowheads[{{0.004837841384890075, 1.}}], {
               LABColor[
               0.4203858375274028, 0.5233912025926387, -0.26612788796810827`], 
               
               ArrowBox[{{-1.2009885551414134`, -2.3611060396977637`}, \
{-1.2229549118274108`, -2.3312280155063623`}, {-1.266082016608414, \
-2.2650095247094066`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4003563175371856, 0.5222181121068461, -0.35128608215281765`], 
               
               ArrowBox[{{2.2651928128819323`, 1.1584854529450295`}, {
                2.304047912234156, 1.2136635431562106`}, {2.3433928258294503`,
                 1.2724714434248345`}, {2.3831473968731567`, 
                1.3351734041707368`}, {2.4230650381842143`, 
                1.4021296112152584`}, {2.4628991625815617`, 
                1.4737002503797394`}, {2.5027330098530065`, 
                1.5501216787135244`}, {2.512118128333122, 
                1.5694366951041683`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.487663519274459, 0.5277751342463578, 0.03359586169422482], 
               
               ArrowBox[{{2.517362575982651, 1.580230015670674}, {
                2.542385958211261, 1.6317293162835544`}, {2.5812156281126213`,
                 1.7190319434375652`}, {2.6185796400133823`, 
                1.8125383405232915`}, {2.6476714201204743`, 
                1.8940022402005516`}, {2.675367642485471, 
                1.9800631724915154`}, {2.6889779413390715`, 
                2.027748105538925}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5830224577391508, 0.5339888898030988, 0.4584223102022801], 
               
               ArrowBox[{{2.6922714698261463`, 2.039287285323677}, {
                2.701310547499444, 2.070956524794309}, {2.7251423755534643`, 
                2.1669176845070592`}, {2.746394242246399, 
                2.268162959410749}, {2.764597263177114, 
                2.3749086572863605`}, {2.781275861226719, 
                2.484404566647933}, {2.784158592140288, 
                2.5099350095390536`}}]}}, {
              Arrowheads[{{0.018576256594891465`, 1.}}], {
               LABColor[
               0.6722392595011603, 0.4746381118544693, 0.747610525219964], 
               
               ArrowBox[{{2.785504998003511, 2.521859236610503}, {
                2.794287109782617, 2.599636597717835}, {2.7977331752872203`, 
                2.7177190362909585`}, {2.7957701693822976`, 
                2.841078153517721}, {2.790659602143876, 
                2.9670256216949262`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.2903716635462441, 0.5224144994876719, -0.6141434089818578], 
               
               ArrowBox[{{1.7325583605342598`, -0.32898482361974163`}, {
                1.802374175791686, -0.3571180744806297}, {
                1.8777564243055227`, -0.3889523662744331}, {
                1.9593807442630153`, -0.42520495856746}, {
                2.0479682901790213`, -0.46660470443495417`}, {
                2.1444062625986575`, -0.5142459021540235}, {
                2.1695183207180695`, -0.5271640861503689}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.35340850240301874`, 0.5223019416059184, -0.4634888007943423], 
               
               ArrowBox[{{2.1801891847353816`, -0.5326534086153031}, {
                2.195835337080668, -0.5407021266403311}, {
                2.2495464321885827`, -0.5690728115084509}, {
                2.305746757210092, -0.5997337310789502}, {
                2.3646435214328854`, -0.6330606596723967}, {
                2.467984349969236, -0.6945084442934899}, {
                2.5227570841200477`, -0.728551785028148}, {
                2.5797358916787267`, -0.7650803407711029}, {
                2.594381904686216, -0.7747803289524972}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.4342407962544572, 0.5242940159855386, -0.20440370138417746`], 
               
               ArrowBox[{{2.6043866465993073`, -0.7814064242772291}, {
                2.639032110913339, -0.8043519586156991}, {
                2.7007570800919494`, -0.8466244856552816}, {
                2.763696424242559, -0.8903974672923571}, {
                2.8291987640026393`, -0.9375072511178396}, {
                2.892862084843295, -0.9866381148406085}, {
                2.958930740887256, -1.0395873230237536`}, {
                2.990813826068525, -1.065680395654253}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.22939960698475662`, 0.5225233705170126, -0.7598633000526761], 
               
               ArrowBox[{{0.9188996026763239, 0.6335492105027519}, {
                0.9519990165375699, 0.7371301271669758}, {0.9759487972279902, 
                0.861733602789325}, {0.982332014425644, 0.9328828772321412}, {
                0.983396513507227, 1.010206325958034}, {0.9776898879257439, 
                1.0938652565989555`}, {0.9758522469210383, 
                1.1054764433768618`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.26057327137588504`, 0.5224677071669145, -0.6853599417024053], 
               ArrowBox[{{0.9739764178296973, 1.1173289226626517`}, {
                0.9635073366938268, 1.183478108575669}, {0.9425304958154075, 
                1.2666222764142632`}, {0.9121905360388607, 
                1.3531176182821592`}, {0.8709700009292517, 
                1.4419421637172496`}, {0.8176855049437726, 
                1.5314289484192711`}, {0.7974550074417351, 
                1.558184717189899}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28962455097767653`, 0.5224158335236051, -0.6159289672892033], 
               
               ArrowBox[{{0.7902175884169678, 1.5677565386393377`}, {
                0.7511125665960082, 1.6194747389211934`}, {0.6707770380710122,
                 1.7035588524132121`}, {0.5761076975211765, 
                1.7809214655920378`}, {0.4682281385071545, 
                1.8484461374558032`}, {0.42394017817115415`, 
                1.8701967543861706`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.30930288356618263`, 0.5223806961107403, -0.5688988252378084], 
               
               ArrowBox[{{0.413169057354322, 1.8754866462895279`}, {
                0.4005891245168308, 1.8816648784339332`}, {
                0.32942900257418806`, 1.9100173272306542`}, {
                0.2553115459205353, 1.9330487958447744`}, {
                0.17880052779718164`, 1.9503045962751018`}, {
                0.1006026408828028, 1.9615164735389958`}, {
                0.02142457785607447, 
                1.9664161726538174`}, {-0.02308234699589225, 
                1.9673902472366873`}, {-0.053567545931732075`, 
                1.9666776411793367`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.31526200978023927`, 0.5223700555609297, -0.5546568384694289], 
               
               ArrowBox[{{-0.06556426879720732, 
                1.9663972120635456`}, {-0.06763300172912375, 
                1.9663488544451018`}, {-0.11498543903752126`, 
                1.9607704247881723`}, {-0.16179905900414834`, 
                1.952954556084308}, {-0.24240822824077424`, 
                1.9360809295763308`}, {-0.3205090082388488, 
                1.9127953983553305`}, {-0.39543844783118615`, 
                1.8836097982338051`}, {-0.4665335958506004, 
                1.8490359650242514`}, {-0.5177881610411362, 
                1.8188837251180205`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.30526881515209586`, 0.5223878992986503, -0.5785400288157152], 
               
               ArrowBox[{{-0.5281311515258206, 
                1.8127991094494897`}, {-0.5333586007242171, 
                1.8097238847989294`}, {-0.5954776108791625, 
                1.7663235436300986`}, {-0.6857921506176521, 
                1.6886811805245474`}, {-0.7626718553093055, 
                1.6050169709425002`}, {-0.8259167755233626, 
                1.5182041133526445`}, {-0.8549098695835361, 
                1.4679416925681286`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.28250462319224073`, 0.5224285467878534, -0.6329452065279031], 
               
               ArrowBox[{{-0.8609058475461959, 
                1.4575470666358836`}, {-0.8766241843140965, 
                1.4302977618524322`}, {-0.9157126379992993, 
                1.3432510178389354`}, {-0.9445705874027984, 
                1.2585059078232284`}, {-0.9644554596516894, 
                1.1771967206550364`}, {-0.9767286054293528, 
                1.0998944700797368`}, {-0.9828959607899923, 
                0.9984595890854758}}]}}, {
              Arrowheads[{{0.007616734583901032, 1.}}], {
               LABColor[
               0.2521149174191156, 0.5224828103101203, -0.7055749465214718], 
               
               ArrowBox[{{-0.9831694150960634, 
                0.9864782561634889}, {-0.9788772056640195, 
                0.8923036547325373}, {-0.9664703035433817, 
                0.8046480803605449}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.28551262898028706`, 0.5224231757260117, -0.6257562366867353], 
               
               ArrowBox[{{1.7008307990317768`, 0.26187914526908307`}, {
                1.7703931924498049`, 0.28430335233093545`}, {
                1.845692765844941, 0.3096983541381304}, {1.9274763197484457`, 
                0.338648109997485}, {2.0165299927267792`, 
                0.3717413901643498}, {2.1138697926380026`, 
                0.4098759321227563}, {2.151906849060641, 
                0.425557616320753}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.34782251633425637`, 0.5223119158808155, -0.4768390029585468], 
               ArrowBox[{{2.163000996459387, 0.4301314433282924}, {
                2.2204384400545045`, 0.4538114000944215}, {2.337784968703219, 
                0.505201539283053}, {2.445774382256464, 0.5556025606765784}, {
                2.503361402259767, 0.5836320946736865}, {2.563537719834671, 
                0.6137914546068458}, {2.598395404863002, 
                0.6318056888653829}}]}}, {
              Arrowheads[{{0.0187711102352328, 1.}}], {
               LABColor[
               0.42755916086061085`, 
                0.5238586289130199, -0.23417055366142342`], 
               
               ArrowBox[{{2.609055963143558, 0.6373149989081078}, {
                2.62647168783739, 0.6463153368296279}, {2.692331659124141, 
                0.6814384376956046}, {2.759654632052907, 
                0.7178611478831786}, {2.8301140732612358`, 
                0.7571910113697645}, {2.898878398070915, 
                0.7981537019597421}, {2.9707336164765645`, 
                0.8424612702416305}, {3., 0.8608562169570727}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.7467172572953619, 0.3048048342471234, 0.7891586897986069], 
               
               ArrowBox[{{-2.854521828008905, -2.965718251942867}, \
{-2.8567844291104927`, -2.8384542620457913`}, {-2.855961788791677, \
-2.71391151770712}, {-2.849866120218532, -2.5948709368308296`}, \
{-2.835381036582735, -2.4868640347674207`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6731124573329917, 0.47264694595082424`, 0.7480976458233788], 
               
               
               ArrowBox[{{-2.8336294769026877`, -2.474994552988885}, \
{-2.8153018623209305`, -2.3691673653915357`}, {-2.794817839722318, \
-2.2620591317196515`}, {-2.7714368450868605`, -2.1605641626859273`}, \
{-2.7456197942738068`, -2.0644478045855585`}, {-2.7281270315575936`, \
-2.0071886048826246`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.5829982096297716, 0.5339873097537944, 0.45831428427040133`], 
               
               
               ArrowBox[{{-2.7246209781151824`, -1.9957122121889705`}, \
{-2.717827603142407, -1.9734754037137414`}, {-2.6884094330104302`, \
-1.8873985080406392`}, {-2.657714445195646, -1.8059686655364149`}, \
{-2.6183858481988938`, -1.712208526326522}, {-2.5777365212933554`, \
-1.624756042617953}, {-2.5413193269801955`, -1.552798603693917}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.4866510486631424, 0.5277091598868652, 0.029085279876206013`], 
               
               ArrowBox[{{-2.5358735384292266`, -1.5421058899869862`}, \
{-2.495000889365349, -1.4666251794594716`}, {-2.4537176747726086`, \
-1.3950659173123487`}, {-2.4124573309162582`, -1.3281631443723856`}, \
{-2.371457290377238, -1.2655455437286371`}, {-2.330954985736487, \
-1.2068417984701585`}, {-2.291023605787633, -1.151783746467315}, \
{-2.27964109785667, -1.1368633229424816`}}]}}, {
              Arrowheads[{{0.006481487843031292, 1.}}], {
               LABColor[
               0.399221168612339, 0.5222748143219591, -0.35231249394775016`], 
               
               
               ArrowBox[{{-2.2723626874675893`, -1.1273226341723708`}, \
{-2.251642485731554, -1.1001621711797933`}, {-2.212908277760065, \
-1.051694174080629}, {-2.174917634064981, -1.0060968566428572`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4993821892972835, 0.5285387433232237, 0.08580282883530375], 
               
               ArrowBox[{{-3., -0.3886554478170344}, {-2.977520949786697, \
-0.38263949646074696`}, {-2.870524948189473, -0.35514856168178205`}, \
{-2.770829106425937, -0.3304920064853485}, {-2.6777686500268514`, \
-0.30832584484552983`}, {-2.5906788045229763`, -0.2883060907364094}, \
{-2.533575958879578, -0.2754423150230958}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.39927542572668384`, 
                0.5223371303033945, -0.35025761496905317`], 
               
               ArrowBox[{{-2.521869328670126, -0.27280511781030675`}, \
{-2.506574264466707, -0.2693595403926381}, {-2.427773568062643, \
-0.2522317506143498}, {-2.34801517283979, -0.23602434647035328`}, \
{-2.2732124127894333`, -0.221312448286814}, {-2.200639200619619, \
-0.20724944887387295`}, {-2.1325250842108914`, -0.19448424700212838`}, \
{-2.050982907176744, -0.1799142888845442}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.32577102692929333`, 0.522351290776225, -0.5295408604200876], 
               
               
               ArrowBox[{{-2.0391699983326683`, -0.1778035580533948}, \
{-2.0081616022347673`, -0.1722629771065471}, {-1.8974318562176546`, \
-0.1536417175378646}, {-1.7878147416516197`, -0.13639865276138174`}, \
{-1.6901896172634772`, -0.1219422831888367}, {-1.6023040884611017`, \
-0.10954881279955657`}, {-1.5648317578258446`, -0.10453594782853154`}}]}}, {
              Arrowheads[{{0.011822632063367935`, 1.}}], {
               LABColor[
               0.26796155821898293`, 0.5224545147237031, -0.6677023389464533], 
               
               ArrowBox[{{-1.552937712494455, -0.1029448206636413}, \
{-1.5230735793432384`, -0.09894974311106157}, {-1.4512179934983542`, \
-0.08979047916811811}, {-1.3858456233500733`, -0.08185797831183532}, \
{-1.2712571355596862`, -0.068852916981818}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5363325983953953, 0.5309464967394624, 0.25041782267652385`], 
               
               
               ArrowBox[{{-3., -1.0711870166779767`}, {-2.950081052687873, \
-1.0305292262823156`}, {-2.877663685867527, -0.9739144934841095}, \
{-2.8081686702099207`, -0.9216976374257974}, {-2.7414766144934855`, \
-0.8734316253516811}, {-2.676186038747635, -0.8271410352696625}, \
{-2.6147474187343884`, -0.7851619970395963}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.43412095311066057`, 
                0.5242862067962514, -0.20493760557792032`], 
               
               ArrowBox[{{-2.6046544309154753`, -0.7786722993219363}, \
{-2.549227866998599, -0.7433326710454058}, {-2.4876603148689926`, \
-0.7053545028467928}, {-2.4273872763861615`, -0.6687342360189056}, \
{-2.369703265196881, -0.6348297719324698}, {-2.261549912143384, \
-0.5741902147403956}, {-2.190370190694573, -0.5365954949424768}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3533251451706831, 0.5223020904476697, -0.463688020035105], 
               
               ArrowBox[{{-2.1797592752908175`, -0.5309911685517014}, \
{-2.162156608604036, -0.5216940357684321}, {-2.0542162399748283`, \
-0.46834380814374355`}, {-1.9560084873653547`, -0.42274894451479866`}, \
{-1.8661983238155304`, -0.38319234497267707`}, {-1.7839389880313157`, \
-0.34888143871712585`}, {-1.7429028103027593`, -0.332599328057392}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.29031614357508784`, 0.5224145986235178, -0.6142760986860503], 
               
               ArrowBox[{{-1.7317487273115093`, -0.32817367187730867`}, \
{-1.7083298553086073`, -0.31888165964362425`}, {-1.638660570366263, \
-0.2925787108977173}, {-1.574260540515642, -0.2693643429409393}, \
{-1.5145940703720857`, -0.24879648817584676`}, {-1.4191310757655815`, \
-0.2178047518045536}, {-1.334783369202271, -0.19227892262520227`}, \
{-1.2768193778651735`, -0.17575083059874305`}}]}}, {
              Arrowheads[{{0.00810047311264844, 1.}}], {
               LABColor[
               0.24201029417321537`, 0.5225008530135474, -0.7297244451892648], 
               
               ArrowBox[{{-1.2652793540942937`, -0.17246026053148558`}, \
{-1.259611854096884, -0.1708442061612408}, {-1.1923429388355498`, \
-0.1528093067250332}, {-1.0769421348000279`, -0.12428671549052303`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5903356060938533, 0.5344654273669385, 0.49100256846607276`], 
               
               
               ArrowBox[{{-3., -1.6137837680750124`}, {-2.967298971913315, \
-1.5644738692375983`}, {-2.914075201282458, -1.4886584759817334`}, \
{-2.8611519316412677`, -1.4155165887029404`}, {-2.809016458114437, \
-1.3472314627547397`}, {-2.7542050368229463`, -1.2820629799792767`}, \
{-2.7100583498060398`, -1.231860044033434}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.48622960321151215`, 0.5276816977626103, 
                0.027207729881013335`], 
               
               ArrowBox[{{-2.7021340422586895`, -1.2228486429273346`}, \
{-2.7006799117405795`, -1.2211950279860908`}, {-2.6478161798379793`, \
-1.1622828169267203`}, {-2.596275234294912, -1.1072820877349812`}, \
{-2.546073842616626, -1.0558892156267818`}, {-2.4972287723083713`, \
-1.0078005758180306`}, {-2.4035777249300287`, -0.9205388962093226}, \
{-2.3623079445426094`, -0.8843687806733993}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.394949968369568, 0.5222507879923802, -0.36349680646290006`], 
               
               
               ArrowBox[{{-2.3532834271377996`, -0.8764594137195729}, \
{-2.347576993266643, -0.8714581180867821}, {-2.293591670919419, \
-0.8262378671396289}, {-2.241581006555527, -0.7843676611219824}, \
{-2.191504248842137, -0.7453370177879624}, {-2.09684724187891, \
-0.6750824116871803}, {-2.009010227053832, -0.6140500338700399}, \
{-1.9697793095445002`, -0.5883670609033853}}]}}, {
              Arrowheads[{{0.00873471530995412, 1.}}], {
               LABColor[
               0.32540313733496645`, 0.5223519476758127, -0.5304200964937033], 
               
               ArrowBox[{{-1.9597394254427674`, -0.5817943348917693}, \
{-1.9274427048593274`, -0.5606509139799649}, {-1.8515829961778347`, \
-0.5137960870209962}, {-1.7809337413980795`, -0.47243142279202827`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.37966950148206297`, 0.5222550502566268, -0.4007264447083198], 
               
               ArrowBox[{{2.2085974457513284`, -0.9811761114960943}, {
                2.2530132307439636`, -1.031244783091872}, {
                2.2984976837006483`, -1.0849834257039046`}, {
                2.3449515510276315`, -1.1427733788231111`}, {
                2.3924979432138205`, -1.204767994340327}, {
                2.4410820794819954`, -1.271303014226455}, {
                2.4903378693392195`, -1.3430333630925155`}, {
                2.501639756359917, -1.3607247123337765`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4630427554693558, 0.5261708021263877, -0.07609025494339373], 
               
               
               ArrowBox[{{2.508100054459247, -1.3708373058917016`}, {
                2.5398992222925516`, -1.4206139655495282`}, {
                2.57855113242093, -1.485533945998434}, {
                2.6172055774190457`, -1.554465956862955}, {
                2.6556739335552826`, -1.6276964035619543`}, {
                2.6937675770980247`, -1.705511691514295}, {
                2.7312164416556066`, -1.7882286250889765`}, {
                2.7335912525143145`, -1.7939446647812978`}}]}}, {
              Arrowheads[{{0.01999999999999999, 1.}}], {
               LABColor[
               0.5588529976169667, 0.5324139654220639, 0.3507467627247213], 
               
               ArrowBox[{{2.7381952822472275`, -1.8050263122318555`}, {
                2.767750460836364, -1.8761640086549995`}, {
                2.803827057328709, -1.9667086172166932`}, {
                2.8386198103413265`, -2.062858494105974}, {
                2.8673740457961387`, -2.1635463283683434`}, {
                2.8908404045472196`, -2.2592466355283958`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.6567080955178414, 0.5100540543135129, 0.7389463374546066], 
               
               ArrowBox[{{2.893682780120771, -2.270904988367602}, {
                2.918013427152862, -2.3798889118755064`}, {
                2.9392181364494654`, -2.495842230591519}, {
                2.956460221023294, -2.6182415826708634`}, {
                2.968793772562028, -2.7444896877747724`}}]}}, {
              Arrowheads[{{0.005286746723597228, 1.}}], {
               LABColor[
               0.7328651906212447, 0.33639190632982585`, 0.7814312002986762], 
               
               
               ArrowBox[{{2.9696630673011426`, -2.7564570109500406`}, {
                2.9734230204887937`, -2.814370607070118}, {
                2.9761927701206154`, -2.8831612687452575`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3486248554426915, 0.522310483232984, -0.4749214562317913], 
               
               ArrowBox[{{1.9501903477257467`, -1.043100744518209}, {
                2.0080509053434836`, -1.1341136927412134`}, {
                2.0662896814930436`, -1.2360517202713568`}, {
                2.1239008919983955`, -1.3504507047508685`}, {
                2.152140709784646, -1.4128718571484382`}, {
                2.174579412614077, -1.4665202056902453`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4171094640205819, 0.5231777083527515, -0.2807242136329956], 
               
               ArrowBox[{{2.179209778000903, -1.47759087488341}, {
                2.1798270957400256`, -1.4790668103455102`}, {
                2.206618998146669, -1.5492733627409414`}, {
                2.2321753652867082`, -1.6237293127335874`}, {
                2.256480347203204, -1.702702953834078}, {
                2.2792579325304736`, -1.786438183463624}, {
                2.2997768274375385`, -1.8751362058869532`}, {
                2.3115419550540572`, -1.9381349089568185`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.49957504023483973`, 0.5285513098283061, 0.08666198457059711], 
               
               ArrowBox[{{2.3137448919896992`, -1.9499309705392953`}, {
                2.317305738093419, -1.9689982253687939`}, {
                2.329208168785498, -2.0517746634527594`}, {
                2.3384641059125837`, -2.138430506509776}, {
                2.3446588229385226`, -2.229035652962679}, {
                2.347377593327161, -2.323660001234305}, {
                2.3461214238126145`, -2.422302089354866}, {
                2.3458039612510158`, -2.4279896292890113`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5846872608033176, 0.5340973712884991, 0.46583904936278525`], 
               
               
               ArrowBox[{{2.3451351958142417`, -2.4399709794963367`}, {
                2.3403913211289993`, -2.524960455354575}, {
                2.3324242518608496`, -2.6296269602938582`}, {
                2.3193497745158, -2.7382581534161856`}, {
                2.2962981155502167`, -2.8450656792772993`}, {
                2.277864969489983, -2.913866161957556}}]}}, {
              Arrowheads[{{0.003230186365200291, 1.}}], {
               LABColor[
               0.6621537246354625, 0.4976363058633577, 0.7419842265159958], 
               
               ArrowBox[{{2.2747594376787736`, -2.9254573513775233`}, {
                2.266959726348956, -2.95456925134862}, {
                2.253488895372962, -3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.29261406299321674`, 0.5224104954840388, -0.6087841965560707], 
               
               ArrowBox[{{1.618580526656308, 0.7491631119396265}, {
                1.6568495400509113`, 0.7953127510026772}, {
                1.6962221842201577`, 0.8454101906900636}, {
                1.7364216207784546`, 0.9000208117530788}, {
                1.7771710113402097`, 0.9597099949430153}, {1.827840029920429, 
                1.0406845599611465`}, {1.8786532079903964`, 
                1.131078206265285}, {1.8862443651134448`, 
                1.1463214313138625`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.34950374296390024`, 
                0.5223089139011539, -0.47282096297181925`], 
               
               ArrowBox[{{1.8915937521815782`, 1.1570631284793615`}, {
                1.9289569762897765`, 1.2320893760447647`}, {1.977595790399824,
                 1.3450993238876514`}, {2.0009013386485255`, 
                1.4066029229037011`}, {2.0233232471675056`, 
                1.4717051164205963`}, {2.044500157350576, 
                1.5405890379467428`}, {2.0617431750274213`, 
                1.6047738792383655`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.41504988447166236`, 
                0.5230435025397181, -0.28989969187629927`], 
               
               ArrowBox[{{2.0647560572501105`, 1.6163881273901852`}, {
                2.0819763940711566`, 1.6905188892349603`}, {
                2.0979164183406005`, 1.7720322342232995`}, {
                2.1111660098493767`, 1.8580598412545113`}, {
                2.1210003950469836`, 1.948683695627543}, {2.1260885711555026`,
                 2.02739452072098}, {2.1277916151028906`, 
                2.091136945679236}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.4919967359489129, 0.5280574942392747, 0.05290045002189097], 
               
               ArrowBox[{{2.1281121118079622`, 2.1031326649933093`}, {
                2.1282802738139637`, 2.1094267210362054`}, {2.127184075316545,
                 2.1947827699662126`}, {2.1224085479574253`, 
                2.283465140903994}, {2.1134996805992454`, 
                2.3753963041389508`}, {2.100003462104648, 
                2.4704987299604864`}, {2.084213568041841, 
                2.567186787075311}, {2.081511861991142, 
                2.580049877412136}}]}}, {
              Arrowheads[{{0.01801449402477654, 1.}}], {
               LABColor[
               0.5693327048773129, 0.5330968415139167, 0.3974341198670766], 
               
               ArrowBox[{{2.079045255501641, 2.5917936354318654`}, {
                2.0632700029357762`, 2.666901176753181}, {2.0331389507558577`,
                 2.7635676796509934`}, {1.9969953244371454`, 
                2.8618954800987706`}, {1.9575999197759564`, 
                2.9608043939003204`}, {1.9396223330296118`, 3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3256095759696765, 0.5223515790612715, -0.5299267194114916], 
               
               ArrowBox[{{1.724483556189751, -1.1021753179805176`}, {
                1.764583024883088, -1.1949104673696915`}, {
                1.802440344415405, -1.2977928454806902`}, {
                1.8369197642884092`, -1.4119283908631455`}, {
                1.8662396840696178`, -1.5383544896505568`}, {
                1.8697883461306317`, -1.5583711157530902`}}]}}, {
              Arrowheads[{{0.01999999999999999, 1.}}], {
               LABColor[
               0.3838630380100946, 0.5222475623242175, -0.3907041210320631], 
               
               ArrowBox[{{1.8718831100505797`, -1.5701868664325724`}, {
                1.878331815907415, -1.6065615146132486`}, {
                1.8883744541002019`, -1.6783031995777322`}, {
                1.8959134920867031`, -1.7536019397521385`}, {
                1.900494823305641, -1.8324801303445954`}, {
                1.901895295134637, -1.9152021525438807`}, {
                1.8997069918001948`, -2.001838798754253}, {
                1.8963612464146462`, -2.048250840695784}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.4507203776877933, 0.5253678543939021, -0.13098675520229755`], 
               
               ArrowBox[{{1.895498430913534, -2.060219781727097}, {
                1.893198662014359, -2.0921220810070658`}, {
                1.8816390544891755`, -2.1857840113336717`}, {
                1.8689027087450762`, -2.259802580876644}, {
                1.8526744038573366`, -2.3357261559976177`}, {
                1.8326587547379276`, -2.4134050409021537`}, {
                1.8085603762988205`, -2.4926895397958124`}, {
                1.7959694719912855`, -2.5283471806625566`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.5183032333117595, 0.5297716717122896, 0.170096551690773], 
               
               ArrowBox[{{1.791973978566204, -2.539662481466783}, {
                1.7800785526083152`, -2.573350516607318}, {
                1.7469125677347117`, -2.6551588352653943`}, {
                1.711404502269559, -2.7375408248467563`}, {
                1.670862004897517, -2.8207519696599284`}, {
                1.6224634992894986`, -2.899602382525602}, {
                1.5765374107974652`, -2.9665762746274265`}}]}}, {
              Arrowheads[{{0.0012097547137552738`, 1.}}], {
               LABColor[
               0.5799217170543624, 0.5337868401057099, 0.444608433138717], 
               
               ArrowBox[{{1.5697509565631116`, -2.976472942699309}, {
                1.5687710234430345`, -2.977901976549262}, {
                1.552738492799681, -3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.19857654656523147`, 0.5225784078325396, -0.8335287340252526], 
               
               ArrowBox[{{0.36830062698795657`, -0.40914802955035856`}, {
                0.36428851670105405`, -0.4358701450659811}, {
                0.3578653129331928, -0.46389994458501715`}, {
                0.34385541508075534`, -0.5065886665644007}, {
                0.3228314838830343, -0.5507626946551649}, {
                0.2629535999972347, -0.6300054735947112}, {
                0.2053672648701803, -0.6771113826450221}, {
                0.13518385937303773`, -0.7135191977092225}, {
                0.06022800682756043, -0.7335504765587518}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.20645459123238902`, 0.5225643408831783, -0.8147006367707087], 
               
               ArrowBox[{{0.048471305310524085`, -0.7358668832627856}, {
                0.039780718480535784`, -0.7371919515129646}, {
                0.023747268901880544`, -0.7389287660384194}, \
{-0.01148111220357776, -0.7378011647170412}, {-0.04615278602908771, \
-0.7333895666965122}, {-0.11339471199296422`, -0.7184370679392672}, \
{-0.17499177800205365`, -0.6922271747841824}, {-0.22858741788661746`, \
-0.6571256717303381}, {-0.2995680807680127, -0.5830225358559731}, \
{-0.3390756652024162, -0.5107368648639193}}]}}, {
              Arrowheads[{{0.009077508364143217, 1.}}], {
               LABColor[
               0.20073520504071293`, 0.5225745533558585, -0.828369657955889], 
               
               
               ArrowBox[{{-0.3438344464448401, -0.49980224060102935`}, \
{-0.3632283233258575, -0.430139413119038}, {-0.36831005484667545`, \
-0.3649715367472655}, {-0.3585075397159912, -0.28539053983869644`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5119440342395956, 0.5293572951555946, 0.141766161266141], 
               
               ArrowBox[{{-3., -0.7010254300874337}, {-2.936251682075316, \
-0.6693374210880971}, {-2.862323337368841, -0.6337934807620443}, \
{-2.7867658553195334`, -0.5996844958205602}, {-2.7148688057905543`, \
-0.5682009896793518}, {-2.644663084796628, -0.5378849279536122}, \
{-2.5778400208728076`, -0.5099037550588104}, {-2.562575256133836, \
-0.5037012676927889}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4107289765345696, 0.5227619446057, -0.30914944447212], 
               
               ArrowBox[{{-2.551457956062887, -0.4991840075572111}, \
{-2.514180883041571, -0.4840373231234389}, {-2.4534669403253955`, \
-0.46006548427599037`}, {-2.3401411370525733`, -0.41712896792765686`}, \
{-2.2197972884350317`, -0.3742880582970152}, {-2.11094883166721, \
-0.33774670514471783`}, {-2.100717506315725, -0.3344775621258105}}]}}, {
              Arrowheads[{{0.014209474936622004`, 1.}}], {
               LABColor[
               0.33505134217396965`, 0.5223347199480411, -0.5073614129351018], 
               
               ArrowBox[{{-2.0892868346677957`, -0.3308252004683029}, \
{-2.011818050461251, -0.3060721478214815}, {-1.9213889938089728`, \
-0.27862901555003605`}, {-1.838542137906479, -0.2546528165158411}, \
{-1.7624352687939984`, -0.23364863280309311`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.32432934840742567`, 0.5223538650214368, -0.5329863934890572], 
               
               ArrowBox[{{1.4893450062258855`, 1.3893256718896176`}, {
                1.4929441791011735`, 1.4538681759024537`}, {
                1.4937021273577598`, 1.5214640706505937`}, {
                1.4909430142217504`, 1.591897845901095}, {1.4781554560368417`,
                 1.7069266771076759`}, {1.454549763184926, 
                1.8286763869089406`}, {1.4451344042415986`, 
                1.8649904813014284`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.37190008543344166`, 
                0.5222689232399291, -0.41929492548684216`], 
               
               ArrowBox[{{1.4421226803793612`, 1.8766063979410066`}, {
                1.4381844056304847`, 1.8917959283492554`}, {1.418103093152579,
                 1.9560444035715918`}, {1.3943058257512098`, 
                2.0214218125759507`}, {1.3667926034263764`, 
                2.0879281553623317`}, {1.335090977454484, 
                2.1550044728953175`}, {1.2987284991119359`, 
                2.2220918061394896`}, {1.257705168398734, 2.28919015509485}, {
                1.2429031395449979`, 2.3109341085836697`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.41650307932615843`, 0.5231381952633111, -0.2834256725660453], 
               
               ArrowBox[{{1.2361503850345292`, 2.3208538014479343`}, {
                1.2120209853148765`, 2.356299519761397}, {1.141960472675808, 
                2.446179850642162}, {1.062270295628707, 
                2.5334198785918525`}, {0.9729508765959358, 
                2.6166590974455137`}, {0.9078003385222759, 
                2.6679362843373737`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.45544298960006935`, 
                0.5256755880629709, -0.10994740138108346`], 
               
               ArrowBox[{{0.8983706726314528, 2.6753579688622944`}, {
                0.874002637999857, 2.6945370010381904`}, {0.8210423272777547, 
                2.731102182986747}, {0.7659240434891801, 
                2.7656004828702296`}, {0.7086477866341336, 
                2.798031900688641}, {0.649213556712615, 2.828396436441979}, {
                0.5878437450990133, 2.858142727630818}, {0.5244888685464493, 
                2.8853614921594684`}, {0.47698351211951684`, 
                2.900611301659803}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.480864129218517, 0.5273320740736798, 0.003304409461287324], 
               
               ArrowBox[{{0.4655577849789651, 2.9042791019964707`}, {
                0.45539135388103513`, 2.907542652661124}, {
                0.38487592476736976`, 2.9264090939390917`}, {
                0.26516735032807986`, 2.9531389312483256`}, {
                0.14276652999213213`, 2.9699925670808565`}, {
                0.018926208228642886`, 
                2.976730212265482}, {-0.007153923207800371, 
                2.9759693991608405`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.48844342141407926`, 0.5278259540366345, 0.03707034517205172], 
               
               ArrowBox[{{-0.01914882038387568, 
                2.975619482405911}, {-0.10510087049327127`, 
                2.973112077631001}, {-0.2280524686309342, 
                2.959320619349181}, {-0.3486663486416696, 
                2.935538293591789}, {-0.45455962009181866`, 
                2.906057206202799}, {-0.4898259759475232, 
                2.8935097269670567`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.47903080189857605`, 
                0.5272126112524171, -0.004863109460619252], 
               
               ArrowBox[{{-0.5011317090052586, 
                2.889487240170655}, {-0.5572611309414341, 
                2.8695168536884217`}, {-0.6557266165474255, 
                2.8263314594305213`}, {-0.7489118122667021, 
                2.7769152468109586`}, {-0.8365154583004815, 
                2.7219934033337383`}, {-0.9186608690467292, 
                2.6624688102869434`}, {-0.9206489881709649, 
                2.6608151693188486`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.45315774559695343`, 
                0.5255266775586018, -0.12012822039447361`], 
               
               ArrowBox[{{-0.9298747713337169, 
                2.6531415179693356`}, {-0.9949406411574767, 
                2.5990222317285583`}, {-1.0649473712847541`, 
                2.5323344317165657`}, {-1.1287230612645527`, 
                2.4630869653994067`}, {-1.1865665158951255`, 
                2.3919618399772125`}, {-1.238455536271898, 
                2.3196404975855023`}, {-1.2511757927818603`, 
                2.299460887017802}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.41319637911228646`, 0.5229227248820418, -0.2981571044670013], 
               
               ArrowBox[{{-1.2575748019997217`, 
                2.2893094003764416`}, {-1.2843679234902945`, 
                2.246804380359794}, {-1.32460019317688, 
                2.173899161998806}, {-1.3596309835474405`, 
                2.101235791380226}, {-1.3897112795812359`, 
                2.029293623408032}, {-1.4150920662575233`, 
                1.9585520129861964`}, {-1.4393503555079592`, 
                1.877296670102004}, {-1.445809246907631, 
                1.8501696982916127`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3678811047744987, 0.5222760994873106, -0.42890007015251874`], 
               
               ArrowBox[{{-1.448588729312415, 
                1.8384960323052357`}, {-1.4582135052928473`, 
                1.7980725276282887`}, {-1.472195965461153, 
                1.7213019503239957`}, {-1.4818121858618416`, 
                1.64740730294807}, {-1.4875172380527926`, 
                1.57644783825216}, {-1.4897322631398366`, 
                1.5082753164123162`}, {-1.4889208152938656`, 
                1.4430008633240852`}, {-1.4855464486857712`, 
                1.3807356048830155`}, {-1.4833968270240487`, 
                1.3619963252335}}]}}, {
              Arrowheads[{{0.012113062277803038`, 1.}}], {
               LABColor[
               0.32018102532102294`, 0.5223612722212252, -0.5429006595047944], 
               
               ArrowBox[{{-1.482029250584567, 
                1.3500745076421183`}, {-1.472252547283082, 
                1.2648463112207682`}, {-1.4521377351315088`, 
                1.1598347139823924`}, {-1.4272088128539158`, 
                1.0650525582731456`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.5622352848804913, 0.5326343611879627, 0.3658149368165418], 
               
               ArrowBox[{{-1.3588414763286314`, 3.}, {-1.4048962407492545`, 
                2.9463381474167063`}, {-1.4628973063036046`, 
                2.8709844596450056`}, {-1.5155020970726096`, 
                2.7947530940837164`}, {-1.565408750448942, 
                2.7180828896276323`}, {-1.6100967297955768`, 
                2.6410604297293894`}, {-1.627106316740238, 
                2.6037070518840886`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.5080769952653239, 0.5291053121186461, 0.1245384062163057], 
               
               ArrowBox[{{-1.6320794088292112`, 
                2.5927860466613724`}, {-1.6470942689791273`, 
                2.559813126960333}, {-1.6791694726717648`, 
                2.4795791853514957`}, {-1.7089677771591105`, 
                2.4000019605559384`}, {-1.734212283235873, 
                2.3217381693869403`}, {-1.7552163080536618`, 
                2.245000521947275}, {-1.7722931687640862`, 
                2.170001728339715}, {-1.7783855604669283`, 
                2.1368823206746717`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4451063668240856, 0.5250020356068894, -0.15599731357798333`], 
               
               ArrowBox[{{-1.7805565621601989`, 
                2.1250803398389047`}, {-1.7857451735141505`, 
                2.0968740551762117`}, {-1.795874630450859, 
                2.0257497690687156`}, {-1.8041797515209244`, 
                1.937582246374335}, {-1.8078796395141397`, 
                1.8527849229296}, {-1.807677762498112, 
                1.7715715591535734`}, {-1.8042775885404476`, 
                1.6941559154653187`}, {-1.8002952489579582`, 
                1.6469849525154672`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3819983552762529, 0.5222508918810683, -0.39516061110605327`], 
               
               ArrowBox[{{-1.7992857576056256`, 
                1.635027489272389}, {-1.7980552022128011`, 
                1.6204515141099751`}, {-1.7891996118034237`, 
                1.5502003126618666`}, {-1.7781336709548206`, 
                1.4833587245338355`}, {-1.7652802333094944`, 
                1.4198831631387234`}, {-1.7351226189284978`, 
                1.3024132004491626`}, {-1.7005502712600784`, 
                1.196556584396995}, {-1.6898102188155757`, 
                1.1691764429684173`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.3254717729176384, 0.522351825120876, -0.5302560611930333], 
               
               ArrowBox[{{-1.6854281988195445`, 
                1.1580051448901103`}, {-1.663174893393679, 
                1.1012737040557223`}, {-1.6240065572734428`, 
                1.0154978908938075`}, {-1.5925253419832304`, 
                0.9541127122397409}, {-1.56065662700592, 
                0.8976056510149323}, {-1.528795281393535, 
                0.8455196765784273}, {-1.4973361741980984`, 
                0.7973977582892713}, {-1.4551188150631709`, 
                0.7386388508319067}}]}}, {
              Arrowheads[{{0.004802644890951051, 1.}}], {
               LABColor[
               0.27466059650541674`, 0.5224425529950857, -0.6516920026640624], 
               
               ArrowBox[{{-1.4481168892072052`, 
                0.7288934398961093}, {-1.4358568121746234`, 
                0.7118296361305715}, {-1.3766828151685984`, 
                0.6384683764939639}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.5261179324289779, 0.5302808912028342, 0.20491123110707224`], 
               
               
               ArrowBox[{{-0.9337109770812834, 3.}, {-0.9826649685681716, 
                2.9655772833019323`}, {-1.0513308234446863`, 
                2.9144676944506407`}, {-1.1161358261868697`, 
                2.860727492775107}, {-1.1732829094500503`, 
                2.80270665580282}, {-1.2264019119093266`, 
                2.7433445126338074`}, {-1.2775426049281087`, 
                2.683496477129432}, {-1.2840085490298474`, 
                2.6751619370390287`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.4853863686639509, 0.5276267511216356, 0.023451098946699875`], 
               
               ArrowBox[{{-1.2913641525100226`, 
                2.665680634520786}, {-1.3247266790659027`, 
                2.6226766569543303`}, {-1.3680396065165241`, 
                2.5611786212072536`}, {-1.407566859473788, 
                2.4992959389869527`}, {-1.443434926506066, 
                2.437275561775902}, {-1.4757702961817292`, 
                2.375364441056576}, {-1.5136448615720275`, 
                2.292880426798357}, {-1.5300120783225337`, 
                2.251320199038111}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.43349441470454225`, 
                0.5242453804556354, -0.20772884979907638`], 
               
               ArrowBox[{{-1.5344092110529628`, 
                2.240154840837364}, {-1.5458220557014828`, 
                2.2111749336109185`}, {-1.5727078333500746`, 
                2.130835526345982}, {-1.5947081492977826`, 
                2.05244976985527}, {-1.6122069014637979`, 
                1.976181280768182}, {-1.6255753838468614`, 
                1.9019514195870788`}, {-1.6352006453462773`, 
                1.8299843669731208`}, {-1.6402723919457782`, 
                1.7737744062823217`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3782842890300066, 0.5222575236766492, -0.4040370269488915], 
               
               ArrowBox[{{-1.6413507545750736`, 
                1.7618229572471737`}, {-1.6414697348613492`, 
                1.7605043035874688`}, {-1.6447071336054895`, 
                1.6935350496595047`}, {-1.645201569828743, 
                1.6289859337433077`}, {-1.643286462985364, 
                1.5669093989870857`}, {-1.6392952325296057`, 
                1.507357888539046}, {-1.6259137658068221`, 
                1.3955579965412688`}, {-1.6067158997121316`, 
                1.2930423696974889`}, {-1.6047272725112487`, 
                1.284890660627025}}]}}, {
              Arrowheads[{{0.007803893159394735, 1.}}], {
               LABColor[
               0.32561249707288936`, 0.5223515738453819, -0.5299197381340673], 
               
               ArrowBox[{{-1.6018832510225958`, 
                1.2732325500694741`}, {-1.5893965852259047`, 
                1.2220476589096096`}, {-1.5699726025707896`, 
                1.1556664931761993`}, {-1.5490077667862938`, 
                1.0936726360232303`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019478464836797764`, 1.}}], {
               LABColor[
               0.18948038068425208`, 0.5225946498456578, -0.8552680745705681], 
               ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAYVdElJUKwD9Nt7Pndky4P5bSYePX
kcA/frfyuFUxvz9cfwRdICfAP1zHynpWAcQ/ELgFhrRpvj/MeSGot+zGPxVi
mR3X/Lo/G1kJJaX1yT8iLg70Y7+1P63LN3/H18w/H/IpgVppsj+RPplsjCDO
P82JUkOhPq0/w5jSzNw5zz/5Pn4busKdPzPH7EtAQNA/AU9A5gy1Vb9hi0ge
OnbQP+UEvPJC+Wu/lVZH2t910D/xWtD0TYt2v6CVZyr3dNA/JYih/bH3kL9a
7PenPl3QPylKtFyBAZy/SPpLvYo20D+91X6rkqCov7Bn5I9nm88/qui8JzUg
sb/VdmpkOWbOPyx63PAoTbW/Hz/YOSvkzD9OCblHJ4G8v0LxZKyItMg/zebf
CusSwL/kJy+R2WPEPxdWeGrslsC/eKlzDzCNwD/O0eFCUCzAvxA4C06kPrk/
oBCsnA==
                "]]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.299329035466581, 0.5223985053035136, -0.5927357784356255], 
               
               ArrowBox[{{1.8353660318405671`, -0.1238006572540834}, {
                1.923549320334657, -0.13605211658977262`}, {
                2.020503365731637, -0.15017320957336272`}, {
                2.127694528861219, -0.16660792427907167`}, {
                2.185525281113474, -0.1758019628105995}, {
                2.246390814644165, -0.18570529441211153`}, {
                2.3098319158483194`, -0.19633829302642097`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3662428533695063, 0.5222790247308867, -0.43281540169527827`], 
               
               ArrowBox[{{2.3216563942054043`, -0.19838313580816008`}, {
                2.3791118383792673`, -0.20834523395442078`}, {
                2.442385955455529, -0.2196824333837542}, {
                2.509084372646419, -0.23196556410078725`}, {
                2.5795073084650877`, -0.2453113919988945}, {
                2.6539549814246843`, -0.25983668297145046`}, {
                2.7328060798954077`, -0.27569927381566606`}, {
                2.7931470697805407`, -0.28822279683768204`}}]}}, {
              Arrowheads[{{0.008313465653193273, 1.}}], {
               LABColor[
               0.45498975374845096`, 
                0.5256460544205368, -0.11196657840087434`], 
               
               ArrowBox[{{2.804896678877488, -0.29066137963696026`}, {
                2.816439292247456, -0.29305700132875223`}, {
                2.902463561540166, -0.31116229717627375`}, {
                2.993763298205133, -0.3309744280802434}, {
                3., -0.33241554500036524`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.25131504546448113`, 0.5224842385526293, -0.7074865968851495], 
               
               ArrowBox[{{1.3838760249063602`, 0.016317517193140497`}, {
                1.446456637988953, 0.01782474138220931}, {1.5149895512356861`,
                 0.019553104334172875`}, {1.590327960087131, 
                0.021546422978899273`}, {1.673609656420722, 
                0.0238664327600907}, {1.76597513265673, 
                0.026570994352710587`}, {1.8636910948543282`, 
                0.02959336956393101}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3037562266965422, 0.5223906001598547, -0.5821550327602842], 
               
               ArrowBox[{{1.8756851145549442`, 0.029972106331884713`}, {
                1.9251882063120918`, 0.031561831791206134`}, {
                1.9844694425608416`, 0.03351090454194778}, {
                2.0475817328354653`, 0.03565399395820127}, {
                2.1151344282216975`, 0.038036320749074835`}, {
                2.1793793665158834`, 0.04038691992483144}, {
                2.2476427582521996`, 0.04296151275406047}, {
                2.3203425917154314`, 0.04579236389280898}, {2.355374250915006,
                 0.04720140119961884}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.37205678563121225`, 0.5222686434377904, -0.4189204205572459], 
               
               ArrowBox[{{2.3673645559050245`, 0.04768367316266561}, {
                2.397896855190366, 0.04891173799712406}, {2.480857310371881, 
                0.0523654376886783}, {2.569775718954857, 
                0.05619926558914431}, {2.661673104238562, 
                0.060223157594066185`}, {2.760261556308562, 
                0.06468983956479767}, {2.8468938710930662`, 
                0.06890200153112888}}]}}, {
              Arrowheads[{{0.005887585069478305, 1.}}], {
               LABColor[
               0.46318286882812265`, 0.526179932158408, -0.07546604643654785], 
               
               ArrowBox[{{2.8588797121002454`, 0.06948476679315053}, {
                2.8591185726023984`, 0.06949638046323346}, {2.965457211091426,
                 0.07486644428078301}, {3., 0.07664903102985952}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.6005266766221056, 0.5351294953834623, 0.5364040417701781], 
               
               ArrowBox[{{-1.6964861044813329`, 3.}, {-1.7113230929823273`, 
                2.9760017545927946`}, {-1.760929837851468, 
                2.8907622349263504`}, {-1.8049087737107794`, 
                2.805564316324658}, {-1.8406291211203576`, 
                2.716038705495038}, {-1.8711236655290047`, 
                2.627979603957223}, {-1.8918897062039146`, 
                2.563538487600902}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.5347663474125331, 0.5308444370804025, 0.24344013549549565`], 
               
               
               ArrowBox[{{-1.895570301323383, 
                2.5521168756495816`}, {-1.899218242769118, 
                2.540796594482566}, {-1.9225128856721636`, 
                2.4553657691342243`}, {-1.9413644541751474`, 
                2.3718847030883965`}, {-1.956129808215075, 
                2.2905509715212813`}, {-1.967144413695159, 
                2.2114775046064823`}, {-1.9747437365186111`, 
                2.1347772325176027`}, {-1.9775880839451212`, 
                2.0804539600728833`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.46386044590304015`, 
                0.5262240842681334, -0.07244742367331047], 
               
               ArrowBox[{{-1.9782155402145396`, 
                2.0684703755244285`}, {-1.9796586549730033`, 
                2.040908793046014}, {-1.979964437251243, 
                1.9508737337407462`}, {-1.9764100203649377`, 
                1.8648318673460749`}, {-1.969744341325694, 
                1.7829430066062757`}, {-1.9603479831998871`, 
                1.705090159036259}, {-1.9483910410851868`, 
                1.6309981577341537`}, {-1.940423058390173, 
                1.5911655995454175`}}]}}, {
              Arrowheads[{{0.018456335688360095`, 1.}}], {
               LABColor[
               0.3931106107676634, 0.5222310499606563, -0.3686029263061896], 
               
               ArrowBox[{{-1.9380692469208392`, 
                1.5793987150143773`}, {-1.9343067200401438`, 
                1.5605895538190642`}, {-1.9185282251233078`, 
                1.493786898410095}, {-1.8827867444339679`, 
                1.3703083577060151`}, {-1.8429626605365845`, 
                1.2591803848129055`}, {-1.8006570432600708`, 
                1.1592310964980552`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.5384375532846877, 0.5310836592891993, 0.25979544919256253`], 
               
               
               ArrowBox[{{-1.0970491305625363`, -3.}, {-1.1202384826009533`, \
-2.9807780664308243`}, {-1.1859068367400283`, -2.923308585133608}, \
{-1.2473512436866754`, -2.863641908264846}, {-1.301229330309457, \
-2.799755316658668}, {-1.3508115611091391`, -2.7349697517584146`}, \
{-1.398311689117603, -2.6699188073071936`}, {-1.4155488363697608`, \
-2.643833254769972}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.49229515923698774`, 0.5280769400237433, 
                0.054229933211050664`], 
               
               ArrowBox[{{-1.4221644712539379`, -2.6338215928160675`}, \
{-1.441647611543631, -2.604337103754037}, {-1.4809524304151294`, \
-2.5385118218528304`}, {-1.516359247760005, -2.47273014235746}, \
{-1.5480340462278879`, -2.4072237783018187`}, {-1.5761428084684077`, \
-2.3422244427197985`}, {-1.608673232923973, -2.255199666473378}, \
{-1.6256069708794891`, -2.2009802968427996`}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.43628241042778404`, 
                0.5244270511432122, -0.19530825933708204`], 
               
               ArrowBox[{{-1.6291843817033589`, -2.1895259469355697`}, \
{-1.63540375318948, -2.1696124226822877`}, {-1.656848689424874, \
-2.0860148542067907`}, {-1.6735223617900972`, -2.0049591039071477`}, \
{-1.6858413783309931`, -1.9265570069095268`}, {-1.6941665115996312`, \
-1.8506687939206117`}, {-1.6989283285152965`, -1.77746920117144}, \
{-1.7003412140876764`, -1.7164667844191586`}}]}}, {
              Arrowheads[{{0.01953144428936138, 1.}}], {
               LABColor[
               0.37822457269176535`, 
                0.5222576303054818, -0.40417974574163706`], 
               
               ArrowBox[{{-1.7005111250638179`, -1.704469689511552}, \
{-1.699384787244012, -1.6396396209863748`}, {-1.6956847218991886`, \
-1.5748571623065781`}, {-1.6898024865499424`, -1.5127930105160372`}, \
{-1.6820833677834106`, -1.4534545872771307`}, {-1.6619251243393398`, \
-1.3425841085327053`}, {-1.6367912802486744`, -1.2415040902302719`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.6065225904668815, 0.5355201996380458, 0.5631159874487635], 
               
               ArrowBox[{{-1.7433502318516187`, -3.}, {-1.75910507102912, \
-2.97447352512356}, {-1.8057727491958449`, -2.8895814909349413`}, \
{-1.8441862149823376`, -2.8002361504670414`}, {-1.8773333140206976`, \
-2.7121453352533123`}, {-1.9080496561757416`, -2.624833746200851}, \
{-1.928024966160295, -2.5585813053571234`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5389205104242514, 0.5311151296228456, 0.26194703529121055`], 
               
               
               ArrowBox[{{-1.9314889799422859`, -2.5470921535817235`}, \
{-1.933904484564154, -2.5390806094709273`}, {-1.9552399109099472`, \
-2.455099744794343}, {-1.972398046937134, -2.3731049719019}, \
{-1.9857055581134548`, -2.2932259652236873`}, {-1.9954891099066498`, \
-2.215592399189792}, {-2.0030780150565897`, -2.1192489921299456`}, \
{-2.0043959951065893`, -2.0739246866156456`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4667776845211202, 0.5264141766492492, -0.05945105289231267], 
               
               
               ArrowBox[{{-2.004744794231094, -2.0619297568880173`}, \
{-2.0057702001363906`, -2.0266668479177063`}, {-2.004326537323782, \
-1.9380503782069032`}, {-1.999507898796493, -1.8536039946513643`}, \
{-1.9917148876540054`, -1.773225294712426}, {-1.9811422389510873`, \
-1.6966365534557144`}, {-1.9682420227983988`, -1.6237791989414931`}, \
{-1.9600027349813833`, -1.58520026091005}}]}}, {
              Arrowheads[{{0.0036240199572217333`, 1.}}], {
               LABColor[
               0.3948811281393578, 0.5222278885444339, -0.36437148631396765`], 
               
               ArrowBox[{{-1.957496421566006, -1.5734649128937404`}, \
{-1.9534663093065987`, -1.5545946592300255`}, {-1.9370826168881774`, \
-1.4889269533590677`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.6472465873253221, 0.5316292710894047, 0.7336681571706628], 
               
               ArrowBox[{{-3., -2.042071706387327}, {-2.987427055564831, \
-2.009511087366901}, {-2.948357750370442, -1.9135649241820416`}, \
{-2.9081361143519313`, -1.8233957702424684`}, {-2.8634511317996765`, \
-1.7375207640333874`}, {-2.818601485917469, -1.6569116967764765`}, \
{-2.7918879134318817`, -1.6103091744176237`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5427498576461249, 0.531364656599149, 0.2790068726443191], 
               
               ArrowBox[{{-2.7859201795600144`, -1.5998983073819457`}, \
{-2.7737854269172044`, -1.5787289156182345`}, {-2.729036541680825, \
-1.5053987066573304`}, {-2.684519475319579, -1.4365906625000497`}, \
{-2.640398872944716, -1.3719743757526777`}, {-2.5967801401966986`, \
-1.3112648489598322`}, {-2.5537686827159907`, -1.25417708466613}, \
{-2.5143194638220754`, -1.204716319395417}}]}}, {
              Arrowheads[{{0.013231142340898233`, 1.}}], {
               LABColor[
               0.44607662888853744`, 
                0.5250652595834936, -0.15167477188866102`], 
               
               ArrowBox[{{-2.506836939871541, -1.1953348570717874`}, \
{-2.4992888866343943`, -1.1858712352338674`}, {-2.4459433561110817`, \
-1.122853270023047}, {-2.3939246162124372`, -1.0644794424310422`}, \
{-2.343425192004843, -1.0101060058552263`}, {-2.2944405174541824`, \
-0.9594289052093885}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.37153581585490975`, 
                0.5222695736756567, -0.42016550992006624`], 
               
               ArrowBox[{{2.2559061427978935`, -0.7092780469405264}, {
                2.3079015809838377`, -0.7460165076279232}, {
                2.3619854786890304`, -0.785410587379016}, {
                2.4182500831748737`, -0.8279450920695758}, {
                2.4767876417027703`, -0.8741048275753726}, {
                2.5754513392512393`, -0.9564613523336871}, {
                2.627138443171245, -1.001861011033433}, {
                2.6323370421127996`, -1.0065944574859804`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4569192712548884, 0.5257717851629349, -0.10337052979975177`], 
               
               ArrowBox[{{2.6412099934132254`, -1.0146734880726458`}, {
                2.6804416035934677`, -1.0503947907011308`}, {
                2.7353798829584637`, -1.102357353029818}, {
                2.7919723437067883`, -1.1580433597125326`}, {
                2.849391895146778, -1.2155910885722607`}, {
                2.908476811363017, -1.277241324203381}, {
                2.9651658386241397`, -1.3417372827707212`}, {
                2.97761100379823, -1.3565837950057023`}}]}}, {
              Arrowheads[{{0.0009521537894221347, 1.}}], {
               LABColor[
               0.5596589604588611, 0.5324664833733748, 0.3543373472809686], 
               
               ArrowBox[{{2.9853198967422347`, -1.3657801513264354`}, {
                3., -1.3832928423657598`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.6725722838306551, 0.47387871156074246`, 0.7477963055854455], 
               
               
               ArrowBox[{{-2.2646736989886045`, -3.}, {-2.270345273071087, \
-2.9813760662168494`}, {-2.30068580615014, -2.871341744165159}, \
{-2.3246636314611036`, -2.763954475522022}, {-2.3385745971655725`, \
-2.6546197566927487`}, {-2.347296373358659, -2.5492311999246664`}, \
{-2.3485655812826445`, -2.5288764216254664`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.599529789063649, 0.5350645364430049, 0.5319628828411926], 
               
               ArrowBox[{{-2.349312382470896, -2.5168996821699543`}, \
{-2.3537428924447017`, -2.445845880373614}, {-2.355638897316655, \
-2.346467035256621}, {-2.3534880567730863`, -2.25110246397995}, \
{-2.347794039612561, -2.159759965949865}, {-2.338976469899569, \
-2.0723739287567}, {-2.3342368721165725`, -2.0380265197077216`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.5140558691088554, 0.5294949060168842, 0.1511744382644772], 
               
               ArrowBox[{{-2.332596535900617, -2.0261391609977886`}, \
{-2.327454971698599, -1.9888787399907886`}, {-2.3103408967245866`, \
-1.8943313462322566`}, {-2.2901769672239096`, -1.8049517277585134`}, \
{-2.267700538036597, -1.7205460631708243`}, {-2.243648964002678, \
-1.6409205310704547`}, {-2.2183024629082526`, -1.5658325249575435`}, \
{-2.2165781339955966`, -1.5612454670341422`}}]}}, {
              Arrowheads[{{0.0024482945298685216`, 1.}}], {
               LABColor[
               0.43066235633105715`, 
                0.5240608385685446, -0.22034574046654784`], 
               
               ArrowBox[{{-2.212355675489906, -1.5500128874476127`}, \
{-2.1916800313657467`, -1.4950115611315866`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.22828919573428494`, 0.5225253532550511, -0.7625171224032371], 
               
               ArrowBox[{{0.7387555871081619, -0.8158664211541428}, {
                0.7299587481003618, -0.8782215933456369}, {
                0.7146536505535582, -0.9442052463440649}, {
                0.6915038291162188, -1.013250372082667}, {
                0.6593073815212587, -1.084270231410241}, {
                0.6166466792437524, -1.1562334575374371`}, {
                0.5628046724433523, -1.2269584767823114`}, {
                0.5441983886972793, -1.24504270585661}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.24952316697323645`, 0.5224874381110303, -0.7117690887885184], 
               
               ArrowBox[{{0.5355932446638996, -1.2534064069610726`}, {
                0.4719310563725494, -1.3152823630705186`}, {
                0.4186301320569315, -1.3550752366744303`}, {
                0.3603226970815608, -1.3908457542293826`}, {
                0.29752124379060524`, -1.4217942484907187`}, {
                0.23073826452823315`, -1.4471210522137823`}, {
                0.19176562404008543`, -1.4598803746730085`}, {
                0.15176945199426276`, -1.470579737384782}, {
                0.11960974634372434`, -1.4749275160105795`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.26036132707647597`, 0.5224680856123097, -0.6858664770230867], 
               
               ArrowBox[{{0.10771792908584384`, -1.4765352107282343`}, {
                0.09968366759927558, -1.4776213895243013`}, {
                0.04718020260348712, -1.4809516117471369`}, \
{-0.020075080927524552`, -1.4821794965363941`}, {-0.08707181235221301, \
-1.4773149319315257`}, {-0.15301938520948338`, -1.4665435138856449`}, \
{-0.2171271930382409, -1.4500508383518667`}, {-0.33722094753942783`, \
-1.4016469486361873`}, {-0.35639417526765604`, -1.3901697936499793`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.2557670209056396, 0.5224762891545573, -0.6968466182962473], 
               
               ArrowBox[{{-0.3666904299729056, -1.3840064228965177`}, \
{-0.4256831829748435, -1.3486931736688197`}, {-0.5029136279795475, \
-1.2869619742654483`}, {-0.5677700502362173, -1.219272467570229}, \
{-0.6208033188266184, -1.1482017026520934`}, {-0.6624473124947956, \
-1.076048273791556}, {-0.6812478268425483, -1.0333604733006583`}}]}}, {
              Arrowheads[{{0.012343632570958123`, 1.}}], {
               LABColor[
               0.2383052229723415, 0.522507468747675, -0.7385793633640603], 
               
               ArrowBox[{{-0.6860845441801804, -1.022378389463979}, \
{-0.6938654703466163, -1.0047112864431023`}, {-0.7161644073546134, \
-0.9356561814091386}, {-0.7307586945388969, -0.8697149904269776}, \
{-0.739553925342523, -0.7989390215959128}, {-0.7416000585524226, \
-0.7334518890235201}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.40568862682066914`, 0.5224335065846092, -0.3316043281219391], 
               
               ArrowBox[{{1.9552424268128872`, 1.6736761620211744`}, {
                1.965617632816447, 1.7482137913921934`}, {1.9733943480577874`,
                 1.8264349303724559`}, {1.9781032753718095`, 
                1.9083622580401964`}, {1.9795128135886821`, 
                1.994267511686497}, {1.9772012047423597`, 
                2.084223182032161}, {1.9722775209664964`, 
                2.1522174017088758`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.47784691055596257`, 
                0.5271354668176407, -0.010137374910712968`], 
               
               ArrowBox[{{1.9714108310804932`, 2.1641860628136738`}, {
                1.9704139164734222`, 2.1779530783000056`}, {
                1.9583964164224499`, 2.2751810097128478`}, {
                1.9452213019206748`, 2.3517645509533334`}, {
                1.9284556076322625`, 2.4303079955417264`}, {
                1.9077973470611942`, 2.5106586387801206`}, {
                1.8829445337114497`, 2.5926637759706104`}, {
                1.8691515022957457`, 2.6318633743201674`}}]}}, {
              Arrowheads[{{0.016424950722030627`, 1.}}], {
               LABColor[
               0.5481101104030685, 0.5317139400631876, 0.3028869323272505], 
               
               ArrowBox[{{1.8651684786834954`, 2.6431830705574457`}, {
                1.8535896063731958`, 2.6760900603427213`}, {1.8194250038366, 
                2.76070414512598}, {1.7828555637008328`, 
                2.8459121301148125`}, {1.7411180744547121`, 
                2.931984061951266}, {1.6996094917763984`, 3.}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5560892730059787, 0.5322338762826992, 0.3384343006729847], 
               
               ArrowBox[{{-2.9979869984053478`, 
                1.301792865134645}, {-2.9249790290405207`, 
                1.225442028494449}, {-2.8544157726145416`, 
                1.155249563452207}, {-2.7862831174126477`, 
                1.0906418588661648`}, {-2.720566951720076, 
                1.0310453035945673`}, {-2.657214393898417, 
                0.9760092895747774}, {-2.650839727775832, 
                0.9706910225147067}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.45321439519303075`, 
                0.5255303689455665, -0.11987584503146728`], 
               
               ArrowBox[{{-2.641625371366337, 
                0.9630036539168836}, {-2.5961725623092633`, 
                0.9250832087441586}, {-2.5362860938363614`, 
                0.8762120945081252}, {-2.4786325134413802`, 
                0.8309899566066361}, {-2.419219020382259, 
                0.7876964039909616}, {-2.3622013222923894`, 
                0.7475770495451047}, {-2.306317479398372, 
                0.7088798351953558}, {-2.257247365550639, 
                0.6760668089889331}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3684914308970857, 0.5222750096957413, -0.4274414239936613], 
               
               ArrowBox[{{-2.2471912492560815`, 
                0.669520345483898}, {-2.1518468473064507`, 
                0.6088443894415899}, {-2.0588169689065636`, 
                0.5532271139538766}, {-1.956975163509242, 
                0.4964159944790347}, {-1.8640780124553384`, 
                0.4478656031982623}, {-1.8307687360306564`, 
                0.4313839323482943}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.30299949501191953`, 0.5223919513715751, -0.5839635802305806], 
               
               ArrowBox[{{-1.8200133626711312`, 
                0.42606209583284077`}, {-1.7789805629311306`, 
                0.40575876979402553`}, {-1.700910414718422, 
                0.36924595598457927`}, {-1.6290618449377516`, 
                0.33733204746734025`}, {-1.5627820843461564`, 
                0.30936016993678134`}, {-1.444602673207663, 
                0.26282557771755405`}, {-1.378339618421545, 
                0.23886217121742026`}}]}}, {
              Arrowheads[{{0.009978550035108233, 1.}}], {
               LABColor[
               0.2516228983413289, 0.5224836888539399, -0.706750845293191], 
               
               ArrowBox[{{-1.3670548814066725`, 
                0.23478115290023951`}, {-1.3542733874219663`, 
                0.23015884659360822`}, {-1.2743227832627297`, 
                0.20323260991144895`}, {-1.202983603547508, 
                0.18061263225497998`}, {-1.139068717475588, 
                0.16157083022496663`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.7231993754407038, 0.3584330073459155, 0.7760390456784949], 
               
               ArrowBox[{{-2.9056631151852215`, 
                2.75850105252642}, {-2.9006040178161627`, 
                2.6796886175090253`}, {-2.8935912153133065`, 
                2.6032481183836267`}, {-2.8847989565950805`, 
                2.5291249120276964`}, {-2.8744014905799093`, 
                2.4572643553187037`}, {-2.852422226145163, 
                2.333478801587323}, {-2.8413345397161716`, 
                2.283401155308668}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6476538945694804, 0.5232411936620854, 0.7215012678798507], 
               
               ArrowBox[{{-2.8387404445520565`, 
                2.2716848986419884`}, {-2.826606261919003, 
                2.2168807418262073`}, {-2.7976095999809023`, 
                2.107137854531015}, {-2.7660882424103317`, 
                2.0039178181974022`}, {-2.732525983890705, 
                1.9068706915666278`}, {-2.6974066191054367`, 
                1.8156465333799507`}, {-2.6966549121977015`, 
                1.8137972549005905`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.5492763263762807, 0.531789932739916, 0.3080824535659496], 
               
               ArrowBox[{{-2.692136130185923, 
                1.8026805733305342`}, {-2.6615087011873473`, 
                1.727333859415322}, {-2.624526550691561, 
                1.6444359077615311`}, {-2.5833367261064497`, 
                1.5654992518632538`}, {-2.542004006276435, 
                1.4914965695496099`}, {-2.5007095664562766`, 
                1.4197634040486349`}, {-2.4738738304710015`, 
                1.3760153027027013`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.45502770970736567`, 
                0.5256485276973414, -0.11179748365752792`], 
               
               ArrowBox[{{-2.467599281777318, 
                1.3657864201297811`}, {-2.4594916866558325`, 
                1.3525692721729983`}, {-2.4185055987248893`, 
                1.2895990175330834`}, {-2.377906534513233, 
                1.2305374837392726`}, {-2.337792702678369, 
                1.1751138162521189`}, {-2.2982623118778025`, 
                1.1230571605321737`}, {-2.248680888767281, 
                1.0614068107844412`}, {-2.2001613337966064`, 
                1.0045756111648056`}, {-2.1800609599909704`, 
                0.9822126444320269}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3739675168143266, 0.5222652316573383, -0.41435387719999095`], 
               
               ArrowBox[{{-2.172039182954934, 
                0.9732878983188804}, {-2.152877040127681, 
                0.9519687742708255}, {-2.1070014009224067`, 
                0.902991512700059}, {-2.0193456506739342`, 
                0.8149949565490351}, {-1.9369332125934295`, 
                0.7387244247534694}, {-1.8596707400351282`, 
                0.6721797312639204}, {-1.8240009318958588`, 
                0.6435093558109645}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.3096404552410113, 0.522380093346494, -0.568092047338903], 
               
               ArrowBox[{{-1.814647738497686, 
                0.6359915254553115}, {-1.7872204062270163`, 
                0.6139462172550867}, {-1.719329529632442, 
                0.5626813269823816}, {-1.6557083338869905`, 
                0.5174073713940025}, {-1.5639498286136915`, 
                0.45660780493673153`}, {-1.4808843558487612`, 
                0.4057679521582306}, {-1.4164839372088132`, 
                0.3689321122690912}}]}}, {
              Arrowheads[{{0.000026778562117641205`, 1.}}], {
               LABColor[
               0.2576313646472532, 0.5224729602030074, -0.6923909383952004], 
               
               ArrowBox[{{-1.4060675008735495`, 
                0.3629741047100662}, {-1.4055096264986529`, 
                0.36265501095903274`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.5081386205565875, 0.5291093277306296, 0.12481294842542939`], 
               
               
               ArrowBox[{{-3., 0.6235134502301886}, {-2.998419108382232, 
                0.6228131571620534}, {-2.9133138950406843`, 
                0.5864206790000595}, {-2.8327023672612928`, 
                0.5530864012791339}, {-2.7543376822629786`, 
                0.5212812237787423}, {-2.6800709064521033`, 
                0.4921333577268742}, {-2.6042740184675868`, 
                0.4642140348071935}, {-2.55403369775454, 
                0.4462686719002754}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.4071308877977933, 0.5225274868375899, -0.3251790195079985], 
               
               ArrowBox[{{-2.5427329651903863`, 
                0.44223215811812705`}, {-2.5324679889531656`, 
                0.4385656066074402}, {-2.4624900568574537`, 
                0.4139197981549069}, {-2.3961683195991608`, 
                0.39127922919681385`}, {-2.2734516716374142`, 
                0.35121478713499854`}, {-2.1624248600949114`, 
                0.31697004179661553`}, {-2.0860151113919416`, 
                0.29484053985645636`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3322644922935823, 0.522339696116342, -0.5140218322140749], 
               
               ArrowBox[{{-2.0744887791029196`, 
                0.2915023271665498}, {-2.047308938659129, 
                0.2836306047483514}, {-1.9436772723811186`, 
                0.25532434757498995`}, {-1.8496320626140994`, 
                0.23086182155763235`}, {-1.7641473605948768`, 
                0.20974082365418745`}, {-1.6860688408476265`, 
                0.19134198262086416`}, {-1.6145497261256871`, 
                0.17527238185057525`}, {-1.6091422462252074`, 
                0.17413373400287532`}}]}}, {
              Arrowheads[{{0.004653856345976021, 1.}}], {
               LABColor[
               0.27315321498287626`, 0.5224452445588481, -0.6552945623226045], 
               
               ArrowBox[{{-1.5973997499497656`, 
                0.17166112784312426`}, {-1.4881039683316377`, 
                0.14864682010781083`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.6966815803469314, 0.4189019268802425, 0.7612458752462928], 
               
               ArrowBox[{{-2.458416812943502, 3.}, {-2.475860001744041, 
                2.907274646608208}, {-2.494711417405508, 
                2.790321344565511}, {-2.5073879490814157`, 
                2.6772211032474234`}, {-2.509830890517133, 
                2.564259790672808}, {-2.5090005113834475`, 
                2.5238791181998637`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.6272936295977123, 0.5368736769512005, 0.6556514846747518], 
               
               ArrowBox[{{-2.5087537982206163`, 
                2.5118816546089504`}, {-2.507607814167154, 
                2.4561533675592617`}, {-2.503382657034048, 
                2.350438245860759}, {-2.4951533383346867`, 
                2.2495057269923437`}, {-2.4834318231559713`, 
                2.1532607845097465`}, {-2.468730076584802, 
                2.0616083919687}, {-2.463403957181351, 
                2.0347179444842007`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5364119915473285, 0.530951670136387, 0.2507715211479491], 
               
               ArrowBox[{{-2.4610724425928168`, 
                2.0229466217155627`}, {-2.451457090292698, 
                1.9744007468514377`}, {-2.4320218559511786`, 
                1.891490046640195}, {-2.406184637844192, 
                1.7982271289169323`}, {-2.378001510318031, 
                1.7105593597904973`}, {-2.3481729203153, 
                1.6281543956315585`}, {-2.322755485249786, 
                1.5641643915245793`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.4487790217450624, 0.5252413522382471, -0.1396355443322834], 
               ArrowBox[{{-2.3183256387238886`, 
                1.553011972067036}, {-2.317399314778599, 
                1.5506798928107821`}, {-2.285915513868289, 
                1.477852398547617}, {-2.253690265297731, 
                1.4094163976893874`}, {-2.2210249073390336`, 
                1.345081453048573}, {-2.188220778264304, 
                1.2845571274376533`}, {-2.1225923081284304`, 
                1.1740089950637613`}, {-2.0933475770120804`, 
                1.1298688697827861`}}]}}, {
              Arrowheads[{{0.01952377871674189, 1.}}], {
               LABColor[
               0.37216102625514064`, 
                0.5222684573068861, -0.41867129114910984`], 
               
               ArrowBox[{{-2.0867197606158165`, 
                1.1198652679405785`}, {-2.0575970576134726`, 
                1.0759093240842363`}, {-1.9940211542652606`, 
                0.9886092343005921}, {-1.9322400245887168`, 
                0.9107888470535027}, {-1.884291261675415, 
                0.8545378126306225}, {-1.8376866073418188`, 
                0.8031674010894446}, {-1.7925653601408313`, 
                0.756089887632038}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.24343052652483835`, 0.5224983170623799, -0.7263301672979648], 
               
               ArrowBox[{{1.0597508314028856`, -0.7432018455523145}, {
                1.0828710153408156`, -0.8136460655346462}, {
                1.1028296650848632`, -0.8923929404300445}, {
                1.1182575320540655`, -0.980369409559217}, {
                1.127108775511486, -1.0781277162576246`}, {
                1.1269790002550704`, -1.1863730253168505`}, {
                1.1240281495448181`, -1.2151213353675214`}}]}}, {
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.27924240107073267`, 0.5224343717755665, -0.6407417395465257], 
               
               ArrowBox[{{1.122802855563681, -1.2270586154036012`}, {
                1.1148277357010534`, -1.3047552666457398`}, {
                1.0971608132456008`, -1.3936649551709772`}, {
                1.0704992738473795`, -1.4866562204942169`}, {
                1.0333502566277517`, -1.5829517357880938`}, {
                0.9843990771361065, -1.6811632624426995`}, {
                0.9835647560846759, -1.6824834820531487`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.31371680711109623`, 0.5223728146577129, -0.5583497886063952], 
               
               ArrowBox[{{0.977154104296567, -1.6926276204419728`}, {
                0.9222248460878067, -1.7795470188561393`}, {
                0.8459754367223214, -1.8758484858454028`}, {
                0.8022563852536319, -1.9224726997907773`}, {
                0.754639153305243, -1.967681548161879}, {
                0.7033614446593454, -2.0109871957948737`}, {
                0.657194455284069, -2.045518965738567}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3401449617670022, 0.5223256248372734, -0.49518793980476095`], 
               
               ArrowBox[{{0.6475324308984924, -2.0526307700807784`}, {
                0.5782063710521904, -2.0974111509325906`}, {
                0.5029964599970667, -2.1383326455808107`}, {
                0.4235134478762375, -2.174037018646815}, {
                0.34023955263318173`, -2.20389499730683}, {
                0.2538665895716135, -2.227425373204527}, {
                0.2079467253128594, -2.236074281971677}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.3538232322859127, 0.5223012010688298, -0.46249761898471814`], 
               
               ArrowBox[{{0.1961540741050215, -2.238295402745133}, {
                0.1650863739952471, -2.2441469379835763`}, {
                0.11974595614307408`, -2.2508570933994982`}, {
                0.07401530660573909, -2.255739796557111}, {
                0.025902396597724798`, -2.256840630849686}, \
{-0.02217135995196912, -2.2558918579537957`}, {-0.10909799162586632`, \
-2.250847286071266}, {-0.19505126034494893`, -2.2391639095779396`}, \
{-0.2793147961172346, -2.2210991316238435`}, {-0.27965796106081015`, \
-2.220997726781855}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.3522865120893177, 0.5223039450194039, -0.4661702964747471], 
               
               ArrowBox[{{-0.2911660350399482, -2.2175971042960905`}, \
{-0.36117222895074086`, -2.196910355359007}, {-0.44003986074812973`, \
-2.167039359855877}, {-0.5153339934120632, -2.131927924186902}, \
{-0.5788231557953831, -2.0967734923404997`}, {-0.6391271941727352, \
-2.058291910227184}, {-0.6958459065354474, -2.016940986656207}, \
{-0.715305555770774, -2.0007917239410147`}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.33578235209950386`, 0.5223334146648092, -0.5056143390667125], 
               
               ArrowBox[{{-0.7245398543634822, -1.9931283219875278`}, \
{-0.748579090874847, -1.9731785304368195`}, {-0.7973262908304388, \
-1.9273978647342387`}, {-0.8423154761264005, -1.8799554637742324`}, \
{-0.8834890838810686, -1.831253862956879}, {-0.9207895512127798, \
-1.781695597682258}, {-0.9843862889902824, -1.681213516427671}, \
{-1.0163889907553718`, -1.6169545811450678`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.30729494137856417`, 0.522384281470086, -0.5736976975960204], 
               
               
               ArrowBox[{{-1.0217385949573126`, -1.6062129921153863`}, \
{-1.0343361382248093`, -1.5809181053433914`}, {-1.0718601139697148`, \
-1.4827391253244557`}, {-1.098592535520608, -1.3879243633610887`}, \
{-1.1170594367648319`, -1.2901533696799525`}, {-1.126434373846396, \
-1.1981552750452558`}, {-1.1277038873309353`, -1.1420188381629557`}}]}}, {
              Arrowheads[{{0.009995156091679756, 1.}}], {
               LABColor[
               0.27207511939257534`, 0.5224471695944015, -0.657871152007162], 
               
               
               ArrowBox[{{-1.127975195389684, -1.130021905557608}, \
{-1.1283736338815955`, -1.1124034103426594`}, {-1.1243323864126407`, \
-1.0328546467563389`}, {-1.1155961913299284`, -0.9594576525484293}, \
{-1.1031804400849983`, -0.8918946632082828}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.6119490380236745, 0.5358737964712558, 0.5872909466155032], 
               
               ArrowBox[{{-3., 1.7853333350265974`}, {-2.9767740536395473`, 
                1.7423875519104144`}, {-2.929446114366649, 
                1.65814068590008}, {-2.8820638325939703`, 
                1.5792424079472343`}, {-2.831289005295175, 
                1.504056570595362}, {-2.7811694594720002`, 
                1.4336583273614003`}, {-2.7426571072522585`, 
                1.3808363365802023`}}]}}, {
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.5072258793890672, 0.5290498519164808, 0.1207466637661433], 
               
               ArrowBox[{{-2.7355874827336706`, 
                1.3711399244001135`}, {-2.731439249679927, 
                1.3654503750609075`}, {-2.682487711950057, 
                1.3016230046273527`}, {-2.634397170790335, 
                1.241855379662236}, {-2.587249950708705, 
                1.185826663767058}, {-2.541088234304558, 
                1.1332678362561577`}, {-2.4959542041772864`, 
                1.083909876443874}, {-2.439929228821918, 
                1.0255481695116728`}, {-2.4222698574719503`, 
                1.0080694570149331`}}]}}, {
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.41320045013819157`, 0.5229229901572245, -0.2981389679450884], 
               
               ArrowBox[{{-2.4137410626182416`, 
                0.9996279134153686}, {-2.385571520067624, 
                0.9717465508430924}, {-2.3329390921560313`, 
                0.9219229967624933}, {-2.2820899593287653`, 
                0.8754954835942358}, {-2.185504446293979, 
                0.7919688827226017}, {-2.095340715696794, 
                0.7194473536839019}, {-2.05091672905209, 
                0.6859598373217921}}]}}, {
              Arrowheads[{{0.005579001272108928, 1.}}], {
               LABColor[
               0.34007686585270347`, 0.5223257464285843, -0.4953506853274411], 
               
               ArrowBox[{{-2.0413343099643133`, 
                0.6787364555357996}, {-2.011237838119504, 
                0.6560492505038535}, {-1.9327136251932995`, 
                0.6004648744933868}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.02, 1.}}], {
               LABColor[
               0.5251017826158154, 0.5302146771001011, 0.20038425835309445`], 
               
               
               ArrowBox[{{-3., 0.9204558483950919}, {-2.9991280639723503`, 
                0.9198538562850936}, {-2.9283688519285733`, 
                0.87195411372887}, {-2.8605068105353038`, 
                0.8276192326144513}, {-2.790920618000248, 
                0.7850920637501416}, {-2.7243125514783233`, 
                0.7456653838962891}, {-2.6591001982473847`, 
                0.7076273908496163}, {-2.5966792715984197`, 
                0.6723667714173035}, {-2.591161300995789, 
                0.6693456464736226}}]}}, {
              Arrowheads[{{0.019999999999999993`, 1.}}], {
               LABColor[
               0.42335446666051885`, 
                0.5235846436697814, -0.25290257116127113`], 
               
               ArrowBox[{{-2.580635646892721, 
                0.663582782107478}, {-2.536899014719961, 
                0.6396366903420153}, {-2.4796086708005407`, 
                0.6091903123664174}, {-2.3719654879561336`, 
                0.5543753489581135}, {-2.2544054586674243`, 
                0.49825846325179335`}, {-2.1502268365074584`, 
                0.4514876264510505}}]}}, {
              Arrowheads[{{0.011773509696916595`, 1.}}], {
               LABColor[
               0.3448688363068269, 0.5223171899391803, -0.4838981371936044], 
               
               ArrowBox[{{-2.1392114061290393`, 
                0.44672839031663053`}, {-2.049536828200482, 
                0.4085036401298444}, {-1.9598537429823788`, 
                0.3722677575830551}, {-1.87738797295723, 
                0.3405481822247388}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000007`, 1.}}], {
               LABColor[
               0.6689651406103195, 0.4821041334846977, 0.7457840310263018], 
               
               ArrowBox[{{-2.2343486200158624`, 3.}, {-2.260635780146112, 
                2.914790727607713}, {-2.283114357096813, 
                2.8067516070492826`}, {-2.3000726532535998`, 
                2.7019709082168446`}, {-2.3145718733402356`, 
                2.598895784564732}, {-2.3212934352775267`, 
                2.528976901497901}}]}}, {
              Arrowheads[{{0.019999999999999997`, 1.}}], {
               LABColor[
               0.5949463662116917, 0.5347658725770498, 0.5115436197541924], 
               
               ArrowBox[{{-2.322441745887782, 
                2.5170319702405695`}, {-2.3241529412865694`, 
                2.499231811273272}, {-2.329298811355019, 
                2.4030607602822}, {-2.3304924378080027`, 
                2.310464403531251}, {-2.328150716611726, 
                2.221440237785729}, {-2.322690543732393, 
                2.135985759810936}, {-2.312168654798866, 
                2.0380278248202885`}}]}}, {
              Arrowheads[{{0.014268323740652308`, 1.}}], {
               LABColor[
               0.510196117927487, 0.5292433978652938, 0.13397915051373693`], 
               
               ArrowBox[{{-2.3103900015055716`, 
                2.0261610467004667`}, {-2.2977929390794345`, 
                1.943611617297911}, {-2.2805713709514386`, 
                1.854788977241415}, {-2.2612055766280603`, 
                1.7707596680166924`}, {-2.2400207031217896`, 
                1.6913096330511148`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.017084572186884247`, 1.}}], {
               LABColor[
               0.7459712880518892, 0.30650587892293885`, 0.7887425447112477], 
               
               
               ArrowBox[{{-2.8125776469741948`, 3.}, {-2.817247315763194, 
                2.94866969293986}, {-2.817584869936414, 
                2.8247967119957833`}, {-2.8130213145429437`, 
                2.7063084860243993`}, {-2.8063587400527394`, 
                2.5904619773685384`}}]}}}}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             RGBColor[0.192, 0.48, 0.64]], {{
              Arrowheads[{{0.020000000000000004`, 1.}}], {
               LABColor[
               0.6612533450451301, 0.4996894547320941, 0.7414819423446927], 
               
               ArrowBox[{{-2.72485762743817, 
                2.5054540200054967`}, {-2.715414861946098, 
                2.3933346938473288`}, {-2.6973236454235456`, 
                2.284718528172852}, {-2.67618049956747, 
                2.181805122971586}, {-2.6537922590144607`, 
                2.0816021731770458`}, {-2.641190953739207, 
                2.033593620773937}}]}}, {
              Arrowheads[{{0.009137972576673524, 1.}}], {
               LABColor[
               0.5697353177805392, 0.5331230764763115, 0.3992277703895649], 
               
               ArrowBox[{{-2.638144388747569, 
                2.021986793397271}, {-2.628913829067584, 
                1.9868201341959582`}, {-2.6019673989739838`, 
                1.8972111087836279`}, {-2.5733751579808026`, 
                1.8125271996953616`}}]}}}}}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         PlotRange -> {{-3., 3.}, {-3., 3.}}, DisplayFunction -> Identity, 
         AspectRatio -> 1, Frame -> True, FrameLabel -> {
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm], 
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 200, 
         Method -> {
          "VectorLengthFunction" -> 
           Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange},
              System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
             System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
             System`VectorPlotsDump`imin = If[
                NumericQ[System`VectorPlotsDump`min], 
                System`VectorPlotsDump`min, 
                Min[System`VectorPlotsDump`m], 
                Min[System`VectorPlotsDump`m]]; 
             System`VectorPlotsDump`imax = If[
                NumericQ[System`VectorPlotsDump`max], 
                System`VectorPlotsDump`max, 
                Max[System`VectorPlotsDump`m], 
                Max[System`VectorPlotsDump`m]]; Map[If[
                
                Or[# > System`VectorPlotsDump`imax, # < 
                 System`VectorPlotsDump`imin], #, 
                System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
           "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.05], 
            Scaled[0.05]}, {
            Scaled[0.05], 
            Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
         Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
         AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic, 
         BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
         Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
         FormatType :> TraditionalForm, FrameStyle -> {}, 
         FrameTicksStyle -> {}, GridLines -> None, ImageMargins -> 0., 
         ImagePadding -> All, ImageSizeRaw -> Automatic, LabelStyle -> {}, 
         PlotLabel -> None, PlotRegion -> Automatic, PreserveImageOptions -> 
         Automatic, Prolog -> {}, RotateLabel -> True, TicksStyle -> {}, 
         DisplayFunction -> Identity, AspectRatio -> 1, DisplayFunction :> 
         Identity, Frame -> True, FrameLabel -> {
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm], 
           FormBox[
            StyleBox[
            "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
            TraditionalForm]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 200, 
         Method -> {
          "VectorLengthFunction" -> 
           Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange},
              System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
             System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
             System`VectorPlotsDump`imin = If[
                NumericQ[System`VectorPlotsDump`min], 
                System`VectorPlotsDump`min, 
                Min[System`VectorPlotsDump`m], 
                Min[System`VectorPlotsDump`m]]; 
             System`VectorPlotsDump`imax = If[
                NumericQ[System`VectorPlotsDump`max], 
                System`VectorPlotsDump`max, 
                Max[System`VectorPlotsDump`m], 
                Max[System`VectorPlotsDump`m]]; Map[If[
                
                Or[# > System`VectorPlotsDump`imax, # < 
                 System`VectorPlotsDump`imin], #, 
                System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
           "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "TransparentPolygonMesh" -> True}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.05], 
            Scaled[0.05]}, {
            Scaled[0.05], 
            Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp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                  "], {{
                    Rational[-15, 2], -100}, {
                    Rational[15, 2], 100}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -100}, {
                    Rational[-15, 2], -100}, {
                    Rational[-15, 2], 100}, {
                    Rational[15, 2], 100}, {
                    Rational[15, 2], -100}}, {{
                    7.5, -100}, {-7.5, -100}, {-7.5, 100}, {7.5, 100}, {
                    7.5, -100}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -100.}, 
                    Offset[{4., 0}, {7.5, -100.}]}, {{
                    7.5, -41.860465116279066`}, 
                    Offset[{4., 0}, {7.5, -41.860465116279066`}]}, {{7.5, 
                    16.27906976744186}, 
                    Offset[{4., 0}, {7.5, 16.27906976744186}]}, {{7.5, 
                    74.4186046511628}, 
                    Offset[{4., 0}, {7.5, 74.4186046511628}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -88.37209302325581}, 
                    Offset[{2.5, 0.}, {7.5, -88.37209302325581}]}, {{
                    7.5, -76.74418604651163}, 
                    Offset[{2.5, 0.}, {7.5, -76.74418604651163}]}, {{
                    7.5, -65.11627906976744}, 
                    Offset[{2.5, 0.}, {7.5, -65.11627906976744}]}, {{
                    7.5, -53.48837209302326}, 
                    Offset[{2.5, 0.}, {7.5, -53.48837209302326}]}, {{
                    7.5, -30.232558139534884`}, 
                    Offset[{2.5, 0.}, {7.5, -30.232558139534884`}]}, {{
                    7.5, -18.6046511627907}, 
                    Offset[{2.5, 0.}, {7.5, -18.6046511627907}]}, {{
                    7.5, -6.976744186046512}, 
                    Offset[{2.5, 0.}, {7.5, -6.976744186046512}]}, {{7.5, 
                    4.651162790697675}, 
                    Offset[{2.5, 0.}, {7.5, 4.651162790697675}]}, {{7.5, 
                    27.906976744186046`}, 
                    Offset[{2.5, 0.}, {7.5, 27.906976744186046`}]}, {{7.5, 
                    39.53488372093023}, 
                    Offset[{2.5, 0.}, {7.5, 39.53488372093023}]}, {{7.5, 
                    51.16279069767442}, 
                    Offset[{2.5, 0.}, {7.5, 51.16279069767442}]}, {{7.5, 
                    62.7906976744186}, 
                    Offset[{2.5, 0.}, {7.5, 62.7906976744186}]}, {{7.5, 
                    86.04651162790698}, 
                    Offset[{2.5, 0.}, {7.5, 86.04651162790698}]}, {{7.5, 
                    97.67441860465117}, 
                    Offset[{2.5, 0.}, {7.5, 97.67441860465117}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -100.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["5", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -41.860465116279066`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["10", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 16.27906976744186}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["15", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 74.4186046511628}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 200}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    
                    RowBox[{
                    "6.826032671593483`*^-10", ",", "17.17034230651099`"}], 
                    "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "200"}], ",", 
               RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 11. Stream plot of \\!\\(\\*FormBox[RowBox[{RowBox[{\\\"f\\\", \
\\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\
\\\", \\\"2\\\"]}], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->2066907095,ExpressionUUID->"ea307398-dbb9-443e-94ad-8faeb037f815"]
}, {2}]],

Cell[TextData[{
 "Also, the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6a264270-c18a-4cd8-a3f5-f875540e2d5d"],
 " induces a transformation of the plane."
}], "Text",
 CellID->490615681,ExpressionUUID->"a8baee64-6d17-46ce-b8c9-c0b119b33f7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], "/", "2"}]}], ",", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], "/", "2"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "45"}], "/", "10"}], ",", 
            RowBox[{"45", "/", "10"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "45"}], "/", "10"}], ",", 
            RowBox[{"45", "/", "10"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "->", "215"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}]}], ",", 
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", "12", "]"}]}], ",", 
       RowBox[{"Epilog", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{"1", "+", 
                  RowBox[{"1", "/", "10"}]}]}], "}"}]}], "}"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Blue", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}]}], "}"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Green", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "/", "3"}], ",", 
                 RowBox[{"3", "/", "4"}]}], "}"}]}], "]"}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Black", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"5", "/", "4"}], ",", 
                  RowBox[{"3", "/", "4"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"7", "/", "4"}], ",", 
                  RowBox[{"5", "/", "4"}]}], "}"}]}], "}"}], "]"}]}]}], "}"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Gray", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"5", "/", "4"}], ",", 
                  RowBox[{"5", "/", "4"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"7", "/", "4"}], ",", 
                  RowBox[{"3", "/", "4"}]}], "}"}]}], "}"}], "]"}]}]}], 
           "}"}]}], "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", 
      "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.2", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
             ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "->", "60"}], ",", 
       RowBox[{"ImageMargins", "->", "40"}]}], "]"}], "\[IndentingNewLine]", ",",
      "\[IndentingNewLine]", 
     RowBox[{"Show", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "-", 
             SuperscriptBox["t", "2"]}], ",", 
            RowBox[{"2", " ", "t"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Blue"}], "}"}]}],
           ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}],
              ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], 
              "]"}]}], "}"}]}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "45"}], "/", "10"}], ",", 
               RowBox[{"45", "/", "10"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "45"}], "/", "10"}], ",", 
               RowBox[{"45", "/", "10"}]}], "}"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "215"}], ",", 
          RowBox[{"AxesStyle", "->", 
           RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "t"}], ")"}], " ", "t"}], ",", 
            RowBox[{"2", "-", 
             RowBox[{"2", " ", "t"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Blue"}], 
            "}"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", "Blue", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}]}], "}"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", "Blue", ",", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}]}], "}"}]}], 
         "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                RowBox[{"Cos", "[", "t", "]"}]}], "+", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", " ", "t"}], "]"}], "-", 
               RowBox[{"4", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], ",", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"Cos", "[", "t", "]"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], 
            "}"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["1", "288"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "353"}], "+", 
               RowBox[{"97", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "t"}], "]"}]}], "+", 
               RowBox[{"432", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}], ",", 
            RowBox[{
             FractionBox["1", "6"], " ", 
             RowBox[{"Cos", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Green"}], 
            "}"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            FractionBox[
             RowBox[{"2", "+", "t"}], "2"], ",", 
            RowBox[{
             FractionBox["15", "8"], "+", 
             RowBox[{
              FractionBox["1", "2"], " ", "t", " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", "t"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Black"}], 
            "}"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            FractionBox[
             RowBox[{"5", " ", "t"}], "2"], ",", 
            RowBox[{
             FractionBox["1", "8"], " ", 
             RowBox[{"(", 
              RowBox[{"25", "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["t", "2"]}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Gray"}], 
            "}"}]}]}], "]"}], "/.", " ", 
        RowBox[{
         RowBox[{"Line", "[", "x_", "]"}], ":>", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
           RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}]}], 
      "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "}"}], 
   "\[IndentingNewLine]", "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<Fig. 12. Effect of \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], "==", 
          SuperscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], 
       ",", "\"\< on some geometric figures in the complex plane.\>\""}], 
      "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->556452871,ExpressionUUID->"3499422e-5151-475d-b674-94eeda991dab"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[{
             RGBColor[1, 0, 0], 
             Thickness[0.005], 
             Opacity[1.], 
             FaceForm[
              Opacity[0.3]], 
             LineBox[CompressedData["
1:eJw123lUTW24APA0aZIGUlFSKRKiQUJPpiSENBBSVJRUSFEkSigiIUXJlCkh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              "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
        StyleBox[
         DynamicBox[
          (Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  Thickness[0.005], 
                  RGBColor[1, 0, 0]], 
                 Line[CompressedData["
1:eJw123lUTW24APA0aZIGUlFSKRKiQUJPpiSENBBSVJRUSFEkSigiIUXJlCkh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                  "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, "PlotRange" -> {{
                  Rational[-9, 2], 
                  Rational[9, 2]}, {
                  Rational[-9, 2], 
                  Rational[9, 2]}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  Thickness[0.005], 
                  RGBColor[1, 0, 0]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|"PanelPlotLayout" -> <||>, "PlotRange" -> {{
                 Rational[-9, 2], 
                 Rational[9, 2]}, {
                 Rational[-9, 2], 
                 Rational[9, 2]}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 Thickness[0.005], 
                 RGBColor[1, 0, 0]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
          ImageSizeCache -> {{
           4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
         False]}, 
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.005], 
              RGBColor[1, 0, 0]], 
             Line[CompressedData["
1:eJw123lUTW24APA0aZIGUlFSKRKiQUJPpiSENBBSVJRUSFEkSigiIUXJlCkh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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|"PanelPlotLayout" -> <||>, "PlotRange" -> {{
              Rational[-9, 2], 
              Rational[9, 2]}, {
              Rational[-9, 2], 
              Rational[9, 2]}}, "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.005], 
              RGBColor[1, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], Axes -> {True, True}, AxesLabel -> {
        FormBox[
         TagBox[
         "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
         "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm]}, 
      AxesOrigin -> {0, 0}, AxesStyle -> Directive[12], DisplayFunction -> 
      Identity, Epilog -> {{
         RGBColor[1, 0, 0], 
         ArrowBox[
          NCache[{{
             Rational[-1, 2], 1}, {
             Rational[-1, 2], 
             Rational[11, 10]}}, {{-0.5, 1}, {-0.5, 1.1}}]]}, {
         Thickness[0.005], 
         RGBColor[0, 0, 1], 
         ArrowBox[
          LineBox[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]]}, {
         Thickness[0.005], 
         RGBColor[0, 1, 0], 
         ArrowBox[
          CircleBox[{0, -1}, 
           NCache[{
             Rational[1, 3], 
             Rational[3, 4]}, {0.3333333333333333, 0.75}]]]}, {
         Thickness[0.005], 
         GrayLevel[0], 
         ArrowBox[
          LineBox[
           NCache[{{
              Rational[5, 4], 
              Rational[3, 4]}, {
              Rational[7, 4], 
              Rational[5, 4]}}, {{1.25, 0.75}, {1.75, 1.25}}]]]}, {
         Thickness[0.005], 
         GrayLevel[0.5], 
         ArrowBox[
          LineBox[
           NCache[{{
              Rational[5, 4], 
              Rational[5, 4]}, {
              Rational[7, 4], 
              Rational[3, 4]}}, {{1.25, 1.25}, {1.75, 0.75}}]]]}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 215, 
      Method -> {
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None}, PlotRange -> NCache[{{
          Rational[-9, 2], 
          Rational[9, 2]}, {
          Rational[-9, 2], 
          Rational[9, 2]}}, {{-4.5, 4.5}, {-4.5, 4.5}}], PlotRangeClipping -> 
      True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
      Ticks -> {Automatic, Automatic}], 
     GraphicsBox[{{
        Arrowheads[0.2], 
        ArrowBox[{{0, 0}, {2, 0}}]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
        NCache[{1, 
          Rational[1, 2]}, {1, 0.5}], 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]]}, ImageSize -> 60, ImageMargins -> 40], 
     GraphicsBox[{
       InterpretationBox[{
         TagBox[{{{}, {}, 
            TagBox[{
              RGBColor[0, 0, 1], 
              Thickness[0.005], 
              Opacity[1.], 
              FaceForm[
               Opacity[0.3]], {
               Arrowheads[0.04], 
               ArrowBox[CompressedData["
1:eJxF1ns4VGsbBvDBdujktEtFKSUl2ank1OGWUDuUJOngWNTUrpyiSA0iSZMQ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                "]]}}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
          "WolframDynamicHighlight", <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
         StyleBox[
          DynamicBox[
           (Charting`HighlightActionBox["DynamicHighlight", {}, 
            Slot["HighlightElements"], 
            Slot["LayoutOptions"], 
            Slot["Meta"], 
            Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
                Annotation[{
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   Thickness[0.005], 
                   RGBColor[0, 0, 1]], {
                   Arrowheads[0.04], 
                   Arrow[CompressedData["
1:eJxF1ns4VGsbBvDBdujktEtFKSUl2ank1OGWUDuUJOngWNTUrpyiSA0iSZMQ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                    "]]}}, "Charting`Private`Tag#1"]}}, {}}, <|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
              "LayoutOptions" -> <|"PanelPlotLayout" -> <||>, "PlotRange" -> {{
                   Rational[-9, 2], 
                   Rational[9, 2]}, {
                   Rational[-9, 2], 
                   Rational[9, 2]}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   Thickness[0.005], 
                   RGBColor[0, 0, 1]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> Identity, 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ParametricPlot, "GroupHighlight" -> 
                False|>|>]]& )[<|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, "PlotRange" -> {{
                  Rational[-9, 2], 
                  Rational[9, 2]}, {
                  Rational[-9, 2], 
                  Rational[9, 2]}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  Thickness[0.005], 
                  RGBColor[0, 0, 1]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
           ImageSizeCache -> {{
            4.503599627370496*^15, -4.503599627370496*^15}, {
            4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
          False]}, 
        Annotation[{{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               Thickness[0.005], 
               RGBColor[0, 0, 1]], {
               Arrowheads[0.04], 
               Arrow[CompressedData["
1:eJxF1ns4VGsbBvDBdujktEtFKSUl2ank1OGWUDuUJOngWNTUrpyiSA0iSZMQ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                "]]}}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|"PanelPlotLayout" -> <||>, "PlotRange" -> {{
               Rational[-9, 2], 
               Rational[9, 2]}, {
               Rational[-9, 2], 
               Rational[9, 2]}}, "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {215, 215}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               Thickness[0.005], 
               RGBColor[0, 0, 1]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>, 
         "DynamicHighlight"]], 
       InterpretationBox[{
         TagBox[{{{}, {}, 
            TagBox[{
              RGBColor[0, 0, 1], 
              Thickness[0.005], 
              Opacity[1.], 
              FaceForm[
               Opacity[0.3]], {
               Arrowheads[0.04], 
               ArrowBox[CompressedData["
1:eJxdlns0VOsfxueULpR0VChdKKqTWzcSOl85TIoKdaRUJBVKFImTU8oIJSmX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                "]]}}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
          "WolframDynamicHighlight", <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
         StyleBox[
          DynamicBox[
           (Charting`HighlightActionBox["DynamicHighlight", {}, 
            Slot["HighlightElements"], 
            Slot["LayoutOptions"], 
            Slot["Meta"], 
            Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
                Annotation[{
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   Thickness[0.005], 
                   RGBColor[0, 0, 1]], {
                   Arrowheads[0.04], 
                   Arrow[CompressedData["
1:eJxdlns0VOsfxueULpR0VChdKKqTWzcSOl85TIoKdaRUJBVKFImTU8oIJSmX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                    "]]}}, "Charting`Private`Tag#1"]}}, {}}, <|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{-1., 0.}, {0., 2.}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   Thickness[0.005], 
                   RGBColor[0, 0, 1]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> Identity, 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ParametricPlot, "GroupHighlight" -> 
                False|>|>]]& )[<|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 0.}, {0., 2.}},
                "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  Thickness[0.005], 
                  RGBColor[0, 0, 1]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
           ImageSizeCache -> {{
            4.503599627370496*^15, -4.503599627370496*^15}, {
            4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
          False]}, 
        Annotation[{{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               Thickness[0.005], 
               RGBColor[0, 0, 1]], {
               Arrowheads[0.04], 
               Arrow[CompressedData["
1:eJxdlns0VOsfxueULpR0VChdKKqTWzcSOl85TIoKdaRUJBVKFImTU8oIJSmX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                "]]}}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 0.}, {0., 2.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               Thickness[0.005], 
               RGBColor[0, 0, 1]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>, 
         "DynamicHighlight"]], {{
         RGBColor[0, 0, 1], 
         Thickness[0.005], 
         Arrowheads[0.04], 
         ArrowBox[
          LineBox[{{-1, 0}, {0, 0}}]]}, {
         RGBColor[0, 0, 1], 
         Thickness[0.005], 
         Arrowheads[0.04], 
         ArrowBox[
          LineBox[{{0, 0}, {1, 0}}]]}}, 
       InterpretationBox[{
         TagBox[{{{}, {}, 
            TagBox[{
              RGBColor[1, 0, 0], 
              Thickness[0.005], 
              Opacity[1.], 
              FaceForm[
               Opacity[0.3]], {
               Arrowheads[0.04], 
               ArrowBox[CompressedData["
1:eJwlmXc81e/7x885NsdIhYwI7UKFSuom0U7iIw2jQahES0ODFBkZZSQiO0nZ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