(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2650104,      44878]
NotebookOptionsPosition[   2637671,      44679]
NotebookOutlinePosition[   2638031,      44695]
CellTagsIndexPosition[   2637988,      44692]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Setup", "Subsubsection",ExpressionUUID->"bb3e2655-6d6f-4972-a03e-9be8f262eec6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"keyboard", "=", 
   RowBox[{"Import", "[", "\"\<Piano_Frequencies.svg.png\>\"", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"33d9ee27-715a-493a-abac-e21fb785d86a"],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", " ", 
   RowBox[{"Magnification", "\[Rule]", "1.7"}]}], "]"}]], "Input",ExpressionUU\
ID->"cb6b26d4-44d8-4e2d-bfae-71ee59bc26ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotFilter", "[", "f_", "]"}], ":=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{"f", ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Small", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.001", "]"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "0.2"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"f", ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Small", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.001", "]"}]}], "}"}]}]}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "0.2"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",ExpressionUUI\
D->"6fad36a3-f29e-419f-bf78-d259538aed92"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "H0", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H0", "[", 
    RowBox[{"\[Delta]t_", ",", "f0_List"}], "]"}], "[", "\[Nu]_", "]"}], ":=",
   " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "w", ",", " ", "f1", ",", "f2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ArrayDepth", "[", "f0", "]"}], "===", "1"}], ",", 
       RowBox[{"f", "=", "f0"}], ",", " ", 
       RowBox[{"f", "=", 
        RowBox[{
         RowBox[{"Transpose", "[", "f0", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f1", " ", "=", " ", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"f", " ", "-", " ", 
           RowBox[{"Reverse", "[", "f", "]"}]}], ")"}], "/", "2"}], ",", 
        "12"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f2", " ", "=", " ", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"f", " ", "+", " ", 
           RowBox[{"Reverse", "[", "f", "]"}]}], ")"}], "/", "2"}], ",", 
        "12"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"Abs", "[", "f1", "]"}], "]"}], ">", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<Not coded yet: f has an asymmetric part,\>\"", 
         "]"}], ";", 
        RowBox[{"Print", "[", "f1", "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"w", " ", "=", " ", 
      RowBox[{"Length", "[", "f2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "w", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"f2", " ", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"w", "/", "2"}], "+", "1"}], ";;", "w"}], "]"}], "]"}], 
        ".", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", "\[Pi]", " ", "\[Nu]", " ", "n", " ", "\[Delta]t"}],
              "]"}]}], "//", "N"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"1", "/", "2"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"w", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"f2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"w", "+", "1"}], ")"}], "/", "2"}], "]"}], "]"}], "+", 
        " ", 
        RowBox[{
         RowBox[{"f2", " ", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"w", "+", "3"}], ")"}], "/", "2"}], ";;", "w"}], "]"}], 
          "]"}], ".", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2", 
             RowBox[{"Cos", "[", 
              RowBox[{
              "2", "\[Pi]", " ", "\[Nu]", " ", "n", " ", "\[Delta]t"}], 
              "]"}]}], "//", "N"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"w", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], 
          "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}]}], "]"}]}]}], "Input",
 CellID->735082947,ExpressionUUID->"9b1102cc-fb94-4af6-86c6-09bd6063c945"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "munfl"}], "]"}]], "Input",ExpressionUUID->\
"c41f4e48-0411-4237-afe4-5c87e304a061"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"\[Nu]c", ">", "0"}], " ", "&&", 
    RowBox[{"\[Nu]c1", ">", "0"}], " ", "&&", 
    RowBox[{"\[Nu]c2", ">", "0"}], " ", "&&", " ", 
    RowBox[{"\[CapitalDelta]t", " ", ">", "0"}], "&&", 
    RowBox[{"\[Beta]", ">", "0"}]}]}], ";"}]], "Input",ExpressionUUID->\
"5d0f9f3e-dda7-4b93-bab3-9df24bf71387"],

Cell[BoxData[{
 RowBox[{"\[Nu]c", "/:", " ", 
  StyleBox[
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"\[Nu]c", ",", " ", "StandardForm"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[" ",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[":=",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<\[Nu]\>\"", ",", "\"\<c\>\""}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True]}], "\[IndentingNewLine]", 
 RowBox[{"\[Nu]c1", "/:", " ", 
  StyleBox[
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"\[Nu]c1", ",", " ", "StandardForm"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[" ",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[":=",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<\[Nu]\>\"", ",", "\"\<c1\>\""}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True]}], "\[IndentingNewLine]", 
 RowBox[{"\[Nu]c2", "/:", " ", 
  StyleBox[
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"\[Nu]c2", ",", " ", "StandardForm"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[" ",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[":=",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<\[Nu]\>\"", ",", "\"\<c2\>\""}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True]}], "\[IndentingNewLine]", 
 RowBox[{"\[Nu]c3", "/:", " ", 
  StyleBox[
   RowBox[{"MakeBoxes", "[", 
    RowBox[{"\[Nu]c3", ",", " ", "StandardForm"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[" ",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[":=",
   ShowStringCharacters->True,
   NumberMarks->True], 
  StyleBox[
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<\[Nu]\>\"", ",", "\"\<c3\>\""}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True]}]}], "Input",ExpressionUUID->"9983b597-fb2f-463c-a4ba-\
320a0e146ad4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"opts1", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.15"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"opts2", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AspectRatio", "\[Rule]", "0.15"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "100"}]}], "}"}]}], ";"}]}], "Input",Exp\
ressionUUID->"012d5c0a-554f-4e2f-8448-2edf8496d258"],

Cell[BoxData[
 RowBox[{
  RowBox[{"params", " ", "=", " ", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "\[Pi]"}]}], "}"}]}]}], ";"}]], "Input",ExpressionU\
UID->"b01f9c49-3957-4def-92d8-139a25df7afb"]
}, Closed]],

Cell[CellGroupData[{

Cell[" Music Spectrograms as Artwork ", "Title",ExpressionUUID->"99d2ba88-3ce6-4a75-aa6e-fc0ac34b97e7"],

Cell["\<\
  Andrew Norton
  norton.ah@gmail.com\
\>", "Subtitle",
 CellChangeTimes->{{3.932769904417959*^9, 3.932769923329384*^9}, {
  3.932770293213408*^9, 
  3.932770294493455*^9}},ExpressionUUID->"04487757-b293-4006-bf76-\
6f7c10981c31"],

Cell[TextData[{
 "The music spectrograms can be downloaded from\n      ",
 ButtonBox["https://drive.google.com/file/d/1hjAEHLNKGQ6FKAS-aSy6bSPnZQv9cZbW/\
view",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://drive.google.com/file/d/1hjAEHLNKGQ6FKAS-aSy6bSPnZQv9cZbW/\
view"], None},
  ButtonNote->
   "https://drive.google.com/file/d/1hjAEHLNKGQ6FKAS-aSy6bSPnZQv9cZbW/view"],
 "   "
}], "Text",ExpressionUUID->"a4b31401-4ea9-41e0-a40b-613cf845e042"],

Cell[CellGroupData[{

Cell[TextData[{
 "Multi-resolution ",
 StyleBox["filterbank",
  IgnoreSpellCheck->True],
 " design"
}], "Chapter",ExpressionUUID->"899f8f18-09e6-418e-a990-3008e343763c"],

Cell[CellGroupData[{

Cell["The continuous case", "Section",ExpressionUUID->"a4b60d65-fb5d-44c8-9dae-037a8f63b540"],

Cell[TextData[{
 "We start by considering the continuous case where filtering of a signal  f[\
\[ThinSpace]t\[ThinSpace]]  is done by integral convolution with some kernel \
function  ",
 StyleBox["k",
  IgnoreSpellCheck->True],
 "[\[ThinSpace]t\[ThinSpace]], "
}], "Text",ExpressionUUID->"88cb2a18-1684-4cde-ac6e-1644a68431a2"],

Cell[BoxData[
 RowBox[{"                                                 ", 
  RowBox[{
   RowBox[{
    OverscriptBox["f", "_"], "[", "t", "]"}], " ", "=", "  ", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"+", "\[Infinity]"}]], 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"k", "[", 
      RowBox[{"t", "-", "x"}], "]"}], 
     RowBox[{"dx", " ", "."}]}]}]}]}]], "DisplayFormula",ExpressionUUID->\
"4bd7c1f6-ff91-48c5-b93e-2cc6f1e50ca2"],

Cell[TextData[{
 "The band-pass filters of our multi-resolution ",
 StyleBox["filterbank",
  IgnoreSpellCheck->True],
 " will be constructed as differences between low-pass filters that have been \
scaled to have different cut-off frequencies. So our first task is to find a \
suitable low-pass filter."
}], "Text",ExpressionUUID->"062f455b-2ce3-4a7f-92fd-85e51b5a97cf"],

Cell[CellGroupData[{

Cell["A low-pass filter", "Subsection",ExpressionUUID->"d4162835-da41-4ffc-9659-d2b60bbb5bf7"],

Cell[CellGroupData[{

Cell["The \[OpenCurlyDoubleQuote]ideal\[CloseCurlyDoubleQuote] low-pass \
filter", "Subsubsection",ExpressionUUID->"1a9b1b22-1ea5-41a8-8c49-\
e8b5403beeea"],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]ideal\[CloseCurlyDoubleQuote] low-pass filter \
has frequency response H[\[Nu]] = UnitBox[ ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "/", 
    RowBox[{"(", 
     RowBox[{"2", 
      SubscriptBox["\[Nu]", "c"]}]}]}], TraditionalForm]],ExpressionUUID->
  "092f758c-f2ca-49c1-a2de-87664d1ec058"],
 ") ]   where  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", "c"], TraditionalForm]],ExpressionUUID->
  "072ac7f1-b1fa-4d66-9b0f-d4b02c303907"],
 "  is the cutoff frequency\n(for example, \[Nu] = 4),"
}], "Text",ExpressionUUID->"1851e00b-fb0a-4bd7-8adf-9a6c20038bef"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"HIdeal", "[", 
   RowBox[{"\[Nu]c_", ",", "\[Nu]_"}], "]"}], ":=", " ", 
  RowBox[{"UnitBox", "[", 
   RowBox[{"\[Nu]", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Nu]c"}], ")"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Nu]c", "=", "4"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"HIdeal", "[", 
      RowBox[{"\[Nu]c", ",", "\[Nu]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]}], "Input",Expr\
essionUUID->"3206bb8d-5172-466d-941e-c6b6a7a7e7d3"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1YszFAgcB/DdPettwz5kNRt2MGzTPUp55CwprtHJW3lkQjljhzPlOdy5
IRTaMYTdLu4Suxh0ytWxaNEs8rgYr24k0qjtKJa9ltXdzfD7fWe+853PX/C1
uJDgF0MiEAg//tf/N6qZv/Lpk0k3YSe0Taa18xa69+TdsOR/0Nazj/rfvUe/
1V+4M/0SnRhnH9Lag86ymum+mIcWCNklQxR01Yv8BF8dBpgx6u9jS6eDZWf8
PQataGAvW6vLbEsq2KkprHbkc2Ow6tpF6le2RuCmnIQ+Oyv0hazUFLYFeuD7
a89ppmhBSNMdpTba0XrjkGTJEJz6ODfAS4Q+0F6s6VaDnrtf/tCxGu0lEu/j
VKBNbgy9MshHt4XRr4xdQscFsWyeRqFZZ2yme8+jrx53dGkLRgfZhZMrPdHr
ypqyCBv0ufzfy2+x0d17Bypn9qMLHVd+DtqLXu0nVpfS0MHnaL8+M0RbZjjW
fquDztfzFhWS0cvCiPoBIrouZD7EaGvPjt+7JqVphRcp0DrtvjG5i+jqLSEv
cwK9ReorDhegg3WWm10i0BQGd1W9SAH3WpYc7uShCaXaCkWsAdiZ/EMrJ1of
XMo9etQtUxccdStk8W2VNnikjqVDFGiCWfotX3a1aYB1zV+PvKkngeMDcitE
IgI4sufFIKtE3bVrS5dt377sj2BxbOvL9rZ1cNzavbDrgg/gg1nks5psOZia
Nq53U7gAnoyOt2temACnpNsV95d1gutvOHBrvpC47rr4u+yJyJ8mwQYKb+dG
3wXw3OUnh5Nz5ODlR6elKbIP4Nq8XyKjC9bBVhsN1FThR/Dsb/slzrFqcGD5
XL6cT+Du+vbdQon3TRJYI5T3NzlNAzwcKa7zy9EEPzBghivjtcHWAoslLW9d
sCo5R93grw9edRgl2500AMtVZhSRAwVMaJlS6HWgGTFlzxNc94Cru9aGLbLR
HKafdEyKHm6xdeWOoRM9iR2NC2ipMU81L0dTZ6ccTBXoaLFHis8WOtRpasad
ZLhjAkHDnKIK10Q3kj1M03TR26PNwc3G6OpLeeNmbLR2Ruwg2wadWPyNlMNB
uz7Qa3E+hJ4l8a+HHkfvu13hLoxCV4yLW5g1aL7b00JTKyMwJaHBvYduDO70
eChpY1LBat75I0EUGpio9aySo0Yf8UqSniIwwKq/Gpfoq2iPeBn/9Aa6aHPB
IVeFNmeaFShIJmDP4ALbMSq69M+YOL49+uAT1jvdNHRqoFOpeyb68avAY+nZ
6IDPigrfFKAzuJsHZAK07I9JXm4H2vjUGl3SjQ6bpnQqetEryhOU6CE0w/5+
k/ssOrJ3JCh9Hi32l2/fe40+lmTpY7GCvkr8Whmyhh7ln63iK9FM8yuesk30
zt+D/wXsnAjk
       "]]},
     Annotation[#, "Charting`Private`Tag$13910#1"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"bdf2b19d-69a3-\
4dd8-9a5c-b30ad1b15bfe"]
}, Open  ]],

Cell["\<\
By the convolution theorem, the frequency response function for filtering \
with a kernel k[\[ThinSpace]t\[ThinSpace]] is the Fourier transform of the \
kernel, H[\[Nu]] = \[ScriptCapitalF][k][\[Nu]]. \
\>", "Text",
 CellChangeTimes->{{3.9327700064805183`*^9, 
  3.9327700088193007`*^9}},ExpressionUUID->"d3fbdb0a-9cc7-4d25-855a-\
d742795e641c"],

Cell["\<\
The low-pass kernel associated with the UnitBox[ ] response function is \
therefore given by the inverse transform,\
\>", "Text",ExpressionUUID->"6556986b-6c02-4db6-9f5c-cab6b0aa0084"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"kIdeal", "[", 
   RowBox[{"\[Nu]c_", ",", "t_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"InverseFourierTransform", "[", 
    RowBox[{
     RowBox[{"HIdeal", "[", 
      RowBox[{"\[Nu]c", ",", "\[Nu]"}], "]"}], ",", "\[Nu]", ",", "t", ",", 
     "params"}], "]"}], "//", "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Nu]c", "=", "4"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"kIdeal", "[", 
      RowBox[{"\[Nu]c", ",", "\[Nu]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]}], "Input",Expr\
essionUUID->"8173175c-1d95-4dd5-8adf-7810e1a97e75"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SubscriptBox["\[Nu]", "c"], " ", 
  RowBox[{"Sinc", "[", 
   RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
    SubscriptBox["\[Nu]", "c"]}], "]"}]}]], "Output",ExpressionUUID->\
"b4f40d5c-b850-4475-9d89-7c6fa0a66510"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3dYju8Xb+/xjiTiq0RUKhFJ5UaU0JAGIdJApchKkkRJS9pa2nu87d05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       "]]},
     Annotation[#, "Charting`Private`Tag$13966#1"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"180c28c5-0049-\
4c32-92a6-0e85c9cb1d43"]
}, Open  ]],

Cell["\<\
However, the Sinc kernel decays too slowly (as 1/t) to be numerically useful,\
\
\>", "Text",ExpressionUUID->"f7311f42-d1f6-4237-aa99-b524bdadd273"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"kIdeal", "[", 
      RowBox[{"\[Nu]c", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"kIdeal", "[", 
      RowBox[{"4", ",", "\[Nu]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], "}"}]], "Input",Exp\
ressionUUID->"41cf2800-dd4c-4ea4-a4ac-66966d7cc8e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0.9974670505966992`"}], "}"}]], "Output",ExpressionUUID->\
"0587d860-f6a3-48b5-884d-ecab80bd861d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A more useful low-pass filter", "Subsubsection",ExpressionUUID->"37fe237e-0547-4699-a654-362b9e8aa904"],

Cell["\<\
To obtain a kernel that decays faster than  1/\[VeryThinSpace]t  we shall \
multiply by a Gaussian,\
\>", "Text",ExpressionUUID->"b550c04b-1183-47e1-ac95-a6011cd3116a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gaussian", "[", 
   RowBox[{"\[CapitalDelta]t_", ",", "t_"}], "]"}], "=", " ", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"t", "/", "\[CapitalDelta]t"}], ")"}], "2"]}], "/", "2"}], 
    "]"}], "/", 
   RowBox[{"(", 
    RowBox[{"\[CapitalDelta]t", " ", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "\[Pi]"}], "]"}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[CapitalDelta]t", "=", "1"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Gaussian", "[", 
      RowBox[{"\[CapitalDelta]t", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]}], "Input",Expr\
essionUUID->"d7ccd3a8-f294-4a8c-8b8a-37079f4d59f9"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["t", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[CapitalDelta]t", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[CapitalDelta]t"}]]], "Output",Expres\
sionUUID->"c24907ac-ad84-45db-8564-77adb80c5d51"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw1mnc4l2/0x+09PqOEllFkJiIVz7mpaChSSVE2FSUyo0UkSXZZfe1ZFCkk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       "]]},
     Annotation[#, "Charting`Private`Tag$14785#1"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, Automatic},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"5381f5f0-39a5-\
4c2d-bc41-d2a421b18a29"]
}, Open  ]],

Cell[TextData[{
 "Gaussian normalisation:  Integral 1, and inflexions at  t = \[PlusMinus] ",
 StyleBox["\[CapitalDelta]t",
  IgnoreSpellCheck->True],
 ","
}], "Text",ExpressionUUID->"3f8cb8ae-ad95-49cc-a59f-dc3cdf2aa0c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Gaussian", "[", 
      RowBox[{"\[CapitalDelta]t", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"Gaussian", "[", 
          RowBox[{"\[CapitalDelta]t", ",", "t"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "==", "0"}], ",", "t"}], 
     "]"}], "//", "Simplify"}]}], "}"}]], "Input",ExpressionUUID->"c4e18560-\
39f9-4907-a3a7-34b960d8062b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"-", "\[CapitalDelta]t"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", "\[Rule]", "\[CapitalDelta]t"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"1d1c7b13-b833-4ca3-8ed4-1bf8406d9498"]
}, Open  ]],

Cell[TextData[{
 "To have that Gaussian and Sinc scale together as the cut-off frequency  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", "c"], TraditionalForm]],ExpressionUUID->
  "839b4cd1-d724-4365-8b26-9baa02f0b536"],
 "  is varied, we parameterize the width of the Gaussian as  ",
 StyleBox["\[CapitalDelta]t",
  IgnoreSpellCheck->True],
 "  =  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Pi]", 
       RowBox[{"\[Sqrt]", "2"}]}], ")"}], 
     RowBox[{"-", "1"}]], 
    RowBox[{"\[Beta]", "\[VeryThinSpace]", "/", 
     SubscriptBox["\[Nu]", "c"]}]}], TraditionalForm]],ExpressionUUID->
  "0af48cfb-fdc4-4805-a5fb-accfb60b1a57"],
 " . "
}], "Text",ExpressionUUID->"48cba6b1-30ac-4eab-a083-36e906c720a4"],

Cell["The new low-pass kernel, normalized to integral 1, is then ", "Text",ExpressionUUID->"cf979f76-1cdd-4dce-b82e-d1877b742c65"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"k", ",", "kNorm"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kNorm", " ", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Gaussian", "[", 
        RowBox[{"\[CapitalDelta]t", ",", "t"}], "]"}], 
       RowBox[{"kIdeal", "[", 
        RowBox[{"\[Nu]c", ",", "t"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kLow", "[", 
   RowBox[{"\[Beta]_", ",", "\[Nu]c_", ",", "t_"}], "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"kNorm", " ", 
    RowBox[{"Gaussian", "[", 
     RowBox[{"\[CapitalDelta]t", ",", "t"}], "]"}], 
    RowBox[{"kIdeal", "[", 
     RowBox[{"\[Nu]c", ",", "t"}], "]"}]}], "/.", 
   RowBox[{"\[CapitalDelta]t", "\[Rule]", " ", 
    RowBox[{
     RowBox[{"\[Beta]", "/", "\[Nu]c"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], 
      RowBox[{"-", "1"}]]}]}]}]}]}], "Input",ExpressionUUID->"92064fa9-425a-\
46de-9877-5cf91aa024c6"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["t", "2"], " ", 
       SubsuperscriptBox["\[Nu]", "c", "2"]}], 
      SuperscriptBox["\[Beta]", "2"]]}]], " ", 
   SubscriptBox["\[Nu]", "c"], " ", 
   RowBox[{"Sinc", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
     SubscriptBox["\[Nu]", "c"]}], "]"}]}], 
  RowBox[{"Erf", "[", "\[Beta]", "]"}]]], "Output",ExpressionUUID->"2b1d8de8-\
577d-41d9-a476-635cd5c1d682"]
}, Open  ]],

Cell["Check the normalization,", "Text",ExpressionUUID->"3db4a49e-f4cb-4652-a1e0-cc64e2144480"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"kLow", "[", 
    RowBox[{"\[Beta]", ",", "\[Nu]c", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"0cce20cb-a7e6-4829-8cd4-f1a5e798fc03"],

Cell[BoxData["1"], "Output",ExpressionUUID->"cccb17e3-1eac-471b-a2cd-d364a3ce762c"]
}, Open  ]],

Cell["The new kernel decays suitably fast,", "Text",ExpressionUUID->"26f114aa-34f5-42b3-88a7-d91060fa5f4b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "=", "30"}], ",", 
     RowBox[{"\[Nu]c", "=", "4"}]}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"kLow", "[", 
      RowBox[{"\[Beta]", ",", "\[Nu]c", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts2", "]"}]}], "]"}]}], "]"}]], "Input",Expre\
ssionUUID->"fa8f4dcc-9e4a-46da-8e19-1fa3a417ee76"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3c8lu8XlozXfgcZLStKSSGz3Fay914hKytkJ3vvmT0ripSQUXIfM1+j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       "]]},
     Annotation[#, "Charting`Private`Tag$18069#1"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{-2., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {2., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {4., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {6., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {8., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {-4., 
        
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {-3., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {-1., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {1.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {2.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {3.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {4.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {5.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {6.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {7.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {8.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       9., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {9.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {10., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, {{-4., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {-2., 
        
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {2., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {4., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {-6., 
        
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {-5., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {-3., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {-1., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {1.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {2.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {3.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {4.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {5.5, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"2d2a24e1-a15a-\
4c6a-ada4-5fb6644fbd7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"kLow", "[", 
     RowBox[{"6", ",", "4", ",", "\[Nu]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Nu]", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "//", 
  "InputForm"}]], "Input",ExpressionUUID->"17702519-4612-4b79-9fb9-\
bdbd1f5099cf"],

Cell["0.9999999999999999", "Output",ExpressionUUID->"63d92701-b369-4d12-a4d7-2a1b7d6b6c77"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Low-pass frequency response ", "Subsubsection",ExpressionUUID->"2493f4a1-953f-4714-be7c-bf1a7383ee1b"],

Cell[TextData[{
 "The frequency response of the new kernel will be a convolution of  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["H", "Low"], " ", "[", 
    RowBox[{
     SubscriptBox["\[Nu]", "c"], ",", " ", "\[Nu]"}], "]"}], 
   TraditionalForm]],ExpressionUUID->"9c473846-40ca-436d-93b5-a3dc3e59b586"],
 "  with a Gaussian in the Fourier domain. The effect of this convolution \
will be to \[OpenCurlyDoubleQuote]round off the corners\
\[CloseCurlyDoubleQuote] of the response function,"
}], "Text",ExpressionUUID->"39730403-644c-4e64-a4c9-b8d4054a2464"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HLow", "[", 
   RowBox[{"\[Beta]_", ",", "\[Nu]c_", ",", "\[Nu]_"}], "]"}], "=", " ", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"kLow", "[", 
      RowBox[{"\[Beta]", ",", "\[Nu]c", ",", "t"}], "]"}], ",", "t", ",", 
     "\[Nu]", ",", "params"}], "]"}], "//", "Cancel"}]}]], "Input",ExpressionU\
UID->"d7ea3167-7599-4c7b-b303-c3eb0815a62e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Erf", "[", 
    RowBox[{"\[Beta]", "-", 
     FractionBox[
      RowBox[{"\[Beta]", " ", "\[Nu]"}], 
      SubscriptBox["\[Nu]", "c"]]}], "]"}], "+", 
   RowBox[{"Erf", "[", 
    RowBox[{"\[Beta]", "+", 
     FractionBox[
      RowBox[{"\[Beta]", " ", "\[Nu]"}], 
      SubscriptBox["\[Nu]", "c"]]}], "]"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Erf", "[", "\[Beta]", "]"}]}]]], "Output",ExpressionUUID->\
"fd2a9514-b2f2-444b-8950-643aad2e7eb7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "=", "30"}], ",", 
     RowBox[{"\[Nu]c", "=", "4"}]}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"HLow", "[", 
      RowBox[{"\[Beta]", ",", "\[Nu]c", ",", "\[Nu]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]], "Input",Expre\
ssionUUID->"5e6a3eff-4a86-4df3-a5f4-3191f5aa4461"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF2nk0VV0UAPCXZHqjIZUkkSkllUy9e88NSUIyFJIkRVJUyFAyZS4iEQol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       "]]},
     Annotation[#, "Charting`Private`Tag$31629#1"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"82fba651-3179-\
4c89-b271-a7f54455b605"]
}, Open  ]],

Cell["\<\
The parameter \[Beta] is (approximately) proportional to the 1st derivative \
of the frequency response at the cutoff frequency, \
\>", "Text",ExpressionUUID->"b619878e-9310-4f02-b15b-874ffd7a9bd5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"dHd\[Nu]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"HLow", "[", 
       RowBox[{"\[Beta]", ",", "\[Nu]c", ",", "\[Nu]"}], "]"}], ",", 
      "\[Nu]"}], "]"}], "/.", 
    RowBox[{"\[Nu]", "\[Rule]", "\[Nu]c"}]}], "//", 
   "Expand"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", " ", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"dHd\[Nu]", "/", "\[Beta]"}], ",", 
     RowBox[{"\[Beta]", "\[Rule]", "\[Infinity]"}]}], "]"}]}], "//", 
  "Quiet"}]}], "Input",ExpressionUUID->"fc2805d1-9a27-4277-9f5f-d04f1a900315"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["\[Beta]", 
    RowBox[{
     SqrtBox["\[Pi]"], " ", 
     SubscriptBox["\[Nu]", "c"], " ", 
     RowBox[{"Erf", "[", "\[Beta]", "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["\[Beta]", "2"]}]], " ", "\[Beta]"}], 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    SubscriptBox["\[Nu]", "c"], " ", 
    RowBox[{"Erf", "[", "\[Beta]", "]"}]}]]}]], "Output",ExpressionUUID->\
"e90e5b29-c788-4594-85cd-a3215f86ce00"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Beta]", 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    SubscriptBox["\[Nu]", "c"]}]]}]], "Output",ExpressionUUID->"63c723e8-09f9-\
42f6-97dc-a99c41e17f1b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A band-pass filter", "Subsection",ExpressionUUID->"b57ff13a-959f-4b5f-97ad-72438ac55de5"],

Cell["\<\
We now define a band-pass filter kernel  kBand[ ]  and corresponding \
frequency response HBand[ ]  as a difference between low-pass filters that \
have different cut-offs,\
\>", "Text",ExpressionUUID->"1ce2380d-d928-45da-b481-8a74be63a003"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "HBand", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kBand", "[", 
    RowBox[{"\[Beta]_", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Nu]c1_", ",", "\[Nu]c2_"}], "}"}], ",", "t_"}], "]"}], "=", 
   " ", 
   RowBox[{
    RowBox[{"kLow", "[", 
     RowBox[{"\[Beta]", ",", "\[Nu]c2", ",", "t"}], "]"}], " ", "-", " ", 
    RowBox[{"kLow", "[", 
     RowBox[{"\[Beta]", ",", "\[Nu]c1", ",", "t"}], "]"}]}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HBand", "[", 
   RowBox[{"\[Beta]_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Nu]c1_", ",", "\[Nu]c2_"}], "}"}], ",", "\[Nu]_"}], "]"}], 
  "=", " ", 
  RowBox[{
   RowBox[{"HLow", "[", 
    RowBox[{"\[Beta]", ",", "\[Nu]c2", ",", "\[Nu]"}], "]"}], " ", "-", "  ", 
   
   RowBox[{"HLow", "[", 
    RowBox[{"\[Beta]", ",", "\[Nu]c1", ",", "\[Nu]"}], "]"}], 
   " "}]}]}], "Input",ExpressionUUID->"8f142788-b55f-4012-8af7-2b61c71c6c91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["t", "2"], " ", 
         SubsuperscriptBox["\[Nu]", "c1", "2"]}], 
        SuperscriptBox["\[Beta]", "2"]]}]], " ", 
     SubscriptBox["\[Nu]", "c1"], " ", 
     RowBox[{"Sinc", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
       SubscriptBox["\[Nu]", "c1"]}], "]"}]}], 
    RowBox[{"Erf", "[", "\[Beta]", "]"}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["t", "2"], " ", 
        SubsuperscriptBox["\[Nu]", "c2", "2"]}], 
       SuperscriptBox["\[Beta]", "2"]]}]], " ", 
    SubscriptBox["\[Nu]", "c2"], " ", 
    RowBox[{"Sinc", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
      SubscriptBox["\[Nu]", "c2"]}], "]"}]}], 
   RowBox[{"Erf", "[", "\[Beta]", "]"}]]}]], "Output",ExpressionUUID->\
"08aed8d4-0144-4f8b-ae2c-e79a2cbad74f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{"\[Beta]", "-", 
       FractionBox[
        RowBox[{"\[Beta]", " ", "\[Nu]"}], 
        SubscriptBox["\[Nu]", "c1"]]}], "]"}], "+", 
     RowBox[{"Erf", "[", 
      RowBox[{"\[Beta]", "+", 
       FractionBox[
        RowBox[{"\[Beta]", " ", "\[Nu]"}], 
        SubscriptBox["\[Nu]", "c1"]]}], "]"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"Erf", "[", "\[Beta]", "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Erf", "[", 
     RowBox[{"\[Beta]", "-", 
      FractionBox[
       RowBox[{"\[Beta]", " ", "\[Nu]"}], 
       SubscriptBox["\[Nu]", "c2"]]}], "]"}], "+", 
    RowBox[{"Erf", "[", 
     RowBox[{"\[Beta]", "+", 
      FractionBox[
       RowBox[{"\[Beta]", " ", "\[Nu]"}], 
       SubscriptBox["\[Nu]", "c2"]]}], "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"Erf", "[", "\[Beta]", "]"}]}]]}]], "Output",ExpressionUUID->\
"df619a97-dc17-43e1-b860-6016903e8f0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "=", "30"}], ",", 
     RowBox[{"\[Nu]c1", "=", "2"}], ",", 
     RowBox[{"\[Nu]c2", "=", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"HLow", "[", 
           RowBox[{"\[Beta]", ",", "\[Nu]c2", ",", "\[Nu]"}], "]"}], ",", 
          RowBox[{"HLow", "[", 
           RowBox[{"\[Beta]", ",", "\[Nu]c1", ",", "\[Nu]"}], "]"}], ",", 
          RowBox[{"HBand", "[", 
           RowBox[{"\[Beta]", ",", " ", 
            RowBox[{"{", 
             RowBox[{"\[Nu]c1", ",", "\[Nu]c2"}], "}"}], ",", "\[Nu]"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Nu]", ",", "0", ",", "5"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"kBand", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"{", 
            RowBox[{"\[Nu]c1", ",", "\[Nu]c2"}], "}"}], ",", "t"}], "]"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "opts2", "]"}]}], "]"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",ExpressionUUID->"c80c0ec3-7bcf-46b8-\
a1a2-d8ccd80a6a78"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxF13k4VF0YAHDKLNaIiEq2D0llS9LMPSelZEuyFCUhZCtSJEmyVULKkmRJ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           "]]},
         Annotation[#, "Charting`Private`Tag$31769#1"]& ], 
        TagBox[
         {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxF1nk4lF0UAPBBKZJsWSLJTiIpoZn3TImyRhIhIVtlyVJJlAglpKhkyV6K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           "]]},
         Annotation[#, "Charting`Private`Tag$31769#2"]& ], 
        TagBox[
         {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxF2Hk4VU0YAPB7ca8lQkRJEkJItkq658ykFIUkoki2ZEslSrakQvaUpQiV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           "]]},
         Annotation[#, "Charting`Private`Tag$31769#3"]& ]}, {}},
      AspectRatio->0.15,
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{Automatic, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->600,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81e8XV/a67r4iRYlSqUSU8UiSFSVfJEmSJCt7Z+9x7ZG996aiPCeF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           "]]},
         Annotation[#, "Charting`Private`Tag$31819#1"]& ]}, {}},
      AspectRatio->0.15,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->FrontEndValueCache[{{Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
          Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
         Automatic, {{-2., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
            0.}}, {-1., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           0., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           1., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           2., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
            0.}}, {-3., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-2.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-2.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-2.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-2.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-0.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-0.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-0.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-0.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           0.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           0.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           0.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           0.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.2, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.4, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.6, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.8, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           3., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}}}, {Automatic, {{-5., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
            0.}}, {-2.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           0., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           2.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
           5., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
            0.}}, {-7.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-7., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-6.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-6., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-5.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-4.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-4., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-3.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-3., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-2., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-1., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}, {-0.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           0.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           3., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           3.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           4., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           4.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           5.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           6., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           6.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           7., 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           7.5, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}}}}],
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->600,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",ExpressionUUID->"a8ffc347-b28b-4bf4-a02c-4d9b6bd41e2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"HBand", "[", 
     RowBox[{"\[Beta]", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\[Nu]c1", ",", "\[Nu]c2"}], "}"}], ",", "\[Nu]"}], "]"}], "+", 
    RowBox[{"HBand", "[", 
     RowBox[{"\[Beta]", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\[Nu]c2", ",", "\[Nu]c3"}], "}"}], ",", "\[Nu]"}], "]"}]}], 
   " ", "==", 
   RowBox[{"HBand", "[", 
    RowBox[{"\[Beta]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Nu]c1", ",", "\[Nu]c3"}], "}"}], ",", "\[Nu]"}], 
    "]"}]}]}]], "Input",ExpressionUUID->"5d5b7dd2-a975-4b4b-b633-\
068887ac7d63"],

Cell[BoxData["True"], "Output",ExpressionUUID->"d7b25849-d07b-4da9-8368-b5d53b376197"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A general filter-bank", "Subsection",ExpressionUUID->"b41e6ded-b7cf-4c8b-a540-793c04e37914"],

Cell[TextData[{
 "A general filter bank that is (approximately) reproducing for signals \
within the bandwidth of the ",
 StyleBox["filterbank",
  IgnoreSpellCheck->True],
 " can now be specified by a list of cut-off frequencies for the pass-bands,"
}], "Text",ExpressionUUID->"a6b5878d-7014-44c7-866c-24bac11ade26"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"HFilterBank", "[", 
   RowBox[{"\[Beta]_", ",", "\[Nu]c_List", ",", " ", "\[Nu]_"}], "]"}], ":=", 
  " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"HBand", "[", 
     RowBox[{"\[Beta]", ",", 
      RowBox[{"\[Nu]c", "[", 
       RowBox[{"[", 
        RowBox[{"i", ";;", 
         RowBox[{"i", "+", "1"}]}], "]"}], "]"}], ",", "\[Nu]"}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{
       RowBox[{"Length", "[", "\[Nu]c", "]"}], "-", "1"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kFilterBank", "[", 
   RowBox[{"\[Beta]_", ",", "\[Nu]c_List", ",", " ", "t_"}], "]"}], ":=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"kBand", "[", 
     RowBox[{"\[Beta]", ",", 
      RowBox[{"\[Nu]c", "[", 
       RowBox[{"[", 
        RowBox[{"i", ";;", 
         RowBox[{"i", "+", "1"}]}], "]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{
       RowBox[{"Length", "[", "\[Nu]c", "]"}], "-", "1"}]}], "}"}]}], 
   "]"}]}]}], "Input",ExpressionUUID->"bc2cd257-9be5-4929-ac4c-d3aaeb87b9fb"],

Cell["For example,", "Text",ExpressionUUID->"93765f51-af52-410d-9956-22f6b93e7739"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Nu]clist0", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "0.5", ",", "0.6", ",", "1.0", ",", "2.0", ",", "2.2", ",", "2.4", ",", 
     "2.6", ",", "3.0", ",", "3.3", ",", "3.5", ",", "3.6", ",", "3.7", ",", 
     "4.0"}], "}"}]}], ";"}]], "Input",ExpressionUUID->"b38d1307-5dfe-4e95-\
82e0-113e023384bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Beta]", "=", "25"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HFilterBank", "[", 
         RowBox[{"\[Beta]", ",", "\[Nu]clist0", ",", "\[Nu]"}], "]"}], ",", 
        RowBox[{"Total", "[", 
         RowBox[{"HFilterBank", "[", 
          RowBox[{"\[Beta]", ",", "\[Nu]clist0", ",", "\[Nu]"}], "]"}], 
         "]"}]}], "}"}], "//", "Evaluate"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]], "Input",Expre\
ssionUUID->"064126d9-2804-471d-9597-8cdba7d82425"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF12k4VP8bBvCxhijSgixDC0koLcScRyFEftZIRYTsW/HPVkRCSLJFsitF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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k8VF8bAPApktAuP62WkrInlWLuY6kkJQmVkJAtCSFLhEooQraoCEmy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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k4VF0YAPCxJGRPVJQlIVRUinLvO9JiS5ItSVLZsyWhTZKtSFmzZUuU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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1nc8Vf8fB/DrEr5SZjQkGRnJSpHuOZ+TlISijEiSbEJCfkZJyghJQiGz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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k0VG8YB/AxIyKFEippkrJnCUlz73uTRFHIUki2bNmylJ+tyZIlW/ZI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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13c8VX8YB3C510gUJUk2yfoJldA953tKQ1ZGCklmRlZCMkpCspO9QppG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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13c4lW8YB3DiHCOKyIiMCEVGIeW87/OSSggZETJO9hZKqCSyImVmj4oK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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13c8VX0cB/Ar4g5EiShbVjJSku45v1NZSZGVJBkRZUcJRRJllGQnuwcN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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN2Xk0lV8XB/BbKO6lkCiZCZXMIb/7nPPQhFQyV5IMJSEpURTJFIlkylyI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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13c8VX8YB3AiFdcq0ZCdleyE7vl+TyIjZWVUkhk/K7NkREJ2KLOyFRWp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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nc4ll8YB3Aysl6jSJQtSjKz3+ecJxEVMlIUQkhWRiJUKkl2spMVpUEq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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k4VV0UB2BTQlyXVKbMISRJpu7Z+xCSKZGikCFDJRkzJiEhSmQuU5QU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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#1"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k4VU0YAPCbSrj3cpWyJKlkiUTJknvOTIVkS0QkQhGSbEmohIRUtFiT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       "]]},
     Annotation[#, "Charting`Private`Tag$31882#2"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"5a657054-51cf-\
4bfc-aa03-557935e3acab"]
}, Open  ]],

Cell["\<\
Increase  \[Beta]  to get less overlap (better resolution) and hence a more \
uniform response,\
\>", "Text",ExpressionUUID->"a77b9b2d-c26c-467e-aa96-e85c4ad74ffd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Beta]", "=", "100"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"HFilterBank", "[", 
       RowBox[{"\[Beta]", ",", "\[Nu]clist0", ",", "\[Nu]"}], "]"}], "//", 
      "Evaluate"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}]}], "]"}]}], "]"}]], "Input",Expre\
ssionUUID->"442bfe2f-a008-4634-9cb7-4b0d53ef00a4"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1nk41NsbAPCxVC76Zbu6uZahRdmVexHmbdEPkW6WFFLGmjUeQihZQkVD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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1gs01NkfAPDxzKvyyr9STFYpJPnzX5aZL5WVSBKJtBhCyGvTeiVLkUoh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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k0VWsUAPATkiSZ6pVkzJBEmtW9d180GTIVRWYypUmISKaEwuUJZUoh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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k4FV0YAPCZVErKkqKFri17SSXizjnRikq2EELWSgh9kcqWrXCzR3ZK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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#4"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1Hk4VF0YAHBzp7Ik2ZKyRCQ7UX1o5p5TISVC2SUmhbKnEiqEok1FFEWp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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#5"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF1nc8VW8YAPDLOVSijDYhZJakknTved9QFPqhjDSMBkVWVqWyVxkhaSEq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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#6"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k8VF0YB/ApM+4kikIUGlKWlK2E19xzKFGpJJQliWSpJFGKJEV2CsmS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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#7"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k4VF0YAHBS3LkRUinZiZJkK0vmnpMUlcqStCA7n6WsEUKyJYQitCAt
CCEkSojssoWE7LIOouy+O5aZ+Wee3/OeOe+557z3vXf4DK9rmGygoaFppaWh
IX8/dTeklzB2xWjWPsUNvKravJfAupe/5t/h5f2P4qcFQTybeG9SbEV0tP7H
c5fihnnzh+M8URQz/OwWHuVJpDiuIsZ2mOcDxalv7/60Equg2AzURY3YNVB8
rW9fT2bqD4pRPm/hX7KdFAezVIrE6fdQbPjz/Ge6qn6KbUu8Da8LD1GcbsOo
ufPkKHU9rpZD4trjFHvFLKhPjUxQTNPQCT+6/KFYyMHU+bzINMW9048ubP70
l+JTfRa3wmxnKD7bG7Kfm3uO4qEvhp5lKfMUi7E2cR27uki9PjBt0PZniWLl
0cv/+LVo4LpbioxpL4vSUpzlX6zHO0216SbHzpqaDRQb2blmMUbTUXzQbH+N
qsFGir9tFd3sKLeJ4rxUr8eidPQU06tqcTyip1p9UDiKFqV6QKA6oomFarYo
9jBPbqot7yT7N8pRvftik6ObDdWm0wlT/fZUp4e52qs7Ua1czWsr5E61vaKl
Ve09qvN/EYfl71NNuMVi8TKM6pj3WWYuUVQPnffv732y7jSFQ5OXTc7FUu15
/0Dvh/h1FytUitIYCb5ed6PCjor6ruCkdXcrGJi91J9NWfe4QvJG519G6ete
UvgXd0qvJnPdjERFwNUum7Nmz13EoDbSlfi8NUNhYsvNolamz2tmOUQUYA+/
5Fy05hlF4rVMs5buknWrET+oy2ufKV+zuB5xI4mx6X3VmlMtiOcCf53nr12z
nRMxel9GQ2DDml28iX1fvTX+Na1a/2soUdxYu86gddWeyc+IrrQialXta/Gz
ScR+pc0tQl2rVjuUTVTzH7l6u3fVOfFFxNzK6oGfA6uGu78RBZnfXj88vOpt
NT+IwRoh/0LGVq2t0kecCbf1GJ5Ysaex/QTR8IcGw4np1fgD+wViFaf0/diZ
VW9hZsAO629nn59fte3DrVhs/N9nWssrhq+KuTB0oFkobQMD2frWWcKYo8iH
VJR+xZ7/SiSxTuvowyaEFdvMBxOxU+mu+Z8ZV4zE8ytjmVM6JzhYVmxVR6OB
cctiNQ5sK+6w+3kF83flufBtx4r7Q6xNsMl8mo59HCsOkDSywXQ2dJt4c634
Ud6wM1Z6/MtoBy/ZBenTTV6Y5N0XjnKCK3EaEY1A7EmVz+IDYbI9N3OIhGP0
LGY+YyIr451s7WMwG00VppNiZNtMzh95jbVG7AuPlyC7ZbqVJR1TakW5lqTJ
hlL7RnOwVK6RFxdlyZ4ZvLWrCNtlUC367gjZxbJO/BWY94vUTCZAdqBOVlE9
NjZwX8FckWyXoObSVuziftviouNkm3Db0/ZgRdc0VLlOkt1tc7t+CBPNkGp0
UsXtKeaVWzeJRUxv06k/R46LSnApzmE0cn97RDXJcRUBRpkNwNKt2dLvAjne
O/uFlwCaPuf86bqEG05yzR1hBZAu2lVBF3cB7YPvt9lB0glXukf65N/vERvt
4gHbAnTuTRjh1hcqafDYA9yriWyqZrhjF3/u/C4KfrPwPH5lgXtGLOqRnBTQ
OE8jQHuNHD9WGOguBz496kq6Yos7ZzhN5RsEe38WSWY74FYtf8y7+QQI436R
y+KMe+H2heV8VbBg4KNo6Yo7+dXxtHgNYPrStKLEHbdYWFET4SKo/a2sweuF
OwyI3mvUA/Ki+1pdfHBnJ5WbJBqBF9dRw+/+uENpa76OmwPmd8ODBwNx89q9
S7pxHbj8rbINuI/7FZvlxEd70CuXOtsbhntHR+CJOGdw9tb92yACd5FhpV6o
O8gpsCFERzFAz9Op6UXtXoB/o0bo1BMGCHO9VD/u8wOBylK7zsXiJhTlwJOB
4G/AtrjEeAZYgPR/az0QCgxqpvdufM0AOz/uh+GFD0EVa3OaXhIDjNVdyN4+
GQkOa+XIfkjBXZCZ+qn+KYiNjCpgS8fnc9m+NJIXB9A2F5Vrmbh1Js0k51+A
w06JTPff4+t7uP/zuHUCMNjaUv82lwHqdygvHVFPBoEp9JG1nxgg7959PrUX
0kCOyiHdiQIGuFcz+WF6SQbo7THi31qMryeDcHrvzSzA7BE2IFnKAMUdvp6p
cMgB8hyFyZoV+HrKYnYW5+UB0yySrUM1A6wNmt5dqPYZhKlxy4TXMsDGTG6h
oehC8GlYdSGrAc93IWFAPPsL+O3rWtjUxABb6COJPnMlYBt/ku+/Hwww7Tlx
tMqsDIBPLad3tjPA8yeNMlwXK4DFRQZWuU58/bmTJUG51aAw2PixSz8DVIEN
k5L1dWBk3wP9x4MMsKxmpkjPtAHsLCnc83GEASoVbG+pJXwH1+a50xYnGaCG
XXTmC6cWwGn+o9hzmQHaHBS+Lp/1C6jQIQFxGxB4NZtWtqqkE9g/O3yuaBMC
p3yZDKffdoGKxgc/6BgR2MS885WtWw9wPnp2zHcnAtliciqCm/vBiza3d693
I9DPI5Fjw5MB8M3pjXMZNwJvDBOuJWr/BnNbW4mDfAj0Laq0XSAMAqFUhA7d
g0DL1I/JoRmDQP2kTJnIXgRG09m7cqsPAbdek6DT+xEY3DtlfaNvCDRwfGEP
kkAg/4P2kyakYbCUNdGWIo1A+Saz7QdMRoCIOu/zGhkE9tcNinHVjQCtkbNm
JHkE8h4ZPu4jNQo8/W6JsmAInDupyPk1cBQk8ydPiB9FIOKxO/Bs+yho/tSa
ra6EwCX70qDIPWNgwyWCm50yAt2VETUh0zEgNiVz9MEpBJq2yNl7xIyBy/dN
6TPPIPDI0JKDWP0Y8BEJr2xUQ2DBVwXt/KUxkFbyJWRaE4HJKTAgZw8JtOlP
au3QRuBWDiaeeGUSQBZ4d8tcRuDIJIfSsjEJSD0616mti8CUx/8xqriTgJ6k
+0tnfXy/XSPdJx6QQEB1skWUEQLHXZYHzF6RQLb5z4O5pghMPaR9jTmbBLro
0OnW/xBok3Lrx7EvJMAYI5s7b4XALXMKwRdrSEBW3syD0waBGd9eZ0Q2k4DR
93Aloj0CPcOjHJR/kUCwTTFB7wZ+XmV8lrF9JJC7+U+N+00ECi0xM7YMkUDf
K76HMW74720sDnKSSGDEu2uWzhOBAbetrzdPksCkYdxV8zsI/MiO2tVMk8As
NCip8kWgCt4N9syQAA0P336JAAQe0vHXX5glAfrFzpDwIAQmGbE7Ws6TANPP
2L+zIQh8yvaaw3+BBLZ90NfRe4jAV2DKzWiRBDge8RYVPUJgTOLTe5uXSIDP
sVNY+DE+f3aQ5z3cezVjg+49Q6DGhVKtEdxiEvp/SHEIzHxxdf+hZRI4xMx7
6fxLBMKY/GeWuBVGf+XnJOD1ZOCw7SFuxcoYQa5kBHq4o3/TcZ9MvBpw+y0C
H4SBvlLcan48430Z+PXZbu1vxq1t8kvrVDYCn/wb8+zBrXcsJi/1AwKHP0h1
DOM25rvKx/YJgUXIvrYJ3JbL3H5OBQh0WdTn/Yvbrr1j5OcXfP8LtPfM4nbO
e6YBSxH4embz8XncHlF6OS8qEJhmJlK4gNvXiZubUIPvR+SZ8kXcQVodd6zr
8PwOeR5LuB9KPRusa0TgQvTfBbKjWfXOHW5BYIeuucYy7jgSV1b0TzyOXA4k
O6G6nWO5A4HOOubvyE5989TTqBuBFeFh1WRn3dXtL+1DoFjGUgfZH824VEUH
Ecjt5jtE9pfj7ekhIwiU3M85SXaFwFP2aRICc1+y/iO7llb31qU/eP1Fnpoj
u/kXZ8+nvwjM/+/qAtm9j5+k+i7i8az7S2RPanO6nNtIgM8u2y6TzVS7m7WL
lQA5N4yseK/K7gQ7HgKsGFtYsZ4sR1O4PAH2fxpY8cO9uzZ+0CLAy469K/Pr
6Am97rlIgPseW82TLfhQ6tQWHQJ8dffULNkj5XBU9ioB9sRL/yU7c/lMiJEh
AfJv/jJBttuhK1LBJgTI+MtomGwlS/OmHHMCVJQ53U02Y5zjzR5LAlww1v1O
dmOTF+eW6wSYFMX6hewnjCGfZe0IEPU4lUi2seJTQyNHAlwK5/MhW9Q5aVOw
MwGOno5bOZ+plPcJOa4EGBZpzriy3z3Fp3vcCdDhocQb8nl676ofY/LC85dK
7iFb9dyvUFkfAlTrULMm1wObz4i0kT8BJtBssyPXS2vubHPQPQKcWVbjJNfT
83F615xgAswWtD9DrjcLoW3cPaH4eLlz7eR6lNThK2QKJ0CfXKNHf3DPhYoZ
y0YSoFuksQwJd1HpEQajxwTY2DlkPIg7YFElKegZAXJk70rtwq0hdeFMThwB
0vtsuE2+Pzj+MxrvfkGAIyBAoAJ39zObB0wJBDjW7J+Ygzup8dZh2Tf4+rUa
fseR7wf03g/DVAKU5mqx8MYtDyPdgtIJUMHD6ooe7g03XvLkZBJgFJ2RwwFy
vb3JKOp+T4Aaaa59Y/j9Htb12YQpjwBjjx6RjcF9mb0akc0nQNNf0gflcfOf
aX1jWEiAhoTzsbl4PxnyGjgbVEyAZRJ5JzlwZ+RMTbwvxeunuDlWHe8/LmO0
4d0V+Pg9Vx9r4/1JUZBZlqkGn99zgx3fHAmglzl/ytQRYCSpXOc53t/q7+9z
N2wkwC1qUicr/+L3X8lhvqBmApx7ahoQMEUChvPHit+3EqD3RlbvygkSEJFQ
N+tuJ0CbuQK1G2N4/ZvqoUxdBNhNP258He+3uU8sU2R6CdB851HxR3g/9qp3
VjMcIEDhsdb8crxfn0J8/wQOEeCGUBHdjhYSYMUeRLwfxS39Gb6uJYEW+1i5
7nEChBqachNfSSA2MaWNcYoAJyXsrO/kkYD5r1wPmX94PnlnIZ5UEhDfXsZv
OEeAp3yH3no8I4GZU99LAhcJsFD+5NnLgSRQ4Nlt/p4GhYcF7qnrOZGAfzZp
czcdCiexy8qHruL9cWQhlZEBhTuYR9TuHCOBnfyohgyKwucnBmMGBEigU5t9
2oAJhWMBSlyLy2MgIUgwMpAFhb6DXApXmseAzReJI+/ZUDi/rWs2InEMyM5i
HV07UKjbl75Z6cYYoDmoepuRA4U5ybMyfxXGQJnxJUEZLhR+C/b7obg4CkKi
TUsNeFFYcAH4F2WPAqcbXvZuAihsFNvbn2wxCvQ0nvE8EkJh2KsdhpfYR8Fx
sdzK9H0odCnja7v5cQSIok1OVaL4fKdGeCsujQC2/gmBgYMoDLZ6+pYVf9+Y
K2SqpZVCodAeLbs9bsOg/ObxvTJyKLSx+DOufmsIpGkZNKoroHAmUsTdZGIQ
RErc8rQCKNS7n3aCqDsITAczW+KOozA7rP87LddvcKak1vujCgr5Bp1TfWwH
gHTciHjzaRQmMefNzef34+8fgncZNVDoOMK2pfJEHxiUhoeEtVDIu7m2SNur
F9Sy6HQdvYjCmojrmxQ+9ICYsgdyTnoohOjxN1yc3UBBlm6oywKFCd/8ntU+
bgcC23giFqxR6Noh5pL29ydAx+UV2W1R2DHA9qdLqxW0vLaLVnVCoSZDneKw
cDNwZO8+9f4OClu2SVccVaoDOn8W/9b5ohDTrHui2fwNKH3bFT9yF4XbWMcG
mo5Vg61+6vN8ISgs+xXvIeRaBmYNrV8rPECh16gWb77yV9CJ3dXUjsDrgcdB
5/mhYpD6t+BN4BMU0udJ8d13LADh9W3ar2NQ+KQ0OZ4l+BNwS52hK3qOQpVr
Yb0OtrnAOGBbWttLFO4VFdUOe/AenDYV1/mXgMIQpj5h9clMIKmoimxNRqGS
nJaPyr0MwMFtnin6FoXFarLDVVfSAO3cHX3lDBTGwim/hcJk8Pt7DKNhFgo7
yxtk3hxMBN/S83LcclDo/3LjeeO5lyA7qNn4UR4KxbN+/avYHQ+e/veHJSMf
z8dvJn8rKBZ4H2f+VFWIQpYKcE0t7Amw5Nv/30AxPr/+gqZUaCTQWDyxfUMZ
Cj3ZJ9mebQ4H8j8MCzkr8fq8XoRt/BsK+LLcrWVqcIOSgKqAYICERu/SqMPt
WfevsOMuGLfKLrFqRKE+kqFt2+gDmlXqbf2acVvuFCi45AXyBce4nreikKYd
ezeW5w5e0qAVH9vx80/w1fSLvwkC2/bcaO7E87exM+ufdQT2OUf5J3vw8Ua6
0jLxtuDyQ90axgHcT9zuvd1hDTjfobsth/DxLyT3q7mbgV91783KR/G49b89
J3oM8eeHcabwBO7WEV7BI3rAmHkrre8Ubjs9KXT7RSAk9vlM7z/cZ7889tip
CQZVraIV53FL532oEDwLki13DcQu4fYcuRWYqgyuBXyVWqbdDGm2nLnQ6q0I
xBPtPXU34VZKEdjfqAD+lPJW5yG4e4uz0rQOg+z+6l0cjLiNJa22yEkA502u
ps7MuMtk6blsRIC84N53TVtx1z4ZMJQUBIuK35eld+Au8PWOz+YGBQZeqg92
4WZp6FHH2IGX58GoCU7c+lbLpNusQCmmre8cL27P7/hTCgUM+XclUwVw8/aR
eCLoQEXbYQ9GYXLcXECafRELnO+ptBAh+3eCmuc0dpYjdGf5Adw0hlfZn5Mw
VjnMRFiCHLelbdw7gDVqD6f7SJPj+29s6ezEIm5ELvXIkE3P8fFmC3Yx/Php
xSNkB1iCpDpsd+bko1iMbItPOfrlWEd9TO/SUbKhvalgERY7oSqhe5zsWp+P
tR8wQ5a5W3kqZCf33VLOwAQPvq7YpUp2y7FDXxKx/jPn2Z3PkS3uo8v6HEu0
ojVu0iDbc8tb2SjM6l5qmvQFsjtlJr1DMbGkK4thl8iOJVTJ+mPjZcipCR2y
aQrnEj2xjIGsiHP6K74cWncDc6A36kkxWpmvPn7ndUxmD4s4o9lK/CDvDhNs
7tgnNwuLFX/OddTBPhpalJdZr9hpI5cm5n6bfYew7YoV/AJPYkdjiw19HFac
c3YJYhs/277tcVrxeT6Pw9jXdu6Fo64rpjGOP4D5L1SqxLqvOKHLWgA7vftm
+NLtFYe8u7QL2yIv1K3js+JxJUcWrPZig1ie/4ohUNqEhTl5uu4KXLFn48V5
olbEgTKn+6u+7jFB3JnVuq0pbDWfl0o/sbXBz0A6YtUWxDbik0np1LCoVRfX
1BGvsnbPjT9Zteelr0R+8fvK52JXPTWYR+w9q/AwJX7VbRfTia+sBzs3v151
gcNL4n+BEQcsktZsHk0UfXPMpSxl1SGiIcSx8vGvQumrpnl/h5j2+ymbT+aa
h5yI9gyn9Xver+VvtyIeFppJPpq35gsGxBmll7Mx+WvjP5wnuuXF3CkuXLP/
SSKNZDTTYPGa1QDRO+HhI6ayNfNKERl47vNJVq4ZChMDwu++uVCzZnFO4hZG
70OudWumYSWGebl/jmlcs/5G4o5Z55PFzWv2nFGIvm7f8Lt1ffyoAle/tS5T
x7q7FGJ1zAckutbdqCDYYGh7oXfdZQoJJ3XnXQbW/VFBtEDbJ2Zo3WkKaYc1
mItH1x2rIJWiGvV7fN0hCtkCygJMU1TLRx9Nkfi3bhoaRb/DhS6LVKsZ8A4y
oowUX9s+JSshQPXkvbEiLSGqHTcMqrrso9qN1K7/5SDV98pL/bUUqE649bjl
phbVPX2KzkV+VCvG1DwXuUd17MXL1WHBVOtV2vIbhVPdmhZbRRdPdb3rEu/x
fKqLWHPLS6eofk6U2F1twERxio8jq9mBLRT7aRmdppum+lBbXKJfNTPFkfse
p1SfZqHYoyAo8vQHqs/s1npZIchK8dFrpVdY71Idw2koWDVNteCX1xFnr2yl
OORAkUh9PtWmfzbWlYuwUWyYPsl79z7VVl6aC6dCqXbUzGxmfEC1/7RjcEgE
1alys/OPnlI9W7jc9OoN1SH1jEHFpVRHx1ub+5ZTHe9Qc0ylkursHSFzlTVU
t11mM2/4TrVwz65j3T1Ui2e6cL/oo1re5+esyQDVqsJP0waHqLaz5OWemKDa
TeH2bMYfqn2YuhsdpqmOfBt/b2aG6ueeG81y56h+o26i6LZAdSb/Vy5sier8
P0L4/2iq/we0fmdZ
       "]]},
     Annotation[#, "Charting`Private`Tag$31953#8"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxF13k4lF0UAPBRSr3vKEqKxIiPEjWiSDPvvUTJnrIk+1KyVJYskWQpa1G2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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#9"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k4VN8fB/AhLcydokVRdlFMtiI0955DWUIpJZSyJAkpa6JvTagsLSr7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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#10"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN1Xk4VN8fB/AhRcwVKWmxCyFG25eae89B2bdCqZS1iJI1oTRky5YkZFeK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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#11"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJxF13k8VF8bAHCVyjb3jpJKYUT2JJXkN3PPqWQvSoRKKBJFtrKWZMvSKwkp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       "]]},
     Annotation[#, "Charting`Private`Tag$31953#12"]& ]}, {}},
  AspectRatio->0.15,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",ExpressionUUID->"bc4d17fa-3730-\
49c7-bc61-a4f0dae014ab"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A multi-resolution filter-bank", "Subsection",ExpressionUUID->"59c1ce05-a1d6-48fa-a6c1-bbec290b97b0"],

Cell["\<\
A multi-resolution filter bank is defined by taking the widths of the \
pass-bands to be geometrically related.\
\>", "Text",ExpressionUUID->"5f515361-32bf-4c1b-83e8-b242d3eabde7"],

Cell["Example:  3 octaves, with 24 filters per octave,", "Text",ExpressionUUID->"4f701053-dd85-410d-8e67-d9b60b549508"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Nu]clist3", " ", "=", " ", 
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "73"}], "]"}], "/", "24"}], ")"}]}], 
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "48"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Beta]", "=", "50"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HFilterBank", "[", 
         RowBox[{"\[Beta]", ",", "\[Nu]clist3", ",", "\[Nu]"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Total", "[", 
         RowBox[{"HFilterBank", "[", 
          RowBox[{"\[Beta]", ",", "\[Nu]clist3", ",", "\[Nu]"}], "]"}], 
         "]"}]}], "\[IndentingNewLine]", "}"}], "//", "Evaluate"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "opts1", "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Thickness", "[", "0.0015", "]"}]}]}], "]"}]}], "]"}]}], "Input",\
ExpressionUUID->"1777d5b8-e70f-4cb4-a35a-b2a42244ff75"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk0ldsbB/BDZAg5GTKWKUMUpaTbOe9jiNIgCZF+UUmGFbmJBiHcMs+E
e2Rs/BUZkiGSOVGiUGZR5vPSkam4x9C791rP2uuznu/ea/+1H+kzzsbnWEkk
UhWzFneGy6aR6fv+GGll2QRJnhJPtIU/Fs1R5h+iuRFmVG23/0C7RbjHKE+o
khZLuFVoeriEdp/wsWmRliJaHuEI+0eHCmlVhH39Yiq3hrcQdt/IJcd5s4fw
AXEeW4rkd8LzTuHS0TuRs8sEO4YPI4s5SJr864k8lL9VZ7YLOcDs6Ib81AHC
NRGxzeqKQ4Q9+sUig7SQ1XYnHf5qjhzX/aAiMgDZTrUge3wImaO+LTTz6TDh
QinrAxxVyE6ufexWnX+cTJGpsXud9/OPKyjN4qMefGtHVjxECXR20bRVWLE3
mYqVT/4ohhUralAnhK9lCpmvuPsE9b7DvMOFi8v2VvSinijxka/0X/Yz/RQq
3zqOXomUZZcal1HLzgUluhYs2yu2l+pWsNai7sOSS624WLHNvNGCckNLVhsp
lsI6rUUarrOOLhpPLKJikbm0oCaxJYc761hg+pzS+5TVF+3tqenvir1vcpT5
arDkAp/7IZh5Ut7vBOtFJ1eWJKRjvQ4sn43dl84/JocXYY4ah3K5Q5fyQC/5
gDFY7oSVpS86/UzIQj/mWd/jcK1o0W96rbRnMY54Ff3tjUxriak9V+GDcBt3
6aEBpqViHzKypUBMrexXygLTpcqpsfXbIG2Op9VCeAxI4awOC/t1QKX6eA55
C9Mq11clihhDXmRq6Btdpqemip/onAY4NWp/8wTT39p29Bc7Q42Spt5ulzHw
FmZrqZLzAONJH6nx20wrhW/KJvtDW2n93MO7zDxjbCymPQpsgkVarJ+PQXer
/v870pJg7PjZbJE6Zv57oe206UNwl80IaegdAztP9/e7hLKBRJ+2858Zgzjs
TKDvTAEEFuru1eKnQ/tpWuAd7jIQuBW6cVqeDvtP33vqolUDtKOfZzOpdGCY
XmJUhb8HeUm55vMmdLhYTFlv/70JMgecsjY60kH4gBDN1awVNHMLgltu0oHC
Q+4s72qHMi82u7A4OvAeMSo7mNINBw8e0d2XSQd9mR0aEbRe+CicsGGhkg7S
6g/6GqEPTvX2zeS102GMDIItF/rh+1PVT04/6JAdIUnbTv4G+RSquQA7Dv2C
AjWhG76BR2qvnjM/DsYuW55VxfSDNqe/+ltxHJIef/pYdrMPVjttkVZQwMEt
gHeD7FQv1DY18vlux0HMicVgiNwDYbuv/Oqk4uAtYnL8R18HmCRJDv1lgENW
HX7Q2/UziLCXt8Sa4HBP51A5P/kTdDjYVU5Y4bBp3iwsgd4AqQ28OYaOOBSa
cLfHONeCrUZO8mM3HF4OR92vZKsAZZp56GofHH5tFg80sy0GnGX++pkQHGgR
jT77RnIh93yafUkcDpryI2+mWp/A1fr9x8XScajhTymQ1U4DTH1sr1smDloF
MbVjXXHAGh+1vbEQBykrdtuzwmFQPa8ptbWK2c/yzxF44wPBNp28gR+YnsT7
gycug1Gt71x/Ow4kRzLlS7UdCKkpDWoPML0Q+O95Tkv4EvOuOfEH0xn36DIe
h+Du3KWKmXmmzbWNLvyiwNnTotmm3ONASn6emHNNBRSrS5KyhJguDdCWWiUO
Iyo2IbzSTHcH6L4o5ISsSK7r9ipMe+MGep8nMbfpDLvKXYuOeuCX3Iv9dcrE
TFqXaVLk6fb0d9hC+YzuDcNFUxStj+ZjFUpJ2z5bLFrKMjgxFfMP27tx57lF
a5H9bgRhhycHeSIuLtr7aXnUJYzhWe/c7bFoUmpssDmWwJnVqBqw5OAsLyqm
HRm90ytmyaTzc1LYgPiVuHcpS07+UMSKhd2znJPMWO5H1n2laqjCqQuFy/64
poLakS/z+mXVsq1d0qh+OqvleJqWrcXvQ1WuG7xl2bVskoA1tdG0fvDx8Irt
9lCvdj07NDu1YmthqpR9dKYB28TKfztOqZ5wXxfPv2JSLcXJw/LygMQfJ1OE
VkPrLqU/JpFehsnsub0T+azo6rvN2sjcaYMkeUNk87xnVRW2yIx2zJg1Dlll
s6X9jVnkphysrm71D8LXqDKqEgLINUaDjEJlZBt3d+/pk8i0iqg7l14h81jV
Vdr7MQjjLlmZXuHIH/1i42NoyImPrS+8zkXe+pMhKNqPbBQiaVOjN0k4qsiJ
VYHjJ5rPImToC5hC97+VyzpjOUtY9srrv0vsfxMOC4sVXitD0vrj3MDfTWv9
WQjLsirt9uJZRXjgZ1EC7sZGeOq8QHrDAjvhDBIt5OZNDsJFwsGXdgxyEl73
SIvFzJmb8Kv8k0FX29YQfrGXWrzGlpew2bThe6dBPsL3BPvG7JX4CesNs9Ye
G0UO9zZNw9LJ6D2PSkcijq8jPMHPFyghJkC4RyNs08P3yJMJE4KO0YKEOyKd
XGNNhQg7G2xoLOMSJqyAPfOVr0cOHL+sHuS7nnCppskxcw0RwhIlgtUnp5Fl
Wbl2n3kqSviIX9f8XRcxwvKVg2XtiuKEG+J5pnzakZOfkL2skyQIi3seYAdT
ScJFIee6TMQ2EFbdFq/U1IZsGEX62zh8I+E3optus22WIqz95qyJ9T/IaWUZ
Fngn8vq2IU4JLWnCPY1au2oSkGmKB4X/R0M29zSdHE9EblByyBFPQS7xjlJ1
foCcsPWbgnAu8rHAIBGbemS+7pip6XfItTuTm0MakHV6cqNfNCGraXbyr/mC
zPNNjSv7G3LNnj0D+gPIvhF61W2DyLOUE/+wjyIPRPmyWPxATh8M6R5lIFtB
3Cufn8jNQ09uPJlBjtR6cVJ7Dtkw9vWe5l/I3CNvxRznkSu1m2cWFpD/AylO
Id4=
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01HsUAPChbIUoZA9JxKNHiZr5fcf6IkkipIdsWV68VCgKjZClsSW8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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01VsUB/BLEVKRIWPGkniRIpX721eG0iCFkJIi43q8SjSaKzOZQjcK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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01PsbB/AhVKhLlmTJVpZb0aYU833G0l6SLUL5IZFzabmlbgtCiWxj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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01F0YB/BJyFZRyDZlJJJeeiuSzO8Z7VqkENEihiznHa1UFCIkO3nR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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Hk01N0fB/BBhCiErA8jhZSkQpjvpfCUSjR2KltKzmNpsTxapixJlmGQ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxFzgk0lG0bB/ChCCkSshZSSBGyVPM8FyXtkxJZWpCUZGlDyxuhEjF2pakU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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01N8bB/BpStkqsmQtI0siSVmKz+cZlfq2SVkiKpUI36KFUSpKCiVr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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Hs01OkfB/BpQkhyT25FYl3C2kSZ+X6oqNRKlGsXSUr9FpUaK8sUSqTI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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk41dkfB/AbkW2yhGQpRI0lSVkq9/shMaVILo1Q2df5WUZ1Zclaiohs
4ZKGkUxT9kyKS5aIsoWQZSzdK8ryvdxJ6Xev5fs9z3Oe87ye9/l8znnOP0fO
wdvcmYNAIPSwJntFfRWnmHk3EMLacIqROS+V6QLr3laiIjRJuYwZbdBwb6dc
xzxiVi5WT0nB3CvG/FRFycNMYkr0VFLKMSe4Pzz5jNKAOSIyuV4tvgczeQev
Ak/YCGZjKQEXXZmPmI145H5R2T+N+W2np/zocdxW98q/p9vh9tQ6WcoXhzve
iSw3ScPdT21dys/6jLlCl2i1hWsGc9Af/xp6C+HW57mx/7UU7ubOjs0RGrg/
eLjVz13AzZGWqNHxDLcJgy6Q4DOLv+fVVu/hINzpPEUde2/ipkn5331zH3fk
EW4FgU7cKi306zZDuDssW+kFn3DLuic9Ob5xDnPjHFkkTQi3V5DNJZr0uit0
xbihV1tp3V26z2/LH47SXDeq67iNO6tbf816IkS+HDphl+m61YlFqq2Ol6zX
LHuSaFVe2FDnsuZCV+IPSFIS9Vt1qGcEMa+JfMsxZNXD37OIJiSbL8Uxq7YS
riCiA4g5x921+n0dxAwX+bLTuavmqpskHpnhkrhfuGpPZU6EfoUeMPN8xXoO
TyWReM7WD9C04pkdshqIdmyh3u13K87vnPkFGRRPyhkcWXG2zavzyLVsMrfa
5xVfXzbwQ1SVbdyDv67YfndAFNJZgrS0cM+zLBuV1JeBBBDl90pvYdvK2Uu8
EJFr5LrjuYPtePeDErXIKzM6+kyFbTWqRXsn4t3X8iufDtsvwj7KjyPiToXP
zh5l+52wMspAXkwnyjw0Y1tQ+jdNbnAik0OZtizbXfqZ918x4N9gM/qLO8vD
zDKUoAjF0YhR6iWWfQxGGnL2w1lR+YcTYSxPaV0jj+kDIYtLQCuOZYkm0oW6
U/BgN93rWjrLLccrLwfagGlRS3tXHst9qlqWqq7AOFR4QKFkHkI9DKLUBfyA
UpeY6lfNytulO6KjroKBKflr7WtWnvZYsqI/CiZ7rM+J9M4DdejPKoe9dyDB
HqHaj82D7JXpO8f4M0Dnk9zOopl5aCNPhpy6lwNDF7muE77PQ7zWS+ua5r/g
+jKNdooXBdmtvsmbtUtgz42WE/fEUDCLXjYqm/sHuoQLH3+WQ8FWPEM6XqYG
AjMShRE1FDZ+NE/JFGoAeUXyxdhDKOhcSFQYfvMamh5b9wwYoTDjqrRLYGc7
+Oggh1RJKERWVBdsKOiCrbVymYEXUJgbiDyi49gLVSe4CK89UWh48pIepjYA
zu9oDpL+KMwSknpMJ4ZA4EJLvXskCqpX3Hp4ikZgxrfoSUg8CkWTt4omNEeh
KzIlLZmCgsRWPrsT/mNQkRoY8Vc+CnyWddGf3cYhs8DufzWlKJzPzNx3/Ns4
hL8w/LWHioLAsZonbioT4NKmrD/dgkKQuk+gCzoOxqOCKpzvUWCKt+8Lth4H
tQVUdNs4ChXp3QbPncdAhLdvWW0WhWVD39OO8qOwIFVNO/qdlT9IaELvjUCf
Wm6HNS8DtAY9gpWGh6Ba/+ZzHzEGuM32v0wzHoBcC6+863IMeF/u8vf9nF64
4UqKp+xhAN/cV7RS4B38FqATUHyQAc4k38zMP9rBLFbG6ZUhA3KdknzaF1vg
QDaH6eBpBsin5+QumzWCRMlHbfQcAw7Yxjl9caiFb/UtcnweDCh8KyYb7vIc
RnqL+GUvM0AX1FM6rpRBw6cUhmY4A9pMalL/bH4CBcuBQyfiGCAbQLnay/0A
4oTtm+zTGaCT6lAncjobflcwKiHnMYDwm/Y8R1YKnNFWyYwtZkA2aXFwf34c
HDIWisqpYsDwfSluY7NI2H6O4fNPMwP03lcs+JkFAIdPn/XbbpZLZppM8n1g
Irz66Pi/DAgtL5NKyXCC5uRctaXPrP4RWyUGaVbwOP+mhPAS+7zAJzIeJpBY
6cWxe9MCEHScl9oX9MD/DWlKdwvLbtscQ6T3g+2ITrf5DpYJJKjhVgQ9VIbq
psJyKE8vR6o4KGziLLiqzbIs11Jc8SbgkaQlJhmwTE0lhxgykSnV1uCCU+z9
Hz34DWlIGxS7Um3Y/RyD3xX2IKXmqae7Xdk+tLQhsQG56xx0eMqPbQJZ8Ecp
EuRvr8gRyjbPh2zBHMQuxkhQ4hbbPtF3RuMRwyyV//bcZZu6dFczGFEuEho1
yF2pfx+T54ZsrmO0nC1c8R5tEwtkrruv3Pv5iqe+mOkh3fTq7GuvVmwWm6qE
PPuWG53RtepHyVuQLMHoi0XDK6YmwHdiuLz3+capFYe6nhonumpaHPvAXDHh
4sk3xJPHDmrMb1xcMZOzjKhus12aV3jV8b4UoqgXJ/cOmVVnN4YTmaG0LweU
Vh26z404kNj63lhz1QQ3UyI1r/ilnf6aczWIuf+k/n3ZZM1m4sSbLUGpt86u
mfBV12vIPuwP53UP6prPGXlW+K6bqqvFpWr5Jnjd2bqSEsIwdnPd8bp0l/c6
ysnrZv2YZfc1fLJxnyFp7PpWjjshjvST6BhuHq6UfgOEiXlxVtI/Zw5312uF
Igebr5h3+tf8XuX+HfPt2ynigvIEvXWXRn/vFLyxAfNODqWDIQKcmGkLlekz
lzdiXnTdktv2gwvzYwIlNixsE+ZK8Vt+B+g8mEUe6m04482HubrCNuZKPz/m
p0eJL/hdfsJ8hmn61ou+GfOfomOf3ZWEMBt+4mgmTeOOD7XMQXKF8fs8pE4l
/CqCeU5oc7S05BbMI1q3FfPf4makz4l6Joli/nDH62KKpRhm7+PbO2p5xTHv
RgojdrXijp69tD8mYitmqo4FyUpLArN0lWijLRP3Tg7egw5/b8N8KnJoOctX
EvOuenrtwM9SmNvSBBbDB3BnPxIOsbsnjVnqqjEXWMpgrox1HrKQ3I557740
pc5+3KaJhN/N43dgbtqmGLVRWRazfpOjhd013Dm1j8/ODOLe2j/JI60nh3mk
Q0/7VTpuys8nxM9RcFtdtWTMZuJuU/IokbqPuyo0ca/3A9zpahO7xUtxk6Jj
JJxacW8eTl5kvsHdrJndHduG+8hIadLTTtzqOoNC/H24BSbUeYsncL86fJhm
RMMdkWDY2E/H/VXX+hrXNG5aYsSGs/O4c+mxw9Mo7gtwtzp8AXf35KPgR//h
vqP31FZ/CbdpSs3h7m+4+aZeS3ou467X7/7vxw/c/wdvmJzx
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk41dkfB/CLbtyYQsiarkgoZFK2+/3QokaNjK2ohBFhskQoKlmycy0h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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxFznk0lHsYwPGxFaWQJfsuWUORyrzPKBTdq64ttKBruVK2hKiMpWxZJkIa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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      Thickness[0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1Xk01GsYB/AhiiiEsi/Zkq1cWcr8ntEiqdS1FCJLIbnXUllKiyyV7SJR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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1Xk41NsfB/DJFqXsu9QolV2kiO/3Mwp13W6F0aKEUqhfligqNFluRTL2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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxN1Xk0VO8fwPEha/naky1LkjKSKEuZ+xklSZtQ3xKiQihJhUoaIiEhS9Io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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN1nk01N0fB/CxqyZLVEhSkuylsmTm+xlZElEhlaxPCypr5alfxdgqJCNC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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk0lN8fwPHJEkqWKHtUlmRJRPzM83zGN+RL1NdSKTEtQkrWUilDtFiy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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk01N0fwPGREClTVJapRMhakSgz3w8VFZFsbZZRIXlCU/ykbWwt5LEm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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk0VVscB/Arc8kQmVJESIaiDOXe87sqElGZ9YQGU4MMaXh6XIXKkGsM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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk0lN8fB/Aha8le1kRkiRQq0jzPB0VFyk72ki2FlH711TKylSVLKiaV
kEoREZUwqkH2bPlGWZLIFl9FMyO/mcHz3HPuued13u/PPfe/q3A4wMqTk0Ag
zDE365w+sX50NvsySlhcR2LWuMrc9oIlSxWqC/9IO415ukrb90NaJOY+i+JV
1LQbmDtXzY6Up2Vjtp6V/FiaVow50ffRvldpVZjDwq9TNRM+Yv7fWn4lvtA+
zKYyAl7ENd8xm/Ap7FbXGcNs/mtYIDFwErOAWz3VN3was7SkCAxcmcE87PWv
3obruF88v6cdmI7bzlpbmVGMO/Gq9UrxAdzun2V4HSdwa2oMENJpuOvfn5pW
F5nFfEsSGT8hi/uoN/dQicqS84nbixv65rSXTCHycd/o2okuuYP40dq1/cre
JY8QszOUm5psFk0iIMGT4zWr3BctL47sMih54+S3ZFVELP7i63unFx1IRPo/
7y7+HrroGxZIgYZw/sa4RUt6IKSQzkcnUxZdGIwcqE3PfJm56IOXETkp39vz
eQumzJKRMW+tm8avFmxBykVeF/9JiKEuuLerAonhfhP9oXnBwoxmxNEmOlyi
e8HH+voQ1UyrCy7f2SZNX59CZialz2ROLVhObBlaZfD1xPAc2wbmNmJocvxj
v038f1imSNoroh5fTnoGi7M9FCSjg2pvJLqVrmW7+2GmEcpxjusghzrbpsRp
S7S5tt5q9za2f90SO4Telbq+L86Q7eMV/IGov4+LSes+tlNdK86jSMl6AykH
lg2sedEYVIBnfLubB8u9DtSMFLTLpljnvj/L8l4ihGw0J/PCxpGzLM8mvvUq
RM9OmahoRbDsLHvqGwXdYyik8L8Elrc0ygs3oBIJH6XLbrGcV2j6tBMd/HJX
fNkDlrV6SooG0OcbfQT3PmOa5CRmpDKJhp/bzBdfxsofP30twkCt62Y52mtY
rlIuz+OBddKVdOk2ptPlhu9Ii8Kkz5Vf7j2seeO7VjGyQCmxnMj+wXKOs6i+
MlzlkR4e/cXqT9BvSmqBi21/vzYHDQj5RunxtO2gkZXTfUaA6cu73FMu7gTa
VFBHuQTTyXwP1/zYB+8NdzRzKTK9rzVeVNMWUhKW1ZpqMh2tqE594ArePXVv
E7Yz/STuJHHEE7ZpJpd17GK6nWHjNOsP3OedS2QtmCYWNMfdCYa2OqWCw040
IH3IuH219TxEoOryad5Mu9zi4e8Oh20FWvHtJ2lAudVwnlQVC0OKen8FScx5
Bmoafu0apN5Aj++JZfb14j+ompDBlN+4OzSF2be1C/545B4wQszMSrOYuX6i
QMOLbMgdt3w1nU+D3r4kp4d7c8H1kIOaZhkNLISEA0jpz0CozTXF+z0N0nXz
k3wPlwDFxJP3XjsNZl8KKtjQXkPQS7/Tn/pokBB6KznjZSUoagR9ExunwTQP
A/nrQ4W2O2dszGk0eB0Z4VZ15T1Eilx8G8lDh5q3DtmSqxth6HfMvT9ydNCw
/PCTKt8Gqb5JwjrqdGgbyDHW+dIBpt0pF4/p0oG8olLBLfdfYOy/O35/Jx1+
R1SXdV7shtzK+y49B+jwpC1EgWLcA65bntRLOtPhjHo6TWOmF4QfPNth5UMH
qysXdJ229EOl1MucmFN0CJBO69ps9RWCYiukqCQ6+B+gUvn3DoDiPPXy31g6
KIkIimwQ/QZtJ+pndFPpEHTCMJvn4TeIHGjxOnGfDs5rbbRIPIOga/9ve04B
HSbaQwpWqg/C0PueXQNldJiPkuxtEx8EMnGwcE0tHcw1ZPOevvsGZk9H19l3
0MGTXr58LfINGAr/JSb000FUoIVD49IA5Cb/IdSO04GkJcy5PfUruPISApfR
6VD7TYxKvdwPwv/w9BB5GSCvB19VHfqgclRg/2kxBmTraV0zEuqFIDexsqdr
GWDY8brJ4dhnUGqR0hhWZ8AURVyk7dEniCxRXu68iwECFlpTNze1g+6GjWev
WzBAzsWyYUtSCwyl6Qw1OjMgNGdn8xHJZiAL6dvz+TLAtNJPLia5DswuGVQZ
BjNAnE/pm4tTNTCmTbaGhDLgzde6jHOxbyHP2zyrKI4B+mZvX8xsoIDbJ2ux
8VQGDBWsumZ77BUImzteUslmACWeKJlh8xwqK9wn3Z8xgPC9Xs2eswCCtL3d
yeUMcP/P16CoNgeU7h9vaq1lQH4u9/cLHVnQLnEKXfmRAYEbrrZPEtIhMvqf
XJOvDCA5fsr0ME4BvTmSLGmCAb1bjx+NVU+C4YComJd05v3rk5WgKxrI/XG0
Kd456FW9+vjwzTAws0321RCfA4NKq4Ad284Bo5rc6Sk/B4RTE0YKAqcgV//e
7rsac0Cy7gnmkjsGrrkPijv1mHkt7y+lYA8Qks9bL2rMtHXrlrwkR6AkFSWb
WTKdoZFq890SgrhLl0W4MM0V5XelYTconqkMKvdlOuVo2jM9gHLlx5MqwUxn
NT1ya9gCju3JgYkkppuXGbUeUYffYRcmaDFM51s8nW1RgCRtH/8jN1l5tTl5
ZDVo9lmONWQwTeLXLF67EmrjdxzTzWO696fFuT2c4IWuH0l/ycq9dEPzfqOc
Y4JHl1NZjn3t3jCC3rk1O3SymWmCUtlAey+qb9rv/bmL5XOmEuvb0I7ZukGT
7yzXZBU3V6NBD5575k+x7CDS0VyKCtrdHZD6y3JakqdAPprDdcUjjP8v6/8Y
CDfLQE0Kg/pHxVn+yZVNTkb7DzkfspNnmbQ7ajQSvSBs0luhzu7TtbTPotIV
m9zUdNm5QJyTH1p8XOpLkhE75xF1cEGtZJe5MMzZliNLHEDHa0e7PA+yPU42
NkCjz3Y4Nh1he3q+ZTOqrEr5Vy+QbfcxTQW0suORQ0YI2xbcdiKoc8S1jyui
2KY0mnCgszrn7YKT2CY0ckwiyf1e7V9us00KudKLbE60sNnzaCE3eteE1IN+
a0HRglUVyxGfcUUrGcqCa5AnCNftlR/C6xb8U5GMpJvNHBjvWLD8YBRCpPU2
2vcvmJIcjHQ+rDWvHFswwcADOWVfVL/hz6J/WSDCPHfMkrnmFxyOIE+Komrn
hBbtrobs8Tix11tm0QmrkAERp5pm5UUTOBESZddufe0ljxNlAzSrMpEldxJf
rJE0Xrl3ye+INvUc707bLDmf+POfEaNetyWnE2PV2iv3+i05gajaWW5QeHrJ
BILb1iQ0Mg437WtI2UQK7htJnsSDWbgbJ/T0NUpxozk9W1uGcMfH31gttI5g
sORz6rFSD1Rw+1SHysJG3Ebzx9YF6OGe9t+p2bQft8P+n8bxIbjXrTQNFmrH
XRQ91yp0mQOzIqfa9osCyzAP/S4l/zzNhXnGWyyreZ4bcx4hLS40lBdz6erY
k1uG+TCLPjLgsAtYjrnihXPM2a4VmEt2IWUrvFZitpvd3+Q/LIj5vvjAuK+a
MGbjEc5a6zHcCSTbTDRLBH/PI8poor0o5ilhwWhZaTHMfdvi1z9swv2LPCXu
lyyO+XOS/6kbtqswB+yVa3nDvxqzCpofptyAO3oyWCcmTAIzRc/G2mGbJGbZ
cvFq51ncipz82w/nSmE+EN7z984JaczK1OE33aoymJtTBWYudeNOfyJy0f2u
LGaZC6bcYLsGc2mcZ4+NtBzmTVqpaq1duPdfIwRZJazF/F5qfRTXBnnMhu89
bNwjcGe+yTv48wtuia4ffLIGCpj7Wgx0a8i401TNVruk4Xa4YPtr8jbuZrWj
hTL3cJeTrm0KeICbrDmosroIt3V0jOSRBtyCvddnZhtx125N74hrxm3UV5Rc
0op7s94X4RWfcAsMbuZ/Noi7ZseOIZMh3GGJxtVdw7hpRMcI7jHcQ9fCOA7+
hztrOK53bBq3G6RUXPqNu+PHk/NP/uBOMihxNqTj3n+jckcHA/fy0Tppv7+4
qYYdf+bncf8f/o2ruQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk01F0YB/BRhLJGskxFIiJZKmLm94ySQiRLIaFUSGVJCpWxViR74ZUl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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk4lOsbwPGRXUJR2coWEiGyxMx7I2Q5dkKHaLGVIkVSiWwVsqZsmeyJ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxFznk8lGsbB/BBsqSoJGvJVuhQJGLmuSRbZCm7ZDqVrc0WlTo1kuW1ZlJJ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Hk8VN0fwPGhBSGSZFBJsvaopGxz73dSCFmSnVBZS9lKi2JEyPJYkiKk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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Xk4FWsAx/ERXZQsJUtkLWsRLU6cmXe4loqQ7ImTslXXTouyZCuUfQ2d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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Wk4VVsDB/B9CJGQXBFFZEopukWcvde+rmSmMlNkJkWi3htXJ0TXkDFK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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxN0Hk8FesfB/AZyp5UOlmOKHsKaUHOzPNwaVGWZM+NlK2UJaVbkigiZU32
pEKRFKUu2SIisoRulhCyp5Il4TfHYeY3/8zr/frM5/t95lln62Jkx4YgiASK
IMz3mJv00GTKVRxZeI5eEzskmmAPFi2crSAwEH+G9NgbFae6eH/SnYbPV5fF
R5H+uHpysCA+hfSBSaHmvPjnpMOcHuz7N/4Nab/LN8sUQ5tJe4pzS3Fd6iSt
K8pnzxD7Snon17pdCluGSev96ucLc/1Oms/6XZnT5THSIkIrQHfgBOkPVVJP
bA/+Ji15tti9wGmGdIFM+nfZ05QtGyNdw3woh6s4njx6a9FZDMXO/cPVyYuu
YFSGaDirZi76I8Melx5MernoAQbbMP8xnrJFTzMS4yb7TtUumg/bodvl0Nay
4A461jRZ1bvz64KTNmHuqc/ssn4sWADH+E1vdwvPLni3PvZwSeARP+5ZlvFD
2M5s964hwQV/O4F1HbY6bCqxYOsLmLfAzo5CBZaLwoIxkUIla3lVliWC47Dn
J4Tbw7VYrjV+iBnR2f/+o8fy7p8vsJHKoRY7C5YrXMqxoH+aLN8fZbm7vhGT
kSv6T82VZSPpbqy46YF58vl5+1x1+YFZXYlo5g1g5b4vEXxyywXT0+Hzhnyr
+fHILvvG9gSWf9aJ4Mphhsa7H8x79FKOLP4O7Gh4kjPvq1ZlW3HHEUkj0aJ5
O07zaOFLEpbVXa6ad5HHKgM8ae+EwUjTvDMmAixxxu+OGrOueafketjjH9Mq
9YqHmfZxbGl2xz3Mct5tmGLtRy0v4gIciXsjl8wx84rQlkA8IyegcmY50xIq
xVI38d1H3PY4iDJde5RL6g7eveJgRa0M0zZ1udfTcZ8i7V07VJiOpg+OPcPp
Lopv7mJMpyX1mRfjL8SEdJbtYXpI7OimKtz4HVp6xphpZXVf0UZ89NygVoc1
0+z9U7ADD5ZvLN5znGlf3+66PlzuYwHMPsP0Cimxyh94qX9aId2X6X0HFLb9
wa23heP+15m+u/bG7BLw+8v5V9+imS5cW/OHH0SF2zEs7hFO0r0j8IgGVDQN
8koeEw7lbDDwkAA139R2bMwjDP9oNj+SBccS17+8+YawoY7Gth5lwKHHpzZX
R5hLx+BOnypInv713LGNsPZ+i8g3EOAPP2+r7yMsaBIRaL4LfDJ/m6MxRlgx
QGM93RCc4czecn+OsESSWxafKeA+qG8RsBSBiNeM6aaRv4GZymshBi/hkbaR
O9JHwX1utY+jAoQLnMWTeo+Bnx0Zt+7TCG/bdGp1rRvQfLHOzJKOQB/l3K+j
dp4gJCSKtnw9kWuYj9p5eQMvhWDhVFkEQtvT63bE+gHH8kt0sAmBRQ6pAzHs
gcDkiKd4swrRd+/Ujc8IAVpzzutd1BCY1Dezx683AijG2Upz4kR/StmorTYa
iKqay93+i+iP6NVwPk8EXA16Cqp7iNyyyml7azIYO/mX4nt9BNoothe8mUkB
HTzqmx2Mifzj09GounRQnaK4dc6C8K18y5s5WeBfLSnVW9YIlFCgVwQOZIOU
duEdSnYIlMtvnZYOzwXh55Zj5ccQaDjbOV3yJA9cpC2F1q4IdESwUrpsEXB+
+ltr4jQCQxlnBf56VgLM9Ud1Qs4jMFpt4tILvzKgPdCzW/YSArMEyxVuh1WA
zf4tewv9iX2xORbPWqsAT8Gb/d/CiPkTtIKfwXVgwiLfOOAWAv3dZEOGLzaA
7l9PzMQTEMioPE+3uNIIXm1K+NsgDYEborauUMr+Dzx8G27z9RECVfqjlbre
t4Aou6tHLmYjsNWj3bD6axvwQ73t17xEYJCr532usc/ANeGU0+MCBObTZKKK
xjuAlbqT865SBIq/POwX2tsJ9jQecvn8FoHvlkv4/inrAtvdjN093yMwL+fM
0mdhX8D6Zbqnlzci8JMo7UrKzm7A/wCcTf2EwInkdlG+rm4wrb3tPOhAIEdT
KcPncA/o69jg3dyDQCHjQXbe1z3gg5fEJZdB4v7EW4s3Le0FRUK0y5zfEVij
ZX92UKYXPMrhDbg9jkCjmjCRGtleEGuIBqn+QeDB8IPn+jh7gf/QePB7FIWB
zu96P5T3APerQyEOnCgUGlsfkeXYA6ylusLn+FA4bsIxtmqoG+wrar55ayUK
37KLGnEZdwM1q+poJSEU6kv2d/5O/gKkJ0viysVQmBj3qfBRSxdYGfki0VoS
hScjaAxZtAsMVt29F6KIwtrGIQ5X8Q7w0SEmVXYrCu0MAmYnsXZQyh7ysFAd
hVmX1GZ2b24FiRrnsr5po3BrmoHTef6PIKjZJTtAF4VzHV0RLkuagOcpu+fi
hsS8zOI/ARwfgGG6Yb7BQRRO2B/g0dasBYxdOwu/2qDQowa/cZ2tGsh/0Si5
aI9CJDrTFnvxFtAubi5b44zCG4cE3U6kvgFsorIVj91QyOOnxRdV/xqMPKdX
7fJE4cYpnpneHcWgxWhlzWcvFI7mVJmUF70CFSOcdZ6+KMw/2ZnKffklyAma
aVh+lfg+vVg3P+8ZCFcLD1t3A4UMpY682LVPgWuvjMGWSBS+2LAm6NPEI6Af
mcenE4tCrlRVXtfINKCgZVhpmoRC5Z5YzZDZu4BrtDvAMQWFZ4VWD25YlwR6
E/7ROZeBQgGbTLlzNTGgdC8/e/BTFEqYzdRlno0EyVPJRQkviPzEg6/yIqHA
J1XV+3EBCuHm6dJcsUBwyOSdRnEpCjuckdKC436AwX54qr4ShT7PZre0vrkA
hJ/8et5dS9zP2hJ3vztnwPihII/xJhQWCUytEl3mBj7wiatwtRH5sbGB+2ed
wNN/s78JfyH6y4Q3t7fYglDH3Y8U+ol8/weH4MyD4CSt7Rj2jXDccScjSWOw
r9RNzuAX4e3qfgU8emCDO0evzTThRNCQVqwNOCXi7rqjbBAREO6UdMRAd7XS
4cuchPumJ4/e3wpKzpeujVpGGHo/9M3bCJLkLVpTVxFWa5MJqJUE3s3DMS+F
CfvEsGWsFgVWV3zNqsQJhyqGWJqvBDu2rFndJk246Om/r5O4gFBnev2IAnPe
bM7AYQT8ugFDERVm/l4DxvzC6xmNeivVCCO3vnerDuFZA068UjjTSnxa2l34
jejZim3aTB+SMXBpxp13Rvjv0mVahquhshrXHZPVtjBkeuxny+sSXC45Hz1u
yvQ+Q0/nXJzDcH+hlxXThl1Dkxn4l5kerxu2TJ9tWFl8By9KP7cjyZFpxMQ/
5CaeaLF88snJeefc/B6Ie3Hee/bag2lYGjbijVs+UzvVeG4+D9XRccfVjlQr
f/Vh2ufWa1s7nLbCdmTSfz6/erjaHB8rGE/nuT5vCW6ffXid8zUnesS8uy3U
IZ4pIiGrGDPvy9J6KnhwRU43uD3vJBMPKfzYmT3J+++z9tmn0PDdUu3WR9JZ
84L/48Jl6t3FTj+ZNzLKNo0t8eFs8c9lmX3NMNa1KT46+hXL7dyfscIWZdOH
r1n+5FCLxQeWrcp/y3KSYjF2TtWyrvo9y1IfnmDmPSM3PjeyjBgnY9sj/PZ9
b2E562E4JqgpxMPexXJHoy/2fSSjXLCPZfjBHauJ17wiM7LQT7HFMnSbtNTG
FrzPCAuaPIbo/l5wpSbmmDL36iDCzrLEZmynceT5ExwLNpfAJNnk1S/yLbiD
HxvXezwrt3LBPrOMyphtpfVrFoyMMBJ68gK9xBbdxnDdrGUgI7nod4y/LlQI
1sotOp9Be6v/6R/FRacx+gUbb0tuXXQoI9/moF21OuWQjM4NnmDRCGI76TAq
oUOZK9TjvIchZePC62GiDpRleQXNypwp/zaNpbu4U04aSUktuUB5WKzolVMk
ZX+vH/25xZQtKs4+PlxOeaPgnAdvNeX6dF7E+iPltS1SNI5vlHPVzbSM6UtI
943nxY6eoZxh3CkieIGy61OOOFU/ylMn9sd5h1Dm6emN40ujvLFhRYLcf//X
f+xw20ZjKekJh1X3aucoZyLx1y9d4iSdRws+tbWfi/TKBxA1deEhXfjC6to/
LbzU/2hjr3jtl5E2ndR/f7Kfn/R9we4RJ3kB0jqDbJUHhimH+pjcxe+toM7z
oGgozGwl6R8C/EF0kVWkO7eHSKe9p/wr9ofg8UhB0m3hJz2iTFaTdtmztr6E
m0ZaFs/yk6mmHPT99JZrfmtIF6kZHzDfLkSaXiBYbjVJWZKNW932kTBpg8uf
ZxPdREjLlPWXtMqJkq6N4ZvwbaWclLHios1tOmlRb92lwESMdN51u8/GImtJ
K22OkW9ooawfgbgbhYqTfissHbBkgwRpzbdHjG2uUL5bkmkx2k55TcsAFx2u
I91ZD1UrYinHy+2l/R1P2dzb5Nf3BMq18seyRe9QLvCJUHJJpRyr2CtLy6F8
IOia0NFqyvwdNycmayhXbktqul5LWaszJzK3gbKyWrsA7yfKfL3K3E97KVdo
aPTt7KPsF6ZT3tJP+TfD8srSYcp9EX6oxU/K9/qvdwyPUbYG0YW+45SbBjIu
ZExRDoe5VprTlPWjijWa/lDmGaoSOT5LuUyzaWpujvL/ANuwHSA=
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      Thickness[0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxN1nc8Vu//B/D73CmyQzKjyEipNKz7nOsiVEI+2aOQzJSRVEi3iNIwG8q4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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxN0Hk8FfsbB/AzU7ZIlGSPEqIkKtuZ+X6JFmWpZImbpQUlRKsQ1xaRNcm+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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1Hk8FP8fB/DdWSEUSXKsowilJClkZz5DIZtEJOQXKWdyFpUjclTI3UGu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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k4VO0bB/BxJksISfa1ZCmJ4o2ac56TbClLWUoUUZaSvSgSEUV22RoM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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk8VN8bB/AxM5bsZMuSsWRppVJk7j2XsiTZU5YfsouypFIoISLZ9bUM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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Xk4VGscB/BhjiUkhGTfsiTSQmTOeV/a5JYoyZakEkKlTVmuECGuLUUj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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Wk4VG0YB/DBGQnJFrJk3yq7LDXnPE+SSpEiISGVkCKpJNWgSCJbhYYY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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Hk8FP8fB/Cl3SXkKCT3lSP9RIccO/MZEiW0jhylbAopIpVUqpUo95lc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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Hc8Vf8fwPFL7iFbRrJXoUkZ0T3n8yFRlMisrK8oWrSkr9I1C8lIyl4p
K6lQ2dlCiUJkjx+Fr5WV9Dv3uu49/5zH8/H6fD7v8znS9i7HHJkJBII2E4FA
ec9e2jy28PQuRqA9DkHiNqJxp8GaN73exvsj1o3u2erdzp9j/enuM8oXrIqN
pLtdcOFnSexTuk0WhNsKY/PpDnNOP1wQW023j+/Dqp2hbXRfl1wvx+bVR7e+
KOdpkvj/6NZlk9bbtmec7iO/RjnDXKfo5rRtqHL2naVbRJgPDAbM0/2lXu6l
/cklumXd318ucf5Dd0hIpBCPDAGuOTfwTwvPXSa6ZZkVNW5zrqN77siLFYUN
DH+IUq1s3siwq7L20S2yDO+/VSvQpLDmRJJQnWHHjZ1rziGNCnxNkFVZcxmp
yO6kY6PGmhtIIVl9W6+DNXeQ7BfOTEodWPMwSVVnIu+D/ppnSWyhVz2uGtFc
xoR2di5BCfO1zoNmy3shtSfXLIp6XWFtuPQPzWR51LQ0OEz0DM1QBZXnELCo
Ok+zkxa6ZB4t5nKZ5rdH0MZkqX5hd5q1j6OJE0+fld+i+YQjekVzx4XzPqsm
/7qE6vq/3i0UQOvcnqhIs8ZC6X1aJwag4+Jlxc4RNL+LQMucdX34o1c9yZ+E
RuQ1HCxOoHVCFnqGyYT7TOqqpdryUc0j31p4M1e9cLcc5YqyjSrIoe0fb0R7
B4dsHPJXHcnejr5WOi/HXbTqFLUB1P/m9Oib96tuDJ5Aj9e6v/inZtVp2xbQ
7QJ/r3I0Uk3mRtZhf239NPOaqYYy9VxYcyYHwbZ91ZpqG7HU+bAqtm6qQ7lW
pDH3/cJBrwaozrletg0zCIk3shqlulfXQBWT6JQTQv6jOjFKC2JTWzI7X8xS
vfDz5UGs8rJy0vElqtPupx/DHpW8Ob2OwELx8nleK+wsO7b9OZHqV8krDhhq
XjllzkH1nQHogvEm678h8FFMntm++To2ON50M0OI2r07ubywNxoW2qZiFMMO
R6YALNCvi3VFmuLEHls0HLP5fKrxmTzVQXk3ojFl8R/hxjso7l13SCIFY3F2
tfy9e3X+b/dMrC13Tjx1L8VOO6pTXmMZhFsDhhjFabx3JwuxW4fXpS/sp553
Xaa6AjN6HHAx+RDFVpre3+ox2UEelcNHKf6i6u3Tgs3tilz8ZUrdbxuq2onV
eYiVJpyg+Nkdrt5+LLYm2feQHcWP2Z9x/8Bc+BX1ZxwpdvvmPTSFadu+4Ik7
h5vsr7PebQETzFT9qnuJ0u9MwmQCGJkrjJ50ww2zW2K9EZBl2icicAt3WUX+
yQ08wPUVEqPuQ+miFcvGgkCFd7voyQCKGz8UCImDxQvGMZ4hlPNSVTIKZEFJ
vZto8kPcvEo778VsBd6KsTFVMbjbNeJftioD3TvvRUeTcAtn/BWuVQfsQ8Mx
nGkUN6qU+gHwUZtTTCkbt2XOxvtVOiA8UTnWJBe3SsboT3UDYL5iLna9AHdG
Pran0BiIWt2MjS7D/cS++dSCOeh9lyRWUo0buzcUFWkNnmysie1rwO02dKh1
2h44XRsTI7bgtrutNCntBLa38MUpfMMdaL6tPuQimFRSFz/cg7uVTxLFroDc
+1ZxLkO4991o7RJ2B+5jXuIPfrJAsgCXfiuTJ0D1n8XlT+H9qCq3RYQ3YE5r
EO+YZ4Hwgvrzw33+oJo4HffnD95B5Vk94j0QeGqjhDQLERJGup4Y8oYBw/ek
eB12Iiw7qW6pnBkBNkjaSzjxEqFdhsRbkeHHoPXmnfggISKUmtiLzH2JA9Ed
WRIvxIgwcaTk5aHqJGC7tzm+WQbvnB+3K/GlArnIeYk5BSLkHe5fYW1NAyMz
YgmbdhEhVIl1ipJ8DrKMtSVRVSI8mOFRt2s5B7i+OJNgt48IXflKe2TyXgMV
rmBJXy18v4+l3q7SfLBw9lXCMz0iDHUadjKQKABFtW2S9UeIUEnsScerr8XA
a8ufhAkTImwf4hfumSkDur4yUhtOEGERX/i3rq0VgL1fL1HVjgjHmK03D4VU
gfC48MSb5/H5bELG070fgPnvN1KJl3Fj9iKRdY1A5HhXYoU7Ed6UGwnLO98E
UgQUktj9iNBUsPNc9IsWkBtUnPQ4Dr/PY/4/6/I7gPtov3RRChFaqdkKvvL8
Dkh6bMk96UTY/dWfx1a7G1QxmyRvySfC2MADcz1fekGgnbuMfhER+qlebLuQ
3AcMS+KSL5QT4a+w8u+zDv1gg1iFTFgtET5lZn7qJDIAWm+MJOd+JELDi2Fy
bWUDILqNS7b9CxG+7bRiv2Q+CGxU96T87iDCSV2WlLBvg0DmgaWsZB8R/jtW
NlZ1cAgMT95K0f4fEYpc0mhoTh4CGYYpsqfHibBTfYBUMDwELmbVpgTMEOF2
7aOnS/mHwW72Cdnni0S4Jyvaz1lxGMyf4X/S9JcIe54sJfrJD4MTge/OtBER
OFUVZtDCPQyKsmy3dXMg8LOg0qGWniEg+Yn43yAfAntPbB3YGDMEvKcyX/3c
iEAb34x/XbSGwBD/MbdpcQQ+zC382tsyCA6qLWgsyiIw4WlD8FOTQZBpGf/n
ryICpZqOvlEsHwDcHjrvESUE9kef7PotNQAuxf3w5VJDYOVWbpemS/3gS2no
QQESAi9Gz5Zcy+8DUSxdn6QPIrCM+Mu+WqYXyN2/1k2yQ+Cu+bfLCh7fwJ0c
0eT9pxEY5zbvGFXZBn40v3fUP4/AquDILkP+VpCzkXvcwh2BPJo+zaYNzYBf
MzfHxhOB3zXIuY37PgM3qxNXHX3x+ynyzqdc+wT2JT39fTkUgcxM7CPW3+tA
fMXh0huRCFyWddfg1a8BhOFpb3IsAiOLeLH+3kpwii1K904yAgXajJTeJpWD
6q2A/X4aAk0T1B723SsDikeGGiOyEfi25oilgU4xuOcSFBaTi8Dz6ntHkt+/
A/+FKZslFyCQPCsdHxySD47ltgmnlyGQF7OIEc58DfJab31/UY3AEQ9dhwLe
l0B4UTYxvwGBd/nGkSH358BD9MOp4mYEGq1/LN5kkg66UVf5ynYEEuSRbs70
VKBlJ/TzQzcCha0/Nu5ySQZPvIuyPw8iED5N6rymkQCQVPvL7T/w+ULHToUY
RQPnGja1nkkE5lS35JnxRYKG0ezFoTkEKgXr68qdDQc7Oc2Kx5YRaNfuoeMS
cR+E7fxNnmFmhWX6uitJ+wPArFGSzhIbK4R50fNxlb7A4ooeGxMPbq20PTeW
yaDg4Xg9qyArJDt+sbBJ9QDibx+EcIvifUnRCbV3A+QODRNBaVZI2JovO896
GQws9wiJyePri07OtA+fB7qS/h0yO/CeP3DOleMMSNfaHq+4B+9Glh51evaA
06H5HyUNvGvujT3XYQVc/N03qwPcZtc4VZ+Zg+Y0iVH0AO6Ks+mBL42BSn1l
lo4Bbpulwg23DcCj8bOuBsa4J/K7RLQOgCUePpVjFrizqzgQSwisdr+Zt7TG
zRkersKkAUpNrQttT+Eu6xwVYN0DZK6vu33aGXcttjnl43bgF5WufcEF990I
sT0vN4ORwqPI1Wu47UbMsoAUMOj+VfevB+6mCcKwmjDIJsQGe3nhJkiFPJjm
A8j7Pcel7uAmk7cVsXAAG696udJ7uKUIqBnGAvK1Tk1ah1N6dM2Y8grGw/y7
cPkR5XuK9W3OzmFO5eF3YuJww6FBrdBJrMx7q4lmCuV8M/9g6xFMeH+5xLc0
is+bPWrtw1zXnfhxPZviB/5Bf79htRVTeUK5FHNJ3etsxqR8A7zy3lFsPlmk
WY+560gfMS2lOMLGKKwCa2J5JzxTSbGDvshKIaZQZTQY9oFiAcXB8dcY2W/k
hVITxUaxeVgW1n6A7PHpK8V3nxDGUjBlRFjvYifFideKF2KwwOoXG7j6KJ40
fhT0AOv31+vOHKZ21u+7gjBNvZ50/TGKCTOtn72xcNbr10anKCZ7DU3cwH7U
cGvdnacYzuXWXsK07z7llP9DXR/Vo+uERR/E2quY2ShWYfe0w6bZWlMc2Kg2
8zpijunXXXBZx0314xIWQyw5gLgvmZ9qhxOiOtjSoThEaxPVWaKfNDETdtXm
HgmqeTvqlLGsDw1xnnJUtxd7ymMsQQ7O4lupbursl8CsDJZVinZRbRelIoDl
ckQQTqpS3fv5KDvG2bCtYVFzta/nYsIc7lU8egypLstc+YUWHT55Sl2XavI8
aQwV5JrZ2Wqw6iD2fvRiY+DSVWOqCYlTrWh1sEw1v8WqXdkbUQnDgrBXVqsu
0S9H3biPWRvbr1ruv3z048dRhckzqz4Yn4VuCfGavX9h1XZVSajn0U1lO66s
Gs4/RNt4XgY1uNPmEYNQpaaDFuc8V90bSEbvhvbKsPvS1itcRXuN3CfSAlZN
vuyE7uXjLdALWTXB2xoN/fzMbziC5nfG6EgYMPaLplnpAAqPtYnJJdK8VwON
2uAyUp5Kc/sOdLoZyf0nk+bH0qj+g/jbhJc0JwqgySZqBgn5NEuxoUv8H4Ww
IpoJy6RjXxz7v7+nGU6SMiL+PPeooZncT2I2e3hDpHFt/VfSCcEdB941r7mW
9OprJa9l+5qLSOyRVt/nutacQ7I3n332cGDNiaRCoXtXVEbXHEpiGS1fPPwf
w4aFi7cdf60Z/6e2Z+5FMq2nG0nXTl3YxLDRvsXWIn2Gh21Pax7IYnhDOmQy
d2Gnu/StVdCNTg663+igxRynueg2XzD8dHGUm+5UgcEJZ0Veug/8ZP5gMs5w
KNksBXvCR3d2etlYmMUGuqd5uQPFRPjp7lML2Zz2ieFf0dMC5yIE6O4Kv3g1
0kyQbpdDEs3l64XolsdyfLY0Mhw4dW1PkM9Gusv2mppYqgnTLVYiUGO1wLAs
83oN++eb6D7q27MSf0mE7i1Vo+XfFUTpborinPf+znBiFt9tuwQxukU99YnA
TJzuwmDHHlMRCbp3KUcptnQybPiAcPlYqCTddZs232HZKkW3Vt0pUzs/hlPK
s49PdjO8sfMHmxiUpruvGarXRjMcq2AgZB3LsKWn2a+pOIabFM++Fk1iuIT8
YJfLM4ajdw7LC+UybBIYJOzQyDB378P5hY8Mf1BNbA1uYli7LzfiTQvDSnu7
eTk6GOYcVlr/apjh2n37RnRHGPYJO1DTOcrwEumEH3Gc4ZEHPkzHZxh+Mhrc
Oz7LsC14XOo9x3Drj6xbWYsMh8M3Vlq/GTaMfL+vdZlh9rF6kXMrDFdptS7+
/cvw/wE3jspH
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk0FW0cB/Ab7lx7iuw7iVKhCN2ZZ0iUIiKVhGyliBSRJUS2VITsa4Xy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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Xk4VG0YBvAhZiZ79n1PJmuSFnPO+5JUKtmVFGWJNlJJJaFJRUKiZCxR
ohRJSvlsCckWkpAlS0aULCHSd2Yw5/xzrt9138/zvtc5Sge8rNw4CQSCPQeB
wHyPH18+NJV2BSUsPK5hcvtkEtzBoqWeaQgN0n3ZHi/X8/xAD2G72yJP7C09
lu0WsanvhfQ0tq2nJD+9puexHeWZsf0VvZzti7SYt9qRn9g+rbBUlRzUzbaZ
DJ87Ve4b26Zkpc0aq4fZ3jHB4Ivy/sU2n1P1W0/aONvSkstA79VJtpveqz49
sOcP2yp+JT6Fnn/ZjoiIFRdUJsBF54b+bRS8wsG2Cidl/QW+JWz/3pE1py6M
uypuTVmDBG7vVcY71VRwFzjvcatZj9umKDxK5iDuEP9RxosS3Lsr/bL2V+DW
FP13krcGd8MjXoJTC275NlVx4k/cL9bbG9vIcrEdeukLaU4J974PLjUPVuDm
8vTeNaOH2+L21WMpWxedTFXpFdTfvnPR2dTfOrHTEzaLfkl9d062KMlh0WVU
ekUKbavzouupXiIUszG3RbdTjZ2yBBMOL3qQKvZozUfT44v+TR34/frOiO+C
AzmRTJtuadHzixZCvHOI8WsvLvblEH0hTZk9VxdzCjJ91DI+IGLB0AApfO8r
kxKzYIuNSDCFHv82fsHZFojp5RIZxt0FZzoiPH398XzpCw7yQGqN+WR1nyy4
6SRyI3kV3Tp33pAehNjN2cmefjXvwMRwRMbRn36neN7F5beRrvy7soXl89ZN
uIfck6igd1cvzAs+RTxODclyN857RKwA0WxclqD+ecFz5ciI7lq57Z3z9njV
gORed0zw6pt3pn0H4jcUJBf9fd5DPgMIYvYgIe/XvF1vjyGc6dVyrZMsB25H
/yHl3KMJf//O27+cjIa6SMgrcXEzDQtDRVDzEmqiCQ/LyRIP5VFhhQPyHkIs
E2x/rECb/S8nhomzXJ8frYfeac2Uz5JlWdc5m4o6rWtIbFBmWZ+w1BRVjZ2U
/63OcnvRRwt0YEw2SUqHZa6A2N1opqWxArKG5YIaexfUO+tgkrMhy12cEkdR
ff5wBZoRy3P6pafQqUM5SQ82Mx34zlM3EC2o/KTwfgfTxWKpvy+jQWp/k35Y
M614c/+9KNSUpqwo7MB0VzbhUxzK83Vz8hpnlssYDSloLTiquNud1f8gvuUR
eiPhRrL/EdZ+yzMPn6F2My8Uk32YHkmX0y9ApXd/SX7jx7TQYS35MrQjj1Pp
WwDTmiGd16rRVFH1uzyXmLazW7aiCfXw2aGkHcb0ge+qO9pRzXqfu5ZRTO9z
rS/rQUe0biudusW0+6TBme9obth/d28nYA68sy7/7yjqx/iqVJDKdMMud/k/
KHUzOaUzg9m3TxLu4ACE+1rKS7IxQy40w5IM3nJap6jlMT2p1OYrBEKd/ZTN
CpjWsLuoJQ7MCxNSjpYy9yUfN3opB4Rl3yhHVTJ9TD+4TgU0nxlIya3F7B09
Zm26Etz5xK/S0oS53iEwxXYV2LdmdepMK2YyZ8iuEgOgHL1LRaGb2Z9oan+B
gP6R86nG3zCrC3GGmG8ED81TVdyHMXt4XNCY2AKOZVamXh3DPH6HO57PAujx
/FB5PI1Z9MSVnVdtwORBkXv1/zD7fy6WXO4AHELzD37iJkKCGk2py98ZFGQ6
aXTwYu5Yr/3mqStQqOP+2bsMs5HGA43PniD416Oc7xJEGPhD+D5dyBv0iVj5
jsphnrm850DnCbDFYGr9tArmw7/6R339wKNdiX//UbD5mNtJa6bPA4FzJiVE
XSw/uooiaBoMjicM0vgNsHxdzNg3zRDQVBS5RZRKhFCEY49dZSgw+GrAJ2NM
hIo/POSbJCNBHNeXOqUtWH/V9C8Z42gwq3YxWt0cc/4H07QfsWDfVoq9jg0R
Ontwj45rxYOSw3XSBg5EGGlDXqtCTgaq1091UJ2JcMT4lc6axhRwOVsmZaM7
Nn8wsv8tIQ0MNpS4mR0hQu+5Sj+/uAywY+IgxdKHCLsMy4623H8MsiUEhu39
iHCLn2q7hMRTILIhN3tfANaPc1ulmfAM+Do6nHSjYff/nr/1rUceaAkgrDsS
SoQD3ME9IufzgeHdtBmfSCK0KK9VL20vAIlvthediSVC/ZVDEkMmxYDQPxoc
SCfCKZrrqXrjUuBCjjO9nIKd/7VZaYtHGShfCXiupxPhPZ3nN8WelwPKjr6a
m0+IsPrWypVn1N+Ba15hUfG5RFg5TjJWL3kPrHI/SWYUE+F4jR1d93E9eN58
vj2rnAgz6W5CL1Y2AMlpleS8aiLUjjbndX/eCDoQ7xVlLUQ4mitaHcloBp4V
ZIPOEez+BTyix4K/gGrGk+m+39j3i4lI7FHsBNp8tv8NzRJhN/9Tm/cOXSBK
eyZwjJME3VOXEMLlu8G4xV2TP2QSnGtBEjlbu4H9ic1kDkESzFXIig4M+wpe
xQy/J4mRoH/lUY5Dq3qA3MvoCAEZEtR6trzEoKoHBLautxZTwvqzmVJnbHpB
z2ynuOwKErTyGhPqqe0FpgohrcpaJPjjN91427o+kGGkmUhZTYKSV8uWP43o
A3yuDft115OgqVR3FmzqA14hfsvXAhJ0g96mttz9oCFdnoFsIsHWqLLxc8r9
QP99WabJNhKcVSd1ntToB7eGD3lvsyTBLOtlP1cr9oM/gsv0rexJMCVe+3UX
oR846r2Y3LWXBHn3CT38WNMHimz2vnZyIcGlH1CHxMt9QPn0kgvuniTovUnB
bkK7D1yKyzA+6kWClnqoYklZLxh4vZN48hQJXtf7eV/IrBds65h4d/YcCRa3
hahLFPeAJwR6eFAQCRJPH89aod4DiCWrdyteJkHl3v03lSO+gn1B71WLrpFg
zmOOOu+hbiDIOfN69hYJmskXS1IiuoD3EofB009I0Lfo4Mlfq9tA5Ztfz8Vz
SZAiJF4glf0ZKNKuBj3PJ0HrmNuj/lotoJ4rX3KsjAR3f86aaNf/CFYRJTcf
a8POH5UcsrWrA6HlWcL83SSoWtt45XBtNfgasrnjUT92fnbMXmeXKrBhc2eG
2RAJrtQaDS4UrwQ3SKdPMX5h/+MlOv6Q8RYMVggYXZkkQf3EETdG+xtgfCWN
b8VfEtygZm3RPVICRsnNqa5kMmwfpWh/mygAZu+Oei0RIMOB7FHumK58kHKV
2zBFhAwrE4I9Kpa+AH+2JhCNpMhQljTTeMkrF1jzrGnolCdDmsAyx7OCOSCz
qjohQJUMLRSaf3PVZgGuMFdPuZVk+JJ/z1BA/yPguG1Wv0CHDNMdjgttP5AO
cnlvEvasIcPI1pHN0ob3AV+1RvX0BjL0S3VTOX0oBbhee3PrNiRDXX905YfG
JFCwfY/LWlMyVLSS/sTtHg/E+Me0m7eRYZdoWO9kwC1wrCb0z0lLMqxXMXT2
Fb4JysOVy0Xssfv4Z8bUikYBefNXUTmOWP+/dymlE9eAr4DVXssDZAjlXZvd
Tl4BtbUM9ZGDZEhgmIwMRdGAWkTQ+PWjWJ6aR6FQg0DATqlirRNYHnhdML/M
H3wSfBpW7UeGxS0nQo4Pnga69VvsDwdgjn/1NrvmBLgS2aXMQ8PmC2LE3W29
QZeF34/0q9i89OPRtc2HwLplQq82R2DO25CYNuEGIj88uNR/kwwDb7Xm5/bt
BwNRwPLSHSy/5kanCewF0OqTrGoy5j6DhlUB9iBO2Gug9D5m140uyt+twGgD
MXf/I8zB5+O/7TIHZtGJFwhPMRNnKSR0C0ixNtiWlIfZ5wEtdutG8EekVhwt
wFyfrigVhQKrJrev7SWYPfLehCmsAw9v/n18rgJz11mV2Qk9wGkbc0a6huk3
FrQsLeAgprUpvwHzFv3eD6orQM7HMqFdLZjTA185TSkBnljH9t9fmN9rfV1n
lQw4YDf+IKYHs3Ox7ZGDYuC1+LUT+gzMhOrZtENCgItROr39J3P/4apLwWRg
/nr6gtsEZnhW0HoNJ7gVrksMmGH2g7fZDf1Bu5wOXovlWIrlx2LHasfQlXqJ
wlkkzASl3occw+gJro+3K/iZnhu4rtyHFjTzKnSJMF0kYJvWgRIzjO9PSTFt
GvdMrhndee6MxjJFpmkdP0vr0Ns7sp9S1Jgev6aQU45+Vfi21liT6X7diyrF
qMaoXKGDHtMjeeKf8tCTZTYmJ9YxPWBlLZaNFsaGVYWhTHv8Rw1NQ0mepRb3
TJiOrNDwSkItDKebC8yYtpBtqotB7/Dr7v1owXSXvorCdbSn071n2I5p58e7
c2ioZk6CJ3Ev08Vfdu7wR31pTT/lXZiGQVeNTqBFdry+az2ZDnQaEj6EkinG
szu9WG4ejtyPWs34BXucYpow6BZuj8bXZJGDzrFcYH5kJ9qb1H89LojlppY2
E1TbR04s5zLL27deN0RPm9jEV4WzrB8vq4cWi4cp9USzHDidvQLlYZQ8mIlj
OXJ1szxq/XpKSzSZ5WKdKRGUHq6Tq5nGcvKJgqVov5P7hk2ZLDvTAgmorl5C
8d6c+f5LgQnkDFeTqe/L+f31BYNIaTNPzfVClgl8vV0IX4aR9YOyeVOoHxHb
c36fi6rmfSSyCknckeXUUj9vnyvFyIBCf99I87ypZ3ORVaOyR5Z+mfdLagZy
tsx6VKln3l2jiUhZbKjfBsaCu28g/J4lc1Y/5604HILYGU7RDk/MuzjnHJLM
r8NLm5k3Ic0bYXS6RdE5eOY96ILo5dAlnpMWnGuP+NMaE2r4Fyy8HSm341Ht
F1lwKEQEKUYP56QW7Loa2TVzWldCccHJakhKzZM8HbUFQ2nke1IfdYvmgp0F
EH0f2TfOeovmQAJMrLeeWbdgwji1Qjy0LgpdcGA/VYhRbPvQZDFvpTq8nmwr
NVt0NTU1XPtAm8Wii6lDTm4DY3aLzqUa6NGP8e1ddDr1AlfjuKrLoiOplc1L
zyGeuIUzIIed16IJBEspzwjiKdyRV6PkXpzFzX/o63rJENxkDZpPKx3338yK
nn1VuAeyzcsPLudlu+ilY9iZNtwvTJD/eN352babMq87xhBg+75o7w9PihDb
m75zVlkP444MtE1F7y1j+0lG8VCUvTDbo0ICobLSImx3G0QsT6/DPXFnVPTw
TVG2v9w4djLWVoxtr63yDaVLxdlegWZfVKvBHfrr1OqwixJsF6+zsd5lIMm2
bKFoheMUbhXOpesPPJZieyetcy7xuDTbam8Zpe3qMmzXx/FNBrfjTs5cdsE5
SZZtmQAzbmArx/brcLdOG2l5tnVWxVEa23CbRxN8rCIV2H4ntfwy10pFto3e
udg4X8KdWvpk90gHbom2QbIsVGK7uwGurbyDm66+TXwvHfeuANuJXwm46ymH
nsncxV0YGK3j9QD3He3+FeK5uK1DwyRda3ALdMVMTtXirlqT3Bxej9u4O/fm
i0bcuus6hHhbcfP16y7N6cddaWg4YDqA+2LUpoo2Bu4/VIdL3MO4B6Ivcuwe
w32PEd41PI7bCdwuCv6Nu3kw83zmNO4b8IWj0Qxu89gSw+ZZ3DxD76UPz+F+
a9Q8/e8f7v8B4uYoHA==
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Hk4VF0cwPFJmGunkJ1RhIQklLn3HCJSSbYklQiplPQSLRpLKbJFSHZa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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN1nk4VO0bB/BJxRm7QnZRhLZB70TmnOfwCgnZk9fWgrRZXkkpTSFlKWNP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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN1nk0VO8fB/AhaWbsWSJLSJaUhBBz7/OQLUmypRDfSKGyZE1ZipItUopG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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1nk4VO0bB/ApJTNjTfZdESnZXsSc8xyylIhsyUu8di1IyVI/jUKyL5Ek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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      Thickness[0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1nk4VVsfB/ATcZ3BkHkemoxJFNLZey0llSRzriSvMSQqinRFIZkiJaSc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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1nk4VG8bwPFBxMxYkrIkWSJ7QqXMOc+jhEoIyU+2yhItRPZeW5RsEU1I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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF2Gk4VG0YB/CxFWYG0WLLlkJKQiJzzvMolYrIloRkK9os2XuLULIUkcQo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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN13k8FP8fB/BFiuwuua+0EpFy83XszGdIpUJCklzlKFQklCOWKIVylBDl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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN03k4VO0bB/DJUsossmUtSwgle2LOeQ5JkiQhyVaWQkmJEi+TpciSpZDI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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF12k4VG0YB/ApFGFmsmUPRZaSkJQ55zmWJElThGSrtNBiJFt5NSIRaixJ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k0VG8YB/ARFdHMJTuJikKkLFnm3vfK8pOQomyR7EooEhFjK3tkSZJI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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk4FWscB3CFInLmyJYoS0Ii2eI6M++IJApJyEWSEJKyZItjqWTJmmQp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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF0Xk4VG0YBvCRfNnijH1LliQRskXmnPfIkihJkmQrSyRriIjJlihbEpKE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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN12k8VG8bB3CJv0LMmYTsEYVItsiccx9ZGokIkRTZShERETGWSqiQJCEi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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF2Hk8VF0YB/CpZEuYm52sSZIlITH3nisq0UKyRgmJkq0SUglJtqxDomyJ
UsmeJGQrS0IkyT5kJ8uUeN87M8zMP/P5fn7Pec5zztyZP0bCxuXEufU4HK55
HQ5HeZ9zkx4nZwQhuNWXXcjW08JJ9mDNgnly3KOJHnTP1Sg7fkkMpLvPoJC3
OpFI9zde8lhZYgbdRmSBjreJhXRHOmYdKUmsods/ILZaIaKD7mtibNtYb/fR
rSfMYU/YOkz3QVaJQ3J7Jug+Ov+LI9J1hm6OMw3VjgFzdAsJ4MHgvUW62+q3
vbY59ZduKc8K9zLHZbrv3yfycUni0DXnBy+3cgWto1tqvey+Wxwb6B5ZeJsw
7cFE9+L5LenN/22k+yUuMez2bRa63/KFXlb5xUo3lIWuM3Fhp/t9sWWIV9cm
uot04Heb7DfTbUI+9tn5FyfdQt1BtjxTDP+sqFx8M8fwuRA18Y04LrqviIq6
PeRjOFpnAqrTZthEVubppcNrTiYIcZ7V3HJ8zTmE1I4229MWDNuXcpI3WK+5
nLAzRTc069ya6wiTd/zEj19cczMh90Jp/pzrmtsJHscXdBM81txL0FBR6gY+
ayYRVgQuuA3dXvM0oWI5bWPI3TUvEgL6ux8ohdHnh3Vr+RXao1btywxzZBtW
Xo9fy7nh5ogQE4lHq7bmg2OuVo/WpK1ZDDaz+O+mU9aqp6VhEbBvC/Rq1ckK
cI/U5adF+as2U4VTWV9oWpWsOgeG7SdIn9eXr9XrwDtbxO0yq1cdcwSeLLQg
H61fdZURnPswJvR386r1TsEevk3iD9pX3WQDa5xjLUB+rLrbEV45vP/wYB/N
vuVucKWCT/e94VWf8IQDtxS6KU6sOsUX1iNPbfw6u+q8QHhzt2yCN5lmdCIc
bq6wVRBfobmcORbWaz3W17+Om2rre4lwdvXF5wVMNE8bpcGcxUFXg1hoLpd4
Brs+ewJOsa865TXckljJprCZZt/3RbDK/Z5WHDfNvePvYeLtf0mtEM08F6th
8mVBhwxemgVeNcAW9mrKXgI0F8u1wqVmRv/0hWlOju6ERfVda0RFafZk6YN9
4bCIGXGat6eS4H7FZxZVUjSfYZ6EdSRrt8Vtp/lh72/4Cc/gpKMszZ06f2Fc
hAHRaxfVqMvbdYjFpnfwPUWqy5v7WZD8QNmheGVafmQzN8K1nhiaqUp1ckMg
L3LhxnqVYnVafVejCFJFdu6q1aRa/KKGFCJ6pcuvA6HZMEkW8Zo6tHNYi2qD
kY27kbYL+V8WdKjWDY9WQxRI4l7MulQ3L/TASNDZMHE+fdp+i8XayMCPP7XS
x6jmjl06jCBm9i6qhrT1b7cYIvGtLXwHTlI92nvOBJk9BspOmlLN9PG4FXL0
0/NzdhZUy0hJ2SKZBwQ2X7Gi2oN5ygFZXxGQ729NsW/hkoorYkmYORVtS82X
qzdeRYqKrDak2dPWu6heR6A9n57lOlKMvouPvI04vVQ7UelEcfkRu7RApEY2
7c8XF2r9KSXhMETiCVdKnzvFyaLXnkchPuI+ujNXqbnU5FAc0v5wZArnRXGv
HPnOI0SJ3ziO24dibkT4choSElWBiN+iusXjbSZC2qxAUvSjOOLhxbOvEPRe
Qhi4Q7EZN6E7D0lgYlE9HkSxUs0P/jfI/K3LP06HUKyezpHyHjFY6vF3Dqc4
/XHLwAfkmccRuZuRFCd2Ts7XIUyzxS1hMdT9+hy0PiNnLkl7J8VRHFP8PLAV
KRmJlHiRQHGN54jpN4THbqWuNIm6vtVB9yfi3HPBtSGZ4olwh/p+5KNFB/+P
NIoDzqscGka2tWu/H8ugWOBHQdU4ctMwx34pC7Pv/ebJ0hnkW4MI56YXlByS
u9U6j+zRvVcglEPxTPKRhr9I+Id5y515lHp9YcsLODCC2DBpFFLMn7IPzwT2
lzQ9P/wGc/knm0verCBJVdPIvBQzquuvVb8ZkHOe/nV4T8nVJMr4IXBiF0+q
ZyVma7ZxhQlekP3U93BQNaWfONLjLwRYpCam4+oo9XHvn66IAZtH5vFP6zG7
ssfjtKVAqWANKGrC3Cymar9NBvDFKg/XfKHMqygbXyYH3Lgfh7e3YY4Iq7aN
VwINIZvUSB2Yc7I2nPu8B2xn8eye/465+NeP9vi9wNdvMGDjT8zTEhryHATQ
tWywi7cPc/pPVe5UFKh5vWvdNoiZVa/vzittEDEne11lmLK/QkoWOARGXYiS
OqOYLTV3j5zTBwfG1n8ymqCcR+0SXsQAJKg6XFWcxtz+XTQ3/wSYvtUovuk3
pf+Bq1IvjcGBT8oNpHnMO5hvfOAxBwk88dcqyZhFgpeRBUswdXpZ8tES5ig5
s6851kAny6bJawVzpJp30x5b8OB3rZfxOjyKCz85KLXZHkzC8tK7mTAjDec/
HnQE2kFRzRwsmC+iIQljTiC+ZfH6CBtmK6mYPH9XMCliJVPFgUd9T4XX32p1
B9rnK1sec2E5eYuIuNNVEP9a5uZ1CMsNzLdwGnuCyaVQWVNeLOfb6WxEvA60
D862KQtglrHRCVe/BeIjTH05hTFnpO/1Tr0NJr6Xyo1uxTz6iOl5vz/YLy3Z
US2OR8s/w+5cNoEgzuWuX4oU1r9t80W57ffA+Jtx+RvbMdvjzZtVQoEW04lO
M1ms/nvbqHDMfUA8VhSgsguPouvVWTSfRILxeBElbkWs/6ll1kOvooHWwO2u
sd1Yvfy80/OxWECUHw6sVcHqnYO41p2OB+PXjiin7cXyf1VGy2wPgVbl6+6b
GnhU3GG4yPl3EiBy8N+zgPFozttOZ5H7yWDMxEdFDcWjyRbN63YcSgVoSl8P
XhuP9qpmLXRKpYNR1Wy1j7rY/o9QIYJRJgC++P50fawf9+V1k1nPQMwnjzDf
Y3iUO+hM4X75F2CU54e6pSG2fxWeRabnFQBntAb3nsTyxuJDpdavQUxWxv0t
pni0WGY6DzeWC0Z/b9KcMsejBk9A6777+SAmqD0y4wwerTMFpuk7isGvFk3Y
zwarN6h7qiZWApCtKSNW57B+IWzZ3sqlYOT1RcB7EY+Op+4IcjMrB/C/5tHp
S1ge/cvpZHgFiDqoRmxwxaOe5TmHFVsrAdyFm/D3wKNKWbNs5feqQZS0ffwZ
LzwaVPPk5f6lGjDiUq+t6YNHm+8S2I2v14EoJmLC7G3sfjYYmY49qQckeTnd
s2F4NJwv3PSj/heg6RnxmxCBRwt3X39wQb0FRFTOPxKIxqOj6X2NuJ2tQNO0
fP5zPB79yWX5gl/oK4jwNU5D0rHzlHjGbRXtBCry16c3PcVM5P78Yet30NmZ
DHdm4VG91NfE4K1dQHLPeMflV3g0YoX7zguhbpA/5MeRVYJHfbT3yLpc7wVm
UZnmHu/w6LJAz78nM71gGWnK0C7HoyH33RSX7frAwXhBrZ/VeFTnMtQepdUP
RnVA+PM6PKpsV+Mu8Kwf3J+x6/Ksx6NHVSyLj3IOgG96OVe3fMGjlUN1Y251
A8Bn8WtlbyseJe6oIpdtHQQS6UtcL9vx6KdMqzrPS4OgxkDC6nonHuVasuMz
LxoEF5YPPtP9gd3vpgMxokuDgPOZ0yJvDx4l67igYepDIM8kSmegD49qXOct
dHYZAmYbiiNzBvHot67SK1GPh8C/V90/bwzj0aRJHbGmuiGQbLlhl/4o9n0x
58xdHh0CB9hkvQQm8GhC9/KrDcwkMFpwrGZoCo9OBew4+FGQBMJtrmzJm8Xm
k2a2R7aTgDJXgrXvPLZegb/dXI4E2t++f3GUjEej/vxRF5QlAW+Hob9CS3jU
Pvcv+20xEhDj3aQ7soxHVVj2EhM5SaCqQim2AAehJ0N8um8sDAEHZ5N+vw0Q
qpTPexPuGAIcwj6KBswQ6ttRHfQ3Zwjk1Kb4bGWD0Phr6Inv/kPg5JXaj6Ob
IDTxzmVNVoMh8Ed8gq+YE0LV8SzuBbxD4FEjZHcHD6Fl8reyBL4Ogv3e6q9P
8EBoT7RH46XwQUDafnpFjB9C2ZvcXsxrDYKQVn/9CUEIHXBtTZ2fGgBtuz4P
3RWD0D8LHWl3CQPAs3NO2VgSQmf3+6QWdfWDrYFCvpLSELqt8WNdgkc/sO85
J/RuJ9ZfkCz6NbkPsIeGnA+Wh1D08KTpT6U+8Er9db6pEoR+ZTtOWn7XC8iR
/47NqkJoa4B69s+UHhCsE+0vowWhhwmcH+HaLvAyq3w80hRCTauOLEtztQH9
HlX+RAsIlbnxcriIqxWM8DzXyrDC7it74t9B3hYg6RtLLLGF0Oo/sdvsdzeD
9wXsFVX2EBokxHyvKLIJWI7dGmtyhFCHwsAG5aYGQDS5gA64QKgKz+e75u4f
wZ7QngsT7hDKoS5QyNxVC5orTsYuXsXWZ3If1DWqAezyYHSTD3ZeXJXPncsf
wFObfB6+WxBqbxfFWydcCXTiZYG4H4TyOX3aqNhWDm5t4IlRCYJQ1lDredXR
UiCy714ZEgKhDY7jpg9KSkCJ88qIbjiEitdJhC5nFWM/Spe3GEVCqJ3cxOiH
okIw1zkCW8VAaLLdcoPKQD6I5DrtcD4OQn+UeTn5yeUBhQOtUW4JEBpw+HFF
/f3XwCHn3fCdZOz5cMibWjJ4ATaSlKGINAg1+1sxW1LwDKQKZxISMiBUoCz/
sIke9ntruPV8ehaEll/lP5/IkQF+BEZFvsyG0IhEJemTf9OAVylLafErCHXN
zGLWwqcCvlkfUmUuhGayk7fJHE8GeTKz3I0FWM71NCrJNgkYWJ3X7CjGPu8k
f0su5wQwEfXjXN9bCM0pbvli+iYOBNcZRoyVQWhvJ2lORysWyKzUlMxXYM/3
kUDeD+uiQdUewtB/VVi9hUVS70IEOOv4mou9Dju/U4x76r5wsPJouwZPPXZf
D6Gm3p5g8LDtoZ1oEzb/v+CfgZ13gTo7/v6OL1j9f4nP58XugK8g8I1yG4Ti
boZGk7L9gPvVpQFCBzaf7jfUydsXcD135Tz0HcvH42KHNt4A2b1D6obdmP2V
FG76eYHDfKdsT/Vi8xX+3NZl7QFI+s1h5waw/G/U8964yyDg9oFiFxLmqYIE
QTE3IFFU0u/1C3NF1Vfb7kugbFxxc8A4Zr20dX0rjsBS8sne8CnMXII91rH2
4I+pkE38LNZftj49L8YWEMPuh6bOY3bnfZs/Yw32fGAqyiZj9WrZTNd0rEAz
2auvcAnz8f19/Brm4JLC1KaKFcq8NfbhecaA3c5OrX7dFhS3u2ixOOUEePqg
0/orE+YYvzMjE8eBzudjIT0smPVeNSwd1Qd9TFUFv9gx25PO5h49BG5q7Ov9
vRkzayXP+U5tIOz6kn2FGzNxoyexBwXFT6RUWXkwJ8d5WqYQgHFX/BmIH7O4
3UIZrA5muTmDRYQwl9a+Gb6uAoJ5fYpnRTDHa+JVvHYDSaFRUp0YZtczuP2V
8qBE1Iz3sSRmsqDJH31ZYChVo31VGrPnSXHLa9JgREbFXX8H5mnWAT5FSeC7
KzVZQo7iQZfmclEgsJv786I85ohtsQXzgiBH9eZyoxLFiz/Ye3mBrsa4XPoe
zL6aMyn2EOhFLCy81TDjbrBwDnMCT+26IIN9FH/r2z/MBrh01Yq2EyjnuUd8
m70RZBxJH/qHUPI9mhVC6wFiCPG0amEuD+lk2r2CtBv77s/SoeSChooSfxBn
i0nXW4cwoxz6O/vmEOYzlo+N9Sj7v18wNJxBHtl+apQ7SjFrG/7FOKLmoP5v
nQHFR8lw3jDS6JSx89sJSj+f3JiwAcTOjcf8pTHFhiNnhXqRf1f97gaYUXwv
YL33dyTGe7rA4hTFV/gNS74iu26dHlQ6TTFUFNXwBanyb4BYzlLMHrZVpBGx
DNLQ6ral2GIj04daZC400yXPnuLJ3MeWH5CQSL5H9xwpztdEb71HJIkBDWec
KMZVtUW9QUoSZv+qulDsSpIsyUdOPLaW5XCnONF0pCoHGU1rMu2/QjH6aZr3
OeKXSQgsvkax+pmhr08QoRfP8sO9KfZVNolKQXJfCwzY3aDY2mdaIxE5XBiI
1/SlOCdjIZWI9JbMAbw/1cFOolGI53sb5+E71HkOSc6FItxVzYnvgqhOyeC/
i2TWIfXRIRSL8/jY+CFoY/Yfx3DqflMP1G8g374I7UAjqU45pHANcW0PMuGL
oTpt5yl3hKVrIWCcSDWJxHQJedRjl1f5gOqYtCF7RG2wpS8+kbqf5BtWG6Rp
BOV2eUy1udUpS8R+4iVyIJVqAX4tE2RlRuSS8BOqtXAuhghxIfjhzFOqib+0
9RGFJfLH2mdUHzyuewCp/s+enPSCtn5bLIpYMn3dfiWH6ivu9fuQOVZtY708
qgmvmVWQ0M2v/cULqW7ezK6IbIPEcheKt9D+71i/AynlC+tteEvr5xMsiRgJ
L3GmldHqeWJFkFExR9irgmrxqmVexG9bx8XjVVQnlw5wI0KyBxKka2n97IfY
kFz5vLqlj1SjYl82IHrKEotfGqjGWR1cgfvU7ktnfqblobyLsHvVkd1vW6j2
LZKbgdefYIebvtLqb9z4BUf11Or2faP5aF8/LHnpzsm5LpqzR7rg3L/7rVl6
aPaObYO1g3BOQv002x1pgtt4y67JD9FsjdbAdmnX/dERmuOPlcNzSvvuG43R
nNNZBAeULSTYT9Iccf41zHMkP8NrhmayWRb8pNMtN3SOZvGLqbDaecWyx4s0
NxckwDVz4x9z/9LsaxQNm/g9+1q9TDM6EgKTuBz6vuF4aBYOgD2SpCfGNtCM
++UDM8sNkFeYafZ9dwUmFiczQeyree4lWObgaW7pzau52jm4uFVYRJ17NUdO
w7pnO2X0t6za3xj+Nkncc5pv1cHHYAefk8BNcNWpB2AyG6QfILLqGAS+F/fZ
JE5s1RGqsJB0mM0zyVWbKcDPcvWc30mv2kAa1kBZvZt3rLp3K/ypsfrOgNya
eWCLU/6RCwqrFt8Mj42gSWzKq0aZYB+PlUwR1TX/I3AwleYrqq/a9zchMdKr
fL/mqnFjhF1iexuMkbW8n1CaPdfhoLWWfycc1cgduK6z5hbCz1qXqfBDa64j
OBvLL6XorbmcsNI/ylxwdM3FhHDXTKjOYM05BNGVc6JdRmvOJLwKkdo5abLm
ZAIq2Ke6zmLNEYTmjEdaPFYMT1cImmvYrhkb+XiH3VF7hrm7Y1ytHRneTeYK
CnRh2F2BuajlOsPzCbM8F2MYbgt2rXSJYzjfe9LlSgLDVyxGP91IZnhWsN83
Ipvhqfgv4wVVDP8i5lTh5hnujnK+QjTmpdvlsGhLJRsf3TJIjv/2RoaDZ67u
CfHnp7tc/aSRmZoA3SJlPLWWZIal1rPts3khSPfxgJ6VR25CdG+v/lX5Y4cw
3c0POBb9fjCcnI2/Zf1YhG7hm3obgfFWut+Gnes5KSRKt+LuB7KtXQwfi8a5
n4gQo/ujoPRdpp3idGt9tD1pfYfhtMqX5tM/GebvGmUVQSXo7mtB99YlMJy4
Q5/PKpFhs5vG8zNJDDfLXsgTTmG4zDda0eUpwwkKJBm+fIaNgkME7BoZ5uyN
XSQ3MfxJNbk9rJnh/X35MUWtDCup/+Te9J1hDpISWy6J4TpNzZGDIwz7Rx6o
7frF8F+CxZ2NEwyPRPuvM//NcPqvsN6JOYbPgPj3fgsMt49m38j+w3AUWmSp
tcTwMWKFZvs/htnH64UurjBcrdX+57//GP4fYPg0wg==
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN13k4VG8bB3AkLfYzSEiICpEUiTnnOSIJ2bIlJHslW/SjlMlSlsgWkkTK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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk4VF8YB/BJkn2ZsWQpS1myZ0vMveeKJCKEEKWSLIVkiRZjSUq2MKkk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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxN0nc8Vf8fB3BKsrLORUahslJWqHTP+RyRRMmmUsmK+CKppIyMkr2Sla6G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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxN13k4VG8bB/ARKbJljl22spdEIeac54ikRMieJCQkJBQpky2RrSTZQhJS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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      Thickness[0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1nc4VX8cB3BKtjLOtUWK7IQk3XO+p4ysZEZRITOylUSEZJWRJFmlhFQS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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF03k4VG8UB3AkZClpZqxJtiwlIVnm3veK7CRbtiS78rNFodKEpESkhCQJ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], Thickness[
      0.0015], Opacity[1.], LineBox[CompressedData["
1:eJxF1nc4Vm8YB3BJUqmQ9xgpsiKSUn7Se85zzCSVRIQkZERWRtubUSIrklUp
EZK9UgmREWWP7PEKUVZGpN857/QH1+f63vfz3M9zzrkuOyyc9C6wsrCwbMB+
4X9nXSTGF5L8ERbaj1XgNrOtj60B3QI5MlxjcR4Mz37aZ9cQd4fhft18QkVc
JMPthIUfxXFJDJ9a4G97G5fPcJhdik5R3CeGfXwfVsiFtjHsKbxOnON2P8Pa
Wzmtidu+M6zJseOwjMIEw8d+j3KGOU8xzHmutsLOd5ZhQX5uMHRvnuHmz+JZ
FiZ/GBa7UupabPeX4ZCQSGizKAtKd27A36bN/qsYFmOVPujFuZrhkbm3MZMe
bAzP22x5Uf9vDcPpLHFBt2+vZfgtdP/y/lEOhnlS0FWnndYz/KHQNPBq5waG
C9Th9xusNzJ8euH4V8fRTQwn8g79tJPmYljjB2vNqQmmQ0kGCcgLbuY8KSXj
YYY8DE9zbQoQEtzCcADhRuG0ENOigmPDVcJMnxT7pOYuQXc8cWTnftejUkyT
ZJ/H75ChO5OYeeDW3zp5uguJWsrjMi8U6C4h9iHGxtcU6S4nXlGr8tc9SHct
cbOWYoEkke5GYpLOC/IyQnc7ETnJw9ukQncfsdWApJqiTvcw0dH4p7PXYbon
iOznTJ8aaNM9Q3xiWVMnc4xm0iJR0VZpeZUuPV8F1zkk7WrXo+fssJUL75l0
A5pLNsLL7t53fY3o3gJHXJvMMzah9wvCsl5mQ/JmNIvsgMt9annWnqc5VBI2
9VdW6bakOXM3PHs/2SnHmr6fAhwYBj25Z0evPwiLRvrWnnOg74fCRTHTfw44
0TypAes9NZfmdKU5WQceS/hiOOBGc64e7J1MvFPoSbOVESz4OjU3+Bp9vXNw
dhb/oNVNml9YwUfy73AfItH85SLcVzQLuH1otnCBr3ywcPzuRzXJ1wPmKq+P
e+9Py3fchJOrkM/hgTQ3eMNoXdqiXTCt/rA/3N4gKIWG0XLtENi51f80FEG1
uWgEvLZzznc8kmq0Pxp+0muVUxZNtXNcPKw41NgfFUd139FE+MsIyuX0lOoS
9Vew9UQ6ovGcVu+UBa9MCV3amkizej4cORcQO/WS6gXrd7Dc0kJ1ZSrVUnxl
cMU/64XHr2nzsVXCpmwtkm6ZtPmROniWQ81AO4dWH9wI39+Y5SOST7Wibxss
ziOcPVdINX95N/wOCuqrfUu1bf0AfGrr0qaEYqq/lHyHx4Tt4KulVJ+cmYC9
xdvsT5RTnds5DQtKa8RIVFL9tmAezt6dU7VUTfXDmr+w9r4d8w21VGdksCL9
iiESyV8pJpnarUVcy3X2vm2kGBXv2Iiw6q2Hv7RQLJL+jwd50Fup1d9OsfkJ
SX5E9JKf/mwn1a+TtiPZf1TN1/ZSnCnoIIao+bM4CA5QrFsTLoU0E4o9d5Op
+7Vs3INYJVz3QUcolidHKiCz8gdDTv2g2Mj7tRLiWzwXY/2T4viI9QDh1clN
ujpFsbr1LTUkscMl+/4sdV4fVy1E0WZP8dN5itMkHh9HPs2OV2f/odgtRewU
cto7taXiL8U8CNkQGd5s29/Owou7iqXmLOLxWGLix2qKPxkHWCDsMoMLK+wU
W5ttsEEiC+PZeNZTPBcU7YDs1DTjkthIsfvdQheksGmrkBIXblK23YQ7onW+
Y+fRLZR89SO+60j7z0gFMwg3+lApn4TY3tAHLgKUnLw30hdZWMdz1FcId0mj
n9495N6jr6cfCVPqd/cLhCCCEkEWqaK4zb/t5AlHUrO1Hd9L4O67STJ+hCij
HNfqpSj1VnLBcUhNXYXfoAxl/Z9xjs8QYxOfsDk53PUZHmgi8mMEfbxuH27d
eyU9KcgNj5VkoQO4JwvZXTMQTrZ3uXuUKPstKxBykLiwqyWqh3Bz2V8WKUBk
hf+rNUBwJ7tfWX6LvEubbbNVwa0/7j9SghxTzh68ro7baOihdTnSU+n0K/gw
pb9oJbwKcTTYvfRMG3f59N6wOmRlYIw97xhuxS1CZQ1IsHMyT5Uu7kK+Wp0W
ZPvKhe2dp3APbUj37kAyAsV2/TyNW8thm3cPggr0H1hljJvwTfm/AaQ+6YkK
71nc30l2hWTEfL/psZ3muEvVPLpGkclSgTPKlriVO9d8+ImQTrRZHbPG3dLE
gU4jXN0RzuZ2lOfhovr8NxJ/Ue/GZQfMpPFXHrGLyN6Fzf53nPB8Q6WI+gpS
5lcXHu2KuaQwaU/XKqC3JfBpmjvlPib/41wDBuK1Xn24gvfrh8eVcwBXOfaC
xut4Lr/OVXAjYH33sYx8C3OftXs/DzcIP3L7y8JtzPGsc3MsvEC8Dfm2wQ/P
wz6x2/CBXKtl8nZ/zOjxbXmntwL16TdTewNxb/+8NCgMmr08/6oH4/Nk2BU8
EAVWGw+sMwrDLB+WqhYjAX7HTPPaR+D5+bA/kDRoDnAuc3qEWaRZa5ZtN8i9
9tPJLQZf71kbUiYPIi46bLv6GHdKwhl9BeBmPFZzMx6z+aviy2qKQF/b9op3
AmYuwgOH2INAQXlY4m4SZuednR52MODZZdUUmIK5XbRzaw8KpgUGSKFp+H68
dTMn1UDjOnO5hxmYpdY/VxbQBFmL3Z3R2ZiN6rVa4CMgdNTk3pM8fP+cpyk1
OsC5o0MxoRCz7P1zHRd0gW614dDLt5hNPXk2vNQD8m9awtKK8f39O4TkDQBX
yimQVYrP5/LfBIcR+BXVMJ5Xjt+v7By3sgn44n8ipqgSc724xFCtGUi/Unf4
Qw1mPk2pTxfOg2Dbo78/1mGuWe98N94SOBpVP6+qx+v11NOErMFxrcO6dU2Y
166YJvbZgt1KFX8bWvF+vXnLGXvAKaX2qrUDs91A3zlTJzDOV2rU2cWLktJ/
pH4JcwG1awF7Xy/m5RbdjuTL4NX8u5yhAaxelbdweN4dBHxXPj9KxhwX3N3p
cwVcbCvc9HMEq2/gE/l58jrQrlR8N/0DM3ptf6LNLbCrINdu/idW75Fo6Ugm
gfUv9/EtT2HONukbKPEGo5GZ5Sy/edGSOijkcrUvqLoj57pmgRdFMz/sCmG9
C5I90oTXL2H1L0gxX53uAX/rXXWbVrD6Aa6YRd77wPZ08rUtqwgoKWUd7/Lv
YKClKSnFz0bA1heI8NwQBnYqvmgRWovl0Lz9uuIHYJgQLy+5kYCKeAJn/QeR
4NOa7T27uAho/JJUenJhFEj8HRu4ZwvWP9b6Qmt9LPAlCxzcD2H1knIHX957
DKxaHg0rCRDQEsnXvs+E4oF6BSECFiKgmTqNYo1Bz4B4XriKqjABnRStl30t
kAAGI0Lijkpg65ER/cA7SaDMd6O2rhQBNd8z6iN2MRk8dwuc15choPUKO7iD
LqUCC/27emZ7sX4Oi5Tu9nSgqr6GxXI/Aa06xakf9ywT7Njv89rmPwJ65WGG
p/hoFujb4sXhAmPreRd8vZmVC0pW/81zR7HzWKoWGinkg6cz1yyvqWH9glfs
n1YXALMmj2KfIwRUvrCHnf/AW4B8nLX31yGgzv4iPv/Wvwfbc1wFgk5g55Nq
f/52rhh0P3B0izTA6iWOnwH+paDwJFnCxoiA5taqE9D7ZeABl2nbfyYE1Gih
m3M2+iPQDD6i3GGO3cfs2RTDxgqQeU+cRcgBu/83YcLeuTUgQCs2a9yRgPqf
m2b/uLoWWK3lsXzvgp0n1JCcZFIHBPz+VZh5ElB+osh6Ak898CZ9C3zmTUBn
q00GJ9mbgCk4Cbv6EVDl+ZMnhGubgOJK5U9VfwIq3pOwbzm8Gfy4nndyKAib
vypq9eNdrUDfM5RvZzQB5VyIin5xsQNIOmompGUQ0AtJazoqh3oBy+73+jez
CWjg82JxskEf+PZDgf14HgGd+r7V/3NBHwix22H3q4iAFi7uzJ1x7wcXpaIE
S94T0Hy+Zrvahn6g/n1TbWgJASW0dHsryQyABatluX2fCKgZRGBZ1ToAGsUu
97FWY/OWeagsSQ6CtIHRsKbPBNRGVOxPudsgOG/eNuvWQEA9rtVF8rAPAaLw
8SSNZgK6ZrNEO3pkCEA95YZQGwF1OBIdHe4/BGpMsosKurD7N11W5VkaAi8E
pR38ewmolL3f4OJuMrjV8XTbmQHs/u6mZN80JQOjKOirNJmAJpt1zd++QwYK
hkGkP98J6EsP1aKJV2SwCWLb93mMgCqln2tNrSWDkeZrg7ETBPQbzMadNEIG
ZeFTEQ6TBPT7Z9udX/+RQZyerSY8g50n7FIXP88w8ODund84h+3fP8N6VXgY
nKw3SOlZIKB/Xur4jewcBrIhtcYZS9h5E97YWcoMA/bjapykFQIqKM/aPCI9
DPo4i97rroLQ4bvCbNfFhkHRZ3mnHWwQCims1RPmHwYRAS9FptkhNAU8luxZ
OwycjmxvLFsHoZo+36bKpslANWzIvJ4TQvV2r3VxayUD3o7UX92bIfQHV6xf
VC4ZfBdxufWDB0JrO8bNjwSRQZHtfxsXCRDKqVC2OtGcDIIy/8ayC2A2tN9a
J0cG5gsfd/EKQWjRfunO4fkhwO6vq7VHFEJfeSe/j7g+BDq+Qm1ECQjV17E7
46M4BNL4ui9oS0Holdc3ZfgnBoHeSzufC3IQOv1B89Da44NA4tcenst7IdTx
cGNA/QL2fijOxZP2Qyiv6+HibfED4PEn7+JYZQgNOPhg8AC5HzhvOnIsBYbQ
B8nyu2769APV05u78lEITc6AvFDhfjBCjl1s0ITQkZt2W2HdPrB/Td5+jlMQ
6uFUGKKFdIPPat9T3ewhVLdwsev78VbwJPD1QW9HCH1hfeJiuXsLcG66XBXi
AqF7NhmprH3aDCBLluFUTwh9dsSCTfRPI7DwFtjR7wOhPalBJWb5X8GBmt6M
n3cglBS/ya760BfAwZOELN+DUJ3ZYxcdampB+rN9pnyhEMoumgcVsdWAxZKj
j47FQWhZmYpe5Gw5qOXgkTR5CqHf/iz8Ufr8ETzRbc+1fQ6hjdd23c9NKwPq
fVaNPskQmn8p5LJGaAngk5I5H/YKQgu38XlHiX8AY05Tv56kY89n5e4rYeQ9
CP13c2NRLoTe+MUukZP5BlgeVo+rLIDQtAHt69LrCoFiyHqZliIIle+VD/jl
ng+6tj/SmizB+htuaHwIyAEZ1mfb/n6EUCUnjiede7OBd7qY9YZKCPu+FsSd
fmSCnUimj2Qddt8mx+Xjd74Gs/pOEEs9hJasG/BylHwFyuzlUjoaIZR/tLr9
nkoKCPWeOJTTAqHxx5qk5j1fArPotC/327H3IS1lR2FVIpDNtD9v3QmhWuQB
i9p9L8Dip12zoAc7n8xc+L685yBiNllgZhB7XspqFv1/nwKLDbZptcMQyrXr
ukiE/2OwR3QnSBrFrFbIMnsoFiwrDTd4jUMoi5XOMhcUDWpOJFqd+YW5rfXG
asIjEGVtNb9vGkL7fCRjJxQfggs3xQI4f2P3sdX90PLVcMDy6lnGhz8QOqmz
74iHaSj4UmquGv0Xm/+Lh9rMZBCIbRducWXhQ0s+7DyeeDYQ2P7qsdFZzYeS
PLeV9i35A0X2J38k2DG/sdB7VnUHsG07G/SPA7M1+oul1Bc0KAiJdGzgQ1Hx
FUGlAW/gcD5G4z43lrN7yehJewHlK2faL/Bi6xe4+3Sq3ABrQ/jtAR9Wvyfs
BRJ1FTQntv3lF8Tquc/MbZPyBM/fRYZOC2F5247R0xNu2PtrIFYrzIedl6uU
ZcgVwGO8+YmimOeI++05XMD6Vc1aXhJYf+CfjwfTHUE7X3inkRSWt9rqJUTb
gyQ5Pcd9MlieBn+aqrUFlzW4V3HKYXltwWYbVWuAmtaHk+UxZ8j7vJi1BJsu
h0h+UMBc2UZO6jkPuu4dfxOliHnpYaPv/DmQEr9Rx/Ug5vLUQ3CIKfAoqO05
SsT8sbvc6sYZoP4l0EUCYNZoy/IqOA14yNps/1Qwi6pUxR/UB71L6x61q2N2
JF48v3wSpPFUS2cfxoxuzsyZOQGuSfu/C9TGzHJSReGMDtBCD5+4cAyzfkQo
KnwEQIbsA4guZotvp9KImmDoUoUb/ynMk+v3bUhRA1m+vmunDTC3nw9KNlUB
t2LVYj4bYR7SyZuJR4BONuvuRBPMXIY8EsvKQLC69MMtM8y+6LL8h//ASC9J
z+g87not1979IH8OkPdaYY5jFUVO7QM+G/95brDB+3vd67nlga548XqyHeaq
cZ7LkrJg+6Gbj4sdMBvN6UXHS4Hxk0T5KCd8HrFBYT8J8MZ2qczFFbN5kLpx
lSi441VkcNQdczz2qZwTAfqRV0fEr+Drr7Ie8xECoq+Vrq9cwyxSUd1eyw9+
fZzf2H4T7yeryQQSwLtv+fFZJMyZlheOZfGAgCl3hUAfzLo2D7cpcIGXF3/b
nL6DuWQxmE+EE5QPusXtuIe5b6BM1pID9JvO1o8HYibl2GkIrwErLZfXFAbj
659wmdFgBVtPzBz0CcPzi4YVEf8QpSpXx+MR+HodhWaqS4i+yvRzgUf483r0
nUSaR1yKXNqGonFvs9OGZ5FghakNmXF4vwX7uO0UkprmjF5/itvdr29sAqmU
mHTTfI57yp7r9Sgy9MQphTsRt1h+Eeswsor/V3fXS3y9spav7QPI9jBHnuRU
3N9LH2zvQw6t/6l5+TXu0oOvAjoRI59L15FM3CIPr5HaEPfl8Yx1Obi5MiCO
ZuSBu8NQcx7ub0qdGxuQ9J8/+OMLcVfp6qyqQz7b2B+zf4u7JoqQUIWM9I3d
VizGLfVe8Hs5wmZ8MX9VKe7cq7X5pciOptGx2o+43Xjk/75HEB074ahPuPmd
N5u8QUwqRk5ZVuMu2dJtl4dcQWz95Wpx84Ye4spGHhZ8f7f4hTLvsyDndCRb
3maqvAF3oZHKkxTka8qwRGgzJWflu5eIjItaG5u04V64K0p4jnDEkYMlv+F2
JrXqP0EkCBc+TnXhnnSutI1GVIOH5t/14pZ/SFZ9iJittZL1H6Dkg3wVYch1
0qD5KTLuPkX9V0FI1KLFw+0jlP0qz733R/JcB6pHx3CTDBZjfJHGH+dXcico
NjQRv438surfR5rEzXJ+880bCGePuc3RGUoeLpfoiUgb9sVCc7jRD2oxlxHN
+nP1/QuUvNL9kDNicaSX7fUSpb+K9dtFxKvM7OCVFYpzfspZI3GHei6preLH
6/1kj1sghblnn29iw83yZVLWDGnZ3d3awU5xU06bETKdZLohcR3FUPIlfWSz
SBdw5qQ4y6ZSF5GNNnE7tJliW/Ldo8gRns5kdh6KHU1DNBHrQOPuBl6KjXk9
VREftm/cj/kodtixF0Hib57RtBWkOP7WSyXk3Vz7NYVt1Lxn636kw8koY0WY
4tn+8/LI3EjbYLUoxSM2KbsQHgtD/ocSFFc9fCWB7Ols1TGXotj/7aMdiI7+
6dsyMhTXb/IXQuzqWvLmdlPM1buVD7mjaTBWKk/x5HgWD5LwoXl7kALF5qGK
m5ASJf1TRopUJ1hwIK3KYhfMD1JMGtZZjfwgTnvYEilmcfNegVlAqb8zoOY1
vAswpBIac0WVmssuTcOyaufSSBrU/GH/BKyiIVfsr0XNx258h08f/vs19Cg1
H3EagB2O1PZHHafmmd+7YO+jsTPxJ6m+Ft8KPzp2cU2KPtWCmQ1w2omDfFmG
VKc+/gyXneSQfmNMtdbdCrjtVJty6Vmqb5SVwOMGSTrV5lSzbC6CWY3czRos
aT6UC/MZqzt3WNP6zTJgWdMt3v12VHMdSYZVzQbCRx2ojv/0HDY0z0qccqLl
K3GwgwWpYNGVamfjSNjb6kT1Kg+q+w6EwY+st3euu0q1iGcAnGY7Mc59g7a/
ni9cdvHdioAX1ai0F9zuEMgl6k3LuzzhCUdj0V1+VJMQV5jVRXr/Pn+au+xh
/ssLGsqB9PwCLOdeaagaTOvfbQ6reUbaaYfRHGMEG129cF0vguZ0Pdjx+v4g
40c0n9aBfW+ufmoRQ7ObBhzt1Zh58THNyiicfvtZmWs8zSQluNzHuflaAs03
9sHf/MCwdxLN7TLwr7ubFgJSaJ4Uh9kCuteFp9HsLAwL3k/bGptBcygfLB98
fXdCNs3x3LBGqDZ4lUez+XrY+IHAyZxCmktWw84RIxZv39Ln+Uv0iyxw+1hM
M/ZPT0zUnTufS2lGJ4mZMQZRTeX0fIRYESee2llJ9wDx25OZt4M1dHcSJ+PL
6n7U0d1MXJMQ1jtTT/cXomCi+dRSE92fiPIv96xma6O7hKiRssLL+Y3uQqLx
qzpJ3m66M4nOr+OUhProTibeybDXFh+kO54Ym6VsKjvM9Ke8di/iON2hRKFi
3krTBbqxbzCkq0t+iWmi+YtpthWmTVn3b3+9WoDhx5qn3P9uYnr71zCxJxJM
i/RtIvXqMS3Guu6gxWumT/j2rjxxEWRYsmK0rEtqK8P10Zzz3l1Mx6dxe5k/
FWJ46y3tNcBgG8Nvgy706gtuZ3jP3mjppk6mj4ezuOqFCjNcLSBxl22XCMMq
1Zb65n5MJ5Sln5nsYZqvc4xDCN3BcH8j+l9VDNNxUkehs3FMG90y+D31mOl6
6Ys5W58xXUwK3+P0kukYueGdUC7TpwIC+a3qmN7U93B+4QvTNQfiW4PqmVbt
z40oaGJaXqmHa8M3pjmH5ddlDzNddejQiOYI0z5hGpWdo0z/IRr7rZlgeiTc
Z9WZGaZfjAb1TcwyfQ5EffCeY7p1LO1m2iLTD9ACU5Ulpo9Hlh5qXWZ6/fhn
QfsVpitUWhf//WP6fykOqfo=
       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF2Hc4VX8cB3AJkS3utUJCSolI0T3ne7JCSHbxQ8hKNqHkZpSIrGwiI0pC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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF03c8VW8cB/CbJApJ3HuNrBRKViK65zyHpBKRkVmULT97pYyIRFYkorJl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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k8VF0YB3AJ2ULCjJItSpSEUpp7z7UmCdmyJSFLKWsSr4ytRFkiIUlZ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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF2Hc8Vf8fB3CroZAk91zKKkWEUNY953NCkshMVpK9ypb0ww1JZGVkJVll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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk8FP8fB3By5EqlsLuEHEUKSaJ25jPOJCSSM8ktclfoJxvlKyJyRG2S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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1nk0VV8UB3BEmRIS3nuKzCIhP+O799wkVGSOECrJlFlE8lASEWkQkojI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       "]]},
     Annotation[#, "Charting`Private`Tag$32086#1"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], Thickness[0.0015], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF2Hc8VX8YB3Cz7JCMe61EKSOiUu4535OVpJCREH6SrGxSGjcrkT0iKgkt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